/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.io.evs;

import com.progress.blackbird.evs.EEvsIOException;
import com.progress.blackbird.evs.EEvsIOWouldAsyncException;
import com.progress.blackbird.evs.EEvsNotOwnerException;
import com.progress.blackbird.evs.EEvsObjectBusyException;
import com.progress.blackbird.evs.EEvsObjectHotException;
import com.progress.blackbird.evs.EEvsTimeoutException;
import com.progress.blackbird.evs.IEvsDispatcher;
import com.progress.blackbird.evs.IEvsIOBuf;
import com.progress.blackbird.evs.IEvsIOBufList;
import com.progress.blackbird.evs.IEvsNetworkPort;
import com.progress.blackbird.evs.IEvsNetworkPortDataEvent;
import com.progress.blackbird.evs.IEvsPortEvent;
import com.progress.blackbird.evs.IEvsPortEventHandler;
import com.progress.blackbird.evs.nio.EvsIOBuf;
import com.progress.blackbird.evs.nio.EvsIOBufList;
import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOFlushPendingException;
import com.progress.blackbird.io.IIOConnection;
import com.progress.blackbird.io.IIOPacket;
import com.progress.blackbird.io.IIOPacketSerializer;
import com.progress.blackbird.io.evs.IONetworkConnection;
import com.progress.blackbird.sys.SysTrace;
import java.io.IOException;
import java.io.OutputStream;

final class IONetworkConnectionOutputStream
extends OutputStream
implements IEvsPortEventHandler {
    private final IONetworkConnection connection;
    private final IONetworkConnection.Statistics statistics;
    private final IIOPacketSerializer packetSerializer;
    private final SysTrace trace;
    private final SysTrace packetTrace;
    private final IEvsNetworkPort port;
    private final IEvsDispatcher syncDispatcher;
    private final PacketWriteContext packetWriteContext;
    private final BufferMgmtContext bufferMgmtContext;
    private final Buffer buffer;
    private IIOConnection.AsyncFlushContext asyncFlushContext;
    private boolean flgOpen;

    IONetworkConnectionOutputStream(IONetworkConnection iONetworkConnection, IEvsNetworkPort iEvsNetworkPort, IEvsDispatcher iEvsDispatcher, IIOPacketSerializer iIOPacketSerializer, SysTrace sysTrace, SysTrace sysTrace2, int n) {
        this.connection = iONetworkConnection;
        this.statistics = (IONetworkConnection.Statistics)iONetworkConnection.getStatistics();
        this.port = iEvsNetworkPort;
        this.syncDispatcher = iEvsDispatcher;
        this.packetSerializer = iIOPacketSerializer;
        this.trace = sysTrace;
        this.packetTrace = sysTrace2;
        this.bufferMgmtContext = new BufferMgmtContext(n);
        this.packetWriteContext = new PacketWriteContext();
        this.buffer = new Buffer(this.bufferMgmtContext.quantum);
        this.flgOpen = true;
    }

    private void onFlushCompletion(Exception exception) throws EIOException {
        boolean bl = this.buffer.postDrain();
        if (exception == null) {
            if (this.trace.debug) {
                this.trace.debugln("OutputStream.onFlushCompletion : Flush completed successfully.");
            }
            int n = this.bufferMgmtContext.quantum;
            this.bufferMgmtContext.updateBufferQuantum();
            if (bl) {
                if (n != this.bufferMgmtContext.quantum) {
                    this.buffer.init(this.bufferMgmtContext.quantum);
                } else {
                    this.buffer.reset();
                }
            } else {
                this.buffer.compact();
            }
        } else {
            if (this.trace.debug) {
                this.trace.debugln("OutputStream.onFlushCompletion : Flush failed [" + exception.getMessage() + "]");
            }
            this.buffer.compact();
            throw exception instanceof EIOException ? (EIOException)exception : new EIOException(exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final boolean write(IIOPacket iIOPacket, IIOConnection.FlushContext flushContext, int n) throws EIOFlushPendingException, EIOException {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = (n & 4) == 4;
        boolean bl4 = bl = (n & 2) == 2;
        if (this.trace.debug) {
            this.trace.debugln("OutputStream.write : Writing (forceFlush=" + bl3 + " suppressFlush=" + bl + ")...");
        }
        if (!this.flgOpen) throw new InternalError("write invoked on closed outbound stream!");
        if (this.asyncFlushContext != null) throw new EIOFlushPendingException();
        if (iIOPacket == null) return bl2;
        if (this.packetTrace.debug) {
            this.packetTrace.debugln("[OUT] " + iIOPacket);
        }
        this.packetWriteContext.set();
        try {
            this.packetSerializer.serialize(iIOPacket, this);
            this.bufferMgmtContext.updatePacketSerializedLenMean(this.packetWriteContext.bytesWritten);
            bl2 = !bl && this.bufferMgmtContext.autoFlushSize >= 0 && (bl3 || this.getBufferSize() >= this.bufferMgmtContext.autoFlushSize);
            if (!bl2) return bl2;
            this.flush(flushContext);
            return bl2;
        }
        catch (Exception exception) {
            throw new EIOException(exception);
        }
        finally {
            this.packetWriteContext.reset();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void flush(IIOConnection.FlushContext flushContext) throws EIOFlushPendingException, EIOException {
        IEvsDispatcher iEvsDispatcher;
        SyncFlushContext syncFlushContext;
        IIOConnection.AsyncFlushContext asyncFlushContext;
        boolean bl;
        boolean bl2 = flushContext == null || flushContext.flushMode == 0;
        boolean bl3 = flushContext != null && flushContext.flushMode == 1;
        boolean bl4 = bl = bl2 || bl3;
        if (this.trace.debug) {
            this.trace.debugln("OutputStream.flush : Flushing (mode=" + (bl ? (bl2 ? "blocking sync" : "non-blocking sync") : "async") + ")...");
        }
        if (!this.flgOpen) throw new InternalError("flush invoked on closed outbound stream!");
        if (this.asyncFlushContext != null) throw new EIOFlushPendingException();
        this.buffer.flip();
        ++this.statistics.numFlushes;
        if (flushContext != null) {
            flushContext.reset();
        }
        if (bl) {
            asyncFlushContext = null;
            ++this.statistics.numFlushesSync;
            syncFlushContext = new SyncFlushContext();
            iEvsDispatcher = this.syncDispatcher;
        } else {
            syncFlushContext = null;
            this.asyncFlushContext = asyncFlushContext = (IIOConnection.AsyncFlushContext)flushContext;
            iEvsDispatcher = asyncFlushContext.dispatcher;
        }
        try {
            iEvsDispatcher.acquire();
            int n = 1;
            if (bl3) {
                n |= 2;
            }
            this.port.writePost(this.buffer.iobufList(), iEvsDispatcher, (byte)31, this, syncFlushContext != null ? syncFlushContext : this, n);
            if (bl) {
                while (!syncFlushContext.done) {
                    iEvsDispatcher.dispatch(-1);
                }
            }
            if (bl2) {
                IIOConnection.SyncBlockingFlushContext syncBlockingFlushContext = (IIOConnection.SyncBlockingFlushContext)flushContext;
                if (this.trace.debug) {
                    this.trace.debugln("Flush [blocking sync) complete " + syncFlushContext + " " + syncBlockingFlushContext);
                }
                if (syncFlushContext.status == null && syncBlockingFlushContext != null) {
                    syncBlockingFlushContext.complete = true;
                }
                this.onFlushCompletion(syncFlushContext.status);
                return;
            } else if (bl3) {
                IIOConnection.SyncNonBlockingFlushContext syncNonBlockingFlushContext = (IIOConnection.SyncNonBlockingFlushContext)flushContext;
                if (this.trace.debug) {
                    this.trace.debugln("Flush [non-blocking sync) complete " + syncFlushContext + " " + syncNonBlockingFlushContext);
                }
                if (syncFlushContext.status == null) {
                    syncNonBlockingFlushContext.complete = true;
                } else if (syncFlushContext.status instanceof EEvsIOWouldAsyncException) {
                    syncFlushContext.status = null;
                }
                this.onFlushCompletion(syncFlushContext.status);
                return;
            } else {
                if (this.trace.debug) {
                    this.trace.debugln("Flush (async) complete " + asyncFlushContext);
                }
                if (asyncFlushContext.syncCompletion) {
                    ++this.statistics.numFlushesSync;
                    this.asyncFlushContext = null;
                    this.onFlushCompletion(asyncFlushContext.status);
                    return;
                } else {
                    this.asyncFlushContext.inProgress = true;
                }
            }
            return;
        }
        catch (EEvsObjectHotException eEvsObjectHotException) {
            throw new InternalError("Acquisition of dispatcher failed - " + eEvsObjectHotException.getMessage());
        }
        catch (EEvsObjectBusyException eEvsObjectBusyException) {
            throw new InternalError("Acquisition of dispatcher failed - " + eEvsObjectBusyException.getMessage());
        }
        catch (EEvsTimeoutException eEvsTimeoutException) {
            throw new InternalError("Dispatch of dispatcher failed - " + eEvsTimeoutException.getMessage());
        }
        catch (EEvsNotOwnerException eEvsNotOwnerException) {
            throw new InternalError("Dispatch of dispatcher failed - " + eEvsNotOwnerException.getMessage());
        }
        catch (EEvsIOException eEvsIOException) {
            this.asyncFlushContext = null;
            this.onFlushCompletion(eEvsIOException);
            return;
        }
    }

    final int getBufferSize() {
        return this.buffer.size();
    }

    final String getStatisticsString() {
        String string = " OutputStream{";
        string = string + this.bufferMgmtContext.packetSerializeLenMean;
        string = string + "}";
        return string;
    }

    final void shutdown() throws EIOFlushPendingException, EIOException {
        if (!this.flgOpen) {
            throw new InternalError("shutdown invoked on closed outbound stream!");
        }
        this.write(null, null, 0);
        this.flgOpen = false;
    }

    @Override
    public final void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public final void write(byte[] byArray, int n, int n2) throws IOException {
        this.packetWriteContext.newBufferAllocated = this.buffer.write(byArray, n, n2);
        this.packetWriteContext.bytesWritten += n2;
    }

    @Override
    public final void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    @Override
    public final void flush() throws IOException {
        throw new UnsupportedOperationException("flush is not supported on the output I/O stream");
    }

    @Override
    public final void close() throws IOException {
        throw new UnsupportedOperationException("close is not supported on the output I/O stream");
    }

    @Override
    public final void handleEvent(IEvsPortEvent iEvsPortEvent) {
        switch (iEvsPortEvent.getType()) {
            case 5: {
                if (iEvsPortEvent.getData() instanceof SyncFlushContext) {
                    SyncFlushContext syncFlushContext = (SyncFlushContext)iEvsPortEvent.getData();
                    syncFlushContext.done = true;
                    syncFlushContext.status = ((IEvsNetworkPortDataEvent)iEvsPortEvent).getStatus();
                    syncFlushContext.bytesFlushed = ((IEvsNetworkPortDataEvent)iEvsPortEvent).getBytesTransferred();
                    break;
                }
                IEvsNetworkPortDataEvent iEvsNetworkPortDataEvent = (IEvsNetworkPortDataEvent)iEvsPortEvent;
                EEvsIOException eEvsIOException = iEvsNetworkPortDataEvent.getStatus();
                if (this.asyncFlushContext == null) {
                    throw new InternalError("Async flush context is null on async flush completion!");
                }
                if (this.asyncFlushContext.syncCompletion) {
                    throw new InternalError("Async flush context sync completion is true on async flush completion!");
                }
                EIOException eIOException = this.asyncFlushContext.status = eEvsIOException != null ? new EIOException(eEvsIOException) : null;
                if (this.asyncFlushContext.inProgress) {
                    IIOConnection.AsyncFlushContext asyncFlushContext = this.asyncFlushContext;
                    this.asyncFlushContext = null;
                    asyncFlushContext.inProgress = false;
                    try {
                        if (this.trace.debug) {
                            this.trace.debugln("Flush (async) complete " + asyncFlushContext);
                        }
                        this.onFlushCompletion(asyncFlushContext.status);
                    }
                    catch (EIOException eIOException2) {
                        // empty catch block
                    }
                    if (asyncFlushContext.completionHandler == null) break;
                    asyncFlushContext.completionHandler.handleCompletion(asyncFlushContext);
                    break;
                }
                this.asyncFlushContext.syncCompletion = true;
            }
        }
    }

    private final class BufferMgmtContext {
        int packetSerializeLenMean;
        double lambda;
        int quantum;
        int autoFlushSize;

        BufferMgmtContext(int n) {
            this.packetSerializeLenMean = this.autoFlushSize = n;
            this.lambda = 0.1;
            this.quantum = this.packetSerializeLenMean;
        }

        final void updateBufferQuantum() {
            if (this.packetSerializeLenMean > this.quantum) {
                this.quantum *= 2;
            } else if (this.packetSerializeLenMean * 2 <= this.quantum) {
                this.quantum /= 2;
            }
            if (((IONetworkConnectionOutputStream)IONetworkConnectionOutputStream.this).trace.debug) {
                IONetworkConnectionOutputStream.this.trace.debugln("OutputStream.BufferMgmtContext.updateBufferQuantum : packetSerializeLenMean=" + this.packetSerializeLenMean + " quantum=" + this.quantum);
            }
        }

        final void updatePacketSerializedLenMean(int n) {
            this.packetSerializeLenMean = Math.max((int)(this.lambda * (double)n + (1.0 - this.lambda) * (double)this.packetSerializeLenMean), this.autoFlushSize);
            if (((IONetworkConnectionOutputStream)IONetworkConnectionOutputStream.this).trace.debug) {
                IONetworkConnectionOutputStream.this.trace.debugln("OutputStream.BufferMgmtContext.updatePacketSerializedLenMean : packetSerializedLen=" + n + " packetSerializeLenMean=" + this.packetSerializeLenMean + " quantum=" + this.quantum);
            }
        }
    }

    private final class PacketWriteContext {
        boolean newBufferAllocated;
        int bytesWritten;

        PacketWriteContext() {
            this.reset();
        }

        final void set() {
        }

        final void reset() {
            this.newBufferAllocated = false;
            this.bytesWritten = 0;
        }
    }

    private final class Buffer {
        private IEvsIOBufList iobufList;
        private int quantum;
        private IEvsIOBuf iobufCurrent;
        private volatile int pos;
        private int limit;

        Buffer(int n) {
            this.init(n);
        }

        final void init(int n) {
            if (((IONetworkConnectionOutputStream)IONetworkConnectionOutputStream.this).trace.debug) {
                IONetworkConnectionOutputStream.this.trace.debugln("OutputStream.Buffer.init : quantum=" + n);
            }
            this.quantum = n;
            this.iobufList = EvsIOBufList.create();
            this.iobufCurrent = null;
            this.limit = 0;
            this.pos = 0;
        }

        final void flip() {
            this.limit = this.pos;
            this.pos = 0;
            IEvsIOBuf iEvsIOBuf = this.iobufList.getNext(null);
            while (iEvsIOBuf != null) {
                iEvsIOBuf.flip();
                iEvsIOBuf = this.iobufList.getNext(iEvsIOBuf);
            }
            if (((IONetworkConnectionOutputStream)IONetworkConnectionOutputStream.this).trace.debug) {
                IONetworkConnectionOutputStream.this.trace.debugln("OutputStream.Buffer.flip (pre-drain) : Buf = <pos=" + this.pos + ", lim=" + this.limit + ", currBuf=" + this.iobufCurrent + ">");
            }
        }

        final boolean postDrain() {
            boolean bl = true;
            IEvsIOBuf iEvsIOBuf = this.iobufList.getNext(null);
            while (iEvsIOBuf != null) {
                this.pos += iEvsIOBuf.getPos();
                if (iEvsIOBuf.getLimit() > iEvsIOBuf.getPos()) {
                    bl = false;
                    break;
                }
                iEvsIOBuf = this.iobufList.getNext(iEvsIOBuf);
            }
            if (((IONetworkConnectionOutputStream)IONetworkConnectionOutputStream.this).trace.debug) {
                IONetworkConnectionOutputStream.this.trace.debugln("OutputStream.Buffer.postDrain (post-drain) : Buf = <pos=" + this.pos + ", lim=" + this.limit + ", currBuf=" + this.iobufCurrent + ">");
            }
            return bl;
        }

        final void reset() {
            if (this.pos != this.limit) {
                throw new InternalError("pos != limit after full drain");
            }
            this.limit = 0;
            this.pos = 0;
            IEvsIOBuf iEvsIOBuf = this.iobufList.getNext(null);
            while (iEvsIOBuf != null) {
                iEvsIOBuf.reset();
                this.limit += iEvsIOBuf.getLimit();
                iEvsIOBuf = this.iobufList.getNext(iEvsIOBuf);
            }
            this.iobufCurrent = this.iobufList.getNext(null);
        }

        final void compact() {
            this.limit = 0;
            this.pos = 0;
            IEvsIOBuf iEvsIOBuf = this.iobufList.getNext(null);
            while (iEvsIOBuf != null && iEvsIOBuf.getPos() == iEvsIOBuf.getLimit()) {
                this.iobufList.remove(iEvsIOBuf);
                iEvsIOBuf = this.iobufList.getNext(null);
            }
            if (iEvsIOBuf != null) {
                do {
                    iEvsIOBuf.compact();
                    iEvsIOBuf.setLimit(iEvsIOBuf.getPos());
                    this.pos += iEvsIOBuf.getPos();
                    this.limit += iEvsIOBuf.getLimit();
                } while (iEvsIOBuf != this.iobufCurrent && (iEvsIOBuf = this.iobufList.getNext(iEvsIOBuf)) != null);
            } else {
                this.iobufCurrent = null;
            }
            if (iEvsIOBuf != null) {
                IEvsIOBuf iEvsIOBuf2;
                while ((iEvsIOBuf2 = this.iobufList.getNext(iEvsIOBuf)) != null) {
                    this.iobufList.remove(iEvsIOBuf2);
                }
            }
            if (((IONetworkConnectionOutputStream)IONetworkConnectionOutputStream.this).trace.debug) {
                IONetworkConnectionOutputStream.this.trace.debugln("OutputStream.Buffer.compact (pre-fill) : Buf = <pos=" + this.pos + ", lim=" + this.limit + ", currBuf=" + this.iobufCurrent + ">");
            }
        }

        final int size() {
            return this.pos;
        }

        final IEvsIOBufList iobufList() {
            return this.iobufList;
        }

        final boolean write(byte[] byArray, int n, int n2) {
            boolean bl = false;
            if (((IONetworkConnectionOutputStream)IONetworkConnectionOutputStream.this).trace.debug) {
                IONetworkConnectionOutputStream.this.trace.debugln("OutputStream.Buffer.write : <" + n + "," + n2 + ">" + " Buf = <pos=" + this.pos + ", lim=" + this.limit + ", currBuf=" + this.iobufCurrent + ">");
            }
            if (this.iobufCurrent == null) {
                if (this.limit != this.pos) {
                    throw new InternalError("Current is null but remaining is not zero!");
                }
                this.iobufCurrent = EvsIOBuf.create(this.quantum);
                this.iobufList.append(this.iobufCurrent);
                this.limit += this.iobufCurrent.getLimit();
                bl = true;
                if (((IONetworkConnectionOutputStream)IONetworkConnectionOutputStream.this).trace.debug) {
                    IONetworkConnectionOutputStream.this.trace.debugln("OutputStream.Buffer.write : Allocated new buffer..." + this.iobufCurrent);
                }
            }
            int n3 = this.iobufCurrent.write(byArray, n, n2);
            if (this.iobufCurrent.getPos() == this.iobufCurrent.getLimit()) {
                if (((IONetworkConnectionOutputStream)IONetworkConnectionOutputStream.this).trace.debug) {
                    IONetworkConnectionOutputStream.this.trace.debugln("OutputStream.Buffer.write : Updating current buffer");
                }
                this.iobufCurrent = this.iobufList.getNext(this.iobufCurrent);
            }
            this.pos += n3;
            if (n3 < n2) {
                bl |= this.write(byArray, n + n3, n2 - n3);
            }
            return bl;
        }
    }

    private final class SyncFlushContext {
        boolean done;
        EEvsIOException status;
        int bytesFlushed = 0;

        private SyncFlushContext() {
        }

        final void reset() {
            this.done = false;
            this.status = null;
            this.bytesFlushed = 0;
        }

        public final String toString() {
            return "[done=" + this.done + ", status=" + (this.status == null ? "ok" : this.status.getMessage()) + ", bytesFlushed=" + this.bytesFlushed + "]";
        }
    }
}

