/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.framework.IMessageLogger;
import com.sonicsw.mf.framework.agent.Agent;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

class ConsoleLogger
implements IMessageLogger {
    private Agent m_agent;
    private Writer m_writer;
    private final OutputStream m_delegate;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    ConsoleLogger(Agent agent, OutputStream outputStream) {
        this.m_agent = agent;
        this.m_delegate = outputStream;
        this.createLogWriter(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logMessage(String logMessageParam) {
        String logMessage = logMessageParam;
        OutputStream outputStream = this.m_delegate;
        synchronized (outputStream) {
            try {
                logMessage = logMessage + LINE_SEPARATOR;
                this.m_writer.write(logMessage);
                this.m_writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void createLogWriter(OutputStream outputStream) {
        OutputStreamWriter osw = new OutputStreamWriter(outputStream);
        this.m_writer = new BufferedWriter(osw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(int b) {
        OutputStream outputStream = this.m_delegate;
        synchronized (outputStream) {
            try {
                this.m_writer.write(b);
                this.m_writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(byte[] b, int off, int len) {
        OutputStream outputStream = this.m_delegate;
        synchronized (outputStream) {
            try {
                for (int i = off; i < off + len; ++i) {
                    this.m_writer.write(b[i]);
                }
                this.m_writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

