/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import java.util.LinkedList;

final class AccessSemaphore {
    private LinkedList m_waitersQueue = new LinkedList();

    AccessSemaphore() {
    }

    private int getFirstLockTypeIndx(int lockType) {
        if (this.m_waitersQueue.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        for (int index = 0; index < this.m_waitersQueue.size(); ++index) {
            Caller caller = (Caller)this.m_waitersQueue.get(index);
            if (caller.state != lockType) continue;
            return index;
        }
        return Integer.MAX_VALUE;
    }

    private int getIndex(Thread t) {
        if (this.m_waitersQueue.isEmpty()) {
            return -1;
        }
        for (int index = 0; index < this.m_waitersQueue.size(); ++index) {
            Caller caller = (Caller)this.m_waitersQueue.get(index);
            if (caller.t != t) continue;
            return index;
        }
        return -1;
    }

    synchronized void sharedLock() {
        Caller caller;
        Thread me = Thread.currentThread();
        int index = this.getIndex(me);
        if (index == -1) {
            caller = new Caller(me, 0);
            this.m_waitersQueue.addLast(caller);
        } else {
            caller = (Caller)this.m_waitersQueue.get(index);
        }
        boolean interrupted = false;
        do {
            interrupted = false;
            try {
                while (this.getIndex(me) > this.getFirstLockTypeIndx(1)) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while (interrupted);
        ++caller.nAcquires;
    }

    synchronized void exclusiveLock() {
        Caller caller;
        Thread me = Thread.currentThread();
        int index = this.getIndex(me);
        if (index == -1) {
            caller = new Caller(me, 1);
            this.m_waitersQueue.addLast(caller);
        } else {
            caller = (Caller)this.m_waitersQueue.get(index);
            if (caller.state == 0) {
                throw new Error("Lock upgrade is invalid");
            }
            caller.state = 1;
        }
        boolean interrupted = false;
        do {
            interrupted = false;
            try {
                while (this.getIndex(me) != 0) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while (interrupted);
        ++caller.nAcquires;
    }

    synchronized void releaseLock() {
        Thread me = Thread.currentThread();
        int index = this.getIndex(me);
        if (index == -1) {
            return;
        }
        if (index > this.getFirstLockTypeIndx(1)) {
            throw new Error("Conflicting WRITE lock");
        }
        Caller caller = (Caller)this.m_waitersQueue.get(index);
        --caller.nAcquires;
        if (caller.nAcquires == 0) {
            this.m_waitersQueue.remove(index);
            this.notifyAll();
        }
    }

    private final class Caller {
        static final int READ = 0;
        static final int WRITE = 1;
        Thread t;
        int state;
        int nAcquires;

        Caller(Thread t, int state) {
            this.t = t;
            this.state = state;
            this.nAcquires = 0;
        }
    }
}

