/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.Dbkey;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IObjectsBufferNote;
import com.sonicsw.mtstorage.impl.IRedoNoteInfo;
import java.io.IOException;

final class CreateNote
extends AbstractNote
implements IObjectsBufferNote,
IRedoNoteInfo {
    static final byte NOTE_TYPE = 2;
    byte[] m_scratchBuffer = new byte[8];
    long m_dbkey;
    short m_fragmentSize;
    int m_classType;
    boolean m_lead;
    boolean m_last;
    int m_totalObjectLength;

    CreateNote() {
    }

    public String toString() {
        return this.getClass().getName() + " dbk " + this.m_dbkey;
    }

    @Override
    public long getDbkey() {
        return this.m_dbkey;
    }

    @Override
    public long getPageNum() {
        return Dbkey.getPageNumber(this.m_dbkey);
    }

    @Override
    public byte getSlotNum() {
        return Dbkey.getSlot(this.m_dbkey);
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write((byte)2);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_dbkey);
        writer.write(this.m_scratchBuffer, 0, 8);
        BitUtil.putShort(this.m_scratchBuffer, 0, this.m_fragmentSize);
        writer.write(this.m_scratchBuffer, 0, 2);
        writer.write((byte)(this.m_lead ? 1 : 0));
        writer.write((byte)(this.m_last ? 1 : 0));
        int noteLength = 13;
        if (this.m_lead) {
            BitUtil.putInt(this.m_scratchBuffer, 0, this.m_classType);
            writer.write(this.m_scratchBuffer, 0, 4);
            noteLength += 4;
        }
        if (this.m_lead && !this.m_last) {
            BitUtil.putInt(this.m_scratchBuffer, 0, this.m_totalObjectLength);
            writer.write(this.m_scratchBuffer, 0, 4);
            noteLength += 4;
        }
        return noteLength;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        int currentOffset = offset;
        this.m_dbkey = BitUtil.getLong(buffer, currentOffset);
        this.m_fragmentSize = BitUtil.getShort(buffer, currentOffset += 8);
        currentOffset += 2;
        this.m_lead = buffer[currentOffset++] == 1;
        boolean bl = this.m_last = buffer[currentOffset++] == 1;
        if (this.m_lead) {
            this.m_classType = BitUtil.getInt(buffer, currentOffset);
            currentOffset += 4;
        }
        if (this.m_lead && !this.m_last) {
            this.m_totalObjectLength = BitUtil.getInt(buffer, currentOffset);
        }
    }

    void initNote(long dbkey, short fragmentSize, int classType, boolean lead, boolean last, int totalObjectLength) {
        this.m_dbkey = dbkey;
        this.m_fragmentSize = fragmentSize;
        this.m_classType = classType;
        this.m_totalObjectLength = totalObjectLength;
        this.m_lead = lead;
        this.m_last = last;
    }
}

