/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.Database;
import com.odi.Segment;
import com.odi.Session;
import com.odi.UpdateReadOnlyException;
import com.odi.imp.ObjectManager;
import com.odi.imp.PersistentObjectIterator;
import java.util.Iterator;

public abstract class Cluster
extends com.odi.Cluster {
    public static final int EXPORTED_CLUSTER_ID = -4;
    protected final com.odi.imp.Segment segment;
    protected final int clusterId;
    protected final ObjectManager om;

    @Override
    public com.odi.Cluster getCluster() {
        return this;
    }

    @Override
    public Segment getSegment() {
        return this.segment;
    }

    @Override
    public Database getDatabase() {
        return this.segment.getDatabase();
    }

    @Override
    public int getClusterId() {
        return this.clusterId;
    }

    protected Cluster(com.odi.imp.Segment seg, int cluid, ObjectManager oman) {
        this.segment = seg;
        this.clusterId = cluid;
        this.om = oman;
    }

    @Override
    public Session getSession() {
        return this.segment.getSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(7);
            if (this.segment.getDatabase().getOpenMode() != 7) {
                throw new UpdateReadOnlyException("Attempt to destroy a cluster in a database that was open read-only.");
            }
            this.segment.serverCheckCluster(this.clusterId);
            this.om.forgetObjectsInCluster(this, true);
            this.serverDestroy();
        }
    }

    public abstract void serverDestroy();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireLock(int lockType, int timeoutMillis) {
        ObjectManager.checkAcquireLockArguments(lockType, timeoutMillis, "Cluster");
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(lockType);
            this.serverAcquireLock(lockType, timeoutMillis);
        }
    }

    public abstract void serverAcquireLock(int var1, int var2);

    @Override
    public Iterator getObjects() {
        return new PersistentObjectIterator(this);
    }

    @Override
    public Iterator getObjects(Class ofType) {
        return new PersistentObjectIterator(this, ofType);
    }
}

