/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp.mtsonic;

import com.odi.DatabaseNotOpenException;
import com.odi.DatabaseRootAlreadyExistsException;
import com.odi.DatabaseRootNotFoundException;
import com.odi.DatabaseSegmentEnumeration;
import com.odi.FatalInternalException;
import com.odi.IncompatibleOpenModeException;
import com.odi.ObjectException;
import com.odi.ObjectNotFoundException;
import com.odi.ObjectStore;
import com.odi.ObjectStoreException;
import com.odi.SegmentException;
import com.odi.SegmentNotFoundException;
import com.odi.Session;
import com.odi.Transaction;
import com.odi.UpdateReadOnlyException;
import com.odi.imp.DatabaseIdAndMode;
import com.odi.imp.MutatingObjRef;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.Segment;
import com.odi.imp.Server;
import com.odi.imp.Utilities;
import com.odi.imp.mtsonic.Cluster;
import com.odi.imp.mtsonic.ObjectTable;
import com.odi.util.OSHashtable;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public final class Database
extends com.odi.imp.Database {
    private static final int ROOT_TABLE_INDEX = 0;
    private static final int SCHEMA_CLASS_COUNT_INDEX = 1;
    private static final int SCHEMA_STRING_INDEX = 2;
    private static final int HEADER_LENGTH = 8;
    private com.odi.imp.mtsonic.Server sv;
    final com.odi.imp.mtsonic.Segment theSegment;
    private Object[] header = null;
    private int openMode;

    public boolean serverOpenDatabaseByID(int openMode, HashMap parameters) {
        return this.openDatabaseByID(openMode, parameters, false);
    }

    @Override
    public boolean serverOpenDatabaseByID(int openMode) {
        return this.openDatabaseByID(openMode, null, false);
    }

    @Override
    public int serverDatabaseOpenMode() {
        if (this.openMode == 0) {
            throw new DatabaseNotOpenException("Database is not open.");
        }
        return this.openMode;
    }

    @Override
    public void backup(String backupDB) {
        try {
            this.sv.objectTable.backup(backupDB);
        }
        catch (IOException e) {
            this.sv.IOFailure(e);
        }
    }

    @Override
    public void serverClose() {
        com.odi.imp.mtsonic.Transaction.assureNone("close a database");
        this.assureOpen("close a database");
        try {
            this.sv.objectTable.closeDatabase();
        }
        catch (IOException e) {
            this.sv.IOFailure(e);
        }
        this.sv.currentDatabase.openMode = 0;
        this.sv.currentDatabase = null;
    }

    @Override
    public void serverDestroy() {
        com.odi.imp.mtsonic.Transaction.assureNone("destroy a database");
        this.assureOpenUpdate("destroy a database");
        try {
            this.sv.objectTable.destroyDatabase();
        }
        catch (IOException e) {
            this.sv.IOFailure(e);
        }
        this.sv.currentDatabase.openMode = 0;
        this.sv.currentDatabase = null;
    }

    @Override
    public long serverGetSizeInBytes() {
        this.assureRead("get the size of a database");
        return this.sv.objectTable.databaseGetSizeInBytes();
    }

    @Override
    public void serverCreateRoot(String name, byte[] ref) {
        this.assureUpdate("create a root");
        ObjectStore.fetch(this.header);
        Object[] indirectRoots = (Object[])this.header[0];
        OSHashtable roots = null;
        if (indirectRoots == null) {
            ObjectStore.dirty(this.header);
            roots = new OSHashtable(23);
            indirectRoots = new Object[]{roots};
            ObjectStore.migrate(indirectRoots, this.theSegment, false);
            this.header[0] = indirectRoots;
        } else {
            ObjectStore.fetch(indirectRoots);
            roots = (OSHashtable)indirectRoots[0];
        }
        if (roots.containsKey(name)) {
            throw new DatabaseRootAlreadyExistsException("Database root " + name + " already exists.");
        }
        Object rootValue = this.om.getJavaReference(ref, 0);
        String nameCopy = new String(name);
        ObjectStore.migrate(nameCopy, this.theSegment, false);
        roots.put(nameCopy, rootValue == null ? roots : rootValue);
    }

    @Override
    public void serverDestroyRoot(String name) {
        this.assureUpdate("destroy a root");
        ObjectStore.fetch(this.header);
        Object[] indirectRoots = (Object[])this.header[0];
        if (indirectRoots != null) {
            ObjectStore.fetch(indirectRoots);
            OSHashtable roots = (OSHashtable)indirectRoots[0];
            Object existingName = roots.getKey(name, true);
            if (existingName != null) {
                roots.remove(name);
                ObjectStore.destroy(existingName);
                return;
            }
        }
        throw new DatabaseRootNotFoundException("Database root " + name + " was not found.");
    }

    @Override
    public byte[] serverGetRoot(String name) {
        this.assureRead("get a root");
        ObjectStore.fetch(this.header);
        Object[] indirectRoots = (Object[])this.header[0];
        if (indirectRoots != null) {
            ObjectStore.fetch(indirectRoots);
            OSHashtable roots = (OSHashtable)indirectRoots[0];
            Object rootValue = roots.get(name, true);
            if (rootValue != null) {
                if (rootValue == roots) {
                    rootValue = null;
                }
                byte[] result = new byte[this.om.objectAccess.referenceSize];
                this.om.putJavaReference(result, 0, rootValue, (Cluster)this.getDefaultSegment().getDefaultCluster(), true);
                return result;
            }
            if (roots.containsKey(name, true)) {
                throw new ObjectNotFoundException("root refers to destroyed object");
            }
        }
        throw new DatabaseRootNotFoundException("Database root " + name + " was not found.");
    }

    @Override
    public void serverSetRoot(String name, byte[] ref) {
        this.assureUpdate("set a root");
        ObjectStore.fetch(this.header);
        Object[] indirectRoots = (Object[])this.header[0];
        if (indirectRoots != null) {
            ObjectStore.fetch(indirectRoots);
            OSHashtable roots = (OSHashtable)indirectRoots[0];
            if (roots.containsKey(name)) {
                Object rootValue = this.om.getJavaReference(ref, 0);
                roots.put(name, rootValue == null ? roots : rootValue);
                return;
            }
        }
        throw new DatabaseRootNotFoundException("Database root " + name + " was not found.");
    }

    @Override
    public Enumeration serverGetRoots() {
        this.assureRead("get all roots");
        ObjectStore.fetch(this.header);
        Object[] indirectRoots = (Object[])this.header[0];
        if (indirectRoots != null) {
            ObjectStore.fetch(indirectRoots);
            OSHashtable roots = (OSHashtable)indirectRoots[0];
            OSHashtable theClone = (OSHashtable)roots.clone();
            return theClone.keys();
        }
        return null;
    }

    @Override
    public Enumeration serverGetRootValues() {
        this.assureRead("get all root values");
        ObjectStore.fetch(this.header);
        Object[] indirectRoots = (Object[])this.header[0];
        if (indirectRoots != null) {
            ObjectStore.fetch(indirectRoots);
            OSHashtable roots = (OSHashtable)indirectRoots[0];
            Object rootValue = roots.get(this.name, true);
            OSHashtable theClone = (OSHashtable)roots.clone();
            return theClone.elements();
        }
        return null;
    }

    @Override
    public Segment serverCreateNewSegment() {
        this.assureUpdate("create a segment");
        throw new SegmentException("Creating multiple segments is not supported in the Pro version.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.odi.Segment getDefaultSegment() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(6);
            this.assureRead("get default segment");
            return this.theSegment;
        }
    }

    @Override
    public boolean serverCheckSegment(int segmentId) {
        this.assureRead("check a segment");
        if (segmentId != 0) {
            throw new SegmentNotFoundException("Segment " + segmentId + " was not found.");
        }
        return false;
    }

    @Override
    public Segment serverCreateExistingSegment(int segmentId) {
        if (segmentId != 0) {
            throw new SegmentException("Using a non-default segment is not supported in the Pro version.");
        }
        return this.theSegment;
    }

    @Override
    public MutatingObjRef serverExportObject(ObjectReference objRef, int exportId) {
        throw new ObjectException("Exporting objects is not supported in the Pro version.");
    }

    @Override
    public void serverDestroyObject(ObjectReference objRef) {
        this.assureUpdate("destroy an object");
        try {
            this.sv.objectTable.deleteObject(objRef.getLocation(), true);
        }
        catch (IOException e) {
            this.sv.IOFailure(e);
        }
    }

    @Override
    public int serverGetDefaultSegmentId() {
        this.assureOpen("get the default segment");
        return 0;
    }

    @Override
    public void serverSetDefaultSegmentId(int segmentId) {
        this.assureOpen("set the default segment");
    }

    @Override
    public DatabaseSegmentEnumeration serverGetSegments() {
        this.assureRead("get all segments");
        int[] segids = new int[]{0};
        return new com.odi.imp.DatabaseSegmentEnumeration(this.om, this, segids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties serverGC(Properties GCProperties) {
        Properties ret = null;
        Transaction t = null;
        try {
            this.openDatabaseByID(7, null, true);
            t = com.odi.imp.mtsonic.Transaction.begin(7);
            ret = this.sv.objectTable.GC(GCProperties);
            t.commit();
        }
        finally {
            if (Session.getCurrent() != null) {
                if (t != null && t.isActive()) {
                    t.commit();
                }
                if (this.isOpen()) {
                    this.close();
                }
            }
        }
        return ret;
    }

    @Override
    public void serverInstallTypes(int[] installAftcs, int[] installAvtcs) {
        throw new ObjectStoreException("Database.installTypes() is not supported in PSE or PSE Pro.");
    }

    @Override
    public String[] serverGetSchemaClasses() {
        return this.sv.schemaManager.getAllClasses();
    }

    @Override
    public int serverGetSchemaClassCount() {
        return this.sv.schemaManager.getClassCount();
    }

    @Override
    public String serverGetSchemaString() {
        return this.sv.schemaManager.getCurrentSchemaString();
    }

    public void serverUpgradeSchema(String[] skipTypes) {
        this.sv.schemaManager.upgradeSchema(skipTypes);
    }

    @Override
    public void serverAffiliate(int targetDbid, boolean deep) {
        throw new ObjectStoreException("Database.affiliate() is not supported in PSE or PSE Pro.");
    }

    @Override
    public Iterator serverGetAffiliatedDatabases() {
        throw new ObjectStoreException("Database.getAffiliatedDatabases() is not supported in PSE or PSE Pro.");
    }

    @Override
    public void serverAcquireLock(int lockType, int timeoutMillis) {
        if (lockType == 7) {
            this.assureUpdate("acquire an update lock on a database");
        } else {
            this.assureRead("acquire a lock on a database");
        }
    }

    @Override
    public int serverGetNDeadObjects() {
        return this.sv.objectTable.getNDeadOTEs();
    }

    @Override
    public void serverResync() {
        this.sv.objectTable.resync();
    }

    static int serverCreateDatabase(com.odi.imp.mtsonic.Server sv, String pathname, int fileMode, HashMap parameters, ObjectManager om) {
        String[] schemaStringIndirect;
        com.odi.imp.mtsonic.Transaction.assureNone("create a database");
        try {
            sv.objectTable.createDatabase(pathname, parameters);
        }
        catch (IOException e) {
            sv.IOFailure(e);
        }
        Database database = (Database)sv.databasesByName.get(pathname);
        if (database == null) {
            database = new Database(sv, sv.nextDatabaseId++, pathname, 7, om);
        } else {
            database.openMode = 7;
        }
        Transaction transaction = com.odi.imp.mtsonic.Transaction.begin(7);
        database.header = new Object[8];
        database.header[1] = new Integer(0);
        database.header[2] = schemaStringIndirect = new String[]{""};
        ObjectStore.migrate(database.header, database.theSegment.theCluster, false);
        ObjectReference ref = om.getObjRef(database.header);
        sv.objectTable.databaseSetHeader(ref.getLocation());
        sv.schemaManager.beginTransaction(database);
        sv.currentDatabase = database;
        transaction.commit();
        return database.getDatabaseId();
    }

    private static void checkOpenMode(int openMode) {
        switch (openMode) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            case 10: {
                throw new IllegalArgumentException("PSE does not support the MULTI_DB_MVCC database open mode.");
            }
        }
        throw new IllegalArgumentException("Invalid database open mode: " + openMode);
    }

    static boolean serverOpenDatabaseByName(com.odi.imp.mtsonic.Server sv, String pathname, int openMode, HashMap parameters, ObjectManager om, DatabaseIdAndMode diam) {
        Database database = (Database)sv.databasesByName.get(pathname);
        if (database == null) {
            database = new Database(sv, sv.nextDatabaseId++, pathname, 0, om);
        }
        boolean retVal = database.serverOpenDatabaseByID(openMode, parameters);
        diam.set(database.getDatabaseId(), openMode);
        return retVal;
    }

    void makeInUse() {
        long location = this.sv.objectTable.databaseGetHeader();
        MutatingObjRef tempObjRef = this.om.objRefFactory.createMutating();
        tempObjRef.setObjectId(this.getDefaultSegment(), location);
        tempObjRef.AFTypeCode = Utilities.makeArrayTypeCode(1, 100);
        tempObjRef.arrayElementCount = 8;
        byte[] refBytes = new byte[this.om.objectAccess.referenceSize];
        this.om.objectAccess.encodeObjRef(refBytes, 0, tempObjRef);
        this.header = (Object[])this.om.getJavaReference(refBytes, 0);
        this.sv.schemaManager.beginTransaction(this);
    }

    static Database get(com.odi.imp.mtsonic.Server sv, int databaseId, String pathname, int openMode, ObjectManager om) {
        if (sv.currentDatabase != null && databaseId == sv.currentDatabase.getDatabaseId()) {
            return sv.currentDatabase;
        }
        Database existing = (Database)sv.databasesByName.get(pathname);
        if (existing != null) {
            Database.odiAssert(databaseId == existing.databaseId && openMode == existing.openMode);
            return existing;
        }
        Database.odiAssert(openMode == 0);
        return new Database(sv, databaseId, pathname, openMode, om);
    }

    @Override
    protected Server getServer() {
        return this.sv;
    }

    void assureOpen(String operationName) {
        if (this.openMode == 0) {
            throw new DatabaseNotOpenException("Attempt to " + operationName + " for database " + this.name + " which is not open.");
        }
    }

    void assureRead(String operationName) {
        com.odi.imp.mtsonic.Transaction.assure(operationName);
        this.assureOpen(operationName);
    }

    void assureUpdate(String operationName) {
        com.odi.imp.mtsonic.Transaction.assureUpdate(operationName);
        this.assureOpenUpdate(operationName);
    }

    void assureOpenUpdate(String operationName) {
        this.assureOpen(operationName);
        if (this.openMode != 7 && this.openMode != 4) {
            throw new UpdateReadOnlyException("Attempt to " + operationName + " for database " + this.name + " which is not open for update.");
        }
    }

    int getSchemaClassCount() {
        ObjectStore.fetch(this.header);
        return (Integer)this.header[1];
    }

    void setSchemaClassCount(int count) {
        ObjectStore.dirty(this.header);
        this.header[1] = new Integer(count);
    }

    String getSchemaString() {
        ObjectStore.fetch(this.header);
        Object[] indirect = (String[])this.header[2];
        ObjectStore.fetch(indirect);
        return indirect[0];
    }

    void setSchemaString(String string) {
        ObjectStore.fetch(this.header);
        Object[] indirect = (String[])this.header[2];
        ObjectStore.dirty(indirect);
        ObjectStore.destroy(indirect[0]);
        indirect[0] = string;
    }

    public ObjectTable debugGetObjectTable() {
        return this.sv.objectTable;
    }

    public boolean hasLock(Session sess) {
        return this.sv.objectTable.hasLock(sess);
    }

    private Database(com.odi.imp.mtsonic.Server sv, int databaseId, String pathname, int openMode, ObjectManager om) {
        super(databaseId, pathname, om);
        this.sv = sv;
        this.openMode = openMode;
        this.theSegment = new com.odi.imp.mtsonic.Segment(sv, this, 0, om);
        sv.databasesByName.put(pathname, this);
    }

    private static void odiAssert(boolean x) {
        if (!x) {
            throw new FatalInternalException("Assertion violated.");
        }
    }

    private void checkOpenModeCompatible(int openMode) {
        if (openMode != this.openMode) {
            throw new IncompatibleOpenModeException("Attempt to open database \"" + this.getPath() + "\" with open mode " + Database.getOpenModeName(openMode) + ", but it is already open with incompatible open mode " + Database.getOpenModeName(this.openMode) + ".");
        }
    }

    private static String getOpenModeName(int openMode) {
        switch (openMode) {
            case 7: {
                return "update";
            }
            case 6: {
                return "read-only";
            }
            case 3: {
                return "MVCC";
            }
            case 10: {
                return "MULTI_DB_MVCC";
            }
            case 4: {
                return "update non-blocking";
            }
            case 5: {
                return "read-only non-blocking";
            }
        }
        return "[unknown]";
    }

    @Override
    public String serverGetHostName() {
        return null;
    }

    private boolean openDatabaseByID(int openMode, HashMap parameters, boolean exclusive) {
        if (openMode == 8) {
            if (this.openMode != 0) {
                return true;
            }
            openMode = this.sv.autoOpenMode;
            if (openMode == 99) {
                this.assureOpen("open a database");
                return false;
            }
        }
        if (this.openMode != 0) {
            this.checkOpenModeCompatible(openMode);
            return true;
        }
        Database.checkOpenMode(openMode);
        try {
            boolean updateMode = openMode == 7 || openMode == 4;
            this.sv.objectTable.openDatabase(this.name, updateMode, openMode == 3, parameters, 0, exclusive);
        }
        catch (IOException e) {
            this.sv.IOFailure(e);
        }
        this.sv.currentDatabase = this;
        this.sv.currentDatabase.openMode = openMode;
        if (com.odi.imp.mtsonic.Transaction.inTransaction()) {
            this.makeInUse();
        }
        return false;
    }
}

