/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp.mtsonic;

import com.odi.ObjectStoreException;
import com.odi.ReplicationController;
import com.odi.ReplicationStateHandler;
import com.odi.Storage;
import com.odi.imp.mtsonic.DatabasesTable;
import com.sonicsw.mtstorage.replication.ReplicationManager;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class PhysicalStorage
extends Storage {
    private String m_path;

    public PhysicalStorage(String path) {
        this.m_path = path;
    }

    public static PhysicalStorage openPhysicalStorage(String path, HashMap storageParameters) throws ObjectStoreException {
        try {
            path = new File(path).getCanonicalPath();
            DatabasesTable.m_databases.openPhysicalStorage(path, false, storageParameters);
            return new PhysicalStorage(path);
        }
        catch (IOException e) {
            throw new ObjectStoreException(e.toString());
        }
    }

    public static PhysicalStorage createPhysicalStorage(String path, HashMap storageParameters) throws ObjectStoreException {
        try {
            path = new File(path).getCanonicalPath();
            DatabasesTable.m_databases.openPhysicalStorage(path, true, storageParameters);
            return new PhysicalStorage(path);
        }
        catch (IOException e) {
            throw new ObjectStoreException(e.toString());
        }
    }

    public static PhysicalStorage openPhysicalStorage(ReplicationController controller, ReplicationStateHandler callerStateListener, String path, HashMap storageParameters, boolean thisPrimary, boolean startActive, boolean autoDualActiveResolve, HashMap[] channelConfigs) throws ObjectStoreException {
        try {
            path = new File(path).getCanonicalPath();
            DatabasesTable.m_databases.openPhysicalStorage(controller, callerStateListener, path, storageParameters, false, thisPrimary, startActive, autoDualActiveResolve, channelConfigs);
            return new PhysicalStorage(path);
        }
        catch (IOException e) {
            throw new ObjectStoreException(e.toString());
        }
    }

    public static PhysicalStorage createPhysicalStorage(ReplicationController controller, ReplicationStateHandler callerStateListener, String path, HashMap storageParameters, boolean thisPrimary, boolean startActive, boolean autoDualActiveResolve, HashMap[] channelConfigs) throws ObjectStoreException {
        try {
            path = new File(path).getCanonicalPath();
            DatabasesTable.m_databases.openPhysicalStorage(controller, callerStateListener, path, storageParameters, true, thisPrimary, startActive, autoDualActiveResolve, channelConfigs);
            return new PhysicalStorage(path);
        }
        catch (IOException e) {
            throw new ObjectStoreException(e.toString());
        }
    }

    public static void setReplicationTracing(boolean trace, boolean trace_verbose) {
        ReplicationManager.setTracing(trace, trace_verbose);
    }

    @Override
    public void close() throws ObjectStoreException {
        DatabasesTable.m_databases.closePhysicalStorage(this.m_path);
    }
}

