/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.io.evs;

import com.progress.blackbird.evs.EEvsIOCancelledException;
import com.progress.blackbird.evs.EEvsIOException;
import com.progress.blackbird.evs.EEvsIONotPendingException;
import com.progress.blackbird.evs.EEvsIOPendingException;
import com.progress.blackbird.evs.IEvsDispatcher;
import com.progress.blackbird.evs.IEvsIOBuf;
import com.progress.blackbird.evs.IEvsIOBufList;
import com.progress.blackbird.evs.IEvsNetworkPort;
import com.progress.blackbird.evs.IEvsNetworkPortDataEvent;
import com.progress.blackbird.evs.IEvsPortEvent;
import com.progress.blackbird.evs.IEvsPortEventHandler;
import com.progress.blackbird.evs.nio.EvsDPCPort;
import com.progress.blackbird.evs.nio.EvsIOBuf;
import com.progress.blackbird.evs.nio.EvsIOBufList;
import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOInboundStreamClosedException;
import com.progress.blackbird.io.EIOInboundStreamOpenException;
import com.progress.blackbird.io.EIOInsufficientDataException;
import com.progress.blackbird.io.IIOPacket;
import com.progress.blackbird.io.IIOPacketSerializer;
import com.progress.blackbird.io.evs.IONetworkConnection;
import com.progress.blackbird.io.evs.IONetworkConnectionPingManager;
import com.progress.blackbird.sys.SysTrace;
import java.io.IOException;
import java.io.InputStream;

final class IONetworkConnectionInputStream
extends InputStream
implements IEvsPortEventHandler {
    private final IONetworkConnection connection;
    private final IONetworkConnection.Statistics statistics;
    private final IIOPacketSerializer packetSerializer;
    private final SysTrace trace;
    private final SysTrace packetTrace;
    private final IEvsNetworkPort port;
    private IEvsDispatcher dispatcher;
    private IONetworkConnectionPingManager pingManager;
    private Buffer buffer;
    private BufferMgmtContext bufferMgmtContext;
    private boolean flgPartialPost;
    private int partialPostBufferMark;
    private volatile int state;
    private volatile boolean inDispatch;
    private volatile boolean flgFailing;
    private volatile Exception failException;
    private final int STATE_OPEN = 0;
    private final int STATE_CLOSING = 1;
    private final int STATE_CLOSED = 2;

    IONetworkConnectionInputStream(IONetworkConnection iONetworkConnection, IEvsNetworkPort iEvsNetworkPort, IIOPacketSerializer iIOPacketSerializer, IONetworkConnectionPingManager iONetworkConnectionPingManager, SysTrace sysTrace, SysTrace sysTrace2) {
        this.connection = iONetworkConnection;
        this.statistics = (IONetworkConnection.Statistics)iONetworkConnection.getStatistics();
        this.port = iEvsNetworkPort;
        this.packetSerializer = iIOPacketSerializer;
        this.pingManager = iONetworkConnectionPingManager;
        this.trace = sysTrace;
        this.packetTrace = sysTrace2;
        this.buffer = new Buffer(8192);
        this.bufferMgmtContext = new BufferMgmtContext(8192);
        this.flgPartialPost = false;
        this.partialPostBufferMark = 0;
        this.state = 2;
    }

    private IIOPacket unpackPacket() throws EIOException {
        IIOPacket iIOPacket = null;
        if (this.buffer.remaining() > 0) {
            if (this.trace.debug) {
                this.trace.debugln("InputStream.unpackPacket : Unpacking packet <remaining=" + this.buffer.remaining() + ">...");
            }
            try {
                this.buffer.mark();
                iIOPacket = this.packetSerializer.deserialize(this);
            }
            catch (Exception exception) {
                IEvsIOBuf iEvsIOBuf = this.buffer.last();
                int n = iEvsIOBuf.getPos();
                int n2 = iEvsIOBuf.getLimit();
                int n3 = iEvsIOBuf.getSize();
                this.buffer.rewind();
                int n4 = iEvsIOBuf.getPos();
                if (exception instanceof EIOInsufficientDataException) {
                    int n5 = ((EIOInsufficientDataException)exception).getAdditionalRequiredLen();
                    if (this.trace.debug) {
                        this.trace.debugln("InputStream.unpackPacket : Received EIOInsufficientDataException (requiredLen=" + n5 + ")");
                    }
                    if (n5 < 0) {
                        if (this.trace.debug) {
                            this.trace.debugln("InputStream.unpackPacket : Compacting <pos=" + n + " limit=" + n2 + " size=" + n3 + " remaining=" + this.buffer.remaining() + ">");
                        }
                        iEvsIOBuf.compact();
                        if (this.trace.debug) {
                            this.trace.debugln("InputStream.unpackPacket : Compacted <pos=" + iEvsIOBuf.getPos() + " limit=" + n2 + " size=" + n3 + " remaining=" + this.buffer.remaining() + ">");
                        }
                        if (iEvsIOBuf.getPos() < n3) {
                            this.flgPartialPost = true;
                            this.partialPostBufferMark = 0;
                            iEvsIOBuf.setLimit(n3);
                            if (this.trace.debug) {
                                this.trace.debugln("InputStream.unpackPacket : Limit set <pos=" + iEvsIOBuf.getPos() + " limit=" + n2 + " size=" + n3 + " remaining=" + this.buffer.remaining() + ">");
                            }
                        } else {
                            iEvsIOBuf.reset();
                            this.buffer.graft(this.bufferMgmtContext.quantum);
                            this.flgPartialPost = false;
                        }
                    } else if (n5 <= n3 - n2) {
                        if (this.trace.debug) {
                            this.trace.debugln("InputStream.unpackPacket : Enough space in buffer to complete packet <req=" + n5 + ", space=" + (n3 - n2) + ">");
                        }
                        this.flgPartialPost = true;
                        this.partialPostBufferMark = n4;
                        iEvsIOBuf.setPos(n2);
                        iEvsIOBuf.setLimit(n3);
                    } else if (n2 - n4 < n3 * 20 / 100) {
                        iEvsIOBuf.compact();
                        this.flgPartialPost = true;
                        this.partialPostBufferMark = 0;
                        iEvsIOBuf.setLimit(n3);
                    } else {
                        if (this.trace.debug) {
                            this.trace.debugln("InputStream.unpackPacket : Not enough space in buffer to complete packet");
                        }
                        this.buffer.graft(this.bufferMgmtContext.quantum);
                        this.flgPartialPost = false;
                    }
                }
                if (this.trace.debug) {
                    this.trace.debugln("InputStream.unpackPacket : Received exception during packet unpack - " + exception);
                }
                throw new EIOException(exception);
            }
        }
        return iIOPacket;
    }

    private void unpackPacketsAndDispatch() throws EIOException {
        block4: {
            IIOPacket iIOPacket;
            int n = 0;
            if (this.trace.debug) {
                this.trace.debugln("InputStream.unpackPacketsAndDispatch :  Start (available=" + this.buffer.remaining() + ")...");
            }
            while ((iIOPacket = this.unpackPacket()) != null) {
                if (this.trace.debug) {
                    this.trace.debugln("InputStream.unpackPacketsAndDispatch : successfully unpacked packet - dispatching...");
                }
                this.buffer.prune();
                ++this.statistics.numPacketsRead;
                ++n;
                if (this.packetTrace.debug) {
                    this.packetTrace.debugln("[IN] " + iIOPacket);
                }
                if (this.flgFailing) continue;
                this.inDispatch = true;
                this.pingManager.handlePacket(null, iIOPacket);
                this.inDispatch = false;
            }
            if (!this.trace.debug) break block4;
            this.trace.debugln("InputStream.unpackPacketsAndDispatch : End (#unpacked=" + n + ", available=" + this.buffer.remaining() + ")");
        }
    }

    private void onReadCompletion(IEvsPortEvent iEvsPortEvent) {
        EIOException eIOException;
        IEvsNetworkPortDataEvent iEvsNetworkPortDataEvent;
        boolean bl = false;
        if (this.trace.debug) {
            this.trace.debugln("InputStream.onReadCompletion : on read completion...");
        }
        if ((iEvsNetworkPortDataEvent = (IEvsNetworkPortDataEvent)iEvsPortEvent).getStatus() != null && !(iEvsNetworkPortDataEvent.getStatus() instanceof EEvsIOCancelledException)) {
            if (this.trace.debug) {
                this.trace.debugln("InputStream.onReadCompletion : stream exception - " + iEvsNetworkPortDataEvent.getStatus().getMessage());
            }
            eIOException = new EIOException(iEvsNetworkPortDataEvent.getStatus());
        } else if (iEvsNetworkPortDataEvent.getBytesTransferred() == -1) {
            if (this.trace.debug) {
                this.trace.debugln("InputStream.onReadCompletion : end of stream...");
            }
            eIOException = new EIOException("end of stream");
        } else {
            if (this.trace.debug) {
                this.trace.debugln("InputStream.onReadCompletion : success/cancel - " + iEvsNetworkPortDataEvent.getBytesTransferred());
            }
            eIOException = null;
            this.statistics.numBytesRead += (long)iEvsNetworkPortDataEvent.getBytesTransferred();
            if (iEvsNetworkPortDataEvent.getStatus() instanceof EEvsIOCancelledException) {
                bl = true;
            }
        }
        if (eIOException == null && iEvsNetworkPortDataEvent.getBytesTransferred() > 0) {
            this.buffer.flip();
            if (this.flgPartialPost) {
                if (this.trace.debug) {
                    this.trace.debugln("InputStream.onReadCompletion :  partial post - setting pos=" + this.partialPostBufferMark);
                }
                this.buffer.last().setPos(this.partialPostBufferMark);
                this.flgPartialPost = false;
            } else {
                this.bufferMgmtContext.updateBytesReadPerPostMean(iEvsNetworkPortDataEvent.getBytesTransferred());
                this.bufferMgmtContext.updateBufferQuantum(iEvsNetworkPortDataEvent.getBytesTransferred());
            }
            try {
                this.unpackPacketsAndDispatch();
            }
            catch (EIOException eIOException2) {
                if (this.trace.debug) {
                    this.trace.debugln("InputStream.onReadCompletion :  Exception during packet unpack - " + eIOException2);
                }
                eIOException = eIOException2;
            }
        }
        if (eIOException == null && !bl) {
            try {
                if (this.trace.debug) {
                    this.trace.debugln("InputStream.onReadCompletion : Posting read <pos=" + this.buffer.last().getPos() + ", lim=" + this.buffer.last().getLimit() + ", size=" + this.buffer.last().getSize() + ">...");
                }
                ++this.statistics.numReadsPosted;
                this.port.readPost(this.buffer.last(), this.dispatcher, (byte)15, this, null, 0);
            }
            catch (EEvsIOPendingException eEvsIOPendingException) {
                throw new InternalError("Read post failed - " + eEvsIOPendingException.getMessage());
            }
            catch (EEvsIOException eEvsIOException) {
                eIOException = new EIOException(eEvsIOException);
            }
        }
        if (eIOException != null) {
            this.state = 2;
            this.pingManager.handlePacket(eIOException, null);
        } else if (bl) {
            if (this.trace.debug) {
                this.trace.debugln("InputStream.onReadCompletion : Received read cancel event.");
            }
            this.state = 2;
            if (this.flgFailing) {
                if (this.trace.debug) {
                    this.trace.debugln("InputStream.onReadCompletion : Cancel caused by force fail. Dispatching fail notification...");
                }
                eIOException = this.failException == null ? new EIOException("force fail") : (this.failException instanceof EIOException ? (EIOException)this.failException : new EIOException(this.failException));
                this.pingManager.handlePacket(eIOException, null);
            }
        }
    }

    final void clozeCore() {
        block8: {
            if (Thread.currentThread() != this.dispatcher.getOwner() || this.inDispatch) {
                if (this.trace.debug) {
                    if (Thread.currentThread() != this.dispatcher.getOwner()) {
                        this.trace.debugln("InputStream.cloze : Thread not dispatcher owner. Posting DPC to owner...");
                    } else {
                        this.trace.debugln("InputStream.cloze : Close invoked from within packet handler. Deferring close using DPC...");
                    }
                }
                EvsDPCPort.create(this.connection.isThreaded()).post(this.dispatcher, (byte)31, this, null);
            } else {
                if (this.trace.debug) {
                    this.trace.debugln("InputStream.cloze : Cancelling posted read...");
                }
                try {
                    this.port.readCancel(this.buffer.last());
                }
                catch (EEvsIONotPendingException eEvsIONotPendingException) {
                    if (!this.trace.debug) break block8;
                    this.trace.debugln("InputStream.cloze : Read already cancelled.");
                }
            }
        }
    }

    final void open(IEvsDispatcher iEvsDispatcher) throws EIOInboundStreamOpenException, EIOException {
        if (!this.isOpen()) {
            if (this.trace.debug) {
                this.trace.debugln("InputStream.open : Opening...");
            }
            this.dispatcher = iEvsDispatcher;
            try {
                if (this.trace.debug) {
                    this.trace.debugln("InputStream.open : Posting read...");
                }
                ++this.statistics.numReadsPosted;
                this.port.readPost(this.buffer.last(), iEvsDispatcher, (byte)15, this, null, 0);
                this.state = 0;
                this.flgFailing = false;
            }
            catch (EEvsIOPendingException eEvsIOPendingException) {
                throw new InternalError("Read post failed - " + eEvsIOPendingException.getMessage());
            }
            catch (EEvsIOException eEvsIOException) {
                throw new EIOException("Read post failed - " + eEvsIOException.getMessage());
            }
        } else {
            if (this.trace.debug) {
                this.trace.debugln("InputStream.open : Already open.");
            }
            throw new EIOInboundStreamOpenException();
        }
    }

    final boolean isOpen() {
        return this.state != 2;
    }

    final String getStatisticsString() {
        String string = " InputStream{";
        string = string + this.bufferMgmtContext.bytesReadPerPostMean;
        string = string + ",";
        string = string + this.bufferMgmtContext.quantum;
        string = string + "}";
        return string;
    }

    final void fail(Exception exception) throws EIOInboundStreamClosedException {
        this.flgFailing = true;
        this.failException = exception;
        this.cloze();
    }

    final void cloze() throws EIOInboundStreamClosedException {
        if (this.isOpen()) {
            if (this.state == 1) {
                if (this.trace.debug) {
                    this.trace.debugln("InputStream.cloze : Already closing.");
                }
            } else {
                if (this.trace.debug) {
                    this.trace.debugln("InputStream.cloze : Closing...");
                }
                this.state = 1;
                this.clozeCore();
            }
        } else {
            if (this.trace.debug) {
                this.trace.debugln("InputStream.cloze : Already closed");
            }
            throw new EIOInboundStreamClosedException();
        }
    }

    @Override
    public final int available() throws IOException {
        int n = this.buffer.remaining();
        return n == 0 ? -1 : n;
    }

    @Override
    public final void mark(int n) {
        throw new UnsupportedOperationException("Mark operation not supported on input stream");
    }

    @Override
    public final boolean markSupported() {
        return false;
    }

    @Override
    public final int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.read(byArray, 0, 1) > 0) {
            return byArray[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.buffer.read(byArray, n, n2);
        return n3 > 0 ? n3 : -1;
    }

    @Override
    public final void reset() {
        throw new UnsupportedOperationException("reset not supported on input I/O stream");
    }

    @Override
    public final long skip(long l) {
        throw new UnsupportedOperationException("skip not supported on input I/O stream");
    }

    @Override
    public final void close() throws IOException {
        throw new UnsupportedOperationException("close not supported on input I/O stream");
    }

    @Override
    public void handleEvent(IEvsPortEvent iEvsPortEvent) {
        switch (iEvsPortEvent.getType()) {
            case 4: {
                this.onReadCompletion(iEvsPortEvent);
                break;
            }
            case 1: {
                if (!this.isOpen()) break;
                this.clozeCore();
            }
        }
    }

    private final class BufferMgmtContext {
        int bytesReadPerPostMean;
        int packetSerializeLenMean;
        double lambda;
        int quantum;

        BufferMgmtContext(int n) {
            this.bytesReadPerPostMean = this.packetSerializeLenMean = n;
            this.quantum = this.packetSerializeLenMean;
            this.lambda = 0.1;
        }

        final void updateBufferQuantum(int n) {
            if (n == this.quantum) {
                this.quantum *= 2;
            } else if (this.bytesReadPerPostMean * 2 < this.quantum) {
                this.quantum /= 2;
            }
        }

        final void updateBytesReadPerPostMean(int n) {
            this.bytesReadPerPostMean = (int)(this.lambda * (double)n + (1.0 - this.lambda) * (double)this.bytesReadPerPostMean);
            if (((IONetworkConnectionInputStream)IONetworkConnectionInputStream.this).trace.debug) {
                IONetworkConnectionInputStream.this.trace.debugln("InputStream.BufferMgmtContext:updateBytesReadPerPostMean : bytesReadInPost=" + n + " bytesReadPerPostMean=" + this.bytesReadPerPostMean + " quantum=" + this.quantum);
            }
        }

        final void updatePacketSerializedLenMean(int n) {
            this.packetSerializeLenMean = (int)(this.lambda * (double)n + (1.0 - this.lambda) * (double)this.packetSerializeLenMean);
            if (((IONetworkConnectionInputStream)IONetworkConnectionInputStream.this).trace.debug) {
                IONetworkConnectionInputStream.this.trace.debugln("InputStream.BufferMgmtContext:updatePacketSerializedLenMean : packetSerializedLen=" + n + " packetSerializeLenMean=" + this.packetSerializeLenMean + " quantum=" + this.quantum);
            }
        }
    }

    private final class Buffer {
        private IEvsIOBufList iobufList = EvsIOBufList.create();
        private IEvsIOBuf iobufCurrent;
        private IEvsIOBuf iobufLast;
        private int quantum;

        Buffer(int n) {
            this.graft(n);
        }

        final void flip() {
            this.last().flip();
            this.iobufCurrent = this.iobufList.getNext(null);
        }

        final void graft(int n) {
            if (n > 0) {
                this.quantum = n;
            }
            this.iobufLast = EvsIOBuf.create(this.quantum);
            this.iobufList.append(this.iobufLast);
            if (((IONetworkConnectionInputStream)IONetworkConnectionInputStream.this).trace.debug) {
                IONetworkConnectionInputStream.this.trace.debugln("InputStream.Buffer:graft - Grafting new buffer - buf = " + this.iobufLast + ", quantum = " + n);
            }
        }

        final void prune() {
            EvsIOBuf evsIOBuf = (EvsIOBuf)this.iobufList.getNext(null);
            while (evsIOBuf != null) {
                EvsIOBuf evsIOBuf2 = (EvsIOBuf)this.iobufList.getNext(evsIOBuf);
                if (evsIOBuf.getLimit() - evsIOBuf.getPos() == 0) {
                    if (((IONetworkConnectionInputStream)IONetworkConnectionInputStream.this).trace.debug) {
                        IONetworkConnectionInputStream.this.trace.debugln("InputStream.Buffer:prune : Removing buffer");
                    }
                    if (evsIOBuf == this.iobufCurrent) {
                        throw new InternalError("Current buffer is being removed during prune");
                    }
                    this.iobufList.remove(evsIOBuf);
                }
                evsIOBuf = evsIOBuf2;
            }
            if (this.iobufList.getNext(null) == null) {
                this.iobufLast = null;
            }
        }

        final void mark() {
            if (((IONetworkConnectionInputStream)IONetworkConnectionInputStream.this).trace.debug) {
                IONetworkConnectionInputStream.this.trace.debugln("InputStream.Buffer:mark : Marking buffer");
            }
            IEvsIOBuf iEvsIOBuf = this.iobufList.getNext(null);
            while (iEvsIOBuf != null) {
                iEvsIOBuf.mark();
                iEvsIOBuf = this.iobufList.getNext(iEvsIOBuf);
            }
        }

        final void rewind() {
            if (((IONetworkConnectionInputStream)IONetworkConnectionInputStream.this).trace.debug) {
                IONetworkConnectionInputStream.this.trace.debugln("InputStream.Buffer:rewind : Rewinding buffer");
            }
            IEvsIOBuf iEvsIOBuf = this.iobufList.getNext(null);
            while (iEvsIOBuf != null) {
                iEvsIOBuf.rewindMark();
                iEvsIOBuf = this.iobufList.getNext(iEvsIOBuf);
            }
        }

        final int remaining() {
            IEvsIOBuf iEvsIOBuf = this.iobufList.getNext(null);
            int n = 0;
            while (iEvsIOBuf != null) {
                n += iEvsIOBuf.getLimit() - iEvsIOBuf.getPos();
                iEvsIOBuf = this.iobufList.getNext(iEvsIOBuf);
            }
            if (((IONetworkConnectionInputStream)IONetworkConnectionInputStream.this).trace.debug) {
                IONetworkConnectionInputStream.this.trace.debugln("InputStream.Buffer:remaining : Remaining=" + n);
            }
            return n;
        }

        final IEvsIOBuf last() {
            if (this.iobufLast == null) {
                if (this.iobufList.getNext(null) != null) {
                    throw new InternalError("Last buffer is null but list is not empty!");
                }
                this.graft(0);
            }
            return this.iobufLast;
        }

        final int read(byte[] byArray, int n, int n2) {
            int n3 = 0;
            if (this.iobufCurrent != null) {
                if (((IONetworkConnectionInputStream)IONetworkConnectionInputStream.this).trace.debug) {
                    IONetworkConnectionInputStream.this.trace.debugln("InputStream.Buffer:read : <" + n + "," + n2 + ">" + " Buf = <currBuf=" + this.iobufCurrent + ", pos=" + this.iobufCurrent.getPos() + ", lim=" + this.iobufCurrent.getLimit() + ">");
                }
                n3 += this.iobufCurrent.read(byArray, n, n2);
                if (this.iobufCurrent.getPos() == this.iobufCurrent.getLimit()) {
                    if (((IONetworkConnectionInputStream)IONetworkConnectionInputStream.this).trace.debug) {
                        IONetworkConnectionInputStream.this.trace.debugln("InputStream.Buffer:read : Updating current buffer");
                    }
                    this.iobufCurrent = this.iobufList.getNext(this.iobufCurrent);
                }
                if (n3 < n2) {
                    n3 += this.read(byArray, n + n3, n2 - n3);
                }
            }
            return n3;
        }
    }
}

