/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.sdf.AbstractDiagnosticsProvider;
import com.sonicsw.sdf.DiagnosticsManagerAccess;
import com.sonicsw.sdf.IDiagnosticsConstants;
import com.sonicsw.sdf.IDiagnosticsManager;
import com.sonicsw.sdf.IStateWriter;
import com.sonicsw.sdf.ITracer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class ClassLoaderFactory {
    private static final boolean DEBUG = false;
    private static HashMap m_delegatingLoaders = new HashMap();
    private static HashMap m_delegateLoaders = new HashMap();
    private static URLClassLoader m_globalLoader;
    private static HashMap m_delegateLoaderOwners;
    private static HashMap m_delegateLoaderUsages;
    private static volatile IContainer m_container;
    private static int m_traceMask;
    public static final String[] EMPTY_STRING_ARRAY;
    public static final URL[] EMPTY_URL_ARRAY;
    private static String m_devPrivateClasspath;
    private static String m_devSharedClasspath;
    private static final int SDF_TRACE_NOTHING = 0;
    private static final int SDF_TRACE_NAME = 1;
    private static final int SDF_TRACE_LOADER_NAME = 2;
    private static final int SDF_TRACE_LOADED_PATH = 4;
    private static final int SDF_TRACE_LOADING_THREAD = 8;
    private static final String SDF_DOIID_CLASSES = "Classes";
    private static final String SDF_DOIID_RESOURCES = "Resources";
    public static Class m_classLoaderFactoryClass;
    private static final Class[] TRACE_LOADING_SIGNATURE;
    public static int m_sdfClassTraceMask;
    public static int m_sdfResourceTraceMask;
    private static IDiagnosticsManager m_diagnosticsManager;
    private static ClassLoaderDiagnostics m_classLoaderDiagnostics;

    static void setTraceMask(int traceMask, IContainer container) {
        m_traceMask = traceMask;
        m_container = container;
    }

    public static synchronized ClassLoader createDelegatingLoader(String containerName, String id, URL[] classpathParam, ClassLoader parent, String[] delegateLoaderNames) {
        URL[] classpath = classpathParam;
        classpath = ClassLoaderFactory.prependAndEscape(m_devPrivateClasspath, classpath);
        DelegatingLoader loader = new DelegatingLoader(containerName, id, classpath, parent, delegateLoaderNames);
        m_delegatingLoaders.put(containerName + ':' + id, loader);
        ClassLoaderFactory.addDelegateLoaderUsages(containerName, id, delegateLoaderNames);
        return loader;
    }

    public static synchronized URLClassLoader getDelegatingLoader(String containerName, String id) {
        return (URLClassLoader)m_delegatingLoaders.get(containerName + ':' + id);
    }

    public static synchronized ClassLoader createDelegateLoader(String containerName, String id, String delegateName, URL[] classpathParam, ClassLoader parent) {
        URL[] classpath = classpathParam;
        classpath = ClassLoaderFactory.prependAndEscape(m_devSharedClasspath, classpath);
        ClassLoader loader = (ClassLoader)m_delegateLoaders.get(containerName + ':' + delegateName);
        if (loader == null) {
            loader = new DelegateLoader(containerName, delegateName, classpath, parent);
        }
        ClassLoaderFactory.addDelegateLoader(containerName, id, delegateName, loader);
        return loader;
    }

    public static synchronized URLClassLoader createGlobalLoader(String containerName, URL[] classpathParam, ClassLoader parent) {
        URL[] classpath = classpathParam;
        if (m_globalLoader != null && Boolean.getBoolean("sonicsw.mf.lsd.colocate")) {
            return m_globalLoader;
        }
        String devClasspath = System.getProperty("sonicsw.mf.devGlobalClasspath");
        classpath = ClassLoaderFactory.prependAndEscape(devClasspath, classpath);
        m_globalLoader = new GlobalLoader(containerName, classpath, parent);
        return m_globalLoader;
    }

    private static URL[] prependAndEscape(String classPathItem, URL[] classpathParam) {
        URL[] classpath = classpathParam;
        if (classPathItem != null) {
            classpath = ClassLoaderFactory.prependClasspath(classPathItem, classpath);
        }
        ClassLoaderFactory.escapeURLs(classpath);
        return classpath;
    }

    public static synchronized void setGlobalLoader(URLClassLoader globalLoader) {
        if (m_globalLoader == null) {
            m_globalLoader = globalLoader;
        }
    }

    public static synchronized void addDelegatingLoader(String containerName, String id, String[] delegateLoaderNames, ClassLoader loader) {
        m_delegatingLoaders.put(containerName + ':' + id, loader);
        ClassLoaderFactory.addDelegateLoaderUsages(containerName, id, delegateLoaderNames);
    }

    public static synchronized void addDelegateLoader(String containerName, String id, String delegateName, ClassLoader loader) {
        m_delegateLoaders.put(containerName + ':' + delegateName, loader);
        if (id != null) {
            m_delegateLoaderOwners.put(containerName + ':' + delegateName, containerName + ':' + id);
        }
    }

    private static synchronized void addDelegateLoaderUsages(String containerName, String id, String[] delegateNames) {
        if (delegateNames == null || delegateNames.length == 0) {
            return;
        }
        for (int i = 0; i < delegateNames.length; ++i) {
            HashSet<String> delegateLoaderUsage = (HashSet<String>)m_delegateLoaderUsages.get(containerName + ':' + delegateNames[i]);
            if (delegateLoaderUsage == null) {
                delegateLoaderUsage = new HashSet<String>();
                m_delegateLoaderUsages.put(containerName + ':' + delegateNames[i], delegateLoaderUsage);
            }
            delegateLoaderUsage.add(containerName + ':' + id);
        }
    }

    public static synchronized void removeLoaderUsages(String containerName, String id) {
        Map.Entry entry;
        Iterator iterator = m_delegateLoaderUsages.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            HashSet delegateLoaderUsage = (HashSet)entry.getValue();
            if (!delegateLoaderUsage.remove(containerName + ':' + id) || !delegateLoaderUsage.isEmpty()) continue;
            m_delegateLoaders.remove(entry.getKey());
            iterator.remove();
        }
        iterator = m_delegateLoaderOwners.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            String ownerID = (String)entry.getValue();
            if (!ownerID.equals(containerName + ':' + id)) continue;
            iterator.remove();
            break;
        }
        m_delegatingLoaders.remove(containerName + ':' + id);
    }

    public static synchronized String[] getDependentComponents(String containerName, String id) {
        for (Map.Entry entry : m_delegateLoaderOwners.entrySet()) {
            String ownerID = (String)entry.getValue();
            if (!ownerID.equals(containerName + ':' + id)) continue;
            String delegateName = (String)entry.getKey();
            HashSet ids = (HashSet)m_delegateLoaderUsages.get(delegateName);
            return ids.toArray(EMPTY_STRING_ARRAY);
        }
        return EMPTY_STRING_ARRAY;
    }

    public static URL[] prependClasspath(String addClasspath, URL[] existingClasspath) {
        ArrayList<URL> aggregatedClasspath = new ArrayList<URL>();
        StringTokenizer st = new StringTokenizer(addClasspath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String pathElement = st.nextToken();
            if (pathElement.length() <= 0) continue;
            try {
                aggregatedClasspath.add(new File(pathElement).toURL());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < existingClasspath.length; ++i) {
            aggregatedClasspath.add(existingClasspath[i]);
        }
        return aggregatedClasspath.toArray(EMPTY_URL_ARRAY);
    }

    private static void escapeURLs(URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            if (urls[i].toExternalForm().indexOf(" ") <= -1) continue;
            urls[i] = ClassLoaderFactory.escapeURL(urls[i]);
        }
    }

    public static void traceClassLoading(Class loadedClass, ClassLoader loader, URL url) {
        if (m_classLoaderFactoryClass != null) {
            try {
                Field sdfClassTraceMaskField = m_classLoaderFactoryClass.getField("m_sdfClassTraceMask");
                int sdfClassTraceMask = sdfClassTraceMaskField.getInt(null);
                if (sdfClassTraceMask > 0) {
                    String sdfTraceMessage = ClassLoaderFactory.getSDFTraceMessage(sdfClassTraceMask, "class", loadedClass.getName(), loader, url);
                    Method traceLoadingMethod = m_classLoaderFactoryClass.getMethod("traceLoading", TRACE_LOADING_SIGNATURE);
                    traceLoadingMethod.invoke(null, sdfTraceMessage);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void traceResourceLoading(String name, ClassLoader loader, URL url) {
        if (m_classLoaderFactoryClass != null) {
            try {
                Field sdfResourceTraceMaskField = m_classLoaderFactoryClass.getField("m_sdfResourceTraceMask");
                int sdfResourceTraceMask = sdfResourceTraceMaskField.getInt(null);
                if (sdfResourceTraceMask > 0) {
                    String sdfTraceMessage = ClassLoaderFactory.getSDFTraceMessage(sdfResourceTraceMask, "resource", name, loader, url);
                    Method traceLoadingMethod = m_classLoaderFactoryClass.getMethod("traceLoading", TRACE_LOADING_SIGNATURE);
                    traceLoadingMethod.invoke(null, sdfTraceMessage);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String getSDFTraceMessage(int traceMask, String type, String name, ClassLoader loader, URL path) {
        StringBuffer sb = new StringBuffer();
        if ((traceMask & 1) > 0) {
            sb.append("Loaded ").append(type).append(": ").append(name);
        }
        if ((traceMask & 2) > 0) {
            ClassLoaderFactory.appendNewLine(sb);
            sb.append("  - Loader: ").append(loader == null ? "<system loader>" : loader.toString());
        }
        if ((traceMask & 4) > 0) {
            ClassLoaderFactory.appendNewLine(sb);
            sb.append("  - Path  : ").append(path.toExternalForm());
        }
        if ((traceMask & 8) > 0) {
            ClassLoaderFactory.appendNewLine(sb);
            sb.append("  - Thread: \"").append(Thread.currentThread()).append("\" of group \"").append(Thread.currentThread().getThreadGroup()).append('\"');
        }
        return sb.toString();
    }

    private static void appendNewLine(StringBuffer sb) {
        if (sb.length() > 0) {
            sb.append(IDiagnosticsConstants.NEWLINE);
        }
    }

    public static void traceLoading(String traceMessage) {
        ClassLoaderFactory.m_classLoaderDiagnostics.traceLoading(traceMessage);
    }

    private static URL escapeURL(URL url) {
        URL result = url;
        try {
            StringBuffer newURL = new StringBuffer("");
            StringTokenizer token = new StringTokenizer(url.toExternalForm(), " ", true);
            while (token.hasMoreTokens()) {
                String newToken = token.nextToken();
                if (newToken.equals(" ")) {
                    newURL.append("%20");
                    continue;
                }
                newURL.append(newToken);
            }
            result = new URL(newURL.toString());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return result;
    }

    static {
        m_delegateLoaderOwners = new HashMap();
        m_delegateLoaderUsages = new HashMap();
        EMPTY_STRING_ARRAY = new String[0];
        EMPTY_URL_ARRAY = new URL[0];
        m_devPrivateClasspath = System.getProperty("sonicsw.mf.devPrivateClasspath");
        m_devSharedClasspath = System.getProperty("sonicsw.mf.devSharedLibraryClasspath");
        TRACE_LOADING_SIGNATURE = new Class[]{String.class};
        m_sdfClassTraceMask = 0;
        m_sdfResourceTraceMask = 0;
        if (ClassLoaderFactory.class.getClassLoader().getClass().getName().equals(DelegatingLoader.class.getName())) {
            m_classLoaderFactoryClass = ClassLoaderFactory.class;
            m_diagnosticsManager = DiagnosticsManagerAccess.createManager();
            m_classLoaderDiagnostics = new ClassLoaderDiagnostics();
            m_classLoaderDiagnostics.register();
        }
    }

    public static class DelegatingLoader
    extends URLClassLoader {
        private String containerName;
        private String id;
        private String[] delegateLoaderNames;
        private HashSet notFounds = new HashSet();

        private DelegatingLoader(String containerName, String id, URL[] urls, ClassLoader parent, String[] delegateLoaderNames) {
            super(urls, parent);
            this.containerName = containerName;
            this.id = id;
            this.delegateLoaderNames = delegateLoaderNames;
        }

        public String[] getDelegateLoaderNames() {
            return (String[])this.delegateLoaderNames.clone();
        }

        public String toString() {
            return '[' + this.containerName + ':' + this.id + "] " + DelegatingLoader.class.getName();
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            return this.loadClass(name, false);
        }

        /*
         * Exception decompiling
         */
        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public URL getResource(String name) {
            HashSet hashSet = this.notFounds;
            synchronized (hashSet) {
                if (this.notFounds.contains(name)) {
                    return null;
                }
            }
            URL url = null;
            url = m_globalLoader.findResource(name);
            if (url != null) {
                if (!name.endsWith(".class")) {
                    ClassLoaderFactory.traceResourceLoading(name, m_globalLoader, url);
                }
                return url;
            }
            if (this.delegateLoaderNames != null) {
                for (int i = 0; i < this.delegateLoaderNames.length; ++i) {
                    URLClassLoader loader = (URLClassLoader)m_delegateLoaders.get(this.containerName + ':' + this.delegateLoaderNames[i]);
                    if (loader == null || (url = loader.findResource(name)) == null) continue;
                    if (!name.endsWith(".class")) {
                        ClassLoaderFactory.traceResourceLoading(name, loader, url);
                    }
                    return url;
                }
            }
            if ((url = this.findResource(name)) != null) {
                if (!name.endsWith(".class")) {
                    ClassLoaderFactory.traceResourceLoading(name, this, url);
                }
                return url;
            }
            url = super.getResource(name);
            if (url != null && !name.endsWith(".class")) {
                ClassLoaderFactory.traceResourceLoading(name, null, url);
            }
            if (url == null) {
                HashSet hashSet2 = this.notFounds;
                synchronized (hashSet2) {
                    this.notFounds.add(name);
                }
            }
            return url;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            URL url = this.getResource(name);
            try {
                return url != null ? url.openStream() : null;
            }
            catch (IOException e) {
                return null;
            }
        }

        private void logClassLoadingFailure(String name, Throwable throwable) {
            if (m_container == null) {
                return;
            }
            if (name.indexOf(".prBundle_") > 0) {
                return;
            }
            if ((m_traceMask & 0x400) > 0) {
                String logID = this.id.equals("AGENT") ? null : this.id;
                boolean traceDetail = true;
                StringBuffer sb = new StringBuffer("Failed to load class (").append(name).append(")...");
                sb.append(IContainer.NEWLINE);
                sb.append("Class loader graph...");
                sb.append(IContainer.NEWLINE);
                sb.append("\tPrivate loader: " + this);
                if (traceDetail) {
                    this.appendURLs(sb, this.getURLs());
                }
                if (this.delegateLoaderNames != null) {
                    for (int i = 0; i < this.delegateLoaderNames.length; ++i) {
                        ClassLoader loader = (ClassLoader)m_delegateLoaders.get(this.containerName + ':' + this.delegateLoaderNames[i]);
                        if (loader == null) continue;
                        sb.append(IContainer.NEWLINE);
                        sb.append("\tShared loader : " + loader + " (" + this.containerName + ':' + this.delegateLoaderNames[i] + ")");
                        if (!traceDetail) continue;
                        this.appendURLs(sb, ((URLClassLoader)loader).getURLs());
                    }
                }
                sb.append(IContainer.NEWLINE);
                sb.append("\tGlobal loader : " + this.getParent());
                if (traceDetail) {
                    this.appendURLs(sb, ((URLClassLoader)this.getParent()).getURLs());
                    if (m_container == null) {
                        System.out.println(sb.toString());
                    } else {
                        m_container.logMessage(logID, sb.toString(), throwable, 7);
                    }
                } else {
                    sb.append(IContainer.NEWLINE);
                    sb.append(throwable.getClass().getName()).append(": ").append(name);
                    m_container.logMessage(logID, sb.toString(), 7);
                }
            }
        }

        private void appendURLs(StringBuffer sb, URL[] urls) {
            for (int i = 0; i < urls.length; ++i) {
                sb.append(IContainer.NEWLINE).append("\t\t").append(urls[i].toExternalForm());
            }
        }
    }

    public static class DelegateLoader
    extends URLClassLoader {
        private String containerName;
        private String delegateName;
        private HashSet notFounds = new HashSet();

        private DelegateLoader(String containerName, String delegateName, URL[] urls, ClassLoader parent) {
            super(urls, parent);
            this.containerName = containerName;
            this.delegateName = delegateName;
        }

        public String toString() {
            return '[' + this.containerName + ':' + this.delegateName + "] " + DelegateLoader.class.getName();
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            return this.loadClass(name, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> loadedClass = null;
            try {
                if (name.startsWith("[")) {
                    Class<?> clazz = loadedClass = Class.forName(name, false, this);
                    return clazz;
                }
                loadedClass = this.findLoadedClass(name);
                if (loadedClass != null) {
                    Class<?> clazz = loadedClass;
                    return clazz;
                }
                String classFilename = name.replace('.', '/') + ".class";
                URL url = m_globalLoader.findResource(classFilename);
                if (url != null) {
                    Class<?> clazz = loadedClass = m_globalLoader.loadClass(name);
                    return clazz;
                }
                loadedClass = this.findClass(name);
                ClassLoaderFactory.traceClassLoading(loadedClass, this, this.findResource(classFilename));
                Class<?> clazz = loadedClass;
                return clazz;
            }
            finally {
                if (loadedClass != null && resolve) {
                    this.resolveClass(loadedClass);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public URL getResource(String name) {
            HashSet hashSet = this.notFounds;
            synchronized (hashSet) {
                if (this.notFounds.contains(name)) {
                    return null;
                }
            }
            URL url = null;
            url = m_globalLoader.findResource(name);
            if (url != null) {
                if (!name.endsWith(".class")) {
                    ClassLoaderFactory.traceResourceLoading(name, m_globalLoader, url);
                }
                return url;
            }
            url = this.findResource(name);
            if (url != null) {
                if (!name.endsWith(".class")) {
                    ClassLoaderFactory.traceResourceLoading(name, this, url);
                }
                return url;
            }
            url = super.getResource(name);
            if (url != null && !name.endsWith(".class")) {
                ClassLoaderFactory.traceResourceLoading(name, null, url);
            }
            if (url == null) {
                HashSet hashSet2 = this.notFounds;
                synchronized (hashSet2) {
                    this.notFounds.add(name);
                }
            }
            return url;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            URL url = this.getResource(name);
            try {
                return url != null ? url.openStream() : null;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    public static class GlobalLoader
    extends URLClassLoader {
        private String containerName;
        private HashSet notFounds = new HashSet();

        private GlobalLoader(String containerName, URL[] urls, ClassLoader parent) {
            super(urls, parent);
            this.containerName = containerName;
        }

        public String toString() {
            return '[' + this.containerName + ":GLOBAL] " + GlobalLoader.class.getName();
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            return this.loadClass(name, false);
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> loadedClass = null;
            if (name.startsWith("[")) {
                loadedClass = Class.forName(name, false, this);
                return loadedClass;
            }
            loadedClass = this.findLoadedClass(name);
            if (loadedClass != null) {
                return loadedClass;
            }
            loadedClass = super.loadClass(name, resolve);
            ClassLoaderFactory.traceClassLoading(loadedClass, loadedClass.getClassLoader(), this.getResource(name.replace('.', '/') + ".class"));
            return loadedClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public URL getResource(String name) {
            HashSet hashSet = this.notFounds;
            synchronized (hashSet) {
                if (this.notFounds.contains(name)) {
                    return null;
                }
            }
            URL url = super.getResource(name);
            if (url != null && !name.endsWith(".class")) {
                ClassLoader loader = this;
                while (loader.getParent() != null && loader.getParent().getResource(name) != null) {
                    loader = loader.getParent();
                }
                ClassLoaderFactory.traceResourceLoading(name, loader, url);
            }
            if (url == null) {
                HashSet hashSet2 = this.notFounds;
                synchronized (hashSet2) {
                    this.notFounds.add(name);
                }
            }
            return url;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            URL url = this.getResource(name);
            try {
                return url != null ? url.openStream() : null;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    private static class ClassLoaderDiagnostics
    extends AbstractDiagnosticsProvider {
        private static String[] OPERATIONS;
        private static HashMap SHOW_TRACE_LEVEL_PARAM_DESCIPTOR;
        private static HashMap UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR;
        private static HashMap PARAM_DESCRIPTOR;
        private static HashMap DUMP_STATE_PARAM_DESCIPTOR;
        private static HashMap DESCRIBE_PARAM_DESCIPTOR;
        private static HashMap LIST_DIAGNOSTICS_INSTANCES_PARAM_DESCIPTOR;
        String description = "Use this subsystem to help diagnose the Sonic MF specific class loading hierarchy." + NEWLINE + NEWLINE + "The diagnosis includes tracing of class and resource loading and dumping of the current class loader hierarchy." + NEWLINE + "Two diagnosed object instances are used to distinguish between classes (\"Classes\") and resources (\"Resources\")." + NEWLINE + "Tracing can be configured so that in addition to loaded class or resource names, the associated loader and/or path can be traced." + NEWLINE + NEWLINE + "Examples:" + NEWLINE + "  sonic.mf.classloading updateTraceLevel doiID=Classes integerTraceLevel=7" + NEWLINE + "  sonic.mf.classloading updateTraceLevel doiID=Resources integerTraceLevel=5" + NEWLINE;

        ClassLoaderDiagnostics() {
            super("sonic.mf.classloading");
        }

        public String describe() {
            return this.description;
        }

        public String[] getOperations() {
            return OPERATIONS;
        }

        public HashMap describeParameters(String operationName) {
            return (HashMap)PARAM_DESCRIPTOR.get(operationName);
        }

        public String[] getDOInstances() {
            return new String[]{ClassLoaderFactory.SDF_DOIID_CLASSES, ClassLoaderFactory.SDF_DOIID_RESOURCES};
        }

        public void updateTraceLevel(String doiID, HashMap parameters, StringBuffer buffer) {
            try {
                if (doiID.equals(ClassLoaderFactory.SDF_DOIID_CLASSES)) {
                    m_sdfClassTraceMask = this.parseTraceLevel(doiID, parameters, buffer, m_sdfClassTraceMask, m_sdfResourceTraceMask);
                }
                if (doiID.equals(ClassLoaderFactory.SDF_DOIID_RESOURCES)) {
                    m_sdfResourceTraceMask = this.parseTraceLevel(doiID, parameters, buffer, m_sdfResourceTraceMask, m_sdfClassTraceMask);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                buffer.append(e.toString());
            }
        }

        public void showTraceLevel(String doiID, HashMap parameters, StringBuffer buffer) {
            if (doiID.equals(ClassLoaderFactory.SDF_DOIID_CLASSES)) {
                buffer.append("Trace level for \"").append(this.m_subsystemName).append("\" [").append(doiID).append("] is ").append(m_sdfClassTraceMask);
            }
            if (doiID.equals(ClassLoaderFactory.SDF_DOIID_RESOURCES)) {
                buffer.append("Trace level for \"").append(this.m_subsystemName).append("\" [").append(doiID).append("] is ").append(m_sdfResourceTraceMask);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void appendStateDump(String doiID, HashMap Parameters2, StringBuffer buffer) {
            if (m_globalLoader == null) {
                buffer.append("Unable to write state of \"").append(this.m_subsystemName).append(" as core MF class loaders bhave not yet been created");
                return;
            }
            try (IStateWriter writer = null;){
                writer = this.m_diagnosticsContext.getStateWriter();
                ArrayList<ClassLoader> parents = new ArrayList<ClassLoader>();
                parents.add(m_globalLoader);
                while (((ClassLoader)parents.get(0)).getParent() != null) {
                    parents.add(0, ((ClassLoader)parents.get(0)).getParent());
                }
                for (int i = 0; i < parents.size(); ++i) {
                    this.dumpClassLoader(writer, this.createIndent(i), (ClassLoader)parents.get(i));
                }
                Iterator sharedLoaders = m_delegateLoaders.values().iterator();
                while (sharedLoaders.hasNext()) {
                    this.dumpClassLoader(writer, this.createIndent(parents.size()), (ClassLoader)sharedLoaders.next());
                }
                Iterator privateLoaders = m_delegatingLoaders.values().iterator();
                while (privateLoaders.hasNext()) {
                    this.dumpClassLoader(writer, this.createIndent(parents.size()), (ClassLoader)privateLoaders.next());
                }
            }
            if (writer != null) {
                buffer.append("Dump of \"").append(this.m_subsystemName).append("\" written to ").append(writer.getFilePath());
            }
        }

        private String createIndent(int offset) {
            String indent = "";
            for (int i = 0; i < offset; ++i) {
                indent = indent + "  ";
            }
            return indent;
        }

        private void dumpClassLoader(IStateWriter writer, String indent, ClassLoader classLoader) throws Exception {
            if (classLoader.getClass().getName().equals("com.sonicsw.mf.framework.agent.ClassLoaderFactory$GlobalLoader")) {
                writer.write(indent + "+ <sonic global loader> " + classLoader.toString());
            } else if (classLoader.getClass().getName().startsWith("com.sonicsw.mf.framework.agent.ClassLoaderFactory$DelegateLoader")) {
                writer.write(indent + "+ <sonic delegate/shared loader> " + classLoader.toString());
            } else if (classLoader.getClass().getName().startsWith("com.sonicsw.mf.framework.agent.ClassLoaderFactory$DelegatingLoader")) {
                writer.write(indent + "+ <sonic delegating/private loader> " + classLoader.toString());
            } else {
                writer.write(indent + "+ <system loader> " + classLoader.getClass().getName());
            }
            writer.write(NEWLINE);
            if (classLoader.getClass().getName().startsWith("com.sonicsw.mf.framework.agent.ClassLoaderFactory$DelegatingLoader")) {
                writer.write(indent + "  + <depends on>");
                writer.write(NEWLINE);
                Class<?> delegatingLoaderClass = classLoader.getClass();
                Method getDelegateLoaderNamesMethod = delegatingLoaderClass.getMethod("getDelegateLoaderNames", new Class[0]);
                String[] delegates = (String[])getDelegateLoaderNamesMethod.invoke((Object)classLoader, new Object[0]);
                if (delegates == null || delegates.length == 0) {
                    writer.write(indent + "    - <none>");
                    writer.write(NEWLINE);
                } else {
                    for (int i = 0; i < delegates.length; ++i) {
                        writer.write(indent + "    - [" + delegates[i] + ']');
                        writer.write(NEWLINE);
                    }
                }
            }
            if (classLoader instanceof URLClassLoader) {
                writer.write(indent + "  + <urls>");
                writer.write(NEWLINE);
                URL[] urls = ((URLClassLoader)classLoader).getURLs();
                for (int i = 0; i < urls.length; ++i) {
                    writer.write(indent + "    - " + urls[i].toExternalForm());
                    writer.write(NEWLINE);
                }
            }
        }

        private int parseTraceLevel(String doiID, HashMap parameters, StringBuffer buffer, int currentTraceMask, int otherTraceMask) throws Exception {
            int traceMask;
            String traceLevel = (String)parameters.get("integerTraceLevel");
            if (traceLevel == null) {
                traceLevel = new String("0");
            }
            if ((traceMask = Integer.parseInt(traceLevel)) == 0 && currentTraceMask > 0 && otherTraceMask == 0 && this.m_tracer != null) {
                this.m_tracer.close();
                this.m_tracer = null;
            }
            if (traceMask > 0) {
                if (this.m_tracer == null) {
                    this.m_tracer = this.m_diagnosticsContext.getTracer();
                }
                buffer.append("Trace file for \"").append(this.m_subsystemName).append("\" [").append(doiID).append("] is \"").append(this.m_tracer.getFilePath()).append("\"");
                this.m_tracer.trace("Start tracing " + this.m_subsystemName + '.' + doiID + " with tracing level " + traceLevel, false);
            }
            return traceMask;
        }

        private void traceLoading(String traceMessage) {
            ITracer tracer = this.m_tracer;
            if (tracer != null) {
                try {
                    tracer.trace(traceMessage, false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        static {
            SHOW_TRACE_LEVEL_PARAM_DESCIPTOR = new HashMap();
            UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR = new HashMap();
            PARAM_DESCRIPTOR = new HashMap();
            DUMP_STATE_PARAM_DESCIPTOR = new HashMap();
            DESCRIBE_PARAM_DESCIPTOR = new HashMap();
            LIST_DIAGNOSTICS_INSTANCES_PARAM_DESCIPTOR = new HashMap();
            UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR.put("doiID", "values: \"Classes\", \"Resources\"");
            UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR.put("integerTraceLevel", "bits: 1 - trace name, 2 - trace class loader name, 4 - trace loaded path");
            PARAM_DESCRIPTOR.put("dumpState", DUMP_STATE_PARAM_DESCIPTOR);
            PARAM_DESCRIPTOR.put("describe", DESCRIBE_PARAM_DESCIPTOR);
            PARAM_DESCRIPTOR.put("showTraceLevel", SHOW_TRACE_LEVEL_PARAM_DESCIPTOR);
            PARAM_DESCRIPTOR.put("updateTraceLevel", UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR);
            PARAM_DESCRIPTOR.put("listDiagnosticsInstances", LIST_DIAGNOSTICS_INSTANCES_PARAM_DESCIPTOR);
            OPERATIONS = ClassLoaderDiagnostics.toOpnameArray((HashMap)PARAM_DESCRIPTOR);
        }
    }
}

