/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.common.IComponent;
import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.AttributeSet;
import com.sonicsw.mf.common.config.impl.IChangeRegistration;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.metrics.IAlert;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.IMetricsData;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.manager.IMetricsManager;
import com.sonicsw.mf.common.metrics.manager.IMetricsRegistrar;
import com.sonicsw.mf.common.metrics.manager.impl.MetricsManager;
import com.sonicsw.mf.common.runtime.ICanonicalName;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.AbstractMBean;
import com.sonicsw.mf.framework.agent.ContainerImpl;
import com.sonicsw.mf.framework.agent.TaskScheduler;
import com.sonicsw.mx.util.IEmptyArray;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.naming.Context;

public class ComponentMBean
extends AbstractMBean {
    private IMetricsManager m_metricsManager;
    private static Method CLEAR_ERROR_METHOD;
    private static Method HANDLE_NOTIFICATION_METHOD;
    private static Method GET_METRICS_INFO_METHOD;
    private static Method ENABLE_METRICS_METHOD;
    private static Method DISABLE_METRICS_METHOD;
    private static Method REPLACE_ENABLED_METRICS_METHOD;
    private static Method GET_ACTIVE_METRICS_METHOD;
    private static Method GET_INSTANCE_METRIC_NAMES_METHOD;
    private static Method GET_ENABLED_METRICS_METHOD;
    private static Method GET_METRICS_DATA_METHOD;
    private static Method RESET_METRICS_METHOD;
    private static Method GET_ENABLED_ALERTS_METHOD;
    private static Method ENABLE_ALERTS_METHOD;
    private static Method DISABLE_ALERTS_METHOD;
    private static Method REPLACE_ENABLED_ALERTS_METHOD;
    private static final String NOTIFICATION_CLASSNAME;
    private static final String METRIC_IDENTITY_ARRAY_CLASSNAME;
    private static final String ALERT_ARRAY_CLASSNAME;
    private static final Class[] HANDLE_NOTIFICATION_CLASS_ARRAY;
    private static final Class[] METRIC_IDENTITY_ARRAY_CLASS_ARRAY;
    private static final Class[] ALERT_ARRAY_CLASS_ARRAY;

    public ComponentMBean(ContainerImpl container, IComponent component, String id, String configID) throws Exception {
        super(container, component, id, configID);
        if (this.m_metricsManager != null) {
            this.addMetricsOperations();
            IElement componentConfig = this.m_componentContext.getConfiguration(true);
            this.applyMetricsAttrs(componentConfig);
            this.enableMetricsAndAlertsFromConfiguration();
        }
    }

    private void addMetricsOperations() {
        int i;
        MBeanAttributeInfo mbInfo = null;
        mbInfo = new MBeanAttributeInfo("MetricsRefreshInterval", Integer.class.getName(), "Metrics refresh interval (in seconds)", true, true, false);
        this.m_attributes.add(mbInfo);
        mbInfo = new MBeanAttributeInfo("MetricsCollectionInterval", Integer.class.getName(), "Metrics collection interval (in minutes)", true, true, false);
        this.m_attributes.add(mbInfo);
        mbInfo = new MBeanAttributeInfo("RepeatMetricAlerts", Boolean.class.getName(), "Repeat metric alert notifications.", true, true, false);
        this.m_attributes.add(mbInfo);
        MBeanParameterInfo[] mbParamInfos = null;
        this.m_operations.add(new MBeanOperationInfo("getMetricsInfo", "Gets the meta-data for all metrics supported by this component.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, IMetricInfo[].class.getName(), 0));
        mbParamInfos = ComponentMBean.createMbParameterInfoIds();
        this.m_operations.add(new MBeanOperationInfo("getEnabledMetrics", "Get the list of metric patterns that have been enabled for this component.", mbParamInfos, IMetricIdentity[].class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("ids", IMetricIdentity[].class.getName(), "A list of metrics identity patterns.")};
        this.m_operations.add(new MBeanOperationInfo("getActiveMetrics", "Gets the the list of metrics currently active in this component.", mbParamInfos, IMetricIdentity[].class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("ids", IMetricIdentity[].class.getName(), "A list of active metrics, either individual metrics or instances."), new MBeanParameterInfo("returnTriggeredAlerts", Boolean.class.getName(), "If true, each metric returned should include a list of triggered (exceeded) alerts for these metrics.")};
        this.m_operations.add(new MBeanOperationInfo("getMetricsData", "Gets metric values for a given set of metrics. If a requested metric was not enabled or is otherwise unknown, then no data for that metric will be included in the results.", mbParamInfos, IMetricsData.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("ids", IMetricIdentity[].class.getName(), "A list of metrics identity patterns.")};
        this.m_operations.add(new MBeanOperationInfo("enableMetrics", "Enable the given set of dynamic metrics.", mbParamInfos, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("ids", IMetricIdentity[].class.getName(), "A list of metrics identity patterns.")};
        this.m_operations.add(new MBeanOperationInfo("disableMetrics", "Disable the given set of dynamic metrics.", mbParamInfos, Void.class.getName(), 1));
        this.m_operations.add(new MBeanOperationInfo("resetMetrics", "Reset all metrics to their initial state.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        IMetricInfo[] infos = this.m_metricsManager.getMetricsInfo();
        for (i = 0; i < infos.length; ++i) {
            if (!infos[i].isInstanceMetric()) continue;
            mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("id", IMetricIdentity.class.getName(), "The instance metric parent identity.")};
            this.m_operations.add(new MBeanOperationInfo("getInstanceMetricNames", "Get the instance names to which the given instance metric may be applied. An array of instance names. If there are no instances the broker will a zero length array. If the metric identity is either unknown or not that of an instance metric, then the broker will return null.", mbParamInfos, String[].class.getName(), 0));
            break;
        }
        for (i = 0; i < infos.length; ++i) {
            if (!infos[i].supportsHighThresholdAlerts() && !infos[i].supportsLowThresholdAlerts()) continue;
            mbParamInfos = ComponentMBean.createMbParameterInfoIds();
            this.m_operations.add(new MBeanOperationInfo("getEnabledAlerts", "Get all metric threshold alerts enabled by this component.", mbParamInfos, IAlert[].class.getName(), 0));
            mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("alerts", IAlert[].class.getName(), "A list of alerts to enable.")};
            this.m_operations.add(new MBeanOperationInfo("enableAlerts", "Enable threshold alerts on a metric.", mbParamInfos, Void.class.getName(), 1));
            mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("alerts", IAlert[].class.getName(), "A list of alerts to disable.")};
            this.m_operations.add(new MBeanOperationInfo("disableAlerts", "Disable threshold alerts on a metric.", mbParamInfos, Void.class.getName(), 1));
            break;
        }
        for (i = 0; i < infos.length; ++i) {
            if (!infos[i].supportsHighThresholdAlerts() && !infos[i].supportsLowThresholdAlerts()) continue;
            int category = infos[i].getMetricIdentity().getNameComponents()[0].equals(INotification.CATEGORY_TEXT[0]) ? 0 : 2;
            String[] notifTypes = new String[]{INotification.CATEGORY_TEXT[category], INotification.SUBCATEGORY_TEXT[4], infos[i].getMetricIdentity().getName()};
            this.m_notifications.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Alert for metric " + infos[i].getMetricIdentity().getName()));
        }
    }

    private static MBeanParameterInfo[] createMbParameterInfoIds() {
        return new MBeanParameterInfo[]{new MBeanParameterInfo("ids", IMetricIdentity[].class.getName(), "A list of metrics identities for which to get the enabled alerts.")};
    }

    private void enableMetricsAndAlertsFromConfiguration() throws Exception {
        IAlert[] alerts;
        IAttributeSet eaas;
        IMetricIdentity[] metricIDs;
        IAttributeSet emas = this.getEnabledMetricsOrAlertsFromConfiguration("ENABLED_METRICS");
        if (emas != null && (metricIDs = this.createMetricIds(emas)).length > 0) {
            this.internalInvoke("enableMetrics", new Object[]{metricIDs}, new String[]{METRIC_IDENTITY_ARRAY_CLASSNAME});
        }
        if ((eaas = this.getEnabledMetricsOrAlertsFromConfiguration("ENABLED_ALERTS")) != null && (alerts = this.createAlerts(eaas)).length > 0) {
            this.m_metricsManager.enableAlerts(alerts);
        }
    }

    private IAttributeSet getEnabledMetricsOrAlertsFromConfiguration(String attributeName) {
        IAttributeSet mas = null;
        IElementIdentity containerIdentity = this.m_container.getContainerIdentity().getConfigIdentity();
        IElement containerCE = this.m_componentContext.getConfiguration(containerIdentity.getName(), true);
        IAttributeSet containerAS = containerCE.getAttributes();
        String compID = this.m_componentName.getComponentName();
        if ("AGENT".equals(compID)) {
            mas = (IAttributeSet)containerAS.getAttribute(attributeName);
        } else {
            IAttributeSet componentAS = (IAttributeSet)containerAS.getAttribute("COMPONENTS");
            HashMap map = componentAS.getAttributes();
            IAttributeSet spas = (IAttributeSet)map.get(compID);
            if (spas == null) {
                return null;
            }
            mas = (IAttributeSet)spas.getAttribute(attributeName);
        }
        return mas;
    }

    private IMetricIdentity[] createMetricIds(IAttributeSet metricsAS) {
        HashMap metricsMap = metricsAS.getAttributes();
        Iterator iterator = metricsMap.values().iterator();
        ArrayList<IMetricIdentity> metricIDList = new ArrayList<IMetricIdentity>();
        while (iterator.hasNext()) {
            String metricName = (String)iterator.next();
            IMetricIdentity metricID = MetricsFactory.createMetricIdentity((String)metricName);
            metricIDList.add(metricID);
        }
        return metricIDList.toArray(new IMetricIdentity[metricIDList.size()]);
    }

    private IAlert[] createAlerts(IAttributeSet alertsAS) {
        HashMap alertsMap = alertsAS.getAttributes();
        Iterator itor = alertsMap.values().iterator();
        ArrayList<IAlert> alertsList = new ArrayList<IAlert>();
        while (itor.hasNext()) {
            int j;
            IAlert[] alerts;
            Object attr = itor.next();
            if (!(attr instanceof AttributeSet)) continue;
            AttributeSet alertAS = (AttributeSet)attr;
            AttributeName compoundName = alertAS.getCompoundName();
            String metricName = (String)compoundName.getComponent(compoundName.getComponentCount() - 1);
            IMetricIdentity metricID = MetricsFactory.createMetricIdentity((String)metricName);
            Object thresholds = alertAS.getAttribute("HIGH_THRESHOLDS");
            if (thresholds instanceof String) {
                alerts = MetricsFactory.createAlerts((IMetricIdentity)metricID, (boolean)true, (String)((String)thresholds));
                for (j = 0; j < alerts.length; ++j) {
                    alertsList.add(alerts[j]);
                }
            }
            if (!((thresholds = alertAS.getAttribute("LOW_THRESHOLDS")) instanceof String)) continue;
            alerts = MetricsFactory.createAlerts((IMetricIdentity)metricID, (boolean)false, (String)((String)thresholds));
            for (j = 0; j < alerts.length; ++j) {
                alertsList.add(alerts[j]);
            }
        }
        return alertsList.toArray(new IAlert[alertsList.size()]);
    }

    @Override
    IComponentContext getContext() {
        return new ContextImpl();
    }

    @Override
    final void cleanup() {
        super.cleanup();
        if (this.m_metricsManager != null) {
            this.m_metricsManager.cleanup();
            this.m_metricsManager = null;
        }
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        MBeanAttributeInfo info = super.getAttributeInfo(name);
        if (info == null) {
            throw new AttributeNotFoundException(name + " is not a valid attribute.");
        }
        if (!info.isReadable()) {
            throw new AttributeNotFoundException(name + " is not a readable attribute.");
        }
        if (name.equals("MetricsRefreshInterval")) {
            int refreshInterval = 20;
            if (this.m_metricsManager != null) {
                long ri = this.m_metricsManager.getRefreshInterval();
                refreshInterval = (int)(ri / 1000L);
            }
            return new Integer(refreshInterval);
        }
        if (name.equals("MetricsCollectionInterval")) {
            int collectionInterval = 10;
            if (this.m_metricsManager != null) {
                long ci = this.m_metricsManager.getCollectionInterval();
                collectionInterval = (int)(ci / 60000L);
            }
            return new Integer(collectionInterval);
        }
        if (name.equals("RepeatMetricAlerts")) {
            boolean repeatAlerts = false;
            if (this.m_metricsManager != null) {
                repeatAlerts = this.m_metricsManager.getRepeatMetricAlerts();
            }
            return new Boolean(repeatAlerts);
        }
        return super.getAttribute(name);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String name = attribute.getName();
        if (name.equals("MetricsRefreshInterval")) {
            MBeanAttributeInfo info = this.validateAttribute(name);
            Object value = this.getAttributeValue(attribute, info);
            this.setRefreshInterval(name, (Integer)value);
        } else if (name.equals("MetricsCollectionInterval")) {
            MBeanAttributeInfo info = this.validateAttribute(name);
            Object value = this.getAttributeValue(attribute, info);
            this.setCollectionInterval(name, (Integer)value);
        } else if (name.equals("RepeatMetricAlerts")) {
            MBeanAttributeInfo info = this.validateAttribute(name);
            Object value = this.getAttributeValue(attribute, info);
            this.setRepeatMetricAlerts(name, (Boolean)value);
        } else {
            super.setAttribute(attribute);
        }
    }

    private void setRefreshInterval(String name, Integer refreshInterval) throws InvalidAttributeValueException {
        long ri = 1000L * refreshInterval.longValue();
        try {
            if (this.m_metricsManager != null) {
                int traceMask = this.m_component.getTraceMask();
                long originalValue = 0L;
                if ((traceMask & 3) > 0) {
                    originalValue = this.m_metricsManager.getRefreshInterval();
                }
                this.m_metricsManager.setRefreshInterval(ri);
                if ((traceMask & 2) > 0) {
                    StringBuffer msg = new StringBuffer("Set attribute [" + name + "]");
                    if ((traceMask & 1) > 0) {
                        int oldVal = (int)(originalValue / 1000L);
                        this.appendData(msg, oldVal, refreshInterval);
                    }
                    this.logMessage(msg.toString(), 7);
                }
            }
        }
        catch (MFException mfe) {
            throw new InvalidAttributeValueException();
        }
    }

    private void setCollectionInterval(String name, Integer collectionInterval) throws InvalidAttributeValueException {
        long ci = 60000L * collectionInterval.longValue();
        try {
            if (this.m_metricsManager != null) {
                int traceMask = this.m_component.getTraceMask();
                long originalValue = 0L;
                if ((traceMask & 3) > 0) {
                    originalValue = this.m_metricsManager.getCollectionInterval();
                }
                this.m_metricsManager.setCollectionInterval(ci);
                if ((traceMask & 2) > 0) {
                    StringBuffer msg = new StringBuffer("Set attribute [" + name + "]");
                    if ((traceMask & 1) > 0) {
                        int oldVal = (int)(originalValue / 60000L);
                        this.appendData(msg, oldVal, collectionInterval);
                    }
                    this.logMessage(msg.toString(), 7);
                }
            }
        }
        catch (MFException mfe) {
            throw new InvalidAttributeValueException();
        }
    }

    private void appendData(StringBuffer msg, int oldVal, Integer collectionInterval) {
        msg.append(", values...");
        msg.append(IContainer.NEWLINE).append("\tOriginal value = ").append(oldVal);
        msg.append(IContainer.NEWLINE).append("\tNew value      = ").append(collectionInterval);
    }

    private void setRepeatMetricAlerts(String name, Boolean repeatMetricAlerts) throws InvalidAttributeValueException {
        try {
            if (this.m_metricsManager != null) {
                int traceMask = this.m_component.getTraceMask();
                boolean originalValue = false;
                if ((traceMask & 3) > 0) {
                    originalValue = this.m_metricsManager.getRepeatMetricAlerts();
                }
                this.m_metricsManager.setRepeatMetricAlerts(repeatMetricAlerts.booleanValue());
                if ((traceMask & 2) > 0) {
                    StringBuffer msg = new StringBuffer("Set attribute [" + name + "]");
                    if ((traceMask & 1) > 0) {
                        msg.append(", values...");
                        msg.append(IContainer.NEWLINE).append("\tOriginal value = ").append(originalValue);
                        msg.append(IContainer.NEWLINE).append("\tNew value      = ").append(repeatMetricAlerts);
                    }
                    this.logMessage(msg.toString(), 7);
                }
            }
        }
        catch (MFException mfe) {
            throw new InvalidAttributeValueException();
        }
    }

    @Override
    Object internalInvoke(String operationNameParam, Object[] params, String[] signature) throws Exception {
        String operationName = operationNameParam;
        ComponentMBean target = null;
        Method method = null;
        try {
            if (operationName.equals("clearError") && signature.length == 0) {
                target = this;
                method = CLEAR_ERROR_METHOD;
            } else if (operationName.equals("handleNotification") && signature.length == 1 && signature[0].equals(NOTIFICATION_CLASSNAME)) {
                target = this;
                method = HANDLE_NOTIFICATION_METHOD;
            } else if (operationName.equals("getMetricsInfo") && signature.length == 0) {
                target = this.m_metricsManager;
                method = GET_METRICS_INFO_METHOD;
            } else if (operationName.equals("enableMetrics") && signature.length == 1 && signature[0].equals(METRIC_IDENTITY_ARRAY_CLASSNAME)) {
                IMetricIdentity[] ids;
                params[0] = ids = (IMetricIdentity[])this.internalInvoke(this.m_metricsManager, operationName, ENABLE_METRICS_METHOD, params);
            } else if (operationName.equals("disableMetrics") && signature.length == 1 && signature[0].equals(METRIC_IDENTITY_ARRAY_CLASSNAME)) {
                IMetricIdentity[] ids;
                params[0] = ids = (IMetricIdentity[])this.internalInvoke(this.m_metricsManager, operationName, DISABLE_METRICS_METHOD, params);
            } else if (operationName.equals("getActiveMetrics") && signature.length == 1 && signature[0].equals(METRIC_IDENTITY_ARRAY_CLASSNAME)) {
                target = this.m_metricsManager;
                method = GET_ACTIVE_METRICS_METHOD;
            } else if (operationName.equals("getEnabledMetrics") && signature.length == 1 && signature[0].equals(METRIC_IDENTITY_ARRAY_CLASSNAME)) {
                target = this.m_metricsManager;
                method = GET_ENABLED_METRICS_METHOD;
            } else if (operationName.equals("getMetricsData") && signature.length == 2 && signature[0].equals(METRIC_IDENTITY_ARRAY_CLASSNAME) && signature[1].equals(Boolean.class.getName())) {
                target = this.m_metricsManager;
                method = GET_METRICS_DATA_METHOD;
            } else if (operationName.equals("resetMetrics") && signature.length == 0) {
                target = this.m_metricsManager;
                method = RESET_METRICS_METHOD;
            } else if (operationName.equals("getEnabledAlerts") && signature.length == 1 && signature[0].equals(METRIC_IDENTITY_ARRAY_CLASSNAME)) {
                target = this.m_metricsManager;
                method = GET_ENABLED_ALERTS_METHOD;
            } else if (operationName.equals("enableAlerts") && signature.length == 1 && signature[0].equals(ALERT_ARRAY_CLASSNAME)) {
                target = this.m_metricsManager;
                method = ENABLE_ALERTS_METHOD;
            } else if (operationName.equals("disableAlerts") && signature.length == 1 && signature[0].equals(ALERT_ARRAY_CLASSNAME)) {
                target = this.m_metricsManager;
                method = DISABLE_ALERTS_METHOD;
            } else if (operationName.equals("replaceEnabledMetrics") && signature.length == 1 && signature[0].equals(METRIC_IDENTITY_ARRAY_CLASSNAME)) {
                IMetricIdentity[][] ids = (IMetricIdentity[][])this.internalInvoke(this.m_metricsManager, operationName, REPLACE_ENABLED_METRICS_METHOD, params);
                params[0] = ids[0];
                super.internalInvoke("disableMetrics", params, signature);
                params[0] = ids[1];
                operationName = "enableMetrics";
            } else if (operationName.equals("replaceEnabledAlerts") && signature.length == 1 && signature[0].equals(ALERT_ARRAY_CLASSNAME)) {
                target = this.m_metricsManager;
                method = REPLACE_ENABLED_ALERTS_METHOD;
            }
            if (target != null) {
                return this.internalInvoke(target, operationName, method, params);
            }
        }
        catch (MFException e) {
            super.throwWrappedExceptionOnUnload((Exception)((Object)e));
        }
        catch (MFRuntimeException e) {
            super.throwWrappedExceptionOnUnload((Exception)((Object)e));
        }
        catch (RuntimeException e) {
            if (e.getClass().getName().startsWith("java.")) {
                super.throwWrappedExceptionOnUnload(e);
            }
            MFRuntimeException mfe = new MFRuntimeException();
            mfe.setLinkedException((Exception)e);
            super.throwWrappedExceptionOnUnload((Exception)((Object)mfe));
        }
        catch (Exception e) {
            if (e.getClass().getName().startsWith("java.")) {
                super.throwWrappedExceptionOnUnload(e);
            }
            MFException mfe = new MFException();
            mfe.setLinkedException(e);
            super.throwWrappedExceptionOnUnload((Exception)((Object)mfe));
        }
        catch (OutOfMemoryError e) {
            this.logMessage("Failed operation [" + operationName + "] due to insufficient memory...", e, 1);
            throw e;
        }
        catch (Error e) {
            this.logMessage("Failed operation [" + operationName + "], trace follows...", e, 1);
            throw e;
        }
        return super.internalInvoke(operationName, params, signature);
    }

    IMetricsRegistrar initMetricsManagement(IMetricInfo[] metricInfos) {
        if (this.m_metricsManager != null) {
            throw new IllegalStateException("Metrics management already initialized");
        }
        try {
            Class<?> metricsManagerClass = this.m_componentClassLoader.loadClass(MetricsManager.class.getName());
            Constructor<?> constructor = metricsManagerClass.getConstructor(IMetricInfo[].class);
            this.m_metricsManager = (IMetricsManager)constructor.newInstance(new Object[]{metricInfos});
        }
        catch (Exception e) {
            MFRuntimeException mfe = new MFRuntimeException("Failed to initialize metrics management");
            mfe.setLinkedException(e);
            throw mfe;
        }
        this.m_metricsManager.init(this.m_componentContext);
        return (IMetricsRegistrar)this.m_metricsManager;
    }

    @Override
    void handleElementChange(IElementChange change) {
        IBasicElement element = change.getElement();
        String configID = element.getIdentity().getName();
        if (configID.equals(super.getConfigID()) || super.getConfigID().startsWith("/backupmanager/") && configID.startsWith("/manager/")) {
            if (element instanceof IDeltaElement) {
                IDeltaElement changes = (IDeltaElement)element;
                IDeltaAttributeSet attrs = (IDeltaAttributeSet)changes.getDeltaAttributes();
                String[] mods = attrs.getModifiedAttributesNames();
                try {
                    for (int i = 0; i < mods.length; ++i) {
                        if (!mods[i].equals("METRICS") || !(attrs.getNewValue("METRICS") instanceof IDeltaAttributeSet)) continue;
                        attrs = (IDeltaAttributeSet)attrs.getNewValue("METRICS");
                        this.handleModifiedMetricsAttrs(attrs.getNewAttributesNames(), attrs);
                        this.handleModifiedMetricsAttrs(attrs.getModifiedAttributesNames(), attrs);
                        this.handleDeletedMetricsAttrs(attrs.getDeletedAttributesNames());
                    }
                }
                catch (Exception e) {
                    this.m_componentContext.logMessage("Error modifying " + this.m_componentName.getComponentName() + " runtime from configuration change, trace follows...", (Throwable)e, 2);
                }
            } else {
                this.applyMetricsAttrs((IElement)element);
            }
        }
        super.handleElementChange(change);
    }

    private void applyMetricsAttrs(IElement element) {
        IElement primaryEl;
        Reference primaryRef;
        IAttributeSet backupRefs;
        IAttributeSet amAttributes = element.getAttributes();
        if (element.getIdentity().getName().startsWith("/backupmanager/")) {
            backupRefs = (IAttributeSet)amAttributes.getAttribute("CONFIG_ELEMENT_REFERENCES");
            if (backupRefs == null) {
                return;
            }
            primaryRef = (Reference)backupRefs.getAttribute("PRIMARY_AM_CONFIG_ELEMENT_REF");
            if (primaryRef == null) {
                return;
            }
            primaryEl = this.m_componentContext.getConfiguration(primaryRef.getElementName(), true);
            amAttributes = primaryEl.getAttributes();
        } else if (element.getIdentity().getName().startsWith("/mq/backupbrokers/")) {
            backupRefs = (IAttributeSet)amAttributes.getAttribute("CONFIG_ELEMENT_REFERENCES");
            if (backupRefs == null) {
                return;
            }
            primaryRef = (Reference)backupRefs.getAttribute("PRIMARY_CONFIG_ELEMENT_REF");
            if (primaryRef == null) {
                return;
            }
            primaryEl = this.m_componentContext.getConfiguration(primaryRef.getElementName(), true);
            amAttributes = primaryEl.getAttributes();
        }
        try {
            IAttributeSet metricsAS = (IAttributeSet)amAttributes.getAttribute("METRICS");
            if (this.m_metricsManager != null) {
                if (metricsAS != null) {
                    Integer refreshInterval = (Integer)metricsAS.getAttribute("REFRESH_INTERVAL");
                    Integer collectionInterval = (Integer)metricsAS.getAttribute("COLLECTION_INTERVAL");
                    long lRefreshInterval = refreshInterval != null ? refreshInterval.longValue() * 1000L : 20000L;
                    long lCollectionInterval = collectionInterval != null ? collectionInterval.longValue() * 60000L : 600000L;
                    this.m_metricsManager.setRefreshAndCollectionInterval(lRefreshInterval, lCollectionInterval);
                    Boolean repeatAlerts = (Boolean)metricsAS.getAttribute("REPEAT_ALERT_NOTIFICATIONS");
                    if (repeatAlerts != null) {
                        this.m_metricsManager.setRepeatMetricAlerts(repeatAlerts.booleanValue());
                    } else {
                        this.m_metricsManager.setRepeatMetricAlerts(false);
                    }
                } else {
                    this.m_metricsManager.setRefreshAndCollectionInterval(20000L, 600000L);
                    this.m_metricsManager.setRepeatMetricAlerts(false);
                }
            }
        }
        catch (Exception e) {
            this.m_componentContext.logMessage("Failed to configure metric settings, trace follows...", (Throwable)e, 2);
        }
    }

    private void handleModifiedMetricsAttrs(String[] attributeNames, IDeltaAttributeSet attrs) throws Exception {
        for (int i = 0; i < attributeNames.length; ++i) {
            if (attributeNames[i].equals("REFRESH_INTERVAL") || attributeNames[i].equals("COLLECTION_INTERVAL")) {
                long refreshInterval = ((Integer)attrs.getNewValue("REFRESH_INTERVAL")).longValue() * 1000L;
                long collectionInterval = ((Integer)attrs.getNewValue("COLLECTION_INTERVAL")).longValue() * 60000L;
                this.m_metricsManager.setRefreshAndCollectionInterval(refreshInterval, collectionInterval);
            }
            if (!attributeNames[i].equals("REPEAT_ALERT_NOTIFICATIONS")) continue;
            this.m_metricsManager.setRepeatMetricAlerts(((Boolean)attrs.getNewValue("REPEAT_ALERT_NOTIFICATIONS")).booleanValue());
        }
    }

    private void handleDeletedMetricsAttrs(String[] attributeNames) throws Exception {
        for (int i = 0; i < attributeNames.length; ++i) {
            if (attributeNames[i].equals("REFRESH_INTERVAL") || attributeNames[i].equals("COLLECTION_INTERVAL")) {
                long refreshInterval = 20000L;
                long collectionInterval = 600000L;
                this.m_metricsManager.setRefreshAndCollectionInterval(refreshInterval, collectionInterval);
            }
            if (!attributeNames[i].equals("REPEAT_ALERT_NOTIFICATIONS")) continue;
            this.m_metricsManager.setRepeatMetricAlerts(false);
        }
    }

    @Override
    void addSharedPath(URL url) throws UnsupportedOperationException {
    }

    @Override
    void addSharedClassname(String classname) throws UnsupportedOperationException {
    }

    static {
        NOTIFICATION_CLASSNAME = INotification.class.getName();
        METRIC_IDENTITY_ARRAY_CLASSNAME = IMetricIdentity[].class.getName();
        ALERT_ARRAY_CLASSNAME = IAlert[].class.getName();
        HANDLE_NOTIFICATION_CLASS_ARRAY = new Class[]{INotification.class};
        METRIC_IDENTITY_ARRAY_CLASS_ARRAY = new Class[]{IMetricIdentity[].class};
        ALERT_ARRAY_CLASS_ARRAY = new Class[]{IAlert[].class};
        try {
            CLEAR_ERROR_METHOD = AbstractMBean.class.getDeclaredMethod("clearError", IEmptyArray.EMPTY_CLASS_ARRAY);
            HANDLE_NOTIFICATION_METHOD = AbstractMBean.class.getDeclaredMethod("handleNotification", HANDLE_NOTIFICATION_CLASS_ARRAY);
            GET_METRICS_INFO_METHOD = IMetricsManager.class.getDeclaredMethod("getMetricsInfo", IEmptyArray.EMPTY_CLASS_ARRAY);
            ENABLE_METRICS_METHOD = IMetricsManager.class.getDeclaredMethod("enableMetrics", METRIC_IDENTITY_ARRAY_CLASS_ARRAY);
            DISABLE_METRICS_METHOD = IMetricsManager.class.getDeclaredMethod("disableMetrics", METRIC_IDENTITY_ARRAY_CLASS_ARRAY);
            REPLACE_ENABLED_METRICS_METHOD = MetricsManager.class.getDeclaredMethod("replaceEnabledMetrics", METRIC_IDENTITY_ARRAY_CLASS_ARRAY);
            GET_ACTIVE_METRICS_METHOD = IMetricsManager.class.getDeclaredMethod("getActiveMetrics", METRIC_IDENTITY_ARRAY_CLASS_ARRAY);
            GET_INSTANCE_METRIC_NAMES_METHOD = IComponent.class.getDeclaredMethod("getInstanceMetricNames", IMetricIdentity.class);
            GET_ENABLED_METRICS_METHOD = IMetricsManager.class.getDeclaredMethod("getEnabledMetrics", METRIC_IDENTITY_ARRAY_CLASS_ARRAY);
            GET_METRICS_DATA_METHOD = IMetricsManager.class.getDeclaredMethod("getMetricsData", IMetricIdentity[].class, Boolean.class);
            RESET_METRICS_METHOD = IMetricsManager.class.getDeclaredMethod("resetMetrics", IEmptyArray.EMPTY_CLASS_ARRAY);
            GET_ENABLED_ALERTS_METHOD = IMetricsManager.class.getDeclaredMethod("getEnabledAlerts", METRIC_IDENTITY_ARRAY_CLASS_ARRAY);
            ENABLE_ALERTS_METHOD = IMetricsManager.class.getDeclaredMethod("enableAlerts", ALERT_ARRAY_CLASS_ARRAY);
            DISABLE_ALERTS_METHOD = IMetricsManager.class.getDeclaredMethod("disableAlerts", ALERT_ARRAY_CLASS_ARRAY);
            REPLACE_ENABLED_ALERTS_METHOD = MetricsManager.class.getDeclaredMethod("replaceEnabledAlerts", ALERT_ARRAY_CLASS_ARRAY);
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
        DEFAULT_OPERATION_INFOS.add(new MBeanOperationInfo("start", "Start providing service.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        DEFAULT_OPERATION_INFOS.add(new MBeanOperationInfo("stop", "Stop providing service.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        DEFAULT_OPERATION_INFOS.add(new MBeanOperationInfo("clearError", "Clear existing error condition.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        String[] notifTypes = null;
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], IComponentState.STATE_TEXT[3]};
        DEFAULT_NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Component start complete."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], IComponentState.STATE_TEXT[1]};
        DEFAULT_NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Component stop complete."));
    }

    public class ContextImpl
    implements IComponentContext,
    IChangeRegistration {
        public Context getInitialContext() {
            return ComponentMBean.super.getInitialContext();
        }

        public ICanonicalName getComponentName() {
            return ComponentMBean.this.m_componentName;
        }

        public void setRuntimeConfiguration(IDirElement configuration) {
            ComponentMBean.super.setRuntimeConfiguration(configuration);
        }

        public IElement getConfiguration(boolean acceptChanges) {
            return ComponentMBean.super.getConfiguration(null, acceptChanges);
        }

        public IElement getConfiguration(String configID, boolean acceptChanges) {
            return ComponentMBean.super.getConfiguration(configID, acceptChanges);
        }

        public IElement getConfiguration(String configID, boolean acceptChanges, boolean alwaysFromDS) {
            return ComponentMBean.super.getConfiguration(configID, acceptChanges, alwaysFromDS);
        }

        public int checkFSConfiguration(String path) {
            return ComponentMBean.super.checkFSConfiguration(path);
        }

        public IElement getFSConfiguration(String path, boolean notify) {
            return ComponentMBean.super.getFSConfiguration(path, notify);
        }

        public IElement getFSConfiguration(String path, boolean notify, boolean alwaysFromDS) {
            return ComponentMBean.super.getFSConfiguration(path, notify, alwaysFromDS);
        }

        public String getPrivateSubDir(String baseDir) {
            return ComponentMBean.super.getPrivateSubDir(baseDir);
        }

        public IElement registerFileChangeInterest(String path) {
            return ComponentMBean.super.registerFileChangeInterest(path);
        }

        public void unregisterFileChangeInterest(String path) {
            ComponentMBean.super.unregisterFileChangeInterest(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IElement[] getConfigurations(String[] configIDs, boolean[] acceptChanges) {
            String currentUserID = TaskScheduler.getCurrentUserID();
            if (TaskScheduler.isExecutionThread()) {
                ((TaskScheduler.ExecutionThread)Thread.currentThread()).setUserID("Administrator");
            }
            try {
                IElement[] iElementArray = ComponentMBean.super.getConfigurations(configIDs, acceptChanges);
                return iElementArray;
            }
            finally {
                if (TaskScheduler.isExecutionThread()) {
                    ((TaskScheduler.ExecutionThread)Thread.currentThread()).setUserID(currentUserID);
                }
            }
        }

        public IElement[] getFSConfigurations(String[] paths, boolean notify) {
            return null;
        }

        public IElement[] getConfigurations(String dirName, boolean acceptChanges) {
            return ComponentMBean.super.getConfigurations(dirName, acceptChanges);
        }

        public File getLocalFile(String path) throws MFException {
            return ComponentMBean.super.getLocalFile(path);
        }

        public INotification createNotification(short category, String subCategory, String eventName, int severityLevel) {
            if (category == 0) {
                if (subCategory.equals(INotification.SUBCATEGORY_TEXT[0])) {
                    if (!eventName.equals(IComponentState.STATE_TEXT[3]) && !eventName.equals(IComponentState.STATE_TEXT[1])) {
                        throw new IllegalArgumentException("Illegal to create system notifications");
                    }
                } else {
                    throw new IllegalArgumentException("Illegal to create system notifications");
                }
            }
            return ComponentMBean.super.createNotification(category, subCategory, eventName, severityLevel);
        }

        public void sendNotification(INotification notification) {
            ComponentMBean.super.sendNotification(notification);
        }

        public void logMessage(String message, int severityLevel) {
            ComponentMBean.super.logMessage(message, severityLevel);
        }

        public void logMessage(String message, Throwable exception, int severityLevel) {
            ComponentMBean.super.logMessage(message, exception, severityLevel);
        }

        public void logMessage(Throwable exception, int severityLevel) {
            ComponentMBean.super.logMessage(exception, severityLevel);
        }

        public boolean registerErrorCondition(String errorMessage, int errorLevel) {
            return ComponentMBean.super.registerErrorCondition(errorMessage, errorLevel);
        }

        public void clearErrorCondition() {
            ComponentMBean.super.clearError();
        }

        public void scheduleTask(Runnable task, Date startTime) {
            ComponentMBean.super.scheduleTask(task, startTime, false);
        }

        public void cancelTask(Runnable task) {
            ComponentMBean.super.cancelTask(task);
        }

        public IMetricsRegistrar initMetricsManagement(IMetricInfo[] metricInfos) {
            return ComponentMBean.this.initMetricsManagement(metricInfos);
        }

        public void fireAttributeChangeHandlers() {
            ComponentMBean.super.fireAttributeChangeHandlers();
        }

        public void registerAttributeChangeHandler(AttributeName name, IAttributeChangeHandler handler) {
            ComponentMBean.super.registerAttributeChangeHandler(name, handler);
        }

        public void unregisterAttributeChangeHandler(AttributeName name) {
            ComponentMBean.super.unregisterAttributeChangeHandler(name);
        }

        public IElement getContainerConfiguration(boolean acceptsChanges) {
            return ComponentMBean.super.getContainerConfiguration(acceptsChanges);
        }

        public IAttributeSet getDeploymentParameters() {
            return ComponentMBean.super.getDeploymentParameters();
        }

        public Object setFaultDetectionConnection(Object jmsConnection) throws Exception {
            throw new UnsupportedOperationException();
        }

        public void restartContainer() throws Exception {
            IContainer container = ContainerImpl.getContainer();
            container.shutdown(14, true);
        }

        public boolean isDirectoryServiceAccessible() {
            return ComponentMBean.super.isDirectoryServiceAccessible();
        }
    }
}

