/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.comm.IConnectionListener;
import com.sonicsw.mf.comm.IExceptionListener;
import com.sonicsw.mf.comm.IGlobalComponentListener;
import com.sonicsw.mf.comm.jms.ConnectorClient;
import com.sonicsw.mf.comm.jms.DurableConnector;
import com.sonicsw.mf.common.IComponent;
import com.sonicsw.mf.common.IConsumer;
import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.MFServiceNotActiveException;
import com.sonicsw.mf.common.MgmtMsgTooBigException;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.util.ObjectNameHelper;
import com.sonicsw.mf.framework.IConnectorServer;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.IFrameworkComponent;
import com.sonicsw.mf.framework.IPermissionsManager;
import com.sonicsw.mf.framework.agent.AbstractMBean;
import com.sonicsw.mf.framework.agent.ContainerImpl;
import com.sonicsw.mf.framework.agent.TaskScheduler;
import com.sonicsw.mf.framework.security.PermissionsManager;
import com.sonicsw.mx.util.IEmptyArray;
import com.sonicsw.mx.util.LoaderInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import progress.message.client.api.IUserAlreadyConnected;
import progress.message.jclient.api.factory.FactoryClassesCache;

public class JMSConnectorServer
extends ConnectorClient
implements MessageListener,
IExceptionListener {
    private static final int MF_SUBJECT_ROOT_LENGTH = "SonicMQ.mf.".length();
    private Vector m_requestHandlers = new Vector();
    private HashMap m_globalSubscriptions = new HashMap();
    private ContainerImpl m_container;
    private IConnectorServer m_connectorDelegate;
    private TaskScheduler m_taskScheduler;
    private boolean m_closePending = false;
    static long NOTIFICATION_TTL;
    private static final long NOTIFICATION_TTL_DEFAULT;
    private static final String NOTIFICATION_TTL_PROPERTY = "sonicsw.mf.notificationTTL";
    private boolean TRACE = false;

    JMSConnectorServer(ContainerImpl container) {
        super(container.getContainerIdentity());
        this.m_container = container;
        this.m_taskScheduler = (TaskScheduler)this.m_container.getTaskScheduler();
        super.setExceptionListener((IExceptionListener)this);
        super.setConnectionListener((IConnectionListener)this.m_container);
        this.m_inContainer = true;
    }

    public void onException(Exception exception) {
        if (this.TRACE) {
            System.out.println("JMSConnectorServer.onException: isConnected = " + this.isConnected() + ", exception msg = " + exception.getMessage());
        }
        if (!this.m_container.isClosing()) {
            if (exception instanceof JMSException && ((JMSException)exception).getLinkedException() instanceof IUserAlreadyConnected) {
                this.logMessage('\"' + this.m_container.getContainerIdentity().getCanonicalName() + "\" appears to be running elsewhere", 1);
                this.m_container.shutdown(13);
            } else {
                this.logMessage("Permanent management connection failure, trace follows...", exception, 1);
                if (this.m_container.isBooted()) {
                    this.m_container.m_agent.shutdown(9);
                } else {
                    this.m_container.shutdown(9);
                }
            }
        }
    }

    public void close() {
        IConsumer[] globalSubscriptions = this.m_globalSubscriptions.values().toArray(new IConsumer[0]);
        for (int i = 0; i < globalSubscriptions.length; ++i) {
            if (globalSubscriptions[i] == null) continue;
            globalSubscriptions[i].close();
        }
        IConsumer subscription = this.m_subscription;
        JMSConnectorServer.closeSubscription(subscription);
        super.close();
        this.m_requestHandlers.removeAllElements();
    }

    public void closePending() {
        this.m_closePending = true;
        super.closePending();
    }

    Connection getConnection() {
        return this.m_durableConnector.getConnection();
    }

    IConsumer addRequestHandler(ContainerImpl.RequestHandler handler) {
        RequestHandlerDelegate delegate = new RequestHandlerDelegate(handler);
        this.m_requestHandlers.addElement(delegate);
        return delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IConnectorServer getConnectorServer() {
        JMSConnectorServer jMSConnectorServer = this;
        synchronized (jMSConnectorServer) {
            if (this.m_connectorDelegate == null) {
                this.m_connectorDelegate = new IConnectorServer(){

                    @Override
                    public long getConnectTimeout() {
                        return JMSConnectorServer.this.getConnectTimeout();
                    }

                    @Override
                    public long getSocketConnectTimeout() {
                        return JMSConnectorServer.this.getSocketConnectTimeout();
                    }

                    @Override
                    public long getRequestTimeout() {
                        return JMSConnectorServer.this.getRequestTimeout();
                    }

                    @Override
                    public void setConnectTimeout(long timeout) {
                        JMSConnectorServer.this.setConnectTimeout(timeout);
                    }

                    @Override
                    public void setSocketConnectTimeout(long timeout) {
                        JMSConnectorServer.this.setSocketConnectTimeout(timeout);
                    }

                    @Override
                    public void setRequestTimeout(long timeout) {
                        JMSConnectorServer.this.setRequestTimeout(timeout);
                    }

                    @Override
                    public boolean isConnected() {
                        return JMSConnectorServer.this.isConnected();
                    }
                };
            }
        }
        return this.m_connectorDelegate;
    }

    private void removeRequestHandler(RequestHandlerDelegate delegate) {
        this.m_requestHandlers.removeElement(delegate);
    }

    void addGlobalComponentSupport(String globalID, String instanceID, IGlobalComponentListener globalComponentListener) throws JMSException {
        String pseudoContainerID = JMSConnectorServer.getPseudoContainerID((String)globalID, (String)instanceID);
        IConsumer subscription = (IConsumer)this.m_globalSubscriptions.remove(pseudoContainerID);
        JMSConnectorServer.closeSubscription(subscription);
        while (!this.m_closePending && !this.m_container.isClosing()) {
            try {
                String subject = "SonicMQ.mf.*." + this.m_domainName + '.' + pseudoContainerID;
                String subscriptionName = this.m_domainName + '/' + pseudoContainerID;
                subscription = this.m_durableConnector.subscribe(subject, subscriptionName, (MessageListener)this, globalComponentListener);
                break;
            }
            catch (IllegalStateException e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((this.m_traceMask & 0x40) <= 0 || (this.m_traceMask & 1) <= 0) continue;
                this.logMessage("Retrying to create global subscription for '" + globalID + "' due to... ", e, 7);
            }
        }
        if (this.m_closePending || this.m_container.isClosing()) {
            return;
        }
        if (this.TRACE) {
            System.out.println("JMSConnectorServer.addGlobalComponentSupport: subscription = " + subscription + ", pseudoContainerID = " + pseudoContainerID + ", instanceID = " + instanceID);
        }
        this.m_globalSubscriptions.put(pseudoContainerID, subscription);
    }

    void removeGlobalComponentSupport(String globalID, String instanceID) {
        String pseudoContainerID = JMSConnectorServer.getPseudoContainerID((String)globalID, (String)instanceID);
        IConsumer subscription = (IConsumer)this.m_globalSubscriptions.remove(pseudoContainerID);
        JMSConnectorServer.closeSubscription(subscription);
    }

    private static void closeSubscription(IConsumer subscription) {
        if (subscription != null) {
            subscription.close();
        }
    }

    void sendDirectedNotification(String commsType, String destination, int listenerHash, Notification notification, Object handback) {
        boolean isMFNotification = notification instanceof INotification;
        boolean isTraceable = !isMFNotification || !((INotification)notification).getEventName().equals("LogMessage");
        int traceMask = 0;
        ObjectName source = null;
        String forwardedBy = null;
        CanonicalName forwarderName = null;
        AbstractMBean mBean = null;
        if (isTraceable) {
            IComponent component;
            source = (ObjectName)notification.getSource();
            if (isMFNotification) {
                forwardedBy = (String)((INotification)notification).getAttributes().get("ForwardedBy");
            }
            if (forwardedBy != null) {
                forwarderName = new CanonicalName(forwardedBy);
                mBean = this.m_container.getMBeanNonBlocking(forwarderName.getComponentName());
            } else if (isMFNotification) {
                mBean = this.m_container.getMBeanNonBlocking(source.getKeyProperty("ID"));
            }
            if (mBean != null && (component = mBean.m_component) != null) {
                traceMask = component.getTraceMask();
            }
        }
        try {
            BytesMessage message = (BytesMessage)FactoryClassesCache.getBytesMessageObjectFactory().createInstance();
            message.setStringProperty("JMS_SonicMQ_mf_comms_type", commsType);
            message.setIntProperty("JMS_SonicMQ_mf_listener_ID", listenerHash);
            message.setShortProperty("JMS_SonicMQ_mf_content_type", (short)0);
            ByteArrayOutputStream arrayOut = new ByteArrayOutputStream(5120);
            ObjectOutputStream out = new ObjectOutputStream(arrayOut);
            out.writeObject(notification);
            out.writeObject(handback);
            out.flush();
            message.writeInt(arrayOut.size());
            message.writeBytes(arrayOut.toByteArray());
            out.close();
            String requestID = "3";
            Object[] reqArr = super.buildRequestArray(destination, requestID);
            if (isTraceable && (traceMask & 8) > 0 && (traceMask & 1) > 0) {
                if (forwardedBy == null) {
                    this.m_container.logMessage(isMFNotification ? source.getKeyProperty("ID") : source.getCanonicalName(), "Sending notification [" + notification.getType() + "] to JMX client " + this.getJMXClientHostAndID(destination), 7);
                } else {
                    this.m_container.logMessage(forwarderName.getComponentName(), "Forwarding notification [" + notification.getType() + "] to JMX client " + this.getJMXClientHostAndID(destination), 7);
                }
            }
            this.m_durableConnector.publish(destination, (Message)message, this.m_requestTimeout, NOTIFICATION_TTL, reqArr);
        }
        catch (Throwable e) {
            if (isTraceable && (traceMask & 8) > 0 && (traceMask & 1) > 0) {
                if (forwardedBy == null) {
                    this.m_container.logMessage(isMFNotification ? source.getKeyProperty("ID") : source.getCanonicalName(), "Failed to send notification [" + notification.getType() + "] to JMX client " + this.getJMXClientHostAndID(destination) + ", trace follows", e, 7);
                } else {
                    this.m_container.logMessage(forwarderName.getComponentName(), "Failed to forward notification [" + notification.getType() + "] to JMX client " + this.getJMXClientHostAndID(destination) + ", trace follows", e, 7);
                }
            }
            return;
        }
    }

    String getJMXClientHostAndID(String destinationParam) {
        String destination = destinationParam;
        StringBuffer sb = new StringBuffer("(host=");
        destination = destination.substring(destination.indexOf(".JMXCLIENT.") + 11);
        int index = destination.indexOf(46);
        sb.append(destination.substring(0, index).replace('_', '.'));
        sb.append(", id=");
        sb.append(destination.substring(index + 1));
        sb.append(')');
        return sb.toString();
    }

    public void logMessage(String message, int severityLevel) {
        this.m_container.logMessage(null, message, severityLevel);
    }

    public void logMessage(String message, Throwable exception, int severityLevel) {
        this.m_container.logMessage(null, message, exception, severityLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message rpcMessage) {
        short contentType;
        if (this.isRedelivered(rpcMessage)) {
            return;
        }
        try {
            contentType = rpcMessage.getShortProperty("JMS_SonicMQ_mf_content_type");
        }
        catch (JMSException e) {
            this.logMessage("Bad MF JMS message content type received .. dropping message, trace follows...", e, 2);
            return;
        }
        if (this.m_closePending && contentType == 1) {
            return;
        }
        if (contentType != 1) {
            super.onMessage(rpcMessage);
            return;
        }
        Object[] handlers = null;
        Vector vector = this.m_requestHandlers;
        synchronized (vector) {
            handlers = new RequestHandlerDelegate[this.m_requestHandlers.size()];
            if (handlers.length > 0) {
                this.m_requestHandlers.copyInto(handlers);
            }
        }
        String userID = null;
        try {
            userID = rpcMessage.getStringProperty("JMSXUserID");
        }
        catch (JMSException e) {
            this.logMessage("Failed to obtain associated UserID .. dropping message, trace follows...", e, 2);
            return;
        }
        String commsType = null;
        try {
            IPermissionsManager permissionsManager;
            commsType = rpcMessage.getStringProperty("JMS_SonicMQ_mf_comms_type");
            if (!IContainer.PRE75_SECURITY && commsType.equals("mf") && this.m_container.m_agent != null && (permissionsManager = this.m_container.m_agent.getPermissionsManager()) != null && ((PermissionsManager)permissionsManager).isPermissionsCheckingEnabled()) {
                String topic = rpcMessage.getJMSDestination().toString();
                int index = topic.indexOf("::");
                if (index > -1) {
                    topic = topic.substring(index + 2);
                }
                if (!topic.startsWith("SonicMQ.mf.MFCLIENT.")) {
                    StringBuffer sb = new StringBuffer("Attempted impersonation (");
                    if (userID != null && userID.length() > 0) {
                        sb.append("user=").append(userID).append(", ");
                    }
                    StringTokenizer st = new StringTokenizer(topic, ".");
                    st.nextToken();
                    st.nextToken();
                    sb.append("clientType=").append(st.nextToken());
                    sb.append(") ... dropping management request");
                    this.logMessage(sb.toString(), 1);
                    return;
                }
            }
        }
        catch (JMSException e) {
            this.logMessage("Bad MF JMS message comms type received .. dropping message, trace follows...", e, 1);
            return;
        }
        long expirationTime = 0L;
        try {
            expirationTime = rpcMessage.getJMSExpiration();
        }
        catch (JMSException index) {
            // empty catch block
        }
        String role = null;
        try {
            role = rpcMessage.getJMSDestination().toString();
            role = role.substring(MF_SUBJECT_ROOT_LENGTH);
            role = role.substring(0, role.indexOf(46));
        }
        catch (JMSException e) {
            this.logMessage("Bad MF JMS message destination received .. dropping message, trace follows...", e, 2);
            return;
        }
        for (int i = 0; i < handlers.length; ++i) {
            if (!((RequestHandlerDelegate)handlers[i]).commsType.equals(commsType)) continue;
            Object handler = handlers[i];
            final String requestorRole = role;
            final String requestorUserID = userID;
            Runnable invoker = new Runnable(){
                final /* synthetic */ RequestHandlerDelegate val$handler;
                final /* synthetic */ Message val$rpcMessage;
                {
                    this.val$handler = requestHandlerDelegate;
                    this.val$rpcMessage = message;
                }

                @Override
                public void run() {
                    ((TaskScheduler.ExecutionThread)Thread.currentThread()).setRole(requestorRole);
                    ((TaskScheduler.ExecutionThread)Thread.currentThread()).setUserID(requestorUserID);
                    this.val$handler.onMessage(this.val$rpcMessage);
                }
            };
            this.m_taskScheduler.scheduleTask(invoker, true, expirationTime);
            return;
        }
    }

    static {
        NOTIFICATION_TTL_DEFAULT = DurableConnector.DURABLE_SUBSCRIPTION_TTL;
        String notificationTTL = System.getProperty(NOTIFICATION_TTL_PROPERTY);
        NOTIFICATION_TTL = notificationTTL == null ? NOTIFICATION_TTL_DEFAULT : Long.parseLong(notificationTTL);
    }

    public final class RequestHandlerDelegate
    implements MessageListener,
    IConsumer {
        ContainerImpl.RequestHandler handler;
        String commsType;

        private RequestHandlerDelegate(ContainerImpl.RequestHandler handler) {
            this.handler = handler;
            this.commsType = handler.getHandlerCommsType();
        }

        public void onMessage(Message message) {
            Object returnValue;
            String operationName;
            BytesMessage reply;
            String invokeMethod;
            ObjectName objectName;
            long replyTimeout;
            String replyToSubject;
            long onMessageAfterPublish;
            long onMessageBeforePublish;
            long onMessageAfterInvoke;
            long onMessageBeforeInvoke;
            long onMessageStart;
            block50: {
                onMessageStart = 0L;
                onMessageBeforeInvoke = 0L;
                onMessageAfterInvoke = 0L;
                onMessageBeforePublish = 0L;
                onMessageAfterPublish = 0L;
                if (JMSConnectorServer.this.TRACE) {
                    onMessageBeforeInvoke = onMessageStart = System.currentTimeMillis();
                    onMessageAfterInvoke = onMessageStart;
                    onMessageBeforePublish = onMessageStart;
                    onMessageAfterPublish = onMessageStart;
                }
                replyToSubject = null;
                boolean isOneway = false;
                replyTimeout = JMSConnectorServer.this.m_requestTimeout;
                objectName = null;
                invokeMethod = null;
                String[] signature = null;
                Object[] params = null;
                BytesMessage requestMessage = (BytesMessage)message;
                reply = null;
                try {
                    String target;
                    replyToSubject = requestMessage.getStringProperty("JMS_SonicMQ_mf_reply_subject");
                    try {
                        isOneway = requestMessage.getBooleanProperty("JMS_SonicMQ_mf_oneway_request");
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (!isOneway) {
                        try {
                            replyTimeout = requestMessage.getLongProperty("JMS_SonicMQ_mf_timeout");
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if ((target = requestMessage.getStringProperty("JMS_SonicMQ_mf_target")) != null) {
                        objectName = new ObjectName(target);
                        objectName = ObjectNameHelper.translateGlobalObjectName((ObjectName)objectName, (String)JMSConnectorServer.this.m_container.getContainerIdentity().getContainerName());
                    }
                    invokeMethod = requestMessage.getStringProperty("JMS_SonicMQ_mf_operation");
                    if ((JMSConnectorServer.this.m_traceMask & 0x10) > 0) {
                        StringBuffer msg = new StringBuffer("Request received from " + replyToSubject);
                        if ((JMSConnectorServer.this.m_traceMask & 1) > 0) {
                            msg.append(", details...");
                            msg.append("\n\ttarget = ").append(objectName == null ? "MBeanServer" : objectName.getCanonicalName());
                            msg.append("\n\trequest = ").append(invokeMethod);
                        }
                        JMSConnectorServer.this.logMessage(msg.toString(), 7);
                    }
                }
                catch (Throwable e) {
                    if ((JMSConnectorServer.this.m_traceMask & 0x20) > 0) {
                        JMSConnectorServer.this.logMessage("Failed to unmarshal request, trace follows...", e, 7);
                        if (e instanceof InvocationTargetException) {
                            JMSConnectorServer.this.logMessage("Target exception follows...", ((InvocationTargetException)e).getTargetException(), 7);
                        }
                    } else {
                        JMSConnectorServer.this.logMessage("Failed to unmarshal MF request", 1);
                    }
                    return;
                }
                IComponent component = null;
                if (objectName != null && ObjectNameHelper.isMFComponentName((ObjectName)objectName)) {
                    String id = objectName.getKeyProperty("ID");
                    while (component == null) {
                        AbstractMBean mBean = JMSConnectorServer.this.m_container.getMBean(id);
                        if (JMSConnectorServer.this.m_container.isClosing()) {
                            return;
                        }
                        if (mBean == null) break;
                        component = mBean.getManagedComponent();
                    }
                }
                try {
                    if (requestMessage.readBoolean()) {
                        signature = IEmptyArray.EMPTY_STRING_ARRAY;
                        params = IEmptyArray.EMPTY_OBJECT_ARRAY;
                    } else {
                        byte[] bytes = new byte[requestMessage.readInt()];
                        requestMessage.readBytes(bytes);
                        ByteArrayInputStream arrayIn = new ByteArrayInputStream(bytes);
                        ObjectInputStream in = null;
                        in = component != null && !(component instanceof IFrameworkComponent) && invokeMethod.equals("invoke") ? new LoaderInputStream((InputStream)arrayIn, component.getClass().getClassLoader()) : new ObjectInputStream(arrayIn);
                        signature = (String[])in.readObject();
                        params = (Object[])in.readObject();
                        in.close();
                    }
                }
                catch (Throwable e) {
                    if ((JMSConnectorServer.this.m_traceMask & 0x20) > 0) {
                        JMSConnectorServer.this.logMessage("Failed to unmarshal request, trace follows...", e, 7);
                        if (e instanceof InvocationTargetException) {
                            JMSConnectorServer.this.logMessage("Target exception follows...", ((InvocationTargetException)e).getTargetException(), 7);
                        }
                    } else {
                        JMSConnectorServer.this.logMessage("Failed to unmarshal MF request", 1);
                    }
                    return;
                }
                operationName = invokeMethod;
                if (params.length > 0) {
                    for (int i = 0; i < params.length; ++i) {
                        if (!(params[i] instanceof ObjectName)) continue;
                        params[i] = ObjectNameHelper.translateGlobalObjectName((ObjectName)((ObjectName)params[i]), (String)JMSConnectorServer.this.m_container.getContainerIdentity().getContainerName());
                    }
                }
                if (invokeMethod.equals("invoke")) {
                    operationName = (String)params[1];
                }
                returnValue = null;
                try {
                    if (!isOneway) {
                        reply = (BytesMessage)FactoryClassesCache.getBytesMessageObjectFactory().createInstance();
                        reply.setJMSCorrelationID(requestMessage.getJMSCorrelationID());
                        reply.setStringProperty("JMS_SonicMQ_mf_comms_type", requestMessage.getStringProperty("JMS_SonicMQ_mf_comms_type"));
                        reply.setShortProperty("JMS_SonicMQ_mf_content_type", (short)2);
                        reply.setStringProperty("JMS_SonicMQ_mf_target", objectName == null ? null : objectName.getCanonicalName());
                        reply.setStringProperty("JMS_SonicMQ_mf_operation", operationName);
                        reply.setLongProperty("JMS_SonicMQ_mf_received", System.currentTimeMillis());
                    }
                    onMessageBeforeInvoke = this.updateMessage(onMessageBeforeInvoke);
                    returnValue = this.handler.invoke(objectName, invokeMethod, params, signature);
                    onMessageAfterInvoke = this.updateMessage(onMessageAfterInvoke);
                    if (isOneway) {
                        return;
                    }
                }
                catch (Throwable e) {
                    Throwable targetException;
                    if (JMSConnectorServer.this.m_container.isClosing()) {
                        return;
                    }
                    if ((JMSConnectorServer.this.m_traceMask & 0x20) > 0) {
                        JMSConnectorServer.this.logMessage("Failed \"" + operationName + "\" on " + (objectName == null ? "MBeanServer" : objectName.getCanonicalName()) + ", trace follows...", e, 7);
                    }
                    returnValue = e;
                    while (returnValue != null && returnValue instanceof InvocationTargetException && (targetException = ((InvocationTargetException)returnValue).getTargetException()) != null) {
                        returnValue = targetException;
                    }
                    if (returnValue instanceof JMException || returnValue instanceof JMRuntimeException) {
                        if (replyToSubject.indexOf(".JNDICLIENT.") > 0) {
                            returnValue = e.getCause();
                        } else if (returnValue instanceof RuntimeOperationsException && ((RuntimeOperationsException)returnValue).getTargetException() instanceof MFServiceNotActiveException) {
                            returnValue = ((RuntimeOperationsException)returnValue).getTargetException();
                        }
                    }
                    if (!isOneway) break block50;
                    return;
                }
            }
            try {
                reply.setLongProperty("JMS_SonicMQ_mf_replied", System.currentTimeMillis());
                reply.writeBoolean(returnValue == null);
                if (returnValue != null) {
                    int size = returnValue instanceof IBlob ? 1005120 : 5120;
                    ByteArrayOutputStream arrayOut = new ByteArrayOutputStream(size);
                    ObjectOutputStream out = new ObjectOutputStream(arrayOut);
                    out.writeObject(returnValue);
                    out.flush();
                    reply.writeInt(arrayOut.size());
                    reply.writeBytes(arrayOut.toByteArray());
                    out.close();
                }
                String requestID = "2";
                Object[] reqArr = JMSConnectorServer.super.buildRequestArray(replyToSubject, requestID);
                if ((JMSConnectorServer.this.m_traceMask & 0x10) > 0) {
                    JMSConnectorServer.this.logMessage("Reply sent to " + replyToSubject, 7);
                }
                onMessageBeforePublish = this.updateMessage(onMessageBeforePublish);
                try {
                    JMSConnectorServer.this.m_durableConnector.publish(replyToSubject, (Message)reply, replyTimeout, replyTimeout, reqArr);
                }
                catch (MgmtMsgTooBigException mmtbe) {
                    String targetObj;
                    String string = targetObj = objectName == null ? "MBeanServer" : objectName.getCanonicalName();
                    if ((JMSConnectorServer.this.m_traceMask & 0x20) > 0) {
                        JMSConnectorServer.this.logMessage("Reply too large to send for \"" + operationName + "\" on " + targetObj + ", trace follows...", mmtbe, 7);
                    } else {
                        JMSConnectorServer.this.logMessage("Reply too large to send for \"" + operationName + "\" on " + targetObj + ":" + mmtbe.toString(), 1);
                    }
                    MFException returnException = new MFException("Request to " + targetObj + " for \"" + operationName + "\" generated response which exceeded maximum size for management messages");
                    reply.clearBody();
                    reply.writeBoolean(false);
                    ByteArrayOutputStream arrayOut = new ByteArrayOutputStream(5120);
                    ObjectOutputStream out = new ObjectOutputStream(arrayOut);
                    out.writeObject((Object)returnException);
                    out.flush();
                    reply.writeInt(arrayOut.size());
                    reply.writeBytes(arrayOut.toByteArray());
                    out.close();
                    JMSConnectorServer.this.m_durableConnector.publish(replyToSubject, (Message)reply, replyTimeout, replyTimeout, reqArr);
                }
                onMessageAfterPublish = this.updateMessage(onMessageAfterPublish);
            }
            catch (Throwable e) {
                if (JMSConnectorServer.this.m_container.isClosing()) {
                    return;
                }
                if ((JMSConnectorServer.this.m_traceMask & 0x20) > 0) {
                    JMSConnectorServer.this.logMessage("Failed to marshal reply to \"" + operationName + "\" on " + (objectName == null ? "MBeanServer" : objectName.getCanonicalName()) + ", trace follows...", e, 7);
                } else {
                    JMSConnectorServer.this.logMessage("Failed to marshal reply to \"" + operationName + "\" on " + (objectName == null ? "MBeanServer" : objectName.getCanonicalName()) + ":" + e.toString(), 1);
                }
                return;
            }
            if (JMSConnectorServer.this.TRACE) {
                long onMessageFinished = System.currentTimeMillis();
                System.out.println("Task's onMessage time for " + invokeMethod + " in thread " + Thread.currentThread().toString() + "\n\tunmarshall " + (onMessageBeforeInvoke - onMessageStart) + "\n\tinvoke " + (onMessageAfterInvoke - onMessageBeforeInvoke) + "\n\tmarshall " + (onMessageBeforePublish - onMessageAfterInvoke) + "\n\tpublish " + (onMessageAfterPublish - onMessageBeforePublish) + "\n\ttotal " + (onMessageFinished - onMessageStart));
            }
        }

        private long updateMessage(long messageTimeParam) {
            long messageTime = messageTimeParam;
            if (JMSConnectorServer.this.TRACE) {
                messageTime = System.currentTimeMillis();
            }
            return messageTime;
        }

        public void close() {
            JMSConnectorServer.this.removeRequestHandler(this);
        }
    }
}

