/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.common.url.SonicRNStreamHandler;
import com.sonicsw.mf.framework.agent.ContainerImpl;
import com.sonicsw.mf.framework.agent.DsdataURLStreamHandler;
import com.sonicsw.mf.framework.agent.SonicfsURLStreamHandler;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

public class SonicURLStreamHandlerFactoryImpl
implements URLStreamHandlerFactory {
    private ContainerImpl m_container;
    private URLStreamHandler m_sonicfsHandler;
    private URLStreamHandler m_sonichomeHandler;
    private URLStreamHandler m_dsdataHandler;
    private URLStreamHandler m_nullHandler;
    private URLStreamHandler m_sonicrnHandler;

    SonicURLStreamHandlerFactoryImpl(ContainerImpl container) {
        this.m_container = container;
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (protocol.equalsIgnoreCase("sonicfs")) {
            if (this.m_sonicfsHandler == null) {
                this.m_sonicfsHandler = new SonicfsURLStreamHandler(this.m_container, "sonicfs:///");
            }
            return this.m_sonicfsHandler;
        }
        if (protocol.equalsIgnoreCase("sonichome")) {
            if (this.m_sonichomeHandler == null) {
                this.m_sonichomeHandler = new SonicfsURLStreamHandler(this.m_container, "sonichome:///");
            }
            return this.m_sonichomeHandler;
        }
        if (protocol.equalsIgnoreCase("dsdata")) {
            if (this.m_dsdataHandler == null) {
                this.m_dsdataHandler = new DsdataURLStreamHandler(this.m_container);
            }
            return this.m_dsdataHandler;
        }
        if (protocol.equalsIgnoreCase("sonic") || protocol.equalsIgnoreCase("jndi")) {
            if (this.m_nullHandler == null) {
                this.m_nullHandler = new NullStreamHandler("sonic");
            }
            return this.m_nullHandler;
        }
        if (protocol.equalsIgnoreCase("sonicrn")) {
            if (this.m_sonicrnHandler == null && this.m_container.getDS().isLocalDS()) {
                this.m_sonicrnHandler = new SonicRNStreamHandler(this.m_container.getDS().getLocalDS(), true);
            }
            return this.m_sonicrnHandler;
        }
        return null;
    }

    void resetSonicRNHandlerDS() {
        if (this.m_sonicrnHandler != null) {
            ((SonicRNStreamHandler)this.m_sonicrnHandler).setDirectoryService(this.m_container.getDS().getLocalDS());
        }
    }

    private class NullStreamHandler
    extends URLStreamHandler {
        private String protocol;

        public NullStreamHandler(String protocolName) {
            this.protocol = protocolName;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            throw new IOException("Can not open URL's of protocol:" + this.protocol);
        }

        @Override
        protected String toExternalForm(URL u) {
            String ret = "";
            ret = u.getProtocol().equals("sonic") ? "sonic:///" + u.getHost() + u.getPath() : (u.getProtocol().equals("jndi") ? "jndi:" + u.getHost() + u.getPath() : super.toExternalForm(u));
            return ret;
        }
    }
}

