/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IVisibleDbkLogicalNote;
import com.sonicsw.mtstorage.impl.LogicalNote;
import java.io.IOException;

class DeleteLogicalNote
extends LogicalNote
implements IVisibleDbkLogicalNote {
    protected static byte NOTE_TYPE = (byte)51;
    long m_dbkey;
    private boolean m_useThisDbkey;

    DeleteLogicalNote() {
    }

    @Override
    byte getType() {
        return NOTE_TYPE;
    }

    @Override
    public long getDbk() {
        return this.m_dbkey;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write(this.getType());
        writer.write((byte)(this.m_start ? 1 : 0));
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_transactionNum);
        writer.write(this.m_scratchBuffer, 0, 8);
        writer.write((byte)(this.m_useThisDbkey ? 1 : 0));
        int noteLength = 11;
        if (this.m_dbkey != 0L) {
            BitUtil.putLong(this.m_scratchBuffer, 0, this.m_dbkey);
            writer.write(this.m_scratchBuffer, 0, 8);
            noteLength += 8;
        }
        return noteLength;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        int currentOffset = offset;
        this.m_start = buffer[currentOffset++] == 1;
        this.m_transactionNum = BitUtil.getLong(buffer, currentOffset);
        currentOffset += 8;
        this.m_useThisDbkey = buffer[currentOffset++] == 1;
        this.m_dbkey = this.m_useThisDbkey ? BitUtil.getLong(buffer, currentOffset) : 0L;
    }

    @Override
    void initNote(long transactionNum, boolean noteStart) {
        this.m_transactionNum = transactionNum;
        this.m_start = noteStart;
        this.m_useThisDbkey = false;
        this.m_dbkey = 0L;
    }

    void initNote(long transactionNum, boolean noteStart, long dbkey) {
        this.m_transactionNum = transactionNum;
        this.m_start = noteStart;
        this.m_useThisDbkey = dbkey != 0L;
        this.m_dbkey = dbkey;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " transaction: " + this.m_transactionNum + " start: " + this.m_start;
    }
}

