/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AccessSemaphore;
import com.sonicsw.mtstorage.impl.AllocateLogicalNote;
import com.sonicsw.mtstorage.impl.AsyncDeleteManager;
import com.sonicsw.mtstorage.impl.AsyncDeleteNote;
import com.sonicsw.mtstorage.impl.BTreeCreateTreeLogicalNote;
import com.sonicsw.mtstorage.impl.BTreeDeleteLogicalNote;
import com.sonicsw.mtstorage.impl.BTreeManager;
import com.sonicsw.mtstorage.impl.BTreeNoteInterface;
import com.sonicsw.mtstorage.impl.BadLogicalNote;
import com.sonicsw.mtstorage.impl.CheckpointDoneNote;
import com.sonicsw.mtstorage.impl.CheckpointNote;
import com.sonicsw.mtstorage.impl.CheckpointV2Note;
import com.sonicsw.mtstorage.impl.DeleteByAsyncThreadLogicalNote;
import com.sonicsw.mtstorage.impl.DeleteLogicalNote;
import com.sonicsw.mtstorage.impl.ILogicalNote;
import com.sonicsw.mtstorage.impl.INote;
import com.sonicsw.mtstorage.impl.ITransactionControl;
import com.sonicsw.mtstorage.impl.IVisibleDbkLogicalNote;
import com.sonicsw.mtstorage.impl.LogEndIndicator;
import com.sonicsw.mtstorage.impl.LogReader;
import com.sonicsw.mtstorage.impl.LogWriteGroup;
import com.sonicsw.mtstorage.impl.LogicalNote;
import com.sonicsw.mtstorage.impl.LogicalRollback;
import com.sonicsw.mtstorage.impl.NoteWriter;
import com.sonicsw.mtstorage.impl.PageAllocationNote;
import com.sonicsw.mtstorage.impl.PageManager;
import com.sonicsw.mtstorage.impl.RecoveryInterruptException;
import com.sonicsw.mtstorage.impl.Storage;
import com.sonicsw.mtstorage.impl.TransactionBeginNote;
import com.sonicsw.mtstorage.impl.TransactionEndNote;
import com.sonicsw.mtstorage.impl.TransactionManager;
import com.sonicsw.mtstorage.replication.ReplicationManager;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;

final class Logger {
    private static final String GROUP_LOG_WRITE_DELAY_PARAMETER = "GROUP_LOG_WRITE";
    private static final long GROUP_LOG_WRITE_DELAY_DEFAULT = 0L;
    private PageManager m_pageManager;
    private NoteWriter m_noteWriter;
    private LogEndIndicator m_logEndInidicator;
    private TransactionBeginNote m_transactionBeginNote;
    private TransactionEndNote m_transactionEndNote;
    private CheckpointV2Note m_checkpointNote;
    private CheckpointDoneNote m_checkpointDoneNote;
    private BadLogicalNote m_badLogicalNote;
    private LogReader m_recoveryLogReader;
    private boolean m_inRecovery;
    private boolean m_recoveryInterrupted;
    private LogWriteGroup m_logWriteGroup;
    private AccessSemaphore m_accessSemaphore;
    private LogicalRollback m_logicalRollbackRecovery;

    Logger(AccessSemaphore acessSemaphore) {
        this.m_accessSemaphore = acessSemaphore;
        this.m_recoveryInterrupted = false;
        this.m_logicalRollbackRecovery = null;
    }

    void open(File dbDir, PageManager pageManager, HashMap parameters) throws IOException {
        this.m_transactionBeginNote = new TransactionBeginNote();
        this.m_transactionEndNote = new TransactionEndNote();
        this.m_checkpointNote = new CheckpointV2Note();
        this.m_checkpointDoneNote = new CheckpointDoneNote();
        this.m_badLogicalNote = new BadLogicalNote();
        this.m_pageManager = pageManager;
        this.m_noteWriter = new NoteWriter(dbDir);
        this.m_noteWriter.open(parameters);
        this.m_logEndInidicator = this.m_noteWriter.getVirtualLog().getIndicator();
        long groupLogWriteDelay = 0L;
        Long groupLogWriteDelayParam = (Long)parameters.get(GROUP_LOG_WRITE_DELAY_PARAMETER);
        if (groupLogWriteDelayParam != null) {
            groupLogWriteDelay = groupLogWriteDelayParam;
        }
        this.m_logWriteGroup = new LogWriteGroup(groupLogWriteDelay);
    }

    void interruptRecovery() {
        this.m_recoveryInterrupted = true;
        if (this.m_logicalRollbackRecovery != null) {
            this.m_logicalRollbackRecovery.interrupt();
        }
    }

    long getNextNoteID() {
        return this.m_noteWriter.getNextNoteID();
    }

    boolean newLogFile() {
        return this.m_noteWriter.getVirtualLog().newLogFile();
    }

    void getMetrics(Properties props, String dbName) {
        if (this.m_noteWriter != null) {
            this.m_noteWriter.getMetrics(props, dbName);
        }
    }

    void setInRecovery(boolean inRecovery) {
        this.m_inRecovery = inRecovery;
    }

    boolean inRecovery() {
        return this.m_inRecovery;
    }

    void activateCache(int maxSize) {
        this.m_noteWriter.getVirtualLog().activateCache(maxSize);
    }

    long getIDAfterLastTransEnd() {
        return this.m_noteWriter.getIDAfterLastTransEnd();
    }

    ReplicationManager.ReplicationDataIndicator getReplicationData(long startingID, boolean firstLogRequest) throws InterruptedException, IOException {
        return this.m_noteWriter.getReplicationData(startingID, firstLogRequest);
    }

    void stopWaitingForData() {
        this.m_noteWriter.stopWaitingForData();
    }

    static int removePageHeaders(byte[] buffer, int dataOffset, long startID, int dataLength) {
        return NoteWriter.removePageHeaders(buffer, dataOffset, startID, dataLength);
    }

    int replicateNotes(byte[] buffer, long startingID, int dataOffset, int totaldataLength, int firstNoteOffset, long[] lastNoteID, CheckpointNote[] checkpointNote) throws IOException {
        return this.m_noteWriter.replicateNotes(buffer, startingID, dataOffset, totaldataLength, firstNoteOffset, lastNoteID, checkpointNote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceToDisk(boolean delayForGroupWrite, boolean lockSemaphore) throws IOException {
        HashSet set = null;
        if (delayForGroupWrite) {
            try {
                set = this.m_logWriteGroup.postRequest();
            }
            catch (InterruptedException e) {
                throw new IOException(e.toString());
            }
            if (set == null) {
                return;
            }
        }
        try {
            if (lockSemaphore) {
                this.m_accessSemaphore.exclusiveLock();
            }
            this.m_noteWriter.forceTailToDisk();
        }
        finally {
            if (lockSemaphore) {
                this.m_accessSemaphore.releaseLock();
            }
        }
        if (set != null) {
            this.m_logWriteGroup.notifyAndRemoveFromGroup(set);
        }
    }

    void close() throws IOException {
        this.m_noteWriter.close();
    }

    long startTransaction(long transactionNum) throws IOException {
        this.m_transactionBeginNote.initNote(transactionNum);
        return this.m_noteWriter.writeNote(this.m_transactionBeginNote);
    }

    long endTransaction(Long transactionNum, boolean commit) throws IOException {
        this.m_transactionEndNote.initNote(transactionNum, commit);
        return this.m_noteWriter.writeNote(this.m_transactionEndNote);
    }

    long synchronousCheckpoint(TransactionManager tm, AsyncDeleteManager deleteManager) throws IOException {
        long noteID = this.checkpointStart(tm, deleteManager);
        this.checkpointDone();
        return noteID;
    }

    long checkpointStart(TransactionManager tm, AsyncDeleteManager deleteManager) throws IOException {
        this.m_checkpointNote.initNote(tm, deleteManager);
        return this.m_noteWriter.writeNote(this.m_checkpointNote);
    }

    void checkpointDone() throws IOException {
        if (!Boolean.getBoolean("_PSETEST_CRASH")) {
            this.m_noteWriter.writeNote(this.m_checkpointDoneNote);
        }
        this.forceToDisk(false, false);
    }

    void releaseNotes(long noteID) throws IOException {
        this.m_noteWriter.releaseLog(noteID);
    }

    void releaseNotes() throws IOException {
        this.m_noteWriter.releaseLog();
    }

    long writeNote(INote note) throws IOException {
        return this.m_noteWriter.writeNote(note);
    }

    LogReader getNewReader(long noteIDPosition) {
        return new LogReader(this.m_noteWriter, noteIDPosition);
    }

    LogReader getNewReader() {
        return new LogReader(this.m_noteWriter);
    }

    LogReader getRollbackReader() {
        return new LogReader(this.m_noteWriter, this.m_logEndInidicator.getLastWrittenNoteID());
    }

    void logicalRollback(Storage storage, long transNum) throws IOException {
        long lastWrittenNoteID = this.m_logEndInidicator.getLastWrittenNoteID();
        LogReader logReader = new LogReader(this.m_noteWriter, lastWrittenNoteID);
        new LogicalRollback(storage, this, logReader, transNum).rollback();
    }

    void logicalRollback(Storage storage, TransactionManager transManager) throws IOException {
        if (this.m_recoveryInterrupted) {
            throw new RecoveryInterruptException();
        }
        this.m_logicalRollbackRecovery = new LogicalRollback(storage, this, this.m_recoveryLogReader, transManager);
        this.m_logicalRollbackRecovery.rollback();
        this.m_recoveryLogReader = null;
    }

    RollforwardInfo backupRollforwardPrepare(long checkpointNoteID, long lastBackupNoteID) throws IOException {
        this.m_recoveryLogReader = new LogReader(this.m_noteWriter, checkpointNoteID);
        return new RollforwardInfo(lastBackupNoteID, (CheckpointNote)this.m_recoveryLogReader.getNext());
    }

    RollforwardInfo rollforwardPrepare() throws IOException {
        long lastWrittenNoteID = this.m_logEndInidicator.getLastWrittenNoteID();
        if (lastWrittenNoteID == -1L) {
            return new RollforwardInfo(-1L, null);
        }
        this.m_recoveryLogReader = new LogReader(this.m_noteWriter, lastWrittenNoteID);
        int numNotes = 0;
        boolean checkpointDoneSeen = false;
        while (true) {
            if (this.m_recoveryInterrupted) {
                throw new RecoveryInterruptException();
            }
            INote note = this.m_recoveryLogReader.getPrev();
            if (note instanceof CheckpointDoneNote) {
                checkpointDoneSeen = true;
            } else if ((checkpointDoneSeen || lastWrittenNoteID == 8L) && note instanceof CheckpointNote) break;
            ++numNotes;
        }
        return new RollforwardInfo(numNotes > 0 ? lastWrittenNoteID : -1L, (CheckpointNote)this.m_recoveryLogReader.getNext());
    }

    private void rollforwardUndoHalfdoneOperation(LogReader logReader, BTreeManager btreeManager) throws IOException {
        INote note;
        long smallestNewPageNum = 0L;
        long largestNewPageNum = 0L;
        while (!((note = logReader.getPrev()) instanceof ILogicalNote)) {
            if (note instanceof PageAllocationNote) {
                long allocatePage = ((PageAllocationNote)note).m_allocatedPage;
                if (largestNewPageNum == 0L) {
                    largestNewPageNum = allocatePage;
                }
                smallestNewPageNum = allocatePage;
            } else if (note instanceof BTreeNoteInterface) {
                btreeManager.undo(note);
            } else if (!(note instanceof AsyncDeleteNote)) {
                this.m_pageManager.undo(note);
            }
            this.m_pageManager.writePagesIfNeeded(false);
        }
        if (smallestNewPageNum != 0L) {
            this.m_pageManager.deallocate(smallestNewPageNum, largestNewPageNum);
        }
    }

    void rollforward(TransactionManager transactionManager, BTreeManager btreeManager, AsyncDeleteManager asyncDeleteManager, long lastNoteID, boolean undoHalfLogical) throws IOException {
        boolean done;
        boolean inLogicalOperation = false;
        boolean reservedDBK = false;
        boolean unreservedDBK = false;
        long dbk = 0L;
        long transNum = 0L;
        boolean bl = done = lastNoteID == -1L;
        while (!done) {
            if (this.m_recoveryInterrupted) {
                throw new RecoveryInterruptException();
            }
            INote note = this.m_recoveryLogReader.getNext();
            if (note.getNoteID() == lastNoteID) {
                done = true;
            }
            if (note instanceof ILogicalNote) {
                boolean bl2 = inLogicalOperation = !inLogicalOperation;
                if (note instanceof BadLogicalNote) {
                    LogReader halfDoneReader = this.m_recoveryLogReader.createClone();
                    halfDoneReader.getPrev();
                    this.rollforwardUndoHalfdoneOperation(halfDoneReader, btreeManager);
                    if (reservedDBK) {
                        transactionManager.pageUnreserveDBK(dbk);
                    } else if (unreservedDBK) {
                        transactionManager.reserveDBK(new Long(transNum), dbk);
                    }
                }
                if (!inLogicalOperation) {
                    reservedDBK = false;
                    unreservedDBK = false;
                }
                if (inLogicalOperation && (note instanceof DeleteLogicalNote || note instanceof BTreeDeleteLogicalNote)) {
                    dbk = ((IVisibleDbkLogicalNote)((Object)note)).getDbk();
                    if (note instanceof DeleteByAsyncThreadLogicalNote && asyncDeleteManager != null) {
                        asyncDeleteManager.alreadyDeleted(new Long(dbk));
                    }
                    transactionManager.reserveDBK(new Long(((LogicalNote)note).m_transactionNum), dbk);
                    reservedDBK = true;
                }
                if (inLogicalOperation && (note instanceof AllocateLogicalNote || note instanceof BTreeCreateTreeLogicalNote)) {
                    dbk = ((IVisibleDbkLogicalNote)((Object)note)).getDbk();
                    transNum = ((LogicalNote)note).m_transactionNum;
                    if (dbk != 0L) {
                        transactionManager.pageUnreserveDBK(dbk);
                        unreservedDBK = true;
                    }
                }
            } else if (note instanceof CheckpointNote) {
                this.m_pageManager.forceToDisk();
            } else if (note instanceof TransactionBeginNote) {
                transactionManager.transactionBegin(((TransactionBeginNote)note).getTransactionNum());
            } else if (note instanceof TransactionEndNote) {
                transactionManager.transactionEnd(new Long(((TransactionEndNote)note).getTransactionNum()));
                if (asyncDeleteManager != null) {
                    asyncDeleteManager.transEnd((TransactionEndNote)note);
                }
            } else if (note instanceof BTreeNoteInterface) {
                btreeManager.redo(note);
            } else if (note instanceof AsyncDeleteNote && asyncDeleteManager != null) {
                asyncDeleteManager.redo((AsyncDeleteNote)note);
            } else if (!(note instanceof ITransactionControl) && !(note instanceof AsyncDeleteNote)) {
                this.m_pageManager.redo(note);
            }
            this.m_pageManager.writePagesIfNeeded(false);
        }
        if (undoHalfLogical && inLogicalOperation) {
            this.rollforwardUndoHalfdoneOperation(this.m_recoveryLogReader, btreeManager);
            if (reservedDBK) {
                transactionManager.pageUnreserveDBK(dbk);
            } else if (unreservedDBK) {
                transactionManager.reserveDBK(new Long(transNum), dbk);
            }
            this.m_badLogicalNote.initNote();
            this.m_noteWriter.writeNote(this.m_badLogicalNote);
        }
    }

    long getLastWrittenNoteID() {
        return this.m_logEndInidicator.getLastWrittenNoteID();
    }

    long getLogLength() {
        return this.m_noteWriter.getVirtualLog().getLogPhysicalLengthEstimate();
    }

    void replicateLog(File replicatedDBDir, long firstNoteID, long lastNoteID) throws IOException {
        this.m_noteWriter.getVirtualLog().replicateLog(replicatedDBDir, firstNoteID, lastNoteID);
    }

    class RollforwardInfo {
        long m_lastWrittenNoteID;
        CheckpointNote m_cpNote;

        RollforwardInfo(long lastWrittenNoteID, CheckpointNote cpNote) {
            this.m_lastWrittenNoteID = lastWrittenNoteID;
            this.m_cpNote = cpNote;
        }
    }
}

