/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.replication.ftchannel.socket;

import com.sonicsw.mtstorage.replication.ftchannel.ChannelConstants;
import com.sonicsw.mtstorage.replication.ftchannel.IActiveChannel;
import com.sonicsw.mtstorage.replication.ftchannel.IChannelListener;
import com.sonicsw.mtstorage.replication.ftchannel.PermanentException;
import com.sonicsw.mtstorage.replication.util.BitUtil;
import com.sonicsw.mtstorage.replication.util.Tracer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.util.HashMap;

public class ActiveChannel
implements IActiveChannel,
ChannelConstants {
    private Socket m_socket;
    private InputStream m_input;
    private OutputStream m_output;
    private boolean m_closing = false;
    private boolean m_open = false;
    private boolean m_alwaysRetry;
    private IChannelListener m_listener;

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("HOST", args[0]);
        config.put("PORT", new Integer(args[1]));
        HashMap[] configs = new HashMap[]{config};
        ActiveChannel ch = new ActiveChannel();
        ch.open(configs, null, new TestListener(), false, false, true);
        byte[] data = new byte[10];
        data[9] = 11;
        BitUtil.putInt(data, 0, 6);
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(1000L);
            ch.send(data, 0, 10);
        }
        Thread.sleep(1000000000L);
    }

    @Override
    public void doNotReportFailure() {
    }

    synchronized void open(Socket socket, HashMap paramUnused, IChannelListener listener, boolean alwaysRetry, boolean primaryUnused) throws IOException {
        this.m_alwaysRetry = alwaysRetry;
        this.m_socket = socket;
        this.m_listener = listener;
        this.init();
    }

    @Override
    public synchronized void open(HashMap[] connections, HashMap paramUnused, IChannelListener listener, boolean alwaysRetry, boolean primaryUnused, boolean reportFailureUnused) throws IOException, PermanentException {
        this.m_listener = listener;
        HashMap connection = connections[0];
        String host = (String)connection.get("HOST");
        int port = (Integer)connection.get("PORT");
        try {
            this.m_socket = new Socket(host, port);
        }
        catch (BindException e) {
            if (this.m_alwaysRetry) {
                throw e;
            }
            throw new PermanentException(e);
        }
        catch (MalformedURLException e) {
            if (this.m_alwaysRetry) {
                throw e;
            }
            throw new PermanentException(e);
        }
        catch (UnknownHostException e) {
            if (this.m_alwaysRetry) {
                throw e;
            }
            throw new PermanentException(e);
        }
        catch (UnknownServiceException e) {
            if (this.m_alwaysRetry) {
                throw e;
            }
            throw new PermanentException(e);
        }
        this.init();
    }

    private void init() throws IOException {
        this.m_input = this.m_socket.getInputStream();
        this.m_output = this.m_socket.getOutputStream();
        this.receive(this.m_input);
        this.m_open = true;
    }

    @Override
    public synchronized void send(byte[] data, int offset, int length) throws IOException {
        if (!this.m_open || this.m_closing) {
            throw new IOException("The connection is down");
        }
        this.m_output.write(data, offset, length);
    }

    @Override
    public void close(boolean unused) {
        this.closeSocket(this.m_socket, this.m_input, this.m_output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeSocket(Socket recivingSocket, InputStream input, OutputStream output) {
        if (!this.m_open) {
            return;
        }
        try {
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
            if (recivingSocket != null) {
                recivingSocket.close();
            }
        }
        catch (Exception e) {
            Tracer.TRACE(e);
        }
        finally {
            output = null;
            input = null;
            recivingSocket = null;
        }
    }

    private void receive(final InputStream input) {
        Thread receiver = new Thread("PSE Replication Data Receiver"){

            @Override
            public void run() {
                byte[] messageLengthBuf = new byte[4];
                try {
                    while (true) {
                        if (ActiveChannel.this.m_closing) {
                            return;
                        }
                        ActiveChannel.this.read(input, messageLengthBuf, 0, 4);
                        int messageLength = BitUtil.getInt(messageLengthBuf, 0);
                        byte[] msgBuffer = new byte[messageLength];
                        ActiveChannel.this.read(input, msgBuffer, 0, messageLength);
                        if (ActiveChannel.this.m_listener == null) continue;
                        ActiveChannel.this.m_listener.messageReceived(msgBuffer);
                    }
                }
                catch (IOException e) {
                    Tracer.TRACE(e);
                    ActiveChannel.this.closeSocket(ActiveChannel.this.m_socket, ActiveChannel.this.m_input, ActiveChannel.this.m_output);
                    if (!ActiveChannel.this.m_closing && ActiveChannel.this.m_listener != null) {
                        ActiveChannel.this.m_listener.connectionDropped(e.toString());
                    }
                    return;
                }
            }
        };
        receiver.setDaemon(true);
        receiver.start();
    }

    private void read(InputStream input, byte[] buffer, int offset, int bytesToRead) throws IOException {
        int n;
        for (int readCount = 0; readCount < bytesToRead; readCount += n) {
            n = input.read(buffer, offset + readCount, bytesToRead - readCount);
            if (n != -1) continue;
            throw new IOException("Channel receiver failed to read");
        }
    }

    static class TestListener
    implements IChannelListener {
        TestListener() {
        }

        @Override
        public void connectionDropped(String message) {
            System.out.println("connectionDropped: " + message);
        }

        @Override
        public void reportEvent(String event, boolean warning) {
            System.out.println("reportEvent: " + event);
        }

        @Override
        public void messageReceived(byte[] message) {
            System.out.println("messageReceived: " + message.length + " bytes ");
        }
    }
}

