/*
 * Decompiled with CFR 0.152.
 */
package com.odi;

import com.odi.FatalInternalException;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectException;
import com.odi.ObjectStore;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.Utilities;

public abstract class Persistent
implements IPersistent,
IPersistentHooks {
    private transient byte objectState = 0;
    public static final String className = "com.odi.Persistent";
    protected transient ObjectReference ref;

    @Override
    public abstract void initializeContents(GenericObject var1);

    @Override
    public abstract void clearContents();

    @Override
    public abstract void flushContents(GenericObject var1);

    @Override
    public void postInitializeContents() {
    }

    @Override
    public void preFlushContents() {
    }

    @Override
    public void preClearContents() {
    }

    public static void fetch(Object object) {
        if (object instanceof IPersistent) {
            Persistent.fetch((IPersistent)object);
        } else if (Utilities.isArray(object)) {
            ObjectManager.fetch(object);
        }
    }

    public static void fetch(IPersistent object) {
        if (object.ODIgetState() < 0) {
            ObjectManager.fetch(object);
        }
    }

    public static void fetch(Persistent object) {
        Persistent.fetch((IPersistent)object);
    }

    public static void fetch(String s) {
    }

    public static void deepFetch(Object object) {
        ObjectManager.deepFetch(object);
    }

    public static void deepFetch(String s) {
    }

    public static void dirty(Object object) {
        if (object instanceof IPersistent) {
            Persistent.dirty((IPersistent)object);
        } else if (Utilities.isArray(object)) {
            ObjectManager.dirty(object);
        }
    }

    public static void dirty(Persistent object) {
        Persistent.dirty((IPersistent)object);
    }

    public static void dirty(IPersistent object) {
        if ((object.ODIgetState() & 2) != 0) {
            ObjectManager.dirty(object);
        }
    }

    public static void dirty(String s) {
        throw new ObjectException("Attempt to call dirty() on a String, which cannot be modified.");
    }

    protected Object clone() throws CloneNotSupportedException {
        if (this.objectState < 0) {
            throw new ObjectException("The invocation of clone() must be preceded by a call to either com.odi.Persistent.fetch() or com.odi.Persistent.dirty()");
        }
        Persistent c = (Persistent)super.clone();
        c.objectState = 0;
        c.ref = null;
        return c;
    }

    public final void destroyInternal() {
        if (ObjectStore.isPersistent(this)) {
            ObjectManager.destroy(this);
        }
    }

    public void destroy() {
        this.destroyInternal();
    }

    @Override
    public void preDestroyPersistent() {
    }

    public static boolean hasWriteBarrier(IPersistent o) {
        return (o.ODIgetState() & 2) != 0;
    }

    public static boolean hasReadBarrier(IPersistent o) {
        return o.ODIgetState() < 0;
    }

    public static boolean isCached(IPersistent o) {
        return (o.ODIgetState() & 4) != 0;
    }

    public static void makeHollow(IPersistent o) {
        o.ODIsetState((byte)-126);
    }

    public static void makeCached(IPersistent o) {
        o.ODIsetState((byte)-122);
    }

    public static void makeReadable(IPersistent o) {
        o.ODIsetState(Persistent.isLazyObject(o) ? (byte)3 : 2);
    }

    public static void makeWritable(IPersistent o) {
        o.ODIsetState(Persistent.isLazyObject(o) ? (byte)1 : 0);
    }

    public final int transientHashCode() {
        return super.hashCode();
    }

    public static void setLazyObject(IPersistent o, boolean lazyObject) {
        byte objectState = o.ODIgetState();
        if (lazyObject) {
            objectState = objectState == 2 ? (byte)3 : 1;
        } else if (objectState == 1) {
            objectState = 0;
        } else if (objectState == 3) {
            objectState = 2;
        } else {
            throw new FatalInternalException("Attempt to set lazyObject to false, but present state is not barriersDownAndLazy or writeBarrierSetAndLazy. objectState=" + objectState);
        }
        o.ODIsetState(objectState);
    }

    public static boolean isLazyObject(IPersistent o) {
        byte objectState = o.ODIgetState();
        return objectState == 1 || objectState == 3;
    }

    public boolean isStale() {
        return ObjectManager.isStale(this);
    }

    public boolean isDestroyed() {
        return ObjectManager.isDestroyed(this);
    }

    @Override
    public final ObjectReference ODIgetRef() {
        return this.ref;
    }

    @Override
    public final void ODIsetRef(ObjectReference objRef) {
        this.ref = objRef;
    }

    @Override
    public final byte ODIgetState() {
        return this.objectState;
    }

    @Override
    public final void ODIsetState(byte state) {
        this.objectState = state;
    }
}

