/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.ClassInfo;
import com.odi.Cluster;
import com.odi.DatabaseException;
import com.odi.DatabaseNotOpenException;
import com.odi.DatabaseOpenException;
import com.odi.DatabaseRootAlreadyExistsException;
import com.odi.DatabaseRootEnumeration;
import com.odi.DatabaseRootNotFoundException;
import com.odi.DatabaseSegmentEnumeration;
import com.odi.ObjectException;
import com.odi.ObjectNotFoundException;
import com.odi.ObjectStore;
import com.odi.ObjectStoreException;
import com.odi.PersistentTypeSummary;
import com.odi.SchemaException;
import com.odi.SegmentNotFoundException;
import com.odi.Session;
import com.odi.UnregisteredType;
import com.odi.imp.MutatingObjRef;
import com.odi.imp.ObjRefUtils;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.SchemaManager;
import com.odi.imp.Segment;
import com.odi.imp.Server;
import com.odi.imp.SimpleHashtable;
import com.odi.imp.Transaction;
import com.odi.imp.Utilities;
import com.odi.util.query.Query;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public abstract class Database
extends com.odi.Database {
    protected int databaseId;
    protected String name;
    private int openMode;
    private Transaction tx;
    boolean alreadyOpen = false;
    protected ObjectManager om;
    SimpleHashtable segments = new SimpleHashtable(11);

    protected Database(int databaseId, String pathname, ObjectManager om) {
        this.databaseId = databaseId;
        this.name = pathname;
        this.om = om;
    }

    private static void checkCreateArgs(String name, int fileMode) {
        if (name == null) {
            Utilities.throwNullArgumentException("Database", "create", "name");
        }
        if (fileMode > 511) {
            throw new IllegalArgumentException("Incorrect \"fileMode\" argument: " + Integer.toString(fileMode, 8) + " supplied to Database.create().");
        }
        if ((fileMode & 0x80) == 0) {
            throw new IllegalArgumentException("The file mode needs to include owner write permission.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static com.odi.Database create(String name, int fileMode, HashMap parameters) {
        ObjectManager om;
        Database.checkCreateArgs(name, fileMode);
        Transaction.assureNoTransaction();
        ObjectManager objectManager = om = ObjectManager.assureCurrent();
        synchronized (objectManager) {
            return om.sv.createDatabase(name, fileMode, parameters, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static com.odi.Database create(String name, int fileMode, int schemaInstallMode) {
        ObjectManager om;
        int product = ObjectStore.whichProduct();
        if (product == 1 || product == 2) {
            throw new ObjectStoreException("Specifying schema installation mode is not supported in PSE and PSE Pro");
        }
        Database.checkCreateArgs(name, fileMode);
        if (schemaInstallMode != 1 && schemaInstallMode != 2) {
            throw new IllegalArgumentException("Incorrect \"schemaInstallMode\" argument: " + fileMode + " supplied to Database.create().");
        }
        Transaction.assureNoTransaction();
        ObjectManager objectManager = om = ObjectManager.assureCurrent();
        synchronized (objectManager) {
            return om.sv.createDatabase(name, fileMode, null, schemaInstallMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static com.odi.Database open(String name, int openMode, HashMap parameters) {
        ObjectManager om;
        if (name == null) {
            Utilities.throwNullArgumentException("Database", "open", "name");
        }
        ObjectManager objectManager = om = ObjectManager.assureCurrent();
        synchronized (objectManager) {
            Database db = om.sv.openDatabase(name, openMode, parameters);
            return db;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.odi.Database open(int openMode) {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.alreadyOpen = this.serverOpenDatabaseByID(openMode);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            try {
                this.getOpenModeInternal();
            }
            catch (DatabaseNotOpenException e) {
                return false;
            }
            return true;
        }
    }

    private int getOpenModeInternal() {
        if (this.tx != null && this.tx == this.om.tx && this.openMode != 0) {
            return this.openMode;
        }
        this.openMode = 0;
        this.tx = this.om.tx;
        this.openMode = this.serverDatabaseOpenMode();
        return this.openMode;
    }

    void setOpenModeInternal(int openMode) {
        this.openMode = openMode;
    }

    @Override
    public void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean retainAsTransient) {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            Transaction.assureNoTransaction();
            this.om.checkDatabaseCloseRetainArgument(retainAsTransient);
            this.serverClose();
            this.om.forgetObjectsInDatabase(this, false, retainAsTransient);
            this.openMode = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            Transaction.assureNoTransaction();
            this.serverDestroy();
            this.om.forgetObjectsInDatabase(this, true, false);
            this.openMode = 0;
        }
    }

    @Override
    public String getPath() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSizeInBytes() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            Transaction.assureTransaction();
            return this.serverGetSizeInBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOpenMode() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            return this.getOpenModeInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createRoot(String name, Object object) {
        if (name == null) {
            Utilities.throwNullArgumentException("Database", "createRoot", "name");
        }
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(7);
            try {
                this.getRoot(name);
                throw new DatabaseRootAlreadyExistsException("Database root " + name + " already exists.");
            }
            catch (DatabaseRootNotFoundException e) {
            }
            catch (ObjectNotFoundException e) {
                // empty catch block
            }
            this.serverCreateRoot(name, this.verifyRootSetValue(name, object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyRoot(String name) {
        if (name == null) {
            Utilities.throwNullArgumentException("Database", "destroyRoot", "name");
        }
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(7);
            this.serverDestroyRoot(name);
        }
    }

    private byte[] verifyRootSetValue(String rootName, Object object) {
        this.om.assureTransactionCompatible(7);
        if (object != null) {
            ObjectReference objRef;
            boolean persistent = this.om.isPersistentObject(object);
            if (!this.om.isImmediateObject(object, true)) {
                if (!persistent) {
                    ObjectStore.migrate(object, this.getDefaultSegment().getDefaultCluster());
                    persistent = true;
                }
            } else if (persistent) {
                ObjectStore.evict(object, 3);
            }
            if (persistent && this.databaseId != ObjRefUtils.getDatabaseId(objRef = this.om.getObjRef(object))) {
                throw new DatabaseException("Attempt to associate an object with a database root in a different database.\nThe object of type " + ObjRefUtils.typeString(objRef) + " in database \"" + Database.of(object).getPath() + "\", segment " + Segment.of(object).getSegmentId() + "\", cluster " + com.odi.imp.Cluster.of(object).getClusterId() + ", location " + objRef.getLocation() + ", was being associated with the database root named \"" + rootName + "\" in database \"" + this.getPath() + "\".");
            }
        }
        byte[] dmssReference = new byte[this.om.objectAccess.referenceSize];
        this.om.putJavaReference(dmssReference, 0, object, (com.odi.imp.Cluster)this.getDefaultSegment().getDefaultCluster(), true);
        return dmssReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getRoot(String name) {
        if (name == null) {
            Utilities.throwNullArgumentException("Database", "getRoot", "name");
        }
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(6);
            return this.om.getJavaReference(this.serverGetRoot(name), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRoot(String name, Object object) {
        if (name == null) {
            Utilities.throwNullArgumentException("Database", "setRoot", "name");
        }
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(7);
            try {
                this.getRoot(name);
            }
            catch (ObjectNotFoundException e) {
                // empty catch block
            }
            this.serverSetRoot(name, this.verifyRootSetValue(name, object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseRootEnumeration getRoots() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(6);
            return new com.odi.imp.DatabaseRootEnumeration(this.serverGetRoots());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.odi.Segment createSegment() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(7);
            Segment seg = this.serverCreateNewSegment();
            this.segments.put(seg.segmentId, seg);
            return seg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.odi.Segment getSegment(int segmentId) {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(6);
            if (segmentId < 0) {
                throw new SegmentNotFoundException("Segment " + segmentId + " in database \"" + this.getPath() + "\" was not found.");
            }
            return this.getSegmentInternal(segmentId);
        }
    }

    private com.odi.Segment getSegmentInternal(int segmentId) {
        this.serverCheckSegment(segmentId);
        return this.getSegmentObject(segmentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    com.odi.Segment getSegmentObject(int segmentId) {
        ObjectManager objectManager = this.om;
        synchronized (objectManager) {
            Segment seg = (Segment)this.segments.get(segmentId);
            if (seg == null) {
                seg = this.serverCreateExistingSegment(segmentId);
                this.segments.put(segmentId, seg);
            }
            return seg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.odi.Segment getDefaultSegment() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(6);
            return this.getSegmentInternal(this.serverGetDefaultSegmentId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultSegment(com.odi.Segment segment) {
        if (segment == null) {
            Utilities.throwNullArgumentException("Database", "setDefaultSegment", "segment");
        }
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(6);
            if (segment.getDatabase() != this) {
                throw new IllegalArgumentException("Attempt to set the default segment of database " + this.name + " to a segment in a different database.");
            }
            this.serverSetDefaultSegmentId(segment.getSegmentId());
        }
    }

    @Override
    public com.odi.Database getDatabase() {
        return this;
    }

    @Override
    public com.odi.Segment getSegment() {
        return this.getDefaultSegment();
    }

    @Override
    public Cluster getCluster() {
        return this.getDefaultSegment().getDefaultCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession() {
        ObjectManager objectManager = this.om;
        synchronized (objectManager) {
            if (this.om.isActive()) {
                return this.om;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void evolveSchema(String dbName, String workdbName, PersistentTypeSummary summary) {
        ObjectManager om;
        ObjectManager objectManager = om = ObjectManager.assureCurrent();
        synchronized (objectManager) {
            int product = ObjectStore.whichProduct();
            if (product == 1 || product == 2) {
                throw new ObjectStoreException("Schema evolution is not supported in PSE and PSE Pro");
            }
            if (dbName == null) {
                Utilities.throwNullArgumentException("Database", "evolveSchema", "dbName");
            }
            if (workdbName == null) {
                Utilities.throwNullArgumentException("Database", "evolveSchema", "workdbName");
            }
            if (summary == null) {
                Utilities.throwNullArgumentException("Database", "evolveSchema", "summary");
            }
            Transaction.assureNoTransaction();
            String[] allClasses = SchemaManager.closeOverTypeSummary(summary);
            for (int i = 0; i < allClasses.length; ++i) {
                om.schemaManager.getClassAFTypeCode(allClasses[i]);
            }
            om.sv.serverEvolveSchema(dbName, workdbName);
        }
    }

    private int[] convertIntegerVector(Vector intList) {
        int[] result = new int[intList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)intList.elementAt(i);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void installTypes(PersistentTypeSummary summary) {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            int product = ObjectStore.whichProduct();
            if (product == 1 || product == 2) {
                throw new ObjectStoreException("Forced type installation is not supported in PSE and PSE Pro");
            }
            this.om.assureTransactionCompatible(7);
            this.om.assureDatabaseCompatible(this, 7);
            String[] allClasses = SchemaManager.closeOverTypeSummary(summary);
            int[] aftcs = new int[allClasses.length];
            Vector<Integer> avtcList = new Vector<Integer>();
            for (int i = 0; i < aftcs.length; ++i) {
                aftcs[i] = this.om.schemaManager.getClassAFTypeCode(allClasses[i]);
                ClassInfo classInfo = this.om.schemaManager.getClassInfo(aftcs[i]);
                Class classDescriptor = null;
                try {
                    classDescriptor = classInfo.getClassDescriptor();
                }
                catch (ClassNotFoundException e) {
                    throw new SchemaException(e.getMessage(), e);
                }
                if (classDescriptor.isInterface()) continue;
                avtcList.addElement(new Integer(this.om.schemaManager.getDefaultAVTypeCode(aftcs[i])));
            }
            int[] avtcs = this.convertIntegerVector(avtcList);
            this.serverInstallTypes(aftcs, avtcs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseSegmentEnumeration getSegments() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(6);
            return this.serverGetSegments();
        }
    }

    public void checkCurrent() {
        this.om.checkCurrent();
    }

    public int getDatabaseId() {
        return this.databaseId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireLock(int lockType, int timeoutMillis) {
        ObjectManager.checkAcquireLockArguments(lockType, timeoutMillis, "Database");
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(lockType);
            this.serverAcquireLock(lockType, timeoutMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void affiliate(com.odi.Database targetDatabase, boolean deep) {
        if (targetDatabase == null) {
            Utilities.throwNullArgumentException("Database", "affiliate", "targetDatabase");
        }
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            Database targetDatabaseImp = (Database)targetDatabase;
            if (this.om != targetDatabaseImp.om) {
                throw new IllegalArgumentException("Attempt to affiliate this database with a target database object from another session.");
            }
            this.serverAffiliate(targetDatabaseImp.getDatabaseId(), deep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator getAffiliatedDatabases() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            return this.serverGetAffiliatedDatabases();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(PrintStream out) {
        if (out == null) {
            Utilities.throwNullArgumentException("Database", "check", "out");
        }
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            ObjectStore.evictAll(3);
            DatabaseSegmentEnumeration segs = this.getSegments();
            boolean ok = true;
            while (segs.hasMoreElements()) {
                Segment seg = (Segment)segs.nextElement();
                if (seg.check(out)) continue;
                ok = false;
            }
            out.flush();
            return ok;
        }
    }

    void showRoots(PrintStream out, boolean showOID) {
        DatabaseRootEnumeration roots = this.getRoots();
        int nRoots = 0;
        while (roots.hasMoreElements()) {
            roots.nextElement();
            ++nRoots;
        }
        switch (nRoots) {
            case 0: {
                out.println("There are no roots.");
                out.println();
                return;
            }
            case 1: {
                out.println("There is one root:");
                out.println();
                break;
            }
            default: {
                out.println("There are " + nRoots + " roots:");
                out.println();
            }
        }
        roots = this.getRoots();
        while (roots.hasMoreElements()) {
            String rootName = (String)roots.nextElement();
            String rootType = null;
            String rootOID = null;
            boolean found = true;
            Object obj = null;
            try {
                obj = this.getRoot(rootName);
            }
            catch (ObjectNotFoundException onfe) {
                found = false;
            }
            if (!found) {
                rootType = "(not found)";
                rootOID = "(not found)";
            } else if (obj == null) {
                rootType = "(null)";
                rootOID = "(null)";
            } else {
                rootType = obj instanceof UnregisteredType ? ((UnregisteredType)obj).getTypeName() : Utilities.userClassName(obj.getClass().getName());
                try {
                    rootOID = ObjRefUtils.OIDString(ObjectManager.getObjectReference(obj));
                }
                catch (ObjectException oe) {
                    rootOID = "(?unknown?)";
                }
            }
            out.println("  Name: " + rootName);
            out.println("  Type: " + rootType);
            if (showOID) {
                out.println("  OID:  " + rootOID);
            }
            out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void show(PrintStream out, boolean dumpObj, boolean dumpData, Query query) {
        if (out == null) {
            Utilities.throwNullArgumentException("Database", "show", "out");
        }
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            DatabaseSegmentEnumeration segs;
            Transaction.assureTransaction();
            if (!this.isOpen()) {
                throw new DatabaseNotOpenException(this);
            }
            out.println();
            out.println("Database Name: " + this.getPath());
            out.println();
            ObjectStore.evictAll(3);
            this.showRoots(out, dumpData || dumpObj);
            int nDeadObjects = this.serverGetNDeadObjects();
            if (nDeadObjects > 0) {
                out.println();
                out.println("Destroyed Objects: " + nDeadObjects);
                out.println();
            }
            if (!(segs = this.getSegments()).hasMoreElements()) {
                out.println("There are no segments.");
                out.println();
                return;
            }
            if (dumpData) {
                dumpObj = true;
            }
            while (segs.hasMoreElements()) {
                Segment seg = (Segment)segs.nextElement();
                seg.showSeg(out, dumpObj, dumpData, query);
            }
            out.flush();
        }
    }

    @Override
    public Properties GC() {
        return this.GC(new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties GC(Properties GCProperties) {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            Transaction.assureNoTransaction();
            if (this.isOpen()) {
                throw new DatabaseOpenException(this);
            }
            return this.serverGC(GCProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resync() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            Transaction.assureNoTransaction();
            if (!this.isOpen()) {
                throw new DatabaseNotOpenException(this);
            }
            this.serverResync();
        }
    }

    public abstract boolean serverOpenDatabaseByID(int var1);

    public abstract int serverDatabaseOpenMode();

    public abstract void serverClose();

    @Override
    public abstract void backup(String var1);

    public abstract void serverDestroy();

    public abstract long serverGetSizeInBytes();

    public abstract void serverCreateRoot(String var1, byte[] var2);

    public abstract void serverDestroyRoot(String var1);

    public abstract byte[] serverGetRoot(String var1);

    public abstract void serverSetRoot(String var1, byte[] var2);

    public abstract Enumeration serverGetRoots();

    public abstract Enumeration serverGetRootValues();

    public abstract Segment serverCreateNewSegment();

    public abstract boolean serverCheckSegment(int var1);

    public abstract Segment serverCreateExistingSegment(int var1);

    public abstract MutatingObjRef serverExportObject(ObjectReference var1, int var2);

    public abstract void serverDestroyObject(ObjectReference var1);

    public abstract int serverGetDefaultSegmentId();

    public abstract void serverSetDefaultSegmentId(int var1);

    public abstract DatabaseSegmentEnumeration serverGetSegments();

    public abstract void serverInstallTypes(int[] var1, int[] var2);

    public abstract void serverAffiliate(int var1, boolean var2);

    public abstract Iterator serverGetAffiliatedDatabases();

    public abstract void serverAcquireLock(int var1, int var2);

    protected abstract Server getServer();

    public abstract Properties serverGC(Properties var1);

    public abstract String[] serverGetSchemaClasses();

    public abstract int serverGetSchemaClassCount();

    public abstract String serverGetSchemaString();

    public int serverGetNDeadObjects() {
        return -1;
    }

    public abstract void serverResync();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHostName() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            Transaction.assureTransaction();
            return this.serverGetHostName();
        }
    }

    public abstract String serverGetHostName();

    static {
        try {
            Class.forName("com.odi.util.BTreeNodeFactory");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

