/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.FatalInternalException;
import com.odi.imp.HashBucket;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.Primes;
import com.odi.imp.Utilities;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;

public abstract class WeakCache {
    private ObjectManager om;
    protected HashBucket[] table;
    private final int entriesPerSlot = 7;
    private int nEntries;
    int nScavengedBuckets = 0;
    int nScannedBuckets = 0;
    protected int reorgThreshold;
    private int nOperations = 0;
    private Runtime runTime = Runtime.getRuntime();
    private long lastTotalMemory;
    private long lastFreeMemory;
    private int currentBucket = 0;
    private int goalBucket = 0;
    int bucketScavenges = 0;
    private HashBucket writeableList;
    private HashBucket readableList;
    private HashBucket cachedList;
    private HashBucket cachedListTail;
    public static Constructor bucketConstructor = null;
    boolean runBucketScavenger = false;
    HashBucket gcSentinel = null;
    Object lastFindBucketObject = null;

    public WeakCache(ObjectManager om, int initialCapacity) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.om = om;
        this.writeableList = (HashBucket)((Object)om.objRefFactory.create(null, null, 0L, 0, 0));
        this.readableList = (HashBucket)((Object)om.objRefFactory.create(null, null, 0L, 0, 0));
        this.cachedList = (HashBucket)((Object)om.objRefFactory.create(null, null, 0L, 0, 0));
        this.cachedListTail = (HashBucket)((Object)om.objRefFactory.create(null, null, 0L, 0, 0));
        this.cachedList.setNextInChain(this.cachedListTail);
        this.cachedListTail.setPrevInChain(this.cachedList);
        this.runBucketScavenger = om.objRefFactory.supportsWeakReference();
        this.gcSentinel = (HashBucket)((Object)om.objRefFactory.create(new Object(), null, 0L, 0, 0));
        this.GCEvent();
    }

    protected final int slotIndex(int hash) {
        return (hash & Integer.MAX_VALUE) % this.table.length;
    }

    private void grow() {
        this.reorg(this.table.length * 3 / 2);
    }

    private void reorg(int newSize) {
        HashBucket[] newTable = new HashBucket[Primes.nextPrime(newSize)];
        this.reorgThreshold = newTable.length * 7;
        for (int i = 0; i < this.table.length; ++i) {
            HashBucket e = this.table[i];
            while (e != null) {
                HashBucket nextE = this.getNext(e);
                if (this.getKey(e) != null && this.getElement(e) != null) {
                    int slot = (this.getHash(e) & Integer.MAX_VALUE) % newTable.length;
                    this.setNext(e, newTable[slot]);
                    newTable[slot] = e;
                } else {
                    e.unchain();
                    this.setNext(e, null);
                    --this.nEntries;
                }
                e = nextE;
            }
            this.table[i] = null;
        }
        this.table = newTable;
        this.nOperations = 0;
        this.GCEvent();
        this.goalBucket = 0;
        this.currentBucket = 0;
    }

    public int size() {
        return this.nEntries;
    }

    public boolean isEmpty() {
        return this.nEntries == 0;
    }

    abstract HashBucket findBucket(Object var1);

    public Object get(Object key) {
        HashBucket e = this.findBucket(key);
        if (e == null) {
            return null;
        }
        return this.getElement(e);
    }

    void makeHollow(HashBucket bucket) {
        bucket.makeHollow();
        this.maybeScavengeBuckets();
    }

    void makeWritable(HashBucket bucket) {
        bucket.makeWritable(this.writeableList);
    }

    void makeReadable(HashBucket bucket) {
        bucket.makeReadable(this.readableList);
    }

    void makeCached(HashBucket bucket) {
        bucket.makeCached(this.cachedListTail);
    }

    public void put(HashBucket bucket) {
        if (this.nEntries >= this.reorgThreshold) {
            this.grow();
        }
        Object key = this.getKey(bucket);
        int index = this.slotIndex(this.computeHashCode(key));
        this.setNext(bucket, this.table[index]);
        this.table[index] = bucket;
        ++this.nEntries;
        this.maybeScavengeBuckets();
    }

    public void remove(HashBucket bucket) {
        this.maybeScavengeBuckets();
        int hash = this.computeHashCode(this.getKey(bucket));
        int index = this.slotIndex(hash);
        HashBucket e = this.table[index];
        HashBucket prev = null;
        while (e != null) {
            if (e == bucket) {
                if (prev != null) {
                    this.setNext(prev, this.getNext(e));
                } else {
                    this.table[index] = this.getNext(e);
                }
                --this.nEntries;
                e.unchain();
                this.setNext(e, null);
                return;
            }
            prev = e;
            e = this.getNext(e);
        }
        throw new FatalInternalException("Bucket not found in ObjectTable");
    }

    void resetReadableList(boolean assertEmptyReadableList) {
        if (assertEmptyReadableList && this.readableElements().hasMoreElements()) {
            throw new FatalInternalException("expected empty readable list");
        }
        while (this.readableList.getNextInChain() != null) {
            this.readableList.getNextInChain().unchain();
        }
    }

    void resetWritableList(boolean assertEmptyWritableList) {
        if (assertEmptyWritableList && this.writeableList.getNextInChain() != null) {
            throw new FatalInternalException("expected empty writable list");
        }
        while (this.writeableList.getNextInChain() != null) {
            this.writeableList.getNextInChain().unchain();
        }
    }

    HashBucket pickWritableList() {
        return this.writeableList.getNextInChain();
    }

    private boolean GCEvent() {
        boolean result = this.runTime.totalMemory() != this.lastTotalMemory || this.runTime.freeMemory() > this.lastFreeMemory;
        this.lastTotalMemory = this.runTime.totalMemory();
        this.lastFreeMemory = this.runTime.freeMemory();
        if (this.gcSentinel.getElement() == null) {
            this.gcSentinel = (HashBucket)((Object)this.om.objRefFactory.create(new Object(), null, 0L, 0, 0));
            result = true;
        }
        return result;
    }

    private void maybeScavengeBuckets() {
        if (!this.runBucketScavenger) {
            return;
        }
        if (this.nOperations++ < 1000) {
            return;
        }
        this.nOperations = 0;
        if (this.GCEvent()) {
            int n = this.goalBucket = this.currentBucket > 0 ? this.currentBucket - 1 : this.table.length - 1;
        }
        if (this.goalBucket == this.currentBucket) {
            return;
        }
        int maxChains = this.table.length / 10;
        while (maxChains-- > 0) {
            if (++this.currentBucket >= this.table.length) {
                this.currentBucket = 0;
            }
            HashBucket e = this.table[this.currentBucket];
            HashBucket prev = null;
            HashBucket next = null;
            while (e != null) {
                ++this.nScannedBuckets;
                next = this.getNext(e);
                if (e.getElement() == null) {
                    if (prev != null) {
                        this.setNext(prev, next);
                    } else {
                        this.table[this.currentBucket] = next;
                    }
                    e.unchain();
                    this.setNext(e, null);
                    --this.nEntries;
                    ++this.nScavengedBuckets;
                } else {
                    prev = e;
                }
                e = next;
            }
            if (this.currentBucket != this.goalBucket) continue;
            ++this.bucketScavenges;
            return;
        }
    }

    public WeakCacheEnumeration keys() {
        return new WeakCacheEnumerationImpl(this.table, true, this);
    }

    public WeakCacheEnumeration elements() {
        return new WeakCacheEnumerationImpl(this.table, false, this);
    }

    public Enumeration buckets() {
        return new WeakCacheBucketEnumeration(this.table, this);
    }

    public WeakCacheEnumeration readableKeys() {
        return new WeakCacheChainedBucketEnumeration(this.readableList, true, this);
    }

    public WeakCacheEnumeration readableElements() {
        return new WeakCacheChainedBucketEnumeration(this.readableList, false, this);
    }

    public WeakCacheEnumeration writableKeys() {
        return new WeakCacheChainedBucketEnumeration(this.writeableList, true, this);
    }

    public WeakCacheEnumeration writableElements() {
        return new WeakCacheChainedBucketEnumeration(this.writeableList, false, this);
    }

    public WeakCacheEnumeration oldestCachedElements() {
        return new WeakCacheChainedBucketEnumeration(this.cachedList, false, this);
    }

    Object oldestCachedObject() {
        HashBucket bucket = this.cachedList.getNextInChain();
        return bucket == null ? null : bucket.getElement();
    }

    ObjectReference oldestCachedObjectReference() {
        HashBucket bucket = this.cachedList.getNextInChain();
        return (ObjectReference)(bucket == null ? null : bucket.getKey());
    }

    ChainedBucketEnumeration oldestCachedElementBuckets() {
        HashBucket markerBucket = (HashBucket)((Object)this.om.objRefFactory.create(null, null, 0L, 0, 0));
        return new ChainedBucketEnumerationImpl(markerBucket, this.cachedList);
    }

    abstract Object getKey(HashBucket var1);

    abstract Object getElement(HashBucket var1);

    abstract HashBucket getNext(HashBucket var1);

    abstract HashBucket getOtherNext(HashBucket var1);

    abstract void setNext(HashBucket var1, HashBucket var2);

    abstract int getHash(HashBucket var1);

    abstract int computeHashCode(Object var1);

    abstract boolean compareKeys(Object var1, Object var2);

    void updateCounters(Properties props, boolean reset) {
        StringBuffer sb = new StringBuffer("com.odi.imp.ObjectTable.count");
        Utilities.putIntegerProperty(props, sb, "ScavengePasses", this.bucketScavenges);
        Utilities.putIntegerProperty(props, sb, "Entries", this.size());
        Utilities.putIntegerProperty(props, sb, "ScavengedBuckets", this.nScavengedBuckets);
        Utilities.putIntegerProperty(props, sb, "ScannedBuckets", this.nScannedBuckets);
        if (reset) {
            this.bucketScavenges = 0;
            this.nScavengedBuckets = 0;
            this.nScannedBuckets = 0;
        }
    }

    private final class WeakCacheChainedBucketEnumeration
    implements WeakCacheEnumeration {
        private HashBucket currEntry;
        private HashBucket nextEntry;
        private Object currEntryElement;
        private Object nextEntryElement;
        private WeakCache cache;
        private boolean enumerateKeys;

        WeakCacheChainedBucketEnumeration(HashBucket list, boolean enumerateKeys, WeakCache cache) {
            this.enumerateKeys = enumerateKeys;
            this.nextEntry = list;
            this.nextEntryElement = this.nextEntry.getElement();
            this.currEntry = null;
            this.currEntryElement = null;
            this.cache = cache;
            this.advance();
        }

        private void advance() {
            while (this.nextEntry != null) {
                this.nextEntry = this.nextEntry.getNextInChain();
                if (this.nextEntry != null && (this.nextEntryElement = this.nextEntry.getElement()) == null) continue;
                break;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.nextEntry != null;
        }

        public Object nextElement() {
            Object ret;
            do {
                if (this.nextEntry == null) {
                    this.currEntry = null;
                    throw new NoSuchElementException("WeakCacheChainedBucketEnumeration");
                }
                ret = this.enumerateKeys ? this.nextEntry.getKey() : this.nextEntryElement;
                this.currEntry = this.nextEntry;
                this.currEntryElement = this.nextEntryElement;
                this.advance();
            } while (ret == null);
            return ret;
        }

        @Override
        public Object currentKey() throws NoSuchElementException {
            if (this.currEntry == null) {
                throw new NoSuchElementException("WeakCacheChainedBucketEnumeration");
            }
            return this.currEntry.getKey();
        }

        @Override
        public Object currentElement() throws NoSuchElementException {
            if (this.currEntry == null) {
                throw new NoSuchElementException("WeakCacheChainedBucketEnumeration");
            }
            return this.currEntryElement;
        }
    }

    private final class WeakCacheEnumerationImpl
    extends WeakCacheBucketEnumeration
    implements WeakCacheEnumeration {
        private boolean enumerateKeys;
        private Object nextKey;
        private HashBucket currEntry;

        WeakCacheEnumerationImpl(HashBucket[] table, boolean enumerateKeys, WeakCache cache) {
            super(table, cache);
            this.enumerateKeys = enumerateKeys;
            this.currEntry = null;
        }

        @Override
        public Object nextElement() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException("WeakCacheEnumerationImpl");
            }
            Object item = this.enumerateKeys ? this.cache.getKey(this.nextEntry) : this.cache.getElement(this.nextEntry);
            this.currEntry = this.nextEntry;
            this.findNextEntry();
            return item;
        }

        @Override
        public Object currentKey() throws NoSuchElementException {
            return this.cache.getKey(this.currEntry);
        }

        @Override
        public Object currentElement() throws NoSuchElementException {
            return this.cache.getElement(this.currEntry);
        }
    }

    private class WeakCacheBucketEnumeration
    implements Enumeration {
        HashBucket[] table;
        int slot = -1;
        HashBucket nextEntry;
        WeakCache cache;
        Object keep;

        WeakCacheBucketEnumeration(HashBucket[] table, WeakCache cache) {
            this.table = table;
            this.cache = cache;
            this.nextEntry = null;
            this.findNextEntry();
        }

        @Override
        public boolean hasMoreElements() {
            return this.nextEntry != null;
        }

        public Object nextElement() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException("WeakCacheBucketEnumeration");
            }
            HashBucket ret = this.nextEntry;
            this.findNextEntry();
            return ret;
        }

        void findNextEntry() {
            if (this.nextEntry != null) {
                this.nextEntry = this.cache.getNext(this.nextEntry);
            }
            while (true) {
                if (this.nextEntry != null) {
                    this.keep = this.nextEntry.getElement();
                    if (this.keep != null) {
                        return;
                    }
                    this.nextEntry = this.cache.getNext(this.nextEntry);
                    continue;
                }
                if (this.slot >= this.table.length - 1) {
                    return;
                }
                this.nextEntry = this.table[++this.slot];
            }
        }
    }

    static interface WeakCacheEnumeration
    extends Enumeration {
        public Object currentKey() throws NoSuchElementException;

        public Object currentElement() throws NoSuchElementException;
    }

    static class ChainedBucketEnumerationImpl
    implements ChainedBucketEnumeration {
        private HashBucket markerBucket;

        ChainedBucketEnumerationImpl(HashBucket markerBucket, HashBucket chainedListStart) {
            this.markerBucket = markerBucket;
            if (chainedListStart != null) {
                HashBucket prev = chainedListStart.getPrevInChain();
                markerBucket.setNextInChain(chainedListStart);
                markerBucket.setPrevInChain(prev);
                if (prev != null) {
                    prev.setNextInChain(markerBucket);
                }
                chainedListStart.setPrevInChain(markerBucket);
            }
        }

        @Override
        public void terminate() {
            this.markerBucket.unchain();
        }

        @Override
        public boolean hasMoreElements() {
            return this.markerBucket.getNextInChain() != null;
        }

        public Object nextElement() throws NoSuchElementException {
            HashBucket nextBucket = this.markerBucket.getNextInChain();
            if (nextBucket == null) {
                throw new NoSuchElementException("No more hash buckets in chained list");
            }
            HashBucket nextNextBucket = nextBucket.getNextInChain();
            this.markerBucket.unchain();
            this.markerBucket.setNextInChain(nextNextBucket);
            this.markerBucket.setPrevInChain(nextBucket);
            nextBucket.setNextInChain(this.markerBucket);
            if (nextNextBucket != null) {
                nextNextBucket.setPrevInChain(this.markerBucket);
            }
            return nextBucket;
        }
    }

    static interface ChainedBucketEnumeration
    extends Enumeration {
        public void terminate();
    }
}

