/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.FatalInternalException;
import com.odi.Field;
import com.odi.GenericObject;
import com.odi.imp.ObjRefUtils;
import com.odi.imp.ObjectReference;
import com.odi.imp.Reference;
import com.odi.imp.ReferenceType;
import com.odi.util.BTreeCheckValidInfo;
import com.odi.util.BTreeImpl;
import com.odi.util.BTreeNode;
import com.odi.util.BTreeNodeFactory;
import com.odi.util.KeyType;
import java.io.PrintStream;

public abstract class BTreeLeafNode
extends BTreeNode {
    private transient Reference nextLeaf;
    private transient Reference prevLeaf;
    private static Field[] fields = new Field[0];
    private static ClassInfo myLeafOdiClassInfoInstance = BTreeNode.getClassInfo("com.odi.util.BTreeLeafNode", fields);

    protected BTreeLeafNode(BTreeImpl btree) {
        super(btree);
    }

    public BTreeLeafNode(ClassInfo ignore) {
        super(ignore);
    }

    public BTreeLeafNode() {
    }

    @Override
    int headerSize() {
        return super.headerSize() + this.REFTYPE().size() + this.REFTYPE().size();
    }

    @Override
    public final boolean getIsLeaf() {
        return true;
    }

    static Field[] getDynamicFields(ReferenceType refType, KeyType keyType) {
        return new Field[]{Field.createLazyReference("nextLeaf", refType), Field.createLazyReference("prevLeaf", refType)};
    }

    static ClassInfo getClassInfo(Class clazz, ReferenceType refType, KeyType keyType) {
        return BTreeLeafNode.getClassInfo(clazz.getName(), refType, keyType);
    }

    static ClassInfo getClassInfo(String className, ReferenceType refType, KeyType keyType) {
        int i;
        Field[] baseFields = BTreeNode.getDynamicFields(refType, keyType);
        Field[] specFields = BTreeLeafNode.getDynamicFields(refType, keyType);
        Field[] mergedFields = new Field[baseFields.length + specFields.length];
        for (i = 0; i < baseFields.length; ++i) {
            mergedFields[i] = baseFields[i];
        }
        for (i = 0; i < specFields.length; ++i) {
            mergedFields[i + baseFields.length] = specFields[i];
        }
        return BTreeNode.getClassInfo(className, mergedFields);
    }

    @Override
    public void initializeContents(GenericObject genericObject) {
        super.initializeContents(genericObject);
        this.nextLeaf = genericObject.getLazyReferenceField(3, this.getClassInfo(), this.REFTYPE());
        this.prevLeaf = genericObject.getLazyReferenceField(4, this.getClassInfo(), this.REFTYPE());
    }

    @Override
    public void flushContents(GenericObject genericObject) {
        genericObject.setLazyReferenceField(3, this.nextLeaf, this.getClassInfo(), this.REFTYPE());
        genericObject.setLazyReferenceField(4, this.prevLeaf, this.getClassInfo(), this.REFTYPE());
        super.flushContents(genericObject);
    }

    @Override
    public void clearContents() {
        this.nextLeaf = this.REFTYPE().NULL();
        this.prevLeaf = this.REFTYPE().NULL();
    }

    @Override
    protected void remove(int index) {
        this.dirty();
        if (BTreeImpl.debug) {
            System.out.println("Removing lazyref value " + this.values[index] + " at index " + index);
            System.out.println("Destroying key at index " + index + " for leaf node");
        }
        this.KEYTYPE().destroy(this.keys, index * this.KEYTYPE().size(), true, this.btree);
        if (this.numEntries > index + 1) {
            this.copyEntries(index + 1, this, index, this.numEntries - index - 1);
        }
        this.clearEntries(this.numEntries - 1, 1);
        this.numEntries = (short)(this.numEntries - 1);
    }

    @Override
    protected void deallocate() {
        if (this.prevLeaf != this.REFTYPE().NULL()) {
            BTreeLeafNode prev = (BTreeLeafNode)this.prevLeaf.resolve(this.btree.cluster, this.btree.leafNodeAFTypecode);
            prev.setNextLeafRef(this.nextLeaf);
        }
        if (this.nextLeaf != this.REFTYPE().NULL()) {
            BTreeLeafNode next = (BTreeLeafNode)this.nextLeaf.resolve(this.btree.cluster, this.btree.leafNodeAFTypecode);
            next.setPrevLeafRef(this.prevLeaf);
        }
        this.setNextLeafRef(this.REFTYPE().NULL());
        this.setPrevLeafRef(this.REFTYPE().NULL());
        super.deallocate();
    }

    @Override
    protected BTreeNode init() {
        super.init();
        this.prevLeaf = this.REFTYPE().NULL();
        this.nextLeaf = this.REFTYPE().NULL();
        return this;
    }

    @Override
    protected boolean compareValue(int index, ObjectReference value, byte[] ignored) {
        if (value == null || ObjRefUtils.isNull(value)) {
            return this.values[index] == this.REFTYPE().NULL();
        }
        return this.values[index].equalsObjectReference(value);
    }

    @Override
    void insertKey(byte[] key, int index) {
        this.setKey(index, key);
    }

    @Override
    public void updateInsertedValue(int index) {
    }

    @Override
    void updateAfterInsert(BTreeNode parent, int parentIndex) {
        BTreeLeafNode.odiAssert(parent.numEntries > 1 || parent == this.btree.getTop(), "No other leaves");
        if (parentIndex == parent.numEntries - 1) {
            if (parentIndex != 0) {
                BTreeLeafNode lastNode = (BTreeLeafNode)parent.getChildNode(parentIndex - 1);
                this.setPrevLeaf(lastNode);
                this.setNextLeafRef(lastNode.getNextLeafRef());
                if (lastNode.getNextLeafRef() != lastNode.REFTYPE().NULL()) {
                    lastNode.getNextLeaf().setPrevLeaf(this);
                }
                lastNode.setNextLeaf(this);
            }
        } else {
            BTreeLeafNode nextNode = (BTreeLeafNode)parent.getChildNode(parentIndex + 1);
            this.setPrevLeafRef(nextNode.getPrevLeafRef());
            this.setNextLeaf(nextNode);
            if (nextNode.getPrevLeafRef() != nextNode.REFTYPE().NULL()) {
                nextNode.getPrevLeaf().setNextLeaf(this);
            }
            nextNode.setPrevLeaf(this);
        }
    }

    @Override
    final boolean compareLeafEntry(byte[] key, boolean compareValue, ObjectReference value, int index) {
        this.fetch();
        BTreeLeafNode.odiAssert(this.getIsLeaf(), "Not leaf");
        int keyResult = this.compareKey(key, index);
        if (keyResult != 0) {
            return false;
        }
        if (!compareValue) {
            return true;
        }
        return this.compareValue(index, value, key);
    }

    @Override
    protected Reference getChildReference(int index) {
        throw new FatalInternalException("can not getChildReference() for leaf node");
    }

    @Override
    protected Object getValue(int index) {
        this.fetch();
        if (BTreeImpl.debug) {
            System.out.println("Getting lazyref. value " + this.values[index] + " at index " + index + " in leaf node " + this.REFTYPE().getReference(this));
        }
        Object obj = this.values[index].resolve(this.btree.cluster, this.btree.leafNodeAFTypecode);
        if (BTreeImpl.debug) {
            System.out.println("Returning value " + obj + " at index " + index);
        }
        return obj;
    }

    @Override
    public BTreeNode getChildNode(int childIndex) {
        throw new FatalInternalException("can not call getChildNode on leaf node");
    }

    @Override
    protected final void printContents(PrintStream stream, int level) {
        this.fetch();
        byte[] keyBuffer = new byte[this.btree.getKeySizeInternal()];
        for (int j = 0; j < level; ++j) {
            stream.print("  ");
        }
        String prevString = this.prevLeaf == this.REFTYPE().NULL() ? "null" : String.valueOf(this.prevLeaf);
        stream.println("Prev: (" + prevString + ")");
        for (int i = 0; i < this.numEntries; ++i) {
            for (int j = 0; j < level; ++j) {
                stream.print("  ");
            }
            stream.print(i + ": " + BTreeLeafNode.keyToString(this.getKey(i, keyBuffer)));
            stream.println(" => " + this.getValue(i));
        }
        for (int j = 0; j < level; ++j) {
            stream.print("  ");
        }
        String nextString = this.nextLeaf == this.REFTYPE().NULL() ? "null" : String.valueOf(this.nextLeaf);
        stream.println("Next: (" + nextString + ")");
    }

    @Override
    void validateClassName(BTreeCheckValidInfo info) {
        BTreeLeafNode.odiAssert(info != null, "BTreeCheckValidInfo argument must not be null");
        BTreeNodeFactory cfr_ignored_0 = this.btree.nodeFactory;
        if (!this.getClass().getName().equals(BTreeNodeFactory.newNodeClassName(this.btree, this, true))) {
            BTreeNodeFactory cfr_ignored_1 = this.btree.nodeFactory;
            info.assertFailure("Node class is " + this.getClass().getName() + " but should be " + BTreeNodeFactory.newNodeClassName(this.btree, this, true));
        }
    }

    @Override
    void validateLinks(BTreeCheckValidInfo info) {
        BTreeLeafNode.odiAssert(info != null, "BTreeCheckValidInfo argument must not be null");
        info.odiAssert(info.nItems == 0 || ((BTreeLeafNode)info.prevLeaf).getNextLeaf() == this, "Incorrect next leaf link");
        info.odiAssert(info.nItems == 0 || (BTreeLeafNode)info.prevLeaf == this.getPrevLeaf(), "Incorrect last leaf link");
        info.prevLeaf = this;
    }

    @Override
    void validateKey(BTreeCheckValidInfo info, int i) {
        super.validateKey(info, i);
        info.lastKeyValues.add(this.getValue(i));
        info.checkValue = true;
        ++info.nItems;
    }

    @Override
    void validateChildren(PrintStream stream, BTreeCheckValidInfo info, int i) {
    }

    public final BTreeLeafNode getNextLeaf() {
        this.fetch();
        return (BTreeLeafNode)this.nextLeaf.resolve(this.btree.cluster, this.btree.leafNodeAFTypecode);
    }

    final Reference getNextLeafRef() {
        this.fetch();
        return this.nextLeaf;
    }

    final void setNextLeaf(BTreeNode leaf) {
        this.dirty();
        this.nextLeaf = this.REFTYPE().getReference(leaf);
        if (BTreeImpl.debug) {
            System.out.println("***setNextLeaf in node " + this.REFTYPE().getReference(this) + " to " + this.nextLeaf);
        }
    }

    final void setNextLeafRef(Reference leaf) {
        this.dirty();
        this.nextLeaf = leaf;
        if (BTreeImpl.debug) {
            System.out.println("***setNextLeaf in node " + this.REFTYPE().getReference(this) + " to " + this.nextLeaf);
        }
    }

    final BTreeLeafNode getPrevLeaf() {
        this.fetch();
        return (BTreeLeafNode)this.prevLeaf.resolve(this.btree.cluster, this.btree.leafNodeAFTypecode);
    }

    final Reference getPrevLeafRef() {
        this.fetch();
        return this.prevLeaf;
    }

    final void setPrevLeaf(BTreeNode leaf) {
        this.dirty();
        this.prevLeaf = this.REFTYPE().getReference(leaf);
        if (BTreeImpl.debug) {
            System.out.println("***setPrevLeaf in node " + this.REFTYPE().getReference(this) + " to " + this.prevLeaf);
        }
    }

    final void setPrevLeafRef(Reference leaf) {
        this.dirty();
        this.prevLeaf = leaf;
        if (BTreeImpl.debug) {
            System.out.println("***setPrevLeaf in node " + this.REFTYPE().getReference(this) + " to " + this.prevLeaf);
        }
    }
}

