/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.NoSessionException;
import com.odi.util.OSTreeMap;
import com.odi.util.OSTreeMapIterator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

class OSTreeMapCollectionView
implements Collection {
    private int viewWhat;
    private OSTreeMap map;

    OSTreeMapCollectionView(OSTreeMap m, int what) {
        this.map = m;
        this.viewWhat = what;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        switch (this.viewWhat) {
            case 0: {
                return this.map.containsKey(o);
            }
            case 1: {
                return this.map.contains(o);
            }
            case 2: {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                return this.map.containsKey(entry.getKey()) && entry.getValue().equals(this.map.get(entry.getKey()));
            }
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        return new OSTreeMapIterator(this.map, this.viewWhat);
    }

    @Override
    public Object[] toArray() {
        Object[] anArray = new Object[this.size()];
        Iterator iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            anArray[i++] = iter.next();
        }
        return anArray;
    }

    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator it = this.iterator();
        for (int i = 0; i < size; ++i) {
            a[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public boolean remove(Object o) {
        switch (this.viewWhat) {
            case 0: {
                if (this.map.containsKey(o)) {
                    this.map.remove(o);
                    return true;
                }
                return false;
            }
            case 1: {
                Iterator iter = this.iterator();
                while (iter.hasNext()) {
                    if (iter.next() != o) continue;
                    iter.remove();
                    return true;
                }
                return false;
            }
            case 2: {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                this.map.remove(entry.getKey());
                return true;
            }
        }
        return false;
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException("Collection.addAll not supported by Map views");
    }

    public boolean containsAll(Collection coll) {
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection coll) {
        boolean modified = false;
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            modified = this.remove(iter.next());
        }
        return modified;
    }

    public boolean retainAll(Collection coll) {
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (coll.contains(obj)) continue;
            modified = true;
            iter.remove();
        }
        return modified;
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException("Collection.add not supported by Map views");
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection coll = (Collection)o;
        return coll.size() == this.map.size() && this.containsAll(coll);
    }

    @Override
    public int hashCode() {
        int h;
        block3: {
            h = 0;
            try {
                Iterator e = this.iterator();
                while (e.hasNext()) {
                    h += e.next().hashCode();
                }
            }
            catch (NoSessionException e) {
                if (Boolean.getBoolean("com.odi.debugHashCodes")) break block3;
                throw e;
            }
        }
        return h;
    }
}

