/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.storage.pse;

import com.odi.ClassInfo;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectStore;
import com.odi.imp.ObjectReference;
import com.odi.util.HashPersistent;
import com.odi.util.OSVector;
import com.sonicsw.mf.framework.directory.storage.pse.DSBlobChunk;

public class DSBlob
implements IPersistent,
IPersistentHooks {
    private int ODITheHashCode = HashPersistent.getNextHashCode();
    private int m_blobSize;
    private int m_blobLength;
    private OSVector m_blobChunks;
    private transient ObjectReference ODIref;
    public transient byte ODIObjectState;
    static ClassInfo myOdiClassInfoInstance = DSBlob.getClassInfoInstance();

    public DSBlob() {
        this.m_blobSize = 0;
        this.m_blobLength = 0;
        this.m_blobChunks = new OSVector();
    }

    public int getBlobSize() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch(this);
        }
        return this.m_blobSize;
    }

    public void setBlobSize(int size) {
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty(this);
        }
        this.m_blobSize = size;
    }

    public int getBlobLength() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch(this);
        }
        return this.m_blobLength;
    }

    public void setBlobLength(int length) {
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty(this);
        }
        this.m_blobLength = length;
    }

    public DSBlobChunk getBlobChunk(int pos) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch(this);
        }
        return (DSBlobChunk)this.m_blobChunks.get(pos);
    }

    public void addChunk(DSBlobChunk chunk) {
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty(this);
        }
        this.m_blobChunks.add(this.m_blobChunks.size(), chunk);
        this.m_blobSize += chunk.getSize();
        ++this.m_blobLength;
    }

    @Override
    public void preDestroyPersistent() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch(this);
        }
        for (int i = 0; i < this.m_blobLength; ++i) {
            ObjectStore.destroy(this.m_blobChunks.get(i));
        }
        ObjectStore.destroy(this.m_blobChunks);
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty(this);
        }
        this.m_blobChunks = null;
    }

    @Override
    public ObjectReference ODIgetRef() {
        return this.ODIref;
    }

    @Override
    public void ODIsetRef(ObjectReference objectreference) {
        this.ODIref = objectreference;
    }

    @Override
    public byte ODIgetState() {
        return this.ODIObjectState;
    }

    @Override
    public void ODIsetState(byte byte0) {
        this.ODIObjectState = byte0;
    }

    protected synchronized Object clone() throws CloneNotSupportedException {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch(this);
        }
        DSBlob dsblob = (DSBlob)super.clone();
        dsblob.ODITheHashCode = dsblob.ODIComputeHashCode();
        dsblob.ODIref = null;
        dsblob.ODIObjectState = 0;
        return dsblob;
    }

    @Override
    public void postInitializeContents() {
    }

    @Override
    public void preFlushContents() {
    }

    @Override
    public void preClearContents() {
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch(this);
        }
        return this.ODITheHashCode;
    }

    private int ODIComputeHashCode() {
        return HashPersistent.getNextHashCode();
    }

    @Override
    public void initializeContents(GenericObject genericobject) {
        ClassInfo classinfo = myOdiClassInfoInstance;
        this.ODITheHashCode = genericobject.getIntField(1, classinfo);
        this.m_blobSize = genericobject.getIntField(2, classinfo);
        this.m_blobLength = genericobject.getIntField(3, classinfo);
        this.m_blobChunks = (OSVector)genericobject.getClassField(4, classinfo);
    }

    @Override
    public void flushContents(GenericObject genericobject) {
        ClassInfo classinfo = myOdiClassInfoInstance;
        genericobject.setIntField(1, this.ODITheHashCode, classinfo);
        genericobject.setIntField(2, this.m_blobSize, classinfo);
        genericobject.setIntField(3, this.m_blobLength, classinfo);
        genericobject.setClassField(4, this.m_blobChunks, classinfo);
    }

    @Override
    public void clearContents() {
        this.ODITheHashCode = 0;
        this.m_blobSize = 0;
        this.m_blobLength = 0;
        this.m_blobChunks = null;
    }

    public DSBlob(ClassInfo classinfo) {
    }

    private static final ClassInfo getClassInfoInstance() {
        try {
            return ClassInfo.get(Class.forName("com.sonicsw.mf.framework.directory.storage.pse.DSBlob"));
        }
        catch (ClassNotFoundException classnotfoundexception) {
            return null;
        }
    }
}

