/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.LogPage;

public final class LogPageHeader {
    static final byte RED_MASK = 1;
    static final byte BLUE_MASK = -2;
    static final byte EMPTY_MASK = 2;
    static final byte NON_EMPTY_MASK = -3;
    public static final int HEADER_LENGTH = 8;
    static final int PAYLOAD_BYTES_IN_PAGE = LogPage.PAGE_LENGTH - 8;
    private static final int LAST_NOTE_END_POINTER_OFFSET = 0;
    private static final int FLAGS_FIRST_BYTE_OFFSET = 3;
    private static final int FLAGS_LAST_BYTE_OFFSET = 7;

    static void setPageColor(LogPage page, boolean red) {
        if (red) {
            byte[] byArray = page.getBuffer();
            byArray[3] = (byte)(byArray[3] | 1);
        } else {
            byte[] byArray = page.getBuffer();
            byArray[3] = (byte)(byArray[3] & 0xFFFFFFFE);
        }
    }

    static void setFileEmpty(LogPage page, boolean empty) {
        if (empty) {
            byte[] byArray = page.getBuffer();
            byArray[3] = (byte)(byArray[3] | 2);
        } else {
            byte[] byArray = page.getBuffer();
            byArray[3] = (byte)(byArray[3] & 0xFFFFFFFD);
        }
    }

    static boolean pageIsRed(LogPage page) {
        return (page.getBuffer()[3] & 1) != 0;
    }

    static boolean fileIsEmpty(LogPage page) {
        return (page.getBuffer()[3] & 2) != 0;
    }

    static void storeNoteEndPointer(LogPage page, int offset) {
        BitUtil.putInt3Bytes(page.getBuffer(), 0, offset);
    }

    static int getNoteEndPointer(LogPage page) {
        return BitUtil.getInt3Bytes(page.getBuffer(), 0);
    }
}

