/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.Page;

final class MasterPage
extends Page {
    static final long MASTER_PAGE_NUM = 0L;
    static final short NUM_CHAINS = 9;
    static final byte FREE_CHAIN_ANCHOR = 0;
    static final byte FULL_INDEX_CHAIN_ANCHOR = 1;
    static final byte USED_INDEX_CHAIN_ANCHOR = 2;
    static final byte FULL_HEADER_CHAIN_ANCHOR = 3;
    static final byte USED_HEADER_CHAIN_ANCHOR = 4;
    static final byte FULL_BLOB_CHAIN_ANCHOR = 5;
    static final byte USED_BLOB_CHAIN_ANCHOR = 6;
    static final byte FULL_BTREE_CHAIN_ANCHOR = 7;
    static final byte USED_BTREE_CHAIN_ANCHOR = 8;
    private static final short FLAGS_OFFSET = 10;
    private static final short TRANSACTION_NUM_OFFSET = 11;
    private static final short SESSION_TIMESTAMP_OFFSET = 19;
    private static final short RESERVED_8BYTES_OFFSET = 27;
    private static final short DB_TIMESTAMP_OFFSET = 35;
    private static final short VERSION_OFFSET = 43;
    private static final short CHAIN_ANCHORS_OFFSET = 47;
    private static final short CHAIN_LAST_OFFSET = 119;

    MasterPage() {
        this.setPageNum(0L);
    }

    @Override
    void initValues() {
        super.initValues();
        this.setPageNum(0L);
        this.setPageType((byte)5);
        this.setDBTimestamp(System.currentTimeMillis());
        this.setFlags((byte)0);
        this.setSessionTimestamp(0L);
        this.setVersion(15);
        for (byte i = 0; i < 9; i = (byte)(i + 1)) {
            this.setChainFirst(i, 0L);
            this.setChainLast(i, 0L);
        }
    }

    int getVersion() {
        return BitUtil.getInt(this.m_buffer, 43);
    }

    private void setFlags(byte flags) {
        this.m_buffer[10] = flags;
    }

    private byte getFlags() {
        return this.m_buffer[10];
    }

    void setVersion(int versionOffest) {
        BitUtil.putInt(this.m_buffer, 43, versionOffest);
    }

    long getSessionTimestamp() {
        return BitUtil.getLong(this.m_buffer, 19);
    }

    void setSessionTimestamp(long timestamp) {
        BitUtil.putLong(this.m_buffer, 19, timestamp);
    }

    long getDBTimestamp() {
        return BitUtil.getLong(this.m_buffer, 35);
    }

    void setDBTimestamp(long timestamp) {
        BitUtil.putLong(this.m_buffer, 35, timestamp);
    }

    long getChainFirst(byte anchorNum) {
        return BitUtil.getLong(this.m_buffer, MasterPage.getAnchorOffset(anchorNum));
    }

    void setChainFirst(byte anchorNum, long pageNum) {
        BitUtil.putLong(this.m_buffer, MasterPage.getAnchorOffset(anchorNum), pageNum);
    }

    private static short getAnchorOffset(byte chainNumber) {
        return (short)(47 + chainNumber * 8);
    }

    long getChainLast(byte anchorNum) {
        return BitUtil.getLong(this.m_buffer, MasterPage.getChainLastOffset(anchorNum));
    }

    void setChainLast(byte anchorNum, long pageNum) {
        BitUtil.putLong(this.m_buffer, MasterPage.getChainLastOffset(anchorNum), pageNum);
    }

    private static short getChainLastOffset(byte chainNumber) {
        return (short)(119 + chainNumber * 8);
    }

    static long getDBTimestamp(byte[] buffer, int offset) {
        return BitUtil.getLong(buffer, offset + 35);
    }
}

