/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.BitSetUtil;
import com.sonicsw.mtstorage.impl.ObjectsBuffer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

final class TransactionContext
implements Serializable {
    private static final long serialVersionUID = 0L;
    private HashMap m_transactionPages;
    private long m_transactionStartLogID;
    private boolean m_readOnly;

    TransactionContext(boolean readOnly) {
        this.m_readOnly = readOnly;
    }

    void setTransactionStartLogID(long id) {
        this.m_transactionStartLogID = id;
    }

    long getTransactionStartLogID() {
        return this.m_transactionStartLogID;
    }

    void reserveDBK(Long pageNum, byte slot) {
        BitSetUtil pageSlots;
        if (this.m_transactionPages == null) {
            this.m_transactionPages = new HashMap();
        }
        if ((pageSlots = (BitSetUtil)this.m_transactionPages.get(pageNum)) == null) {
            pageSlots = ObjectsBuffer.createEmptySlots();
            this.m_transactionPages.put(pageNum, pageSlots);
        }
        pageSlots.set(slot);
    }

    HashMap getTransactionPages() {
        return this.m_transactionPages;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.m_transactionPages);
        s.writeLong(this.m_transactionStartLogID);
        s.writeBoolean(this.m_readOnly);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.m_transactionPages = (HashMap)s.readObject();
        this.m_transactionStartLogID = s.readLong();
        this.m_readOnly = s.readBoolean();
    }
}

