/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.evs.nio.nwlink;

import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.INetworkLinkConfig;
import com.sonicsw.blackbird.evs.nio.nwlink.http.EvsHTTPNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.http.proxy.EvsHTTPProxyNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.tcp.EvsTCPNetworkLink;
import java.nio.channels.SelectableChannel;

public final class EvsNetworkLinkFactory {
    public static final String LINK_CLASS_TCP = "tcp";
    public static final String LINK_CLASS_SSL = "ssl";
    public static final String LINK_CLASS_HTTP = "http";
    public static final String LINK_CLASS_HTTPS = "https";
    public static final String LINK_CLASS_DEFAULT = "tcp";

    public static final IEvsNetworkLink create(String linkClass, int linkType, SelectableChannel linkChannel, INetworkLinkConfig linkConfig) throws EEvsIOException {
        if (linkClass == null) {
            linkClass = "tcp";
        }
        if (linkClass == "tcp") {
            if (linkConfig.getHTTPProxyEnabled()) {
                return EvsHTTPProxyNetworkLink.create(linkType, linkConfig);
            }
            return EvsTCPNetworkLink.create(linkType, linkChannel, linkConfig);
        }
        if (linkClass == LINK_CLASS_SSL) {
            if (linkConfig.getHTTPProxyEnabled()) {
                return EvsHTTPProxyNetworkLink.create(linkType, linkConfig);
            }
            throw new UnsupportedOperationException("EVS SSL Link not yet implemented");
        }
        if (linkClass == LINK_CLASS_HTTP) {
            return EvsHTTPNetworkLink.create(linkType, linkChannel, linkConfig);
        }
        if (linkClass == LINK_CLASS_HTTPS) {
            throw new UnsupportedOperationException("EVS HTTPS Network Link not yet implemented");
        }
        throw new IllegalArgumentException();
    }
}

