/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.evs.nio.nwlink;

import com.sonicsw.blackbird.evs.nio.nwlink.INetworkLinkConfig;
import com.sonicsw.blackbird.http.client.HTTPClientFactory;
import com.sonicsw.blackbird.http.client.IHTTPCredentialsProvider;
import java.util.Properties;

public class PropertyBasedNetworkLinkConfg
implements INetworkLinkConfig {
    private Properties m_props = null;
    private String m_linkType = null;
    private Properties m_customHTTPHeaders = new Properties();
    private IHTTPCredentialsProvider m_httpCreds;
    private IHTTPCredentialsProvider m_httpProxyCreds;
    private boolean m_proxyConfigured = false;

    public PropertyBasedNetworkLinkConfg(String linkType, Properties props) {
        this.m_props = props;
        this.m_linkType = linkType;
        int customHTTPProps = this.getIntProperty("httpCustomHeaderCount", 0);
        for (int i = 0; i < customHTTPProps; ++i) {
            String value;
            String name = this.m_props.getProperty("httpCustomHeaderName_" + i);
            if (name == null) {
                new RuntimeException("Missing property httpCustomHeaderName_" + i + "!").printStackTrace();
            }
            if ((value = this.m_props.getProperty("httpCustomHeaderValue_" + i)) == null) {
                new RuntimeException("Missing property httpCustomHeaderValue_" + i + "!").printStackTrace();
            }
            this.m_customHTTPHeaders.put(name, value);
        }
        if (this.m_props.getProperty("httpProxyIPAddr") != null) {
            this.m_proxyConfigured = true;
        }
        String user = this.m_props.getProperty("httpUsername", HTTP_USERNAME_DEFAULT);
        String password = this.m_props.getProperty("httpPassword", HTTP_PASSWORD_DEFAULT);
        this.m_httpCreds = user != null && password != null && user.length() > 0 && password.length() > 0 ? HTTPClientFactory.createCredentialsProvider(user, password) : HTTPClientFactory.getDefaultCredentialsProvider();
        user = this.m_props.getProperty("httpProxyUsername", HTTP_PROXY_USERNAME_DEFAULT);
        password = this.m_props.getProperty("httpProxyPassword", HTTP_PROXY_PASSWORD_DEFAULT);
        this.m_httpProxyCreds = user != null && password != null && user.length() > 0 && password.length() > 0 ? HTTPClientFactory.createCredentialsProvider(user, password) : HTTPClientFactory.getDefaultCredentialsProvider();
    }

    private short getShortProperty(String name, short defaultVal) {
        return Short.parseShort(this.m_props.getProperty(name, "" + defaultVal));
    }

    private int getIntProperty(String name, int defaultVal) {
        return Integer.parseInt(this.m_props.getProperty(name, "" + defaultVal));
    }

    private long getLongProperty(String name, long defaultVal) {
        return Long.parseLong(this.m_props.getProperty(name, "" + defaultVal));
    }

    private boolean getBooleanProperty(String name, boolean defaultVal) {
        return new Boolean(this.m_props.getProperty(name, "" + defaultVal));
    }

    @Override
    public boolean getBlockingIO() {
        return this.getBooleanProperty("blockingIO", false);
    }

    @Override
    public String getLinkType() {
        return this.m_linkType;
    }

    @Override
    public String getLocalInterfaceAddress() {
        return this.m_props.getProperty("localIfAddr", "0.0.0.0");
    }

    @Override
    public int getLocalPort() {
        return this.getIntProperty("localPort", 0);
    }

    @Override
    public String getRemoteInterfaceAddress() {
        return this.m_props.getProperty("remoteIfAddr", "0.0.0.0");
    }

    @Override
    public int getRemotePort() {
        return this.getIntProperty("remotePort", 0);
    }

    @Override
    public int getTCPServerBackLog() {
        return this.getIntProperty("backlog", 0);
    }

    @Override
    public boolean getTCPKeelAlive() {
        return this.getBooleanProperty("tcpKeepAlive", false);
    }

    @Override
    public boolean getTCPNoDelay() {
        return this.getBooleanProperty("tcpNoDelay", true);
    }

    @Override
    public int getSocketSoTimeout() {
        return this.getIntProperty("socketSOTimeout", 0);
    }

    @Override
    public int getSocketMinSendBufferSize() {
        return this.getIntProperty("socketMinSendBufferSize", 2048);
    }

    @Override
    public int getSocketMinRcvBufferSize() {
        return this.getIntProperty("socketMinRcvBufferSize", 2048);
    }

    @Override
    public int getSocketMaxSendBufferSize() {
        return this.getIntProperty("socketMaxSendBufferSize", 65536);
    }

    @Override
    public int getSocketMaxRcvBufferSize() {
        return this.getIntProperty("socketMaxRcvBufferSize", 65536);
    }

    @Override
    public int getSocketInitialSendBufferSize() {
        return this.getIntProperty("socketInitialSendBufferSize", 2048);
    }

    @Override
    public int getSocketInitialRcvBufferSize() {
        return this.getIntProperty("socketInitialRcvBufferSize", 2048);
    }

    @Override
    public boolean getTCPLinger() {
        return this.getBooleanProperty("tcpLinger", false);
    }

    @Override
    public int getTCPLingerTime() {
        return this.getIntProperty("tcpLingerTime", 10);
    }

    @Override
    public IHTTPCredentialsProvider getHTTPCredentialsProvider() {
        return this.m_httpCreds;
    }

    @Override
    public boolean getHTTPMapHostToIp() {
        return this.getBooleanProperty("httpMapHostToIP", false);
    }

    @Override
    public int getHTTPMaxMessagetSize() {
        return this.getIntProperty("httpMaxMessageSize", 65535);
    }

    @Override
    public int getHTTPRetryAttempts() {
        return this.getIntProperty("httpRetryAttempts", 3);
    }

    @Override
    public boolean getHTTPAllowUserInteraction() {
        return this.getBooleanProperty("httpAllowInteraction", false);
    }

    @Override
    public long getHTTPServerReadResponseTimeout() {
        return this.getLongProperty("httpServerReadResponseTimeout", 5000L);
    }

    @Override
    public long getHTTPServerLinkIdleTimeout() {
        return this.getLongProperty("httpServerIdleTimeout", 10000L);
    }

    @Override
    public long getHTTPServerConnectionIdleTimeout() {
        return this.getLongProperty("httpServerConnectionIdleTimeout", 20000L);
    }

    @Override
    public boolean getHTTPPipeliningEnabled() {
        return this.getBooleanProperty("httpPipeliningEnabled", true);
    }

    @Override
    public int getHTTPConnectTimeout() {
        return this.getIntProperty("httpConnectTimeout", 120000);
    }

    @Override
    public int getHTTPCloseTimeout() {
        return this.getIntProperty("httpConnectTimeout", 120000);
    }

    @Override
    public Properties getHTTPCustomHeaders() {
        return this.m_customHTTPHeaders;
    }

    @Override
    public boolean getHTTPProxyEnabled() {
        String host = this.getHTTPProxyHost();
        if (host == null) {
            return false;
        }
        int port = this.getHTTPProxyPort();
        return host.length() > 0 && port > 0;
    }

    @Override
    public boolean getHTTPProxyTunnel() {
        return this.getBooleanProperty("httpProxyTunnel", false);
    }

    @Override
    public String getHTTPProxyProtocol() {
        return this.m_props.getProperty("httpProxyProtocol", "http");
    }

    @Override
    public String getHTTPProxyHost() {
        return this.m_props.getProperty("httpProxyIPAddr", "");
    }

    @Override
    public int getHTTPProxyPort() {
        return this.getIntProperty("httpProxyIPPort", -1);
    }

    @Override
    public IHTTPCredentialsProvider getHTTPProxyCredentialsProvider() {
        return this.m_httpProxyCreds;
    }
}

