/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.http.impl;

import com.sonicsw.blackbird.evs.EEvsEOFException;
import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLinkResult;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsAsyncWriteListener;
import com.sonicsw.blackbird.http.HTTPVersionUnsupportedException;
import com.sonicsw.blackbird.http.IHTTPConnection;
import com.sonicsw.blackbird.http.IHTTPMessage;
import com.sonicsw.blackbird.http.impl.HTTPConnection;
import com.sonicsw.blackbird.http.impl.HTTPConstants;
import com.sonicsw.blackbird.http.impl.HTTPHeader;
import com.sonicsw.blackbird.http.impl.HTTPParseUtil;
import com.sonicsw.blackbird.http.impl.prAccessor;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import progress.message.resources.prMessageFormat;

public abstract class HTTPMessage
implements IHTTPMessage,
IEvsAsyncWriteListener {
    protected static final boolean DEBUG = HTTPConstants.DEBUG;
    protected static final boolean CHECKED = true;
    private static final int TS_INIT = 0;
    private static final int TS_HEADER = 1;
    private static final int TS_BODY = 2;
    private static final int TS_WAIT_COMPLETE = 3;
    private static final int TS_COMPLETE = 4;
    private static final HTTPHeader CHUNKED_TRANSFER_HEADER = new HTTPHeader("Transfer-Encoding", "chunked");
    protected final HashMap m_headers = new HashMap(10);
    protected String m_version = "HTTP/1.1";
    protected short m_majVersion = 1;
    protected short m_dotVersion = 1;
    private boolean m_bodySet = false;
    private ByteBuffer[] m_body = null;
    private int m_bodyOffset = 0;
    private int[] m_bodyPositions = null;
    private ByteBuffer[] m_encodedBody = null;
    protected final boolean m_inWriteMode;
    private int m_transportState = 0;
    private boolean m_handled = false;
    private int m_transmissionAttempts = 0;
    private int m_contentLength = -1;
    private int m_remainingBody = -1;
    private int m_nextProtocolBlock = 0;
    private boolean m_enableWriteChunking = false;
    private int m_chunkThreshold = -1;
    private ChunkedReadController m_readController = null;
    private boolean m_headerAdded = false;
    private boolean m_startLineRead = false;
    private HTTPHeader m_lastHeaderRead = null;
    protected final HTTPConnection m_connection;
    private Object m_attachment;

    protected HTTPMessage(HTTPConnection connection, int transportMode) {
        this.m_connection = connection;
        this.m_inWriteMode = transportMode == 0;
    }

    @Override
    public IHTTPConnection getHTTPConnection() {
        return this.m_connection;
    }

    protected void setHTTPVersion(String version) throws HTTPVersionUnsupportedException, IllegalArgumentException {
        this.m_version = version.trim();
        try {
            int dot = this.m_version.indexOf(46, 5);
            this.m_majVersion = Short.parseShort(this.m_version.substring(5, dot));
            this.m_dotVersion = Short.parseShort(this.m_version.substring(dot + 1));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Malformed HTTP version: " + this.m_version);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Malformed HTTP version: " + this.m_version);
        }
        if (this.m_majVersion != 1) {
            throw new HTTPVersionUnsupportedException("Http Version not supported: " + this.m_version);
        }
    }

    @Override
    public final String getHTTPVersion() {
        return this.m_version;
    }

    @Override
    public short getHTTPMajorVersion() {
        return this.m_majVersion;
    }

    @Override
    public short getHTTPMinorVersion() {
        return this.m_dotVersion;
    }

    public void reset() {
        if (this.m_transportState == 0) {
            return;
        }
        this.m_transportState = 0;
        if (this.m_inWriteMode) {
            this.m_headerAdded = false;
            if (this.m_body != null) {
                for (int i = this.m_bodyOffset; i < this.m_body.length; ++i) {
                    this.m_body[i].position(this.m_bodyPositions[i - this.m_bodyOffset]);
                }
            }
            this.m_remainingBody = this.m_contentLength;
        } else {
            this.m_headers.clear();
            this.m_lastHeaderRead = null;
            this.m_contentLength = -1;
            this.m_remainingBody = -1;
            this.m_nextProtocolBlock = 0;
            this.m_readController = null;
            this.m_startLineRead = false;
        }
    }

    @Override
    public void setAttachment(Object o) {
        this.m_attachment = o;
    }

    @Override
    public Object getAttachment() {
        return this.m_attachment;
    }

    @Override
    public final void setBody(ByteBuffer data) {
        if (data == null) {
            this.setBody((ByteBuffer[])null);
        } else {
            this.setBody(new ByteBuffer[]{data});
        }
    }

    @Override
    public final void setBody(ByteBuffer[] data) {
        if (this.m_transportState > 0) {
            throw new IllegalStateException(prAccessor.getString("Illegal to set body after transport started"));
        }
        if (!this.m_inWriteMode) {
            throw new IllegalStateException(prAccessor.getString("Illegal to set body with TRANSPORT_MODE_READ"));
        }
        this.m_bodySet = true;
        if (data != null) {
            this.m_body = data;
            this.m_contentLength = 0;
            this.m_bodyOffset = 0;
            this.m_bodyPositions = new int[(data.length - this.m_bodyOffset) * 2];
            for (int i = this.m_bodyOffset; i < data.length; ++i) {
                this.m_contentLength += data[i].remaining();
                this.m_bodyPositions[i - this.m_bodyOffset] = data[i].position();
            }
        } else {
            this.m_contentLength = 0;
        }
        this.setHeaderInternal(new HTTPHeader("Content-Length", Integer.toString(this.m_contentLength)));
        this.m_remainingBody = this.m_contentLength;
    }

    private final void prepareChunkedBody() {
        LinkedList<ByteBuffer> encoded = new LinkedList<ByteBuffer>();
        int numChunks = this.m_contentLength / this.m_chunkThreshold;
        if (this.m_contentLength % this.m_chunkThreshold != 0) {
            ++numChunks;
        }
        int leftInChunk = this.m_chunkThreshold;
        int chunkPos = 0;
        for (int i = this.m_bodyOffset; i < this.m_body.length; ++i) {
            ByteBuffer b = this.m_body[i];
            while (b.hasRemaining()) {
                if (b.remaining() < leftInChunk) {
                    leftInChunk -= b.remaining();
                    encoded.add(b.slice());
                    b.position(b.limit());
                    continue;
                }
                int limit = b.limit();
                b.limit(b.position() + leftInChunk);
                encoded.add(b.slice());
                b.position(b.limit());
                b.limit(limit);
                encoded.add(chunkPos, this.prepareChunkHeader(this.m_chunkThreshold, HTTPParseUtil.MAX_HTTP_CHUNK_HEADER_SIZE));
                encoded.add(ByteBuffer.wrap("\r\n".getBytes()));
                chunkPos = encoded.size();
                leftInChunk = this.m_chunkThreshold;
            }
        }
        if (leftInChunk < this.m_chunkThreshold) {
            encoded.add(chunkPos, this.prepareChunkHeader(this.m_chunkThreshold - leftInChunk, HTTPParseUtil.MAX_HTTP_CHUNK_HEADER_SIZE));
            encoded.add(ByteBuffer.wrap("\r\n".getBytes()));
        }
        encoded.add(ByteBuffer.wrap(HTTPParseUtil.getLastChunkHeaderBytes()));
        this.m_encodedBody = new ByteBuffer[encoded.size()];
        Iterator i = encoded.iterator();
        int c = 0;
        while (i.hasNext()) {
            this.m_encodedBody[c++] = (ByteBuffer)i.next();
        }
    }

    private final ByteBuffer prepareChunkHeader(int length, int paddedSize) {
        ByteBuffer header = ByteBuffer.allocateDirect(paddedSize);
        byte[] chunkHeader = HTTPParseUtil.getAsciiBytes(Integer.toHexString(length) + "\r\n");
        for (int spaceToFill = paddedSize - chunkHeader.length; spaceToFill > 0; spaceToFill -= HTTPParseUtil.getHEX0().length) {
            header.put(HTTPParseUtil.getHEX0());
        }
        header.put(chunkHeader);
        header.flip();
        if (DEBUG) {
            byte[] headerBytes = new byte[paddedSize];
            header.slice().get(headerBytes);
            String headerString = null;
            try {
                headerString = new String(headerBytes, "US-ASCII").trim();
            }
            catch (UnsupportedEncodingException ex1) {
                // empty catch block
            }
            System.out.println("Created chunk header: " + headerString + " = " + Integer.parseInt(headerString, 16));
        }
        return header;
    }

    public final void setChunkThreshold(int length) {
        this.m_chunkThreshold = length;
        this.m_enableWriteChunking = this.m_chunkThreshold > 0;
    }

    @Override
    public final ByteBuffer[] getBody() {
        return this.m_body;
    }

    public final ByteBuffer[] getResetBodyCopy() {
        if (this.m_body != null) {
            ByteBuffer[] copy = new ByteBuffer[this.m_body.length];
            for (int i = this.m_bodyOffset; i < this.m_body.length; ++i) {
                copy[i] = this.m_body[i].duplicate();
                copy[i].position(this.m_bodyPositions[i - this.m_bodyOffset]);
            }
            return copy;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean readMessageHeader(EvsNetworkLinkResult result) throws EEvsIOException {
        if (this.m_inWriteMode) {
            throw new IllegalStateException(prAccessor.getString("Can't read message header while in TRANSPORT_MODE_WRITE"));
        }
        switch (this.m_transportState) {
            case 0: {
                this.setState(1);
            }
            case 1: {
                if (!this.m_startLineRead) {
                    if (!this.readStartLine(result)) {
                        if (!DEBUG) return false;
                        System.out.println("Unable to read start line: " + result);
                        return false;
                    }
                    this.m_startLineRead = true;
                }
                if (!this.readHeaders(result)) {
                    if (!DEBUG) return false;
                    System.out.println("Unable to read full message header: " + result);
                    return false;
                }
                HTTPHeader te = this.getHeaderInternal("Transfer-Encoding");
                if (te != null) {
                    if (!te.getHeaderValue().trim().equals("chunked")) throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("Unrecognized Transfer Encoding: {0}"), new Object[]{te}));
                    this.m_readController = new ChunkedReadController();
                    this.m_nextProtocolBlock = 0;
                } else {
                    HTTPHeader clHeader = this.getHeaderInternal("Content-Length");
                    int length = -1;
                    if (clHeader != null) {
                        try {
                            length = Integer.parseInt(clHeader.getHeaderValue());
                        }
                        catch (NumberFormatException ex) {
                            throw new EEvsIOException("Corrupt Content-Length Header: " + clHeader);
                        }
                    }
                    if (length >= 0) {
                        this.m_remainingBody = this.m_nextProtocolBlock = (this.m_contentLength = length);
                    }
                }
                if (this.m_contentLength == 0) {
                    this.setState(4);
                } else {
                    this.setState(2);
                }
                if (!DEBUG) return true;
                System.out.println("Read Message Headers for: " + this);
            }
        }
        return true;
    }

    public boolean skipBody(EvsNetworkLinkResult result) throws EEvsIOException {
        while (!this.isFinished()) {
            if (this.readBody(ByteBuffer.allocate(512), result)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean readBody(ByteBuffer buffer, EvsNetworkLinkResult result) throws EEvsIOException {
        switch (this.m_transportState) {
            case 4: {
                return true;
            }
            case 0: 
            case 1: {
                if (!this.readMessageHeader(result)) {
                    return false;
                }
                this.setState(2);
            }
            case 2: {
                if (this.m_readController != null) {
                    if (!this.m_readController.read(buffer, result)) return false;
                    if (this.m_readController.isComplete()) {
                        this.setState(4);
                        return true;
                    }
                }
                if (this.m_contentLength >= 0) {
                    if (this.m_nextProtocolBlock == 0) {
                        this.setState(4);
                        return true;
                    }
                    if (this.m_nextProtocolBlock < buffer.remaining()) {
                        int limit = buffer.limit();
                        buffer.limit(buffer.position() + this.m_nextProtocolBlock);
                        try {
                            if (this.readBody(buffer, result)) return this.readBody(buffer, result);
                            boolean bl = false;
                            return bl;
                        }
                        finally {
                            buffer.limit(limit);
                        }
                    }
                    int pos = buffer.position();
                    this.m_connection.read(buffer, result);
                    int read = buffer.position() - pos;
                    this.m_nextProtocolBlock -= read;
                    if (this.m_contentLength > 0) {
                        this.m_remainingBody -= read;
                    }
                    if (this.m_nextProtocolBlock != 0) return !buffer.hasRemaining();
                    this.setState(4);
                    return true;
                }
                try {
                    this.m_connection.read(buffer, result);
                    return !buffer.hasRemaining();
                }
                catch (EEvsEOFException eof) {
                    this.setState(4);
                    return true;
                }
            }
        }
        throw new IllegalStateException(prMessageFormat.format(prAccessor.getString("Illegal state for readBody: {0}"), new Object[]{Integer.toString(this.m_transportState)}));
    }

    public final boolean addToConnection(EvsNetworkLinkResult result) throws EEvsIOException {
        switch (this.m_transportState) {
            case 0: {
                if (!this.m_bodySet) {
                    this.setBody((ByteBuffer[])null);
                }
                if (this.m_enableWriteChunking && this.m_contentLength > this.m_chunkThreshold) {
                    this.setHeaderInternal(CHUNKED_TRANSFER_HEADER);
                    this.removeHeaderInternal("Content-Length");
                    this.prepareChunkedBody();
                } else {
                    this.m_encodedBody = this.m_body;
                }
                ++this.m_transmissionAttempts;
                this.setState(1);
            }
            case 1: {
                this.tsHeader(result);
                this.setState(2);
            }
            case 2: {
                if (!this.tsBody()) {
                    return false;
                }
                this.setState(3);
                return true;
            }
            case 3: 
            case 4: {
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private void tsHeader(EvsNetworkLinkResult result) throws EEvsIOException {
        this.writeStartLine(result);
        this.writeHeaders(result);
        this.m_headerAdded = true;
    }

    private boolean tsBody() throws EEvsIOException {
        if (this.m_encodedBody != null) {
            if (this.m_encodedBody.length == 1) {
                this.m_connection.addData(this.m_encodedBody[0], this);
            } else {
                for (int i = 0; i < this.m_encodedBody.length; ++i) {
                    this.m_connection.addData(this.m_encodedBody[i], i == this.m_encodedBody.length - 1 ? this : null);
                }
            }
        } else if (!this.m_connection.commitBufferedData(this)) {
            return false;
        }
        return true;
    }

    @Override
    public final void onAsyncWriteComplete(ByteBuffer buffer) {
        this.m_transportState = 4;
    }

    protected final void writeLine(String str, EvsNetworkLinkResult result) throws EEvsIOException {
        switch (this.m_transportState) {
            case 1: {
                this.m_connection.bufferedWrite(HTTPParseUtil.getAsciiBytes(str + "\r\n"), result);
                break;
            }
            default: {
                throw new UnsupportedOperationException(prAccessor.getString("writeLine not supported for non header data!"));
            }
        }
    }

    protected final String readLine(EvsNetworkLinkResult result) throws EEvsIOException {
        String ret = this.m_connection.readLine(8192, result);
        if (ret == null) {
            return null;
        }
        if (DEBUG) {
            System.out.println("Read message line: " + ret.trim());
        }
        return ret;
    }

    protected abstract void writeStartLine(EvsNetworkLinkResult var1) throws EEvsIOException;

    protected abstract boolean readStartLine(EvsNetworkLinkResult var1) throws EEvsIOException;

    private final void writeHeaders(EvsNetworkLinkResult result) throws EEvsIOException {
        for (HTTPHeader header : this.m_headers.values()) {
            this.writeLine(header.getHeaderName() + ":" + " " + header.getHeaderValue(), result);
        }
        this.writeLine("", result);
    }

    public final boolean finish(EvsNetworkLinkResult result) throws EEvsIOException {
        if (this.m_transportState == 4) {
            return true;
        }
        if (this.m_inWriteMode) {
            if (!this.addToConnection(result)) {
                return false;
            }
            this.m_connection.write(result);
            return this.m_transportState == 4;
        }
        if (!this.readMessageHeader(result)) {
            return false;
        }
        if (!this.skipBody(result)) {
            return false;
        }
        this.setState(4);
        return true;
    }

    private final void setState(int state) {
        this.m_transportState = state;
    }

    @Override
    public final boolean isFinished() {
        return this.m_transportState == 4;
    }

    public final boolean isAddedToConnection() {
        return this.m_transportState >= 3;
    }

    @Override
    public long getRemainingBody() {
        return this.m_remainingBody;
    }

    @Override
    public final int getTransmissionAttempts() {
        return this.m_transmissionAttempts;
    }

    @Override
    public void setHandled() {
        this.m_handled = true;
    }

    @Override
    public boolean isHandled() {
        return this.m_handled;
    }

    public final boolean isTransportStarted() {
        return this.m_transportState > 0;
    }

    public final boolean isHeaderFinished() {
        return this.m_transportState > 1;
    }

    private final boolean readHeaders(EvsNetworkLinkResult result) throws EEvsIOException {
        while (true) {
            String headerLine;
            if ((headerLine = this.readLine(result)) == null) {
                return false;
            }
            if (headerLine.length() == 0) break;
            char firstChar = headerLine.charAt(0);
            if (this.m_lastHeaderRead != null && (firstChar == ' ' || firstChar == '\t')) {
                this.m_lastHeaderRead.appendToHeaderValue(headerLine.trim());
                continue;
            }
            int hd = headerLine.indexOf(":");
            if (hd == -1) {
                throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("Malformed Header: {0} - expected: {1} -- {2}"), new Object[]{headerLine, ":", this.toString()}), null);
            }
            this.m_lastHeaderRead = new HTTPHeader(headerLine.substring(0, hd), headerLine.substring(hd + 1).trim());
            this.addHeaderInternal(this.m_lastHeaderRead);
        }
        this.m_lastHeaderRead = null;
        return true;
    }

    @Override
    public final String getHeaderValue(String headerName) {
        if (!this.m_inWriteMode && this.m_transportState < 2) {
            throw new IllegalStateException(prAccessor.getString("Unable to get header when message header hasn't been yet read"));
        }
        HTTPHeader header = this.getHeaderInternal(headerName);
        return header == null ? null : header.getHeaderValue();
    }

    public final boolean getHeaderToken(String headerName, String token) {
        HTTPHeader header = this.getHeaderInternal(headerName);
        if (header == null) {
            return false;
        }
        return header.containsToken(token);
    }

    private final HTTPHeader getHeaderInternal(String headerName) {
        return (HTTPHeader)this.m_headers.get(headerName.toLowerCase());
    }

    @Override
    public final int getHeaderAsInt(String headerName) {
        String header = this.getHeaderValue(headerName);
        if (header == null) {
            return -1;
        }
        try {
            return new Integer(header);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    @Override
    public boolean hasCloseHeader() {
        HTTPHeader header = this.getHeaderInternal("Connection");
        if (header == null) {
            return this.m_dotVersion == 0;
        }
        if (this.m_dotVersion == 0) {
            return !header.containsToken("Keep-Alive");
        }
        return header.containsToken("close");
    }

    @Override
    public int getContentLength() {
        return this.m_contentLength;
    }

    @Override
    public void setHeader(String header, String value) {
        if (this.m_transportState > 0) {
            throw new IllegalStateException(prAccessor.getString("Unable to add header after transport has started"));
        }
        if (value == null) {
            this.removeHeaderInternal(header);
        }
        this.setHeaderInternal(new HTTPHeader(header, value));
    }

    private final void setHeaderInternal(HTTPHeader header) {
        this.m_headers.put(header.getHeaderName().toLowerCase(), header);
    }

    @Override
    public void addHeader(String header, String value) {
        if (this.m_transportState > 0) {
            throw new IllegalStateException(prAccessor.getString("Unable to add header after transport has started"));
        }
        this.addHeaderInternal(header, value);
    }

    private final void addHeaderInternal(String header, String value) {
        this.addHeaderInternal(new HTTPHeader(header, value));
    }

    private final void addHeaderInternal(HTTPHeader header) {
        HTTPHeader oldHeader = this.m_headers.put(header.getHeaderName().toLowerCase(), header);
        if (oldHeader != null) {
            this.m_headers.put(header.getHeaderName().toLowerCase(), oldHeader.addHeaderValue(header));
        }
    }

    private final void removeHeaderInternal(String headerName) {
        this.m_headers.remove(headerName.toLowerCase());
    }

    public String toString() {
        String ret = "";
        Iterator i = this.m_headers.values().iterator();
        while (i.hasNext()) {
            ret = ret + i.next() + "\n";
        }
        return ret + "Handled: " + this.m_handled + " state: " + this.m_transportState + " (" + this.m_transmissionAttempts + ")\n\n";
    }

    private final class ChunkedReadController {
        private static final int STATE_CHUNK_HEADER = 0;
        private static final int STATE_CHUNK_BODY = 1;
        private static final int STATE_LAST_CHUNK = 2;
        private static final int STATE_COMPLETE = 3;
        private int m_state = 0;
        private int m_chunkSize = 0;

        private ChunkedReadController() {
        }

        final boolean read(ByteBuffer buffer, EvsNetworkLinkResult result) throws EEvsIOException {
            while (this.m_state != 3 && buffer.hasRemaining()) {
                if (this.processReadState(buffer, result)) continue;
                return false;
            }
            return true;
        }

        final boolean processReadState(ByteBuffer buffer, EvsNetworkLinkResult result) throws EEvsIOException {
            switch (this.m_state) {
                case 0: {
                    String chunkHeader = HTTPMessage.this.m_connection.readLine(HTTPParseUtil.MAX_HTTP_CHUNK_HEADER_SIZE + "\r\n".getBytes().length, result);
                    if (chunkHeader == null) {
                        return false;
                    }
                    if (chunkHeader.indexOf(";") > 0) {
                        if (DEBUG) {
                            System.out.println(prMessageFormat.format(prAccessor.getString("Unsupported chunked transfer extension: {0}"), new Object[]{chunkHeader}));
                        }
                        chunkHeader = chunkHeader.substring(0, chunkHeader.indexOf(";"));
                    }
                    try {
                        this.m_chunkSize = Integer.parseInt(chunkHeader, 16);
                        if (DEBUG) {
                            System.out.println("Decoded chunk header, length: " + this.m_chunkSize);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("Error parsing chunk header length: {0}"), new Object[]{nfe.getMessage()}), (Exception)nfe);
                    }
                    if (this.m_chunkSize == 0) {
                        this.m_state = 2;
                        return true;
                    }
                    this.m_state = 1;
                }
                case 1: {
                    while (this.m_chunkSize > 0) {
                        if (!buffer.hasRemaining()) {
                            return true;
                        }
                        int read = HTTPMessage.this.m_connection.read(buffer, this.m_chunkSize, result);
                        if (read == 0) {
                            return false;
                        }
                        if (read == -1) {
                            throw new EEvsIOException();
                        }
                        this.m_chunkSize -= read;
                    }
                    String crlf = HTTPMessage.this.readLine(result);
                    if (crlf == null) {
                        return false;
                    }
                    this.m_state = 0;
                    return true;
                }
                case 2: {
                    if (!HTTPMessage.this.readHeaders(result)) {
                        return false;
                    }
                    this.m_state = 3;
                    return true;
                }
            }
            return false;
        }

        final boolean isComplete() {
            return this.m_state == 3;
        }
    }
}

