/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.interceptor.impls.actional;

import com.sonicsw.interceptor.SimpleContext;
import com.sonicsw.interceptor.impls.actional.IConstants;
import com.sonicsw.mq.components.BrokerComponent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import progress.message.zclient.SessionConfig;

public class Config
implements IConstants {
    public static volatile String NGSO_GROUP = null;
    public static volatile String NGSO_SERVICE = null;
    public static volatile String NGSO_OPERATION = null;
    public static volatile String BROKER_NAME = null;
    public static volatile String BROKER_ROUTING_NODE_NAME = null;
    public static volatile String LG_INCLUDE_PAYLOAD = "PAYLOAD_CAPTURE_ATTR_NONE";
    public static boolean LG_INTERCEPTOR_DEBUG = false;
    public static String LG_INTERCEPTOR_FILTERS = null;
    public static String LG_MESSAGE_FIELDS = null;
    public static volatile String LG_EVENTS_LOG_FILE = null;
    public static final String LOG_LG_ENABLED_PAYLOAD_NONE = "Actional instrumentation is enabled with payload capture disabled";
    public static final String LOG_LG_ENABLED_PAYLOAD_HEADER = "Actional instrumentation is enabled with payload capture enabled for message header";
    public static final String LOG_LG_ENABLED_PAYLOAD_BODY = "Actional instrumentation is enabled with payload capture enabled for message body";
    public static final String LOG_LG_ENABLED_PAYLOAD_ALL = "Actional instrumentation is enabled with payload capture enabled for message header & body";
    public static final String LOG_LG_DISABLED = "Actional instrumentation is disabled";
    public static final String LOG_LG_AGENT_CONNECTED = "Successfully connected to Actional agent";
    public static final String LOG_LG_AGENT_NOT_CONNECTED = "Unable to reach Actional agent";
    private static volatile Properties s_properties = null;
    public static volatile PrintWriter m_logWriter = null;
    private static long s_lastDebugTraceCheck = 0L;
    private static boolean s_lastDebugTraceValue = false;
    private static long CHECK_INTERVAL = 10000L;

    public static void loadConfig(Properties props) {
        s_properties = props;
        NGSO_GROUP = Config.getProperty("NGSO_GROUP_ATTR", NGSO_GROUP);
        NGSO_SERVICE = Config.getProperty("NGSO_SERVICE_ATTR", NGSO_SERVICE);
        NGSO_OPERATION = Config.getProperty("NGSO_OPERATION_ATTR", NGSO_OPERATION);
        BROKER_NAME = Config.getProperty("BROKER_NAME_ATTR", null);
        BROKER_ROUTING_NODE_NAME = Config.getProperty("ROUTING_NODE_NAME_ATTR", null);
        String value = null;
        value = System.getProperties().getProperty("actional.ngso.group");
        if (value != null) {
            NGSO_GROUP = value;
        }
        if ((value = System.getProperties().getProperty("actional.ngso.service")) != null) {
            NGSO_SERVICE = value;
        }
        if ((value = System.getProperties().getProperty("actional.ngso.operation")) != null) {
            NGSO_OPERATION = value;
        }
    }

    public static void setDynamicProperty(String property, Object newvalue) {
        if (property.equalsIgnoreCase("INTERCEPTOR_DEBUG_ATTR")) {
            LG_INTERCEPTOR_DEBUG = newvalue != null && newvalue instanceof Boolean ? (Boolean)newvalue : false;
        }
        if (property.equalsIgnoreCase("EVENTS_LOG_FILE_ATTR")) {
            try {
                Config.closeInteractionLogFile(Config.getInterceptorEventsLogFileName());
                Config.initInteractionLogFile((String)newvalue);
            }
            catch (Exception e) {
                Config.logMessage(e);
            }
        }
        if (property.equalsIgnoreCase("PAYLOAD_CAPTURE_ATTR")) {
            boolean changed = true;
            if (newvalue != null && newvalue instanceof String) {
                LG_INCLUDE_PAYLOAD = (String)newvalue;
                String oldValue = LG_INCLUDE_PAYLOAD;
                if (LG_INCLUDE_PAYLOAD.equalsIgnoreCase(oldValue)) {
                    changed = false;
                }
            } else {
                LG_INCLUDE_PAYLOAD = "PAYLOAD_CAPTURE_ATTR_NONE";
            }
            if (changed) {
                if (LG_INCLUDE_PAYLOAD.equalsIgnoreCase("PAYLOAD_CAPTURE_ATTR_NONE")) {
                    BrokerComponent.getComponentContext().logMessage(LOG_LG_ENABLED_PAYLOAD_NONE, 3);
                } else if (LG_INCLUDE_PAYLOAD.equalsIgnoreCase("PAYLOAD_CAPTURE_ATTR_HEADER")) {
                    BrokerComponent.getComponentContext().logMessage(LOG_LG_ENABLED_PAYLOAD_HEADER, 3);
                } else if (LG_INCLUDE_PAYLOAD.equalsIgnoreCase("PAYLOAD_CAPTURE_ATTR_BODY")) {
                    BrokerComponent.getComponentContext().logMessage(LOG_LG_ENABLED_PAYLOAD_BODY, 3);
                } else if (LG_INCLUDE_PAYLOAD.equalsIgnoreCase("PAYLOAD_CAPTURE_ATTR_ALL")) {
                    BrokerComponent.getComponentContext().logMessage(LOG_LG_ENABLED_PAYLOAD_ALL, 3);
                }
            }
        }
        if (property.equalsIgnoreCase("ACTIONAL_INSTRUMENTATION_ATTR") && newvalue != null && newvalue instanceof Boolean) {
            if (((Boolean)newvalue).booleanValue()) {
                if (LG_INCLUDE_PAYLOAD.equalsIgnoreCase("PAYLOAD_CAPTURE_ATTR_NONE")) {
                    BrokerComponent.getComponentContext().logMessage(LOG_LG_ENABLED_PAYLOAD_NONE, 3);
                } else if (LG_INCLUDE_PAYLOAD.equalsIgnoreCase("PAYLOAD_CAPTURE_ATTR_HEADER")) {
                    BrokerComponent.getComponentContext().logMessage(LOG_LG_ENABLED_PAYLOAD_HEADER, 3);
                } else if (LG_INCLUDE_PAYLOAD.equalsIgnoreCase("PAYLOAD_CAPTURE_ATTR_BODY")) {
                    BrokerComponent.getComponentContext().logMessage(LOG_LG_ENABLED_PAYLOAD_BODY, 3);
                } else if (LG_INCLUDE_PAYLOAD.equalsIgnoreCase("PAYLOAD_CAPTURE_ATTR_ALL")) {
                    BrokerComponent.getComponentContext().logMessage(LOG_LG_ENABLED_PAYLOAD_ALL, 3);
                }
            } else {
                BrokerComponent.getComponentContext().logMessage(LOG_LG_DISABLED, 3);
            }
        }
    }

    public static String getDynamicProperty(String property) {
        if (property.equalsIgnoreCase("INTERCEPTOR_DEBUG_ATTR")) {
            return Boolean.toString(LG_INTERCEPTOR_DEBUG);
        }
        if (property.equalsIgnoreCase("EVENTS_LOG_FILE_ATTR")) {
            return LG_EVENTS_LOG_FILE;
        }
        if (property.equalsIgnoreCase("PAYLOAD_CAPTURE_ATTR")) {
            return LG_INCLUDE_PAYLOAD;
        }
        return null;
    }

    public static final String getProperty(String name, String defaultValue) {
        String value = s_properties.getProperty(name);
        return value == null ? defaultValue : value;
    }

    public static final boolean getBooleanProperty(String name, boolean defaultValue) {
        String value = s_properties.getProperty(name);
        return value == null ? defaultValue : Boolean.valueOf(value.trim());
    }

    public static final int getIntProperty(String name, int defaultValue) {
        String value = s_properties.getProperty(name);
        return value == null ? defaultValue : Integer.valueOf(value.trim());
    }

    public static boolean isInterceptorDebugEnabled() {
        if (LG_INTERCEPTOR_DEBUG) {
            return true;
        }
        if (s_lastDebugTraceCheck != 0L && System.currentTimeMillis() - s_lastDebugTraceCheck < CHECK_INTERVAL) {
            return s_lastDebugTraceValue;
        }
        int traceMask = BrokerComponent.getBrokerComponent().getTraceMask();
        s_lastDebugTraceValue = (traceMask & 0x100) > 0;
        s_lastDebugTraceCheck = System.currentTimeMillis();
        return s_lastDebugTraceValue;
    }

    public static String getInterceptorEventsLogFileName() {
        return LG_EVENTS_LOG_FILE;
    }

    public static void initInteractionLogFile(String logFileName) {
        try {
            if (logFileName != null) {
                FileOutputStream out = new FileOutputStream(new File(logFileName));
                m_logWriter = new PrintWriter(out);
                Config.writeHeader();
                m_logWriter.flush();
                LG_EVENTS_LOG_FILE = logFileName;
            } else {
                m_logWriter = null;
            }
        }
        catch (Exception e) {
            m_logWriter = null;
            Config.logMessage(e);
        }
    }

    public static void closeInteractionLogFile(String logFileName) {
        try {
            if (m_logWriter != null) {
                m_logWriter.flush();
                m_logWriter.close();
            }
        }
        catch (Exception e) {
            Config.logMessage(e);
        }
    }

    private static void writeHeader() {
        DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(3, 3);
        if (DATE_FORMAT instanceof SimpleDateFormat) {
            ((SimpleDateFormat)DATE_FORMAT).applyPattern("yy/MM/dd kk:mm:ss");
        }
        long now = System.currentTimeMillis();
        String banner = "SonicMQ Actional LG Events Output File - created on " + DATE_FORMAT.format(new Date(now)) + "\nBy broker \"" + BROKER_NAME;
        m_logWriter.println(banner);
    }

    public static void logMessage(String err) {
        if (m_logWriter == null) {
            SessionConfig.logMessage(err, SessionConfig.TRACE);
        } else {
            m_logWriter.println(err);
            m_logWriter.flush();
        }
    }

    public static void logMessage(Exception err) {
        if (m_logWriter == null) {
            SessionConfig.logMessage(err, SessionConfig.TRACE);
        } else {
            err.printStackTrace(m_logWriter);
            m_logWriter.flush();
        }
    }

    public static void logDebugMessage(String err) {
        if (Config.isInterceptorDebugEnabled()) {
            Config.logMessage(err + "\n");
        }
    }

    public static void logDebugMessage(Exception err) {
        if (Config.isInterceptorDebugEnabled()) {
            Config.logMessage(err);
        }
    }

    public static void traceContextProperties(String opName, SimpleContext context) {
        if (Config.isInterceptorDebugEnabled()) {
            HashMap props = context.getProperties();
            Iterator iter = props.keySet().iterator();
            StringBuffer msgBuffer = new StringBuffer();
            msgBuffer.append(opName + ": tracing Context properties ==>");
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object val = props.get(key);
                if (val == null) {
                    val = "(null)";
                }
                msgBuffer.append("\n   param=" + key + "=" + val.toString());
            }
            msgBuffer.append("\n");
            Config.logDebugMessage(msgBuffer.toString());
        }
    }
}

