/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.RoutingUserAclEntry;
import progress.message.broker.SubjectAclEntry;
import progress.message.client.EUnknownPrincipal;
import progress.message.db.EDatabaseException;
import progress.message.security.EPermissionConflict;
import progress.message.security.EUnknownPermission;
import progress.message.zclient.ProgressPrincipal;

public class ACLPermissionChangeHandler
implements IAttributeChangeHandler {
    private String m_principalName = null;
    private String m_principalType = null;
    private String m_resourceName = null;
    private String m_aclType = null;

    public ACLPermissionChangeHandler(String principalName, String principalType, String resourceName, String aclType) {
        this.m_principalName = principalName;
        this.m_principalType = principalType;
        this.m_resourceName = resourceName;
        this.m_aclType = aclType;
    }

    public void itemDeleted() {
    }

    public void itemModified(Object newValue) {
        if (newValue == null || this.m_principalName == null || this.m_principalType == null || this.m_resourceName == null || this.m_aclType == null) {
            return;
        }
        String permission = (String)newValue;
        ProgressPrincipal p = null;
        p = this.m_principalType.equalsIgnoreCase("GROUP") ? AgentRegistrar.getAgentRegistrar().getSecurityBean().getGroup(this.m_principalName) : AgentRegistrar.getAgentRegistrar().getSecurityBean().getUser(this.m_principalName);
        if (p == null) {
            // empty if block
        }
        if (p != null) {
            if (this.m_aclType.equalsIgnoreCase("ROUTING_USER_ACL")) {
                RoutingUserAclEntry ruae = new RoutingUserAclEntry(p, this.m_resourceName);
                this.setRoutingUserACLPermission(permission, ruae);
                try {
                    AgentRegistrar.getAgentRegistrar().getSecurityBean().setRoutingUserAclEntry(this.m_resourceName, ruae);
                }
                catch (EUnknownPrincipal eupe) {
                }
                catch (EDatabaseException edbe) {
                }
                catch (IOException ioe) {}
            } else {
                SubjectAclEntry sae = new SubjectAclEntry(p);
                this.setSubjectACLPermissions(this.m_aclType, permission, sae);
                try {
                    AgentRegistrar.getAgentRegistrar().getSecurityBean().setAclEntry(this.m_resourceName, sae);
                }
                catch (EUnknownPrincipal eupe) {
                }
                catch (EDatabaseException edbe) {
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }

    private void setRoutingUserACLPermission(String permission, RoutingUserAclEntry ruae) {
        if (permission.equalsIgnoreCase("GRANT")) {
            ruae.setPosPermission();
        } else if (permission.equalsIgnoreCase("DENY")) {
            ruae.setNegPermission();
        }
    }

    private void setSubjectACLPermissions(String aclType, String permission, SubjectAclEntry sae) {
        try {
            if (permission.equalsIgnoreCase("GRANT")) {
                if (aclType.equalsIgnoreCase("PUBLISH_ACL")) {
                    sae.addPermission((byte)1);
                } else if (aclType.equalsIgnoreCase("SUBSCRIBE_ACL")) {
                    sae.addPermission((byte)2);
                } else if (aclType.equalsIgnoreCase("GUARANTEED_ACL")) {
                    sae.addPermission((byte)4);
                } else if (aclType.equalsIgnoreCase("SEND_ACL")) {
                    sae.addPermission((byte)1);
                } else if (aclType.equalsIgnoreCase("RECEIVE_ACL")) {
                    sae.addPermission((byte)2);
                } else if (aclType.equalsIgnoreCase("BROWSE_ACL")) {
                    sae.addPermission((byte)8);
                } else {
                    BrokerComponent.getComponentContext().logMessage("Unknown ACL type: " + aclType, 2);
                }
            } else if (permission.equalsIgnoreCase("DENY")) {
                if (aclType.equalsIgnoreCase("PUBLISH_ACL")) {
                    sae.addPermission((byte)-2);
                } else if (aclType.equalsIgnoreCase("SUBSCRIBE_ACL")) {
                    sae.addPermission((byte)-3);
                } else if (aclType.equalsIgnoreCase("GUARANTEED_ACL")) {
                    sae.addPermission((byte)-5);
                } else if (aclType.equalsIgnoreCase("SEND_ACL")) {
                    sae.addPermission((byte)-2);
                } else if (aclType.equalsIgnoreCase("RECEIVE_ACL")) {
                    sae.addPermission((byte)-3);
                } else if (aclType.equalsIgnoreCase("BROWSE_ACL")) {
                    sae.addPermission((byte)-9);
                } else {
                    BrokerComponent.getComponentContext().logMessage("Unknown ACL type: " + aclType, 2);
                }
            }
        }
        catch (EPermissionConflict pc) {
        }
        catch (EUnknownPermission up) {
            // empty catch block
        }
    }
}

