/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mq.components.ExternalDomainAuthSPIConfig;
import java.util.ArrayList;
import java.util.HashMap;
import progress.message.broker.AgentRegistrar;

class AuthSPIDefinationChangeHandler
implements IAttributeChangeHandler {
    private HashMap m_attributeSet;

    AuthSPIDefinationChangeHandler(IAttributeSet attributeSet) {
        if (attributeSet != null) {
            this.m_attributeSet = attributeSet.getAttributes();
        }
    }

    public void itemDeleted() {
    }

    public void itemModified(Object newValue) {
        if (newValue == null || this.m_attributeSet == null) {
            return;
        }
        String authSPINameInChangeHandler = null;
        String authSPINameInAgentRegistrar = null;
        if (this.m_attributeSet != null) {
            authSPINameInChangeHandler = (String)this.m_attributeSet.get("AUTH_SPI_NAME");
            authSPINameInAgentRegistrar = AgentRegistrar.getExternalDomainAuthSPIConfig().getAuthSPIName();
        }
        boolean isReInitNeeded = false;
        if (authSPINameInChangeHandler != null && authSPINameInAgentRegistrar != null && authSPINameInChangeHandler.equals(authSPINameInAgentRegistrar)) {
            isReInitNeeded = true;
        }
        if (newValue instanceof IDeltaAttributeSet) {
            String[] newAttrNames;
            String[] modifiedAttrNames;
            IDeltaAttributeSet das = (IDeltaAttributeSet)newValue;
            String[] deletedAttrNames = das.getDeletedAttributesNames();
            if (deletedAttrNames != null && deletedAttrNames.length > 0) {
                for (int i = 0; i < deletedAttrNames.length; ++i) {
                    if (!this.m_attributeSet.containsKey(deletedAttrNames[i])) continue;
                    this.m_attributeSet.remove(deletedAttrNames[i]);
                }
            }
            if ((modifiedAttrNames = das.getModifiedAttributesNames()) != null && modifiedAttrNames.length > 0) {
                for (int i = 0; i < modifiedAttrNames.length; ++i) {
                    try {
                        this.m_attributeSet.put(modifiedAttrNames[i], das.getNewValue(modifiedAttrNames[i]));
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            if ((newAttrNames = das.getNewAttributesNames()) != null && newAttrNames.length > 0) {
                for (int i = 0; i < newAttrNames.length; ++i) {
                    try {
                        this.m_attributeSet.put(newAttrNames[i], das.getNewValue(newAttrNames[i]));
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            String authSPIName = (String)this.m_attributeSet.get("AUTH_SPI_NAME");
            String className = (String)this.m_attributeSet.get("CLASS_NAME");
            ArrayList classpath = null;
            Object o = this.m_attributeSet.get("CLASSPATH");
            if (o != null) {
                try {
                    IAttributeList list = (IAttributeList)o;
                    if (list != null) {
                        classpath = list.getItems();
                    }
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                }
            }
            if (isReInitNeeded) {
                ExternalDomainAuthSPIConfig externalDomainAuthSPIConfig = AgentRegistrar.getExternalDomainAuthSPIConfig();
                externalDomainAuthSPIConfig.setAuthSPIName(authSPIName);
                externalDomainAuthSPIConfig.setClassName(className);
                externalDomainAuthSPIConfig.setClasspath(classpath);
                AgentRegistrar.initAuthenticationSPI();
            }
        }
    }
}

