/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.AbstractApplicationComponent;
import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IFSElementChange;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.info.IManagementInfo;
import com.sonicsw.mf.common.info.InfoFactory;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mq.common.runtime.BrokerNotActiveException;
import com.sonicsw.mq.common.runtime.IBrowseToken;
import com.sonicsw.mq.common.runtime.IConnectionMemberDetails;
import com.sonicsw.mq.common.runtime.IDurableSubscriptionData;
import com.sonicsw.mq.common.runtime.IMessage;
import com.sonicsw.mq.common.runtime.IMessageHeader;
import com.sonicsw.mq.common.runtime.IMessageHeaderToken;
import com.sonicsw.mq.common.runtime.ISubscriberData;
import com.sonicsw.mq.common.runtime.impl.RuntimeDataFactory;
import com.sonicsw.mq.components.ACLConfigChangeHelper;
import com.sonicsw.mq.components.AddNewAcceptorDirectProtocolHandler;
import com.sonicsw.mq.components.AddNewAcceptorDirectURLHandler;
import com.sonicsw.mq.components.AddNewRouteChangeHandler;
import com.sonicsw.mq.components.AttributeChangeHandlerFactory;
import com.sonicsw.mq.components.AttributesHolder;
import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import com.sonicsw.mq.components.BrokerMetricsHelper;
import com.sonicsw.mq.components.ClusterPeerUpdateChangeHandler;
import com.sonicsw.mq.components.ConfigPropertiesPopulator;
import com.sonicsw.mq.components.ConfigurationChangeBindHelper;
import com.sonicsw.mq.components.ConnectionOperationsHelper;
import com.sonicsw.mq.components.ConnectionTuningConfigChangeHandler;
import com.sonicsw.mq.components.DebugInvokeHelper;
import com.sonicsw.mq.components.DurableOperationsHelper;
import com.sonicsw.mq.components.ExternalDomainAuthSPIConfig;
import com.sonicsw.mq.components.GroupConfigChangeHelper;
import com.sonicsw.mq.components.LGConfigChangeHandler;
import com.sonicsw.mq.components.QoPConfigChangeHelper;
import com.sonicsw.mq.components.ReliableSequenceHelper;
import com.sonicsw.mq.components.RemoteSubscriptionHelper;
import com.sonicsw.mq.components.ReplicationOperationsHelper;
import com.sonicsw.mq.components.UserConfigChangeHelper;
import com.sonicsw.mq.components.prAccessor;
import com.sonicsw.mx.util.IEmptyArray;
import com.sonicsw.sdf.AbstractMFComponentTracing;
import com.sonicsw.security.pcs.AbstractCipherSuite;
import com.sonicsw.security.pcs.CipherSuiteInfo;
import com.sonicsw.security.pcs.EInvalidCipherSuiteException;
import com.sonicsw.security.pcs.IPluggableCipherSuite;
import com.sonicsw.security.pcs.SonicCipherSuite;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import progress.message.broker.AcceptorHolder;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.CompactStatusMonitor;
import progress.message.broker.Config;
import progress.message.broker.EBrokerAborted;
import progress.message.broker.FTPairPeerInfoHolder;
import progress.message.broker.InitBrokerDatabase;
import progress.message.broker.SyncBrokerDatabase;
import progress.message.dd.NoDupDetectDb;
import progress.message.ft.ReplicationState;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverter;
import progress.message.msg.MgramFactory;
import progress.message.net.ssl.CRLCachePolicy;
import progress.message.resources.prMessageFormat;
import progress.message.util.DebugState;
import progress.message.util.QueueUtil;
import progress.message.zclient.DebugThread;

public class BrokerComponent
extends AbstractApplicationComponent {
    private static volatile BrokerComponent m_brokerComponent;
    private IElement m_configuration;
    private String m_configID;
    private static volatile IComponentContext m_componentContext;
    private Broker m_broker = null;
    private Properties m_props = null;
    private AttributesHolder m_attributesHolder = null;
    private ConfigurationChangeBindHelper m_bindHelper = null;
    private boolean m_reloadRequired = false;
    private boolean m_reloadRequiredMsgLogged = false;
    private SdfMFTracingIntegration m_SdfMFTracingIntegration;
    static final String PRIMARY_CONFIG_TYPE = "MQ_BROKER";
    static final String BACKUP_CONFIG_TYPE = "MQ_BACKUPBROKER";
    private static final String BROKER_TRACE_MASK_VALUES = "16=HTTP direct inbound,32=HTTP direct outbound,64=DRA log all connection failures,128=external authentication";
    public static final int TRACE_HTTP_DIRECT_INBOUND = 16;
    public static final int TRACE_HTTP_DIRECT_OUTBOUND = 32;
    public static final int TRACE_DRA_LOG_ALL_CONN_FAILURES = 64;
    public static final int TRACE_EXTERNAL_AUTHENTICATION = 128;
    public static final int TRACE_ACTIONAL_INTERACTIONS = 256;
    public static final int STOP_NORMAL = 0;
    public static final int STOP_IMMEDIATE = 1;
    private static final IManagementInfo[] DEBUG_CALLBACK_INFO;
    private static int m_debugCallbackInfoSize;
    private int m_startsSinceLoad = 0;
    InitBrokerDatabase ibd;
    private static final ArrayList ATTRIBUTE_INFOS;
    private static final ArrayList OPERATION_INFOS;

    public static BrokerComponent getBrokerComponent() {
        return m_brokerComponent;
    }

    public void abort(String errorDescription, int stopBehaviorMask) throws EBrokerAborted {
        this.abort(errorDescription, null, stopBehaviorMask);
    }

    public void abort(String errorDescription, Throwable throwable, int stopBehaviorMask) throws EBrokerAborted {
        if (errorDescription == null || errorDescription.length() == 0) {
            errorDescription = prAccessor.getString("ABORT_NO_DESCRIPTION");
        }
        this.m_context.registerErrorCondition(errorDescription, 1);
        try {
            this.m_context.logMessage(errorDescription, 1);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (throwable != null) {
            try {
                this.m_context.logMessage(prAccessor.getString("TRACE_FOLLOWS"), throwable, 1);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        ShutdownThread stopThread = new ShutdownThread(stopBehaviorMask);
        stopThread.setDaemon(true);
        ((Thread)stopThread).start();
        throw new EBrokerAborted();
    }

    public void init(IComponentContext context) {
        DebugState.registerSonicDiagnostics();
        m_brokerComponent = this;
        super.init(context);
        m_componentContext = context;
        this.m_props = new Properties();
        try {
            CipherSuiteInfo cipherInfo = this.getCipherSuiteInfo(m_componentContext);
            if (cipherInfo != null) {
                IPluggableCipherSuite cipherSuite = AbstractCipherSuite.getCipherSuiteInstance(cipherInfo);
                AgentRegistrar.setCipherSuite(cipherSuite);
            }
        }
        catch (EInvalidCipherSuiteException ex) {
            this.m_context.logMessage(prAccessor.getString("INVALID_CIPHER_SUITE_AT_INITIALIZATION_TIME_FAILURE"), (Throwable)ex, 1);
        }
        BrokerManagementNotificationsHelper.init(context);
        BrokerMetricsHelper.init(context);
        DurableOperationsHelper.init(context);
        RemoteSubscriptionHelper.init(context);
        ReliableSequenceHelper.init(context);
        ConnectionOperationsHelper.init(context);
        this.m_configuration = context.getConfiguration(true);
        this.m_configID = this.m_configuration.getIdentity().getName();
        this.m_attributesHolder = new AttributesHolder();
        AttributeChangeHandlerFactory changeHandlerFactory = null;
        if (AttributeChangeHandlerFactory.getAttributeChangeHandlerFactory() == null) {
            changeHandlerFactory = new AttributeChangeHandlerFactory(this.m_configID);
        }
        this.m_bindHelper = new ConfigurationChangeBindHelper(changeHandlerFactory, this.m_attributesHolder, m_componentContext);
        try {
            String type = this.m_configuration.getIdentity().getType();
            if (type.equals(BACKUP_CONFIG_TYPE)) {
                ConfigPropertiesPopulator.loadBackup(m_componentContext, this.m_configuration, this.m_props, this.m_attributesHolder, this.m_bindHelper);
            } else {
                ConfigPropertiesPopulator.loadPrimary(m_componentContext, this.m_configuration, this.m_props, this.m_attributesHolder, this.m_bindHelper);
            }
        }
        catch (NullPointerException npe) {
            MFRuntimeException mfre = new MFRuntimeException("Unable to obtain full configuration during Broker Component initialization - Remove any existing container cache, prior to reloading the Broker Component.");
            throw mfre;
        }
        catch (Exception e) {
            e.printStackTrace();
            MFRuntimeException mfre = new MFRuntimeException(e.getMessage());
            mfre.setLinkedException(e);
            throw mfre;
        }
        this.createAuthenticationSPI(this.m_props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        Short action;
        this.m_SdfMFTracingIntegration = new SdfMFTracingIntegration();
        this.m_SdfMFTracingIntegration.initTraceMask();
        this.m_SdfMFTracingIntegration.register();
        if (this.m_state == 3) {
            return;
        }
        if (this.m_startsSinceLoad > 0) {
            throw new RuntimeException("This component must be reloaded before each start.");
        }
        ++this.m_startsSinceLoad;
        InitBrokerDatabase ibd = new InitBrokerDatabase();
        ibd.setContext(this.m_context);
        ibd.setProps(this.m_props);
        if (ibd.initNeeded()) {
            try {
                action = new Short(0);
                this.initMessageStore(action);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        ibd = new InitBrokerDatabase();
        ibd.setContext(this.m_context);
        ibd.setProps(this.m_props);
        if (ibd.upgradeNeeded()) {
            try {
                action = new Short(3);
                this.initMessageStore(action);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        this.m_state = (short)2;
        try {
            this.m_broker = null;
            this.m_broker = new Broker(this);
            this.m_broker.start(this.m_props);
            AddNewRouteChangeHandler.init(this.m_context);
            AddNewAcceptorDirectProtocolHandler.init(this.m_context);
            AddNewAcceptorDirectURLHandler.init(this.m_context);
            ConnectionTuningConfigChangeHandler.init();
            ClusterPeerUpdateChangeHandler.init(this.m_context, this.m_broker, this.m_attributesHolder);
            this.m_bindHelper.bindChangeHandlers();
            super.start();
        }
        finally {
            if (this.m_state == 2) {
                this.m_state = 1;
            }
        }
    }

    public synchronized void stop() {
        this.stop(0);
    }

    private void stop(int stopBehaviorMask) {
        if (this.m_state == 1) {
            return;
        }
        this.m_broker.setStartupFailed();
        this.m_startTime = 0L;
        this.sendStateNotification(1, 3, (short)0);
        if (this.m_broker != null) {
            this.m_broker.shutdown(stopBehaviorMask);
        }
    }

    public void restartContainer() throws Exception {
        this.m_context.restartContainer();
    }

    public void destroy() {
        short state = this.getState();
        if (state == 3 || state == 2) {
            this.stop();
        }
        super.destroy();
        if (this.m_broker != null) {
            this.m_broker.destroy();
        }
        this.m_startsSinceLoad = 0;
        AcceptorHolder accHolder = (AcceptorHolder)this.m_props.get("ACCEPTOR_HOLDER");
        if (accHolder != null) {
            accHolder.destroy();
        }
        ResourceBundle.clearCache();
        m_brokerComponent = null;
    }

    public MBeanAttributeInfo[] getAttributeInfos() {
        return ATTRIBUTE_INFOS.toArray(IEmptyArray.EMPTY_ATTRIBUTE_INFO_ARRAY);
    }

    public MBeanOperationInfo[] getOperationInfos() {
        return OPERATION_INFOS.toArray(IEmptyArray.EMPTY_OPERATION_INFO_ARRAY);
    }

    public MBeanNotificationInfo[] getNotificationInfos() {
        return BrokerManagementNotificationsHelper.getNotificationInfos().toArray(IEmptyArray.EMPTY_NOTIFICATION_INFO_ARRAY);
    }

    public void setState(short state) {
        super.setState(state);
    }

    public void enableMetrics(IMetricIdentity[] ids) {
        if (ids == null) {
            throw new IllegalArgumentException("null argument not supported");
        }
        BrokerMetricsHelper.enableMetrics(ids);
    }

    public void disableMetrics(IMetricIdentity[] ids) {
        if (ids == null) {
            throw new IllegalArgumentException("null argument not supported");
        }
        BrokerMetricsHelper.disableMetrics(ids);
    }

    public String[] getInstanceMetricNames(IMetricIdentity id) {
        if (id == null) {
            throw new IllegalArgumentException("null argument not supported");
        }
        return BrokerMetricsHelper.getInstanceMetricNames(id);
    }

    public void setTraceMask(Integer traceMask) {
        this.setTraceMask(traceMask, false);
    }

    private void setTraceMask(Integer traceMask, boolean fromSDF) {
        if (traceMask == null) {
            throw new IllegalArgumentException("null argument not supported");
        }
        if (!fromSDF && this.m_SdfMFTracingIntegration != null) {
            if (this.m_SdfMFTracingIntegration.wasUpdated()) {
                return;
            }
            this.m_SdfMFTracingIntegration.setTraceMask(traceMask);
        }
        super.setTraceMask(traceMask);
    }

    public String getTraceMaskValues() {
        return super.getTraceMaskValues() + "," + BROKER_TRACE_MASK_VALUES;
    }

    public ArrayList getQueues(String queueNamePrefix) throws MFException {
        this.validateState((short)3);
        this.validateBrokerActive();
        return AgentRegistrar.getAgentRegistrar().getQueueProc().getQueues(queueNamePrefix);
    }

    public ArrayList getRoutingStatistics(String nodePrefix) throws MFException {
        this.validateState((short)3);
        this.validateBrokerActive();
        return AgentRegistrar.getAgentRegistrar().getQueueProc().getRoutingStatistics(nodePrefix);
    }

    public IBrowseToken createRoutingQueueBrowser(String routingNode, String messageSelector) throws MFException {
        this.validateState((short)3);
        this.validateBrokerActive();
        IBrowseToken bt = null;
        if (routingNode != null) {
            messageSelector = QueueUtil.createRoutingQueueBrowserSelector(messageSelector, routingNode);
            bt = AgentRegistrar.getAgentRegistrar().getQueueProc().getRoutingQueue().openBrowser(messageSelector);
        }
        if (bt == null) {
            throw new MFException("Unable to create routing queue browser for node \"" + routingNode + "\"");
        }
        return bt;
    }

    public ArrayList<IMessageHeader> browseRoutingQueueMessages(IBrowseToken token, Integer maxMessages) throws MFException {
        this.validateState((short)3);
        this.validateBrokerActive();
        ArrayList<IMessageHeader> result = new ArrayList<IMessageHeader>();
        Iterator<IMgram> mgrams = AgentRegistrar.getAgentRegistrar().getQueueProc().getRoutingQueue().browse(token, maxMessages).iterator();
        while (mgrams.hasNext()) {
            result.add(RuntimeDataFactory.createMessageHeader(mgrams.next(), RuntimeDataFactory.getBrowseTokenClientId(token)));
        }
        return result;
    }

    public ArrayList<IMessage> browseRoutingQueueMessagesWithPayload(IBrowseToken token, Integer maxMessages) throws MFException {
        ArrayList<IMessage> result = new ArrayList<IMessage>();
        IMgramConverter converter = null;
        Iterator<IMgram> mgrams = AgentRegistrar.getAgentRegistrar().getQueueProc().getRoutingQueue().browse(token, maxMessages).iterator();
        while (mgrams.hasNext()) {
            if (converter == null) {
                converter = MgramFactory.getMgramConverter(26);
            }
            ByteArrayOutputStream boas = new ByteArrayOutputStream();
            try {
                converter.deliver(mgrams.next(), boas);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                continue;
            }
            result.add(RuntimeDataFactory.createBrowseMessage(boas.toByteArray()));
        }
        return result;
    }

    public Integer deleteRoutingQueueMessages(ArrayList<IMessageHeaderToken> tokens) throws MFException, InterruptedException {
        this.validateState((short)3);
        this.validateBrokerActive();
        return AgentRegistrar.getAgentRegistrar().getQueueProc().getRoutingQueue().deleteMessages(tokens);
    }

    public void deleteQueueMessages(ArrayList<String> queueNames) throws InterruptedException, MFException {
        if (queueNames == null) {
            throw new IllegalArgumentException("null argument not supported");
        }
        this.validateState((short)3);
        this.validateBrokerActive();
        AgentRegistrar.getAgentRegistrar().getQueueProc().deleteQueueMessages(queueNames);
    }

    public ArrayList getPreparedXABranches() throws MFException {
        this.validateState((short)3);
        this.validateBrokerActive();
        return AgentRegistrar.getAgentRegistrar().getTransactionMgr().getPreparedXABranches();
    }

    public void commitPreparedXABranches(Integer[] TIDs) throws Exception {
        if (TIDs == null) {
            throw new IllegalArgumentException("null argument not supported");
        }
        this.validateState((short)3);
        this.validateBrokerActive();
        AgentRegistrar.getAgentRegistrar().getTransactionMgr().commitPreparedXABranches(TIDs);
    }

    public void rollbackPreparedXABranches(Integer[] TIDs) throws Exception {
        if (TIDs == null) {
            throw new IllegalArgumentException("null argument not supported");
        }
        this.validateState((short)3);
        this.validateBrokerActive();
        AgentRegistrar.getAgentRegistrar().getTransactionMgr().rollbackPreparedXABranches(TIDs);
    }

    public void clearDuplicateDetectionData() throws Exception {
        this.validateState((short)3);
        this.validateBrokerActive();
        NoDupDetectDb.clearTransactionTable();
    }

    public ArrayList getGlobalQueueAdvertisements(String nodePrefix) throws MFException {
        this.validateState((short)3);
        this.validateBrokerActive();
        return AgentRegistrar.getAgentRegistrar().getRouterManager().getRouteForwarder().getGlobalQueueRoutes(nodePrefix);
    }

    public void deleteGlobalQueueAdvertisements(ArrayList globalQueueRoutes) throws MFException {
        if (globalQueueRoutes == null) {
            throw new IllegalArgumentException("null argument not supported");
        }
        this.validateState((short)3);
        this.validateBrokerActive();
        AgentRegistrar.getAgentRegistrar().getRouterManager().getRouteForwarder().deleteGlobalQueueRoutes(globalQueueRoutes);
    }

    public void clearGlobalQueueAdvertisements(String nodePrefix) throws MFException {
        this.validateState((short)3);
        this.validateBrokerActive();
        AgentRegistrar.getAgentRegistrar().getRouterManager().getRouteForwarder().clearGlobalQueueRoutes(nodePrefix);
    }

    public ArrayList getConnections(String userPrefix) throws MFException {
        this.validateState((short)3);
        this.validateBrokerActive();
        return AgentRegistrar.getAgentRegistrar().getConnections(userPrefix);
    }

    public ArrayList getConnectionTree(ArrayList nodes, Integer depth) throws MFException {
        return ConnectionOperationsHelper.getConnectionTree(nodes, depth);
    }

    public IConnectionMemberDetails getConnectionMemberDetails(Long ref) throws MFException {
        return ConnectionOperationsHelper.getConnectionMemberDetails(ref);
    }

    public ArrayList getConnectionMemberDetails(ArrayList refs) throws MFException {
        return ConnectionOperationsHelper.getConnectionMemberDetails(refs);
    }

    public void dropConnections(ArrayList connections) throws MFException {
        if (connections == null) {
            throw new IllegalArgumentException("null argument not supported");
        }
        this.validateState((short)3);
        this.validateBrokerActive();
        AgentRegistrar.getAgentRegistrar().dropConnections(connections);
    }

    public ArrayList getUsersWithDurableSubscriptions(String userPrefix) throws MFException {
        return DurableOperationsHelper.getUsersWithDurableSubscriptions(userPrefix);
    }

    public ArrayList getDurableSubscriptions(String user) throws MFException {
        return DurableOperationsHelper.getDurableSubscriptions(user);
    }

    public void deleteDurableSubscriptions(String user, ArrayList durableSubscriptions) throws MFException {
        DurableOperationsHelper.deleteDurableSubscriptions(user, durableSubscriptions);
    }

    public IBrowseToken createDurableBrowseTokenFromDSD(IDurableSubscriptionData dsd, Boolean isLocal) throws MFException {
        return DurableOperationsHelper.createDurableBrowseTokenFromDSD(dsd, isLocal);
    }

    private void loadDebugCallbacks() {
        m_debugCallbackInfoSize = 0;
        String debugProp = System.getProperty("sonicsw.mf.qa");
        if (debugProp != null) {
            Method method = null;
            try {
                method = BrokerComponent.class.getMethod("invokeDebug", ArrayList.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            BrokerComponent.DEBUG_CALLBACK_INFO[BrokerComponent.m_debugCallbackInfoSize++] = InfoFactory.createOperationInfo((String)"invoke debug callback", (Method)method);
        }
    }

    private void createAuthenticationSPI(Properties props) {
        ExternalDomainAuthSPIConfig externalDomainAuthSPIConfig = (ExternalDomainAuthSPIConfig)props.get("ExternalDomainAuthSpiConfig");
        AgentRegistrar.setExternalDomainAuthSPIConfig(externalDomainAuthSPIConfig);
        AgentRegistrar.initAuthenticationSPI();
        props.remove("ExternalDomainAuthSpiConfig");
    }

    public IBrowseToken createDurableBrowseToken(String userId, String jmsClientId, String uniqueName, Boolean isConnectionConsumer, Boolean local) throws MFException {
        return DurableOperationsHelper.createDurableBrowseToken(userId, jmsClientId, uniqueName, isConnectionConsumer, local);
    }

    public ArrayList getBrowseMessages(IBrowseToken ibt, Integer maxMessages) throws MFException {
        return DurableOperationsHelper.getBrowseMessages(ibt, maxMessages);
    }

    public void trimMessages(IBrowseToken ibt, Long dateTime) throws MFException {
        DurableOperationsHelper.trimMessages(ibt, dateTime);
    }

    public void setBrowseInactiveTimeout(IBrowseToken bt, Integer timeout) throws MFException {
        if (bt == null) {
            throw new IllegalArgumentException("Invalid IBrowseToken");
        }
        if (timeout == null || timeout < 0) {
            throw new IllegalArgumentException("Invalid Integer");
        }
        if (RuntimeDataFactory.getBrowseTokenTracking(bt).startsWith("$PQBR$")) {
            this.validateState((short)3);
            this.validateBrokerActive();
            long clientId = RuntimeDataFactory.getBrowseTokenClientId(bt);
            AgentRegistrar.getAgentRegistrar().getQueueProc().getRoutingQueue().setBrowserInactiveTimeout(clientId, timeout);
        } else {
            DurableOperationsHelper.setBrowseInactiveTimeout(bt, timeout);
        }
    }

    public IMessage getMessage(IMessageHeaderToken ht) throws MFException {
        return DurableOperationsHelper.getMessage(ht);
    }

    public void removeMessage(IMessageHeaderToken ht) throws MFException {
        DurableOperationsHelper.removeMessage(ht);
    }

    public IMessageHeader searchMessage(IMessageHeaderToken ht) throws MFException {
        return DurableOperationsHelper.searchMessage(ht);
    }

    public IMessageHeaderToken createDurableMessageHeaderToken(String userId, String jmsClientId, String uniqueName, Boolean isConnectionConsumer, String messageId) throws MFException {
        return DurableOperationsHelper.createDurableMessageHeaderToken(userId, jmsClientId, uniqueName, isConnectionConsumer, messageId);
    }

    public IMessageHeaderToken createDurableMessageHeaderTokenDSD(IDurableSubscriptionData dsd, String messageId) throws MFException {
        return DurableOperationsHelper.createDurableMessageHeaderTokenDSD(dsd, messageId);
    }

    public void closeBrowser(IBrowseToken token) throws MFException {
        if (token == null) {
            throw new IllegalArgumentException("Invalid IBrowseToken");
        }
        if (RuntimeDataFactory.getBrowseTokenTracking(token).startsWith("$PQBR$")) {
            this.validateState((short)3);
            this.validateBrokerActive();
            AgentRegistrar.getAgentRegistrar().getQueueProc().getRoutingQueue().closeBrowser(RuntimeDataFactory.getBrowseTokenClientId(token));
        } else {
            DurableOperationsHelper.closeBrowser(token);
        }
    }

    public ArrayList getRemoteSubscriptionSummary(String nodePattern) throws MFException {
        this.validateState((short)3);
        this.validateBrokerActive();
        return RemoteSubscriptionHelper.getRemoteSubscriptionSummary(nodePattern);
    }

    public ArrayList getRemoteSubscriptionSummary(String nodePattern, Boolean getAllNodes) throws MFException {
        this.validateState((short)3);
        this.validateBrokerActive();
        return RemoteSubscriptionHelper.getRemoteSubscriptionSummary(nodePattern, getAllNodes);
    }

    public ArrayList getRemoteSubscriptionTopics(String node, String topicPattern) throws MFException {
        this.validateState((short)3);
        this.validateBrokerActive();
        return RemoteSubscriptionHelper.getRemoteSubscriptionTopics(node, topicPattern);
    }

    public void deleteRemoteSubscriptions(ArrayList remoteNodes) throws MFException {
        if (remoteNodes == null) {
            throw new IllegalArgumentException("null argument not supported");
        }
        this.validateState((short)3);
        this.validateBrokerActive();
        RemoteSubscriptionHelper.deleteRemoteSubscriptions(remoteNodes);
    }

    public void reconcileRemoteSubscriptions(ArrayList remoteNodes) throws MFException {
        if (remoteNodes == null) {
            throw new IllegalArgumentException("null argument not supported");
        }
        this.validateState((short)3);
        this.validateBrokerActive();
        RemoteSubscriptionHelper.reconcileRemoteSubscriptions(remoteNodes);
    }

    public void activateWaitingBroker() throws MFException {
        this.validateState((short)3);
        ReplicationOperationsHelper.activateWaitingBroker();
    }

    public Integer getReplicationState() throws MFException {
        if (this.m_state != 3) {
            return new Integer(7);
        }
        return ReplicationOperationsHelper.getReplicationState();
    }

    public String getReplicationStateString() throws MFException {
        if (this.m_state != 3) {
            return ReplicationState.getReplicationStateString(7);
        }
        return ReplicationOperationsHelper.getReplicationStateString();
    }

    public String[] getReplicationConnections() throws MFException {
        this.validateState((short)3);
        return ReplicationOperationsHelper.getReplicationConnections();
    }

    public Integer getReplicationConnectionState(String name) throws MFException {
        this.validateState((short)3);
        return ReplicationOperationsHelper.getReplicationConnectionState(name);
    }

    public String getReplicationConnectionStateString(String name) throws MFException {
        this.validateState((short)3);
        return ReplicationOperationsHelper.getReplicationConnectionStateString(name);
    }

    public String getReplicationType() throws MFException {
        return ReplicationOperationsHelper.getReplicationType();
    }

    public String[] getCRLList() throws MFException {
        this.validateState((short)3);
        return CRLCachePolicy.getCAList();
    }

    public void forceCRLUpdate(String distributionPoint) throws MFException {
        this.validateState((short)3);
        CRLCachePolicy.forceCRLUpdate(distributionPoint);
    }

    public synchronized void initMessageStore(Short action) throws Exception {
        this.initMessageStore(action, true, true);
    }

    public synchronized void initDuplicateDetectionStore(Short action) throws Exception {
        this.initMessageStore(action, true, false);
    }

    private synchronized void initMessageStore(Short action, boolean transactionTable, boolean basicDBTables) throws Exception {
        String mbeanOp;
        if (action == null) {
            throw new IllegalArgumentException("null argument not supported");
        }
        int actionValue = action.intValue();
        if (actionValue < 0 || actionValue > 3) {
            throw new IllegalArgumentException("init action must be >= 0 and <=3");
        }
        this.validateState((short)1);
        String actionType = "UNKNOWN";
        boolean actionOk = false;
        switch (actionValue) {
            case 0: {
                actionType = "CREATE";
                actionOk = true;
                break;
            }
            case 1: {
                actionType = "RECREATE";
                actionOk = true;
                break;
            }
            case 2: {
                actionType = "DELETE";
                actionOk = true;
                break;
            }
            case 3: {
                actionType = "UPGRADE";
                actionOk = true;
            }
        }
        String string = mbeanOp = transactionTable && !basicDBTables ? "duplicate detection tables" : "message store/recovery logs";
        if (actionOk) {
            String msg = MessageFormat.format(prAccessor.getString("INITIALIZE_BROKER_ACTION"), mbeanOp, actionType);
            this.m_context.logMessage(msg, 3);
            InitBrokerDatabase ibd = new InitBrokerDatabase();
            try {
                ibd.setAction(actionType);
                ibd.setTransactionTable(transactionTable);
                ibd.setBasicDBTables(basicDBTables);
                ibd.setContext(this.m_context);
                ibd.setProps(this.m_props);
                ibd.execute();
            }
            catch (Exception e) {
                this.m_context.logMessage(prAccessor.getString("MSG_STORE_INITIALIZATION_FAILURE"), (Throwable)e, 2);
                throw e;
            }
        } else {
            throw new IllegalArgumentException("Invalid initialize action: " + action);
        }
        this.m_context.logMessage(prAccessor.getString("MSG_STORE_INITIALIZATION_SUCCESS"), 3);
    }

    public synchronized void syncMessageStore(String sourceWorkingDir) {
        this.validateState((short)1);
        SyncBrokerDatabase sbd = new SyncBrokerDatabase(m_componentContext, this.m_props, sourceWorkingDir);
        try {
            sbd.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void validateState(short requiredState) {
        if (this.m_state != requiredState) {
            throw new IllegalStateException("The broker must be " + IComponentState.STATE_TEXT[requiredState].toLowerCase() + " to invoke the requested operation");
        }
    }

    void validateBrokerActive() throws BrokerNotActiveException {
        BrokerStateManager bsm = BrokerStateManager.getBrokerStateManager();
        int bsmState = bsm.getState();
        switch (bsmState) {
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        throw new BrokerNotActiveException();
    }

    private boolean wasAddedToCluster(IDeltaAttributeSet atts) {
        try {
            String[] newAtts = atts.getNewAttributesNames();
            for (int i = 0; i < newAtts.length; ++i) {
                if (!newAtts[i].equals("CONFIG_ELEMENT_REFERENCES")) continue;
                IAttributeSet configRefAtts = (IAttributeSet)atts.getNewValue("CONFIG_ELEMENT_REFERENCES");
                return configRefAtts.getAttribute("CLUSTER_CONFIG_ELEMENT_REF") != null;
            }
            String[] modAtts = atts.getModifiedAttributesNames();
            for (int i = 0; i < modAtts.length; ++i) {
                if (!modAtts[i].equals("CONFIG_ELEMENT_REFERENCES")) continue;
                Object confObject = atts.getNewValue("CONFIG_ELEMENT_REFERENCES");
                if (confObject instanceof IDeltaAttributeSet) {
                    String[] newRefAtts = ((IDeltaAttributeSet)confObject).getNewAttributesNames();
                    for (int j = 0; j < newRefAtts.length; ++j) {
                        if (!newRefAtts[i].equals("CLUSTER_CONFIG_ELEMENT_REF")) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public synchronized void handleElementChange(IElementChange elementChange) {
        if (elementChange.getChangeType() == 3) {
            this.m_reloadRequired = true;
            if (!this.m_reloadRequiredMsgLogged) {
                m_componentContext.logMessage(prAccessor.getString("BROKER_CONFIGURATION_REPLACED"), 2);
                this.m_reloadRequiredMsgLogged = true;
            }
            return;
        }
        if (this.m_reloadRequired) {
            m_componentContext.logMessage(prAccessor.getString("RELOAD_BROKER_FOR_UPDATES"), 2);
            return;
        }
        String configID = elementChange.getElement().getIdentity().getName();
        if (configID.equals(this.m_configID)) {
            if (elementChange.getChangeType() == 1) {
                IDeltaElement changes = (IDeltaElement)elementChange.getElement();
                IDeltaAttributeSet attrs = (IDeltaAttributeSet)changes.getDeltaAttributes();
                if (this.m_broker != null && this.getState() == 3 && this.wasAddedToCluster(attrs)) {
                    String msg = MessageFormat.format(prAccessor.getString("BROKER_ADDED_TO_CLUSTER"), BrokerComponent.getBrokerComponent().getBrokerName());
                    m_componentContext.logMessage(msg, 2);
                }
            }
            if (this.m_broker != null && this.getState() == 3) {
                m_componentContext.fireAttributeChangeHandlers();
            }
            LGConfigChangeHandler.handleLGConfigurationChange(m_componentContext, elementChange);
            return;
        }
        String elementType = elementChange.getElement().getIdentity().getType();
        if (!(elementType.equals("MQ_ACCEPTORS") || elementType.startsWith("MQ_ACCEPTOR_") || this.m_broker != null && this.getState() == 3)) {
            return;
        }
        if (this.getSecurityEnabled().booleanValue() && configID.startsWith(this.m_attributesHolder.getUserDomainName()) && elementChange.getChangeType() == 0) {
            UserConfigChangeHelper.handleConfigurationChange(this.m_context, elementChange, configID, this.m_broker, this.m_bindHelper);
        } else if (this.getSecurityEnabled().booleanValue() && configID.startsWith(this.m_attributesHolder.getGroupDomainName())) {
            GroupConfigChangeHelper.handleConfigurationChange(this.m_context, elementChange, configID, this.m_broker, this.m_bindHelper);
        } else if (this.getSecurityEnabled().booleanValue() && configID.startsWith(this.m_attributesHolder.getACLDomainName()) && (elementChange.getChangeType() == 0 || elementChange.getChangeType() == 3)) {
            ACLConfigChangeHelper.handleConfigurationChange(this.m_context, elementChange, configID, this.m_bindHelper);
        } else if (this.getSecurityEnabled().booleanValue() && configID.startsWith(this.m_attributesHolder.getQoPDomainName()) && (elementChange.getChangeType() == 0 || elementChange.getChangeType() == 3)) {
            QoPConfigChangeHelper.handleConfigurationChange(this.m_context, elementChange, configID, this.m_bindHelper);
        } else if (elementChange.getChangeType() != 0) {
            if (elementChange.getChangeType() == 1) {
                m_componentContext.fireAttributeChangeHandlers();
            } else if (elementChange.getChangeType() == 2) {
                m_componentContext.fireAttributeChangeHandlers();
            } else if (elementChange.getChangeType() == 3) {
                // empty if block
            }
        }
    }

    public static IComponentContext getComponentContext() {
        return m_componentContext;
    }

    public static void logMessage(String s, Integer level) {
        m_componentContext.logMessage(s, level.intValue());
    }

    public static void logMessage(String s, Throwable t, Integer level) {
        m_componentContext.logMessage(s, t, level.intValue());
    }

    public static void logMessage(Throwable t, Integer level) {
        m_componentContext.logMessage(t, level.intValue());
    }

    public static Integer getLevelUnknown() {
        return new Integer(0);
    }

    public static Integer getLevelSevere() {
        return new Integer(1);
    }

    public static Integer getLevelWarning() {
        return new Integer(2);
    }

    public static Integer getLevelInfo() {
        return new Integer(3);
    }

    public static Integer getLevelConfig() {
        return new Integer(4);
    }

    public static Integer getLevelTrace() {
        return new Integer(7);
    }

    public static Integer getLevelFine() {
        return new Integer(5);
    }

    public static Integer getLevelFiner() {
        return new Integer(6);
    }

    public static Integer getLevelFinest() {
        return new Integer(7);
    }

    public ConfigurationChangeBindHelper getChangeBindHelper() {
        return this.m_bindHelper;
    }

    public Integer getMetricsRefreshInterval() {
        return new Integer((int)(BrokerMetricsHelper.getMetricsRefreshInterval() / 1000L));
    }

    public synchronized void setMetricsRefreshInterval(Integer seconds) throws MFException {
        if (seconds == null) {
            throw new IllegalArgumentException("null argument not supported");
        }
        BrokerMetricsHelper.setMetricsRefreshInterval(seconds.longValue() * 1000L);
    }

    public Integer getMetricsCollectionInterval() {
        return new Integer((int)(BrokerMetricsHelper.getMetricsCollectionInterval() / 60000L));
    }

    public synchronized void setMetricsCollectionInterval(Integer minutes) throws MFException {
        if (minutes == null) {
            throw new IllegalArgumentException("null argument not supported");
        }
        BrokerMetricsHelper.setMetricsCollectionInterval(minutes.longValue() * 60000L);
    }

    public String getBrokerName() {
        return (String)this.m_props.get("BROKER_NAME");
    }

    public String getRoutingNodeName() {
        return Config.ROUTING_NODE_NAME;
    }

    public Boolean getSecurityEnabled() {
        return new Boolean(Config.ENABLE_SECURITY);
    }

    private CipherSuiteInfo getCipherSuiteInfo(IComponentContext context) {
        IAttributeSet cipherAttSet;
        CipherSuiteInfo cipherSuiteInfo = null;
        IElement configuration = context.getConfiguration(true);
        IAttributeSet dirAttSet = null;
        String type = configuration.getIdentity().getType();
        if (type.equals(BACKUP_CONFIG_TYPE)) {
            IAttributeSet bdas = configuration.getAttributes();
            IAttributeSet bcers = (IAttributeSet)bdas.getAttribute("CONFIG_ELEMENT_REFERENCES");
            Reference pref = (Reference)bcers.getAttribute("PRIMARY_CONFIG_ELEMENT_REF");
            String pCID = pref.getElementName();
            configuration = context.getConfiguration(pCID, true);
        }
        if ((cipherAttSet = (IAttributeSet)(dirAttSet = configuration.getAttributes()).getAttribute("CIPHER_SUITE_INFO")) != null) {
            AttributeName name = new AttributeName("USE_SONIC_SUITE");
            Boolean isSonicCipherSuite = (Boolean)cipherAttSet.getAttribute(name);
            if (isSonicCipherSuite == null) {
                isSonicCipherSuite = Boolean.TRUE;
            }
            if (isSonicCipherSuite.booleanValue()) {
                cipherSuiteInfo = SonicCipherSuite.getInstance().getCipherSuiteInfo();
            } else {
                name = new AttributeName("CIPHER");
                String cipher = (String)cipherAttSet.getAttribute(name);
                name = new AttributeName("DIGEST");
                String digest = (String)cipherAttSet.getAttribute(name);
                if (digest == null) {
                    digest = "MD5";
                }
                try {
                    String[] cipherAndKeySize = AbstractCipherSuite.getTransformationAndKeySize(cipher);
                    if (cipherAndKeySize == null || cipherAndKeySize.length == 0 || cipherAndKeySize[0] == null) {
                        throw new Exception();
                    }
                    cipher = cipherAndKeySize[0];
                    String s = cipherAndKeySize[1];
                    int keySize = 0;
                    if (s != null) {
                        keySize = Integer.parseInt(s);
                    }
                    IPluggableCipherSuite suite = AbstractCipherSuite.getCipherSuiteInstance(null, null, cipher, keySize, null, null, digest);
                    cipherSuiteInfo = suite.getCipherSuiteInfo();
                }
                catch (Exception ex) {
                    try {
                        String errorMsg = ex.getMessage() + ". Cipher: " + cipher + ". Digest: " + digest;
                        this.abort(errorMsg, ex, 1);
                    }
                    catch (EBrokerAborted e) {}
                }
            }
        } else {
            cipherSuiteInfo = SonicCipherSuite.getInstance().getCipherSuiteInfo();
        }
        if (cipherSuiteInfo == null) {
            AgentRegistrar.setBadCipherConfiguration(true);
        }
        return cipherSuiteInfo;
    }

    public String getClusterName() {
        String clusterName = (String)this.m_props.get("CLUSTER_NAME");
        if (clusterName == null) {
            return "";
        }
        return clusterName;
    }

    public static boolean isManagementSubject(String subject) {
        return subject.startsWith("SonicMQ.mf.");
    }

    public static boolean isManagementAppId(String appId) {
        return appId.indexOf("SonicMQ/mf/") > 0;
    }

    public void invokeDebug(ArrayList invokeSpec) throws MFException {
        DebugInvokeHelper.invokeDebug(invokeSpec);
    }

    public Hashtable getPeerInfoTable() {
        Hashtable peerInfoTable = null;
        peerInfoTable = (Hashtable)this.m_props.get("PEER_INFO_HASHTABLE");
        return peerInfoTable;
    }

    public void setPeerInfoTable(Hashtable peerInfoTable) {
        Hashtable h = (Hashtable)this.m_props.get("PEER_INFO_HASHTABLE");
        if (h == null) {
            this.m_props.put("PEER_INFO_HASHTABLE", peerInfoTable);
        }
    }

    public Properties getProperties() {
        return this.m_props;
    }

    public FTPairPeerInfoHolder getPeerInfoHolder(String peerBrokerName) {
        if (peerBrokerName == null) {
            return null;
        }
        Hashtable peerInfoTable = null;
        FTPairPeerInfoHolder holder = null;
        peerInfoTable = (Hashtable)this.m_props.get("PEER_INFO_HASHTABLE");
        if (peerInfoTable != null) {
            holder = (FTPairPeerInfoHolder)peerInfoTable.get(peerBrokerName);
        }
        return holder;
    }

    public Boolean refreshSecurity(String prefix) throws MFException {
        if (!Config.ENABLE_SECURITY) {
            return Boolean.FALSE;
        }
        this.validateState((short)3);
        this.validateBrokerActive();
        try {
            return new Boolean(Broker.getBroker().getSecurityCache().updateExternalUsers(null));
        }
        catch (Exception e) {
            Object[] obj = new Object[]{" "};
            String s = prMessageFormat.format(progress.message.broker.prAccessor.getString("STR363"), obj);
            s = s + " : " + e.getMessage();
            BrokerComponent.getComponentContext().logMessage(s, 2);
            return Boolean.FALSE;
        }
    }

    public String[] getExternalUsers(String prefix) throws MFException {
        if (!Config.ENABLE_SECURITY) {
            return null;
        }
        this.validateState((short)3);
        this.validateBrokerActive();
        try {
            return Broker.getBroker().getSecurityCache().getExternalUsers();
        }
        catch (Exception e) {
            Object[] obj = new Object[]{" "};
            String s = prMessageFormat.format(progress.message.broker.prAccessor.getString("STR363"), obj);
            s = s + " : " + e.getMessage();
            BrokerComponent.getComponentContext().logMessage(s, 2);
            return null;
        }
    }

    public ArrayList getReliableReceiveSequences() throws MFException {
        this.validateState((short)3);
        this.validateBrokerActive();
        return ReliableSequenceHelper.getReliableReceiveSequences();
    }

    public ArrayList getReliableSendSequences() throws MFException {
        this.validateState((short)3);
        this.validateBrokerActive();
        return ReliableSequenceHelper.getReliableSendSequences();
    }

    public void cancelReliableSequences(ArrayList ids) throws MFException {
        if (ids == null) {
            throw new IllegalArgumentException("null argument not supported");
        }
        this.validateState((short)3);
        this.validateBrokerActive();
        ReliableSequenceHelper.cancelReliableSequences(ids);
    }

    public void handleFileChange(IFSElementChange change) {
        AgentRegistrar.getAgentRegistrar();
        if (AgentRegistrar.getWSDLCache() != null) {
            AgentRegistrar.getAgentRegistrar();
            AgentRegistrar.getWSDLCache().onFileUpdate(change.getLogicalPath());
        }
    }

    public void startDBCompact() {
        this.doCompact(".");
    }

    public void startDBCompactWorkdir(String workDir) {
        this.doCompact(workDir);
    }

    private void doCompact(final String workDir) {
        this.validateState((short)1);
        this.ibd = new InitBrokerDatabase();
        this.ibd.setContext(this.m_context);
        this.ibd.setProps(this.m_props);
        Thread compactThread = new Thread(new Runnable(){

            @Override
            public void run() {
                BrokerComponent.this.ibd.compactDatabase(workDir);
            }
        });
        compactThread.start();
    }

    public void stopDBCompact() {
        if (this.ibd != null) {
            this.ibd.stopDBCompact();
        }
    }

    public Integer getDBCompactState() throws MFException {
        return CompactStatusMonitor.getStatus().getId();
    }

    public String getDBCompactStateString() throws MFException {
        return CompactStatusMonitor.getStatus().getName();
    }

    public ArrayList getSubscribers(String connectId, String userId) throws MFException {
        if (connectId == null) {
            throw new IllegalArgumentException("null argument not supported");
        }
        this.validateState((short)3);
        this.validateBrokerActive();
        return AgentRegistrar.getAgentRegistrar().getConnectedSubscribers(connectId, userId);
    }

    public ArrayList getSubscribers(Long ref) throws MFException {
        if (ref == null) {
            throw new IllegalArgumentException("null argument not supported");
        }
        this.validateState((short)3);
        this.validateBrokerActive();
        return AgentRegistrar.getAgentRegistrar().getConnectedSubscribers(ref);
    }

    public ArrayList getSubscribers(ArrayList refs) throws MFException {
        if (refs == null) {
            throw new IllegalArgumentException("null argument not supported");
        }
        this.validateState((short)3);
        this.validateBrokerActive();
        ArrayList<ArrayList<ISubscriberData>> result = new ArrayList<ArrayList<ISubscriberData>>();
        for (Long ref : refs) {
            ArrayList<ISubscriberData> subscriptions = null;
            if (ref != null) {
                subscriptions = AgentRegistrar.getAgentRegistrar().getConnectedSubscribers(ref);
            }
            result.add(subscriptions);
        }
        return result;
    }

    public void enableAcceptors(String acceptorName) throws MFException {
        this.validateState((short)3);
        Broker.getBroker().startAcceptors(acceptorName);
    }

    public void disableAcceptors(String acceptorName, Boolean dropConnections) throws MFException {
        this.validateState((short)3);
        Broker.getBroker().stopAcceptors(acceptorName, dropConnections);
    }

    public ArrayList getAcceptors(String acceptorNamePrefix) throws MFException {
        this.validateState((short)3);
        this.validateBrokerActive();
        return Broker.getBroker().getAcceptors(acceptorNamePrefix);
    }

    static {
        DEBUG_CALLBACK_INFO = new IManagementInfo[1];
        m_debugCallbackInfoSize = 0;
        ATTRIBUTE_INFOS = new ArrayList();
        OPERATION_INFOS = new ArrayList();
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("BrokerName", String.class.getName(), "The configured broker name.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("RoutingNodeName", String.class.getName(), "The configured routing node name.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("ClusterName", String.class.getName(), "The name of the cluster to which the broker belongs (empty if the broker is not a member of a cluster).", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("SecurityEnabled", Boolean.class.getName(), "A flag indicating if the broker has security enabled.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("ReplicationState", Integer.class.getName(), ReplicationState.DESCRIPTION_STRING, true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("ReplicationStateString", String.class.getName(), "The current Replication State", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("ReplicationType", String.class.getName(), "PRIMARY or BACKUP", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("DBCompactState", Integer.class.getName(), "The current status of the database compaction operation (Not started, In progress, Failed)", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("DBCompactStateString", String.class.getName(), "The current status of the database compaction operation (Not started, In progress, Failed)", true, false, false));
        MBeanParameterInfo[] mbParamInfos = null;
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("prefix", String.class.getName(), "When specifed, filters the list of returned queues to those with a queue name starting with, or equal to, the given filter. If not specified (null or empty string), all queues will be returned.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getQueues", "Gets the set of queues known by this broker.<p>The list will potentially include all queue types (system, temporary, global and clusterwide).<p>The broker must be in an online state in order to invoke this operation.", mbParamInfos, ArrayList.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("prefix", String.class.getName(), "When specifed, filters the list of returned route statistics to those with a Remote node name starting with, or equal to, the given filter. If not specified (null or empty string), all queues will be returned.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getRoutingStatistics", "Gets a list of nodes that have outstanding messsage to be routed. The list will include IRouteStatistic objects.<p>An IRouteStatistic object may exist for the local node name. This will contain information for messages bound to other brokers in a cluster.<p>The broker must be in an online state in order to invoke this operation.", mbParamInfos, ArrayList.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("queues", ArrayList.class.getName(), "A list of queue names describing the queues to have their messages deleted.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("deleteQueueMessages", "Deletes all messages from the given list of queues currently managed by the broker.<p>The broker must be in an online state in order to invoke this operation.<p>If there are active senders to an applicable queue, then it is possble that calling getQueues(String) immediately after invoking this operation will not yield a message count of 0 (since further messages may have arrived).", mbParamInfos, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("prefix", String.class.getName(), "When specifed, filters the list of returned users to those with a user name starting with, or equal to, the given filter. If not specified (null or empty string), all users with durable subscriptions will be returned.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getUsersWithDurableSubscriptions", "Gets the set of users that have durable subscriptions. The list will include both connected and disconnected durable subscribers<p>The broker must be in an online state in order to invoke this operation.", mbParamInfos, ArrayList.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("user", String.class.getName(), "The user name for which the list of durable subscriptions will be returned.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getDurableSubscriptions", "Gets the set of durable subscriptions for the given user.<p>The broker must be in an online state in order to invoke this operation.", mbParamInfos, ArrayList.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("user", String.class.getName(), "The user for which applicable durable subscriptions will be deleted."), new MBeanParameterInfo("subscriptions", ArrayList.class.getName(), "A list of IDurableSubscriptionData objects describing the user subscriptions to delete. IDurableSubscriptionData objects are initially obtained by invoking getDurableSubscriptions(String) on this component. If no list is provided (null), then all durable subscriptions for the given user will be deleted.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("deleteDurableSubscriptions", "Deletes the subscriptions for the given a user and a list of durable subscriptions. If the user is currently connected and applicable durable subscriptions are active, then the operation will fail (return an exception) after having deleted inactive subscriptions for that user.<p>The broker must be in an online state in order to invoke this operation.", mbParamInfos, Void.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("getPreparedXABranches", "Gets the set of prepared XA branches.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, ArrayList.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("tIDs", Integer[].class.getName(), "The internal TIDs of the branches to commit.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("commitPreparedXABranches", "Commit the given set of prepared XA branches.", mbParamInfos, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("tIDs", Integer[].class.getName(), "The internal TIDs of the branches to rollback.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("rollbackPreparedXABranches", "Rollback the given set of prepared XA branches.", mbParamInfos, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("prefix", String.class.getName(), "When specifed, filters the list of returned advertisements to those with a node name starting with, or equal to, the given filter. If not specified (null or empty string), all advertisements will be returned.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getGlobalQueueAdvertisements", "Gets the set of global queue advertisements known by this broker.<p>The broker must be in an online state in order to invoke this operation.", mbParamInfos, ArrayList.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("prefix", String.class.getName(), "When specifed, clears the list of advertisements to those with a node name starting with, or equal to, the given filter. If not specified (null or empty string), all advertisements will be cleared.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("clearGlobalQueueAdvertisements", "Clears the global queue advertisements known by this broker.<p>The broker must be in an online state in order to invoke this operation.", mbParamInfos, ArrayList.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("advertisements", ArrayList.class.getName(), "A list of IGlobalQueueRouteData objects describing the advertisements to delete. IGlobalQueueRouteData objects are initially obtained by invoking getGlobalQueueAdvertisements(String) on this component.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("deleteGlobalQueueAdvertisements", "Deletes the given set of global queue advertisements known by this broker.<p>The broker must be in an online state in order to invoke this operation.", mbParamInfos, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("prefix", String.class.getName(), "When specifed, filters the list of returned connections to those with a user name starting with, or equal to, the given filter. If not specified (null or empty string), all connected clients will be returned.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getConnections", "Gets the set of current connections to this broker.<p>The broker must be in an online state in order to invoke this operation.", mbParamInfos, ArrayList.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("nodes", ArrayList.class.getName(), "An ArrayList of Longs, each representing a connection member reference id, for which to retrieve a connection sub-tree, or null to retrieve the whole tree."), new MBeanParameterInfo("depth", Integer.class.getName(), "The maximum depth of child nodes to retrieve.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getConnectionTree", "Gets full or partial tree of connection member information.  Exposes the hierachy of currently-connected connections, sessions, consumers, etc.<p> The result is an ArrayList of IConnectionTreeNode instances, one instance per requested node.  The ArrayList will contain a null element for any connection members that no longer exist. <p>The broker must be in an online state in order to invoke this operation.", mbParamInfos, ArrayList.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("ref", Long.class.getName(), "The connection member reference id for which to retrieve the member's details.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getConnectionMemberDetails", "Gets the details of the requested connection member.<p>The result will be null if the member reference id no longer exists.<p>The broker must be in an online state in order to invoke this operation.", mbParamInfos, IConnectionMemberDetails.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("refs", ArrayList.class.getName(), "An ArrayList of Longs, each representing a connection member reference id, for which to retrieve the member's details.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getConnectionMemberDetails", "Gets the details of the requested connection members.<p>The result is an ArrayList of IConnectionMemberDetails instances, one instance per requested member.  The ArrayList will contain a null element for any connection members that no longer exist.<p>The broker must be in an online state in order to invoke this operation.", mbParamInfos, ArrayList.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("connections", ArrayList.class.getName(), "A list of Long (connectionMemberRef) or IConnectionData objects identifying the client connections to drop. IConnectionData objects are initially obtained by invoking getConnections(String) on this component.  If the broker supports connectionMemberRef's (i.e. IConnectionData.getConnectionMemberRef() returns non-null) these Long values provide a more efficient means of identifying the connections.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("dropConnections", "Drops the given set of connections to this broker.<p>The broker must be in an online state in order to invoke this operation.", mbParamInfos, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("action", Short.class.getName(), "The initialize action to be taken. Possible values are: 0 - create the broker specific database tables, 1 - recreate the broker specific database tables, 2 - delete the broker specific database tables, 3 - upgrade from a prior version.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("initMessageStore", "(Re)Initialize the message store, recovery logs and duplicate transaction detection table (0 = Create, 1 = Recreate, 2 = Delete, 3 = Upgrade).<p>The broker must be in an offline state in order to invoke this operation.<p>In order to effect a broker name change, the broker should be stopped, have its database tables deleted, have its configured name changed, the database tables created and the broker restarted.", mbParamInfos, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("action", Short.class.getName(), "The initialize action to be taken. Possible values are: 0 - create the duplicate detection tables, 1 - recreate the duplicate detection tables, 2 - delete the broker duplicate detection tables, 3 - upgrade from a prior version.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("initDuplicateDetectionStore", "(Re)Initialize the duplicate transaction detection table (0 = Create, 1 = Recreate, 2 = Delete, 3 = Upgrade).<p>The broker must be in an offline state in order to invoke this operation.", mbParamInfos, Void.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("clearDuplicateDetectionData", "Remove the duplicate detection data from the duplicate detection store", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("userId", String.class.getName(), "The user that created the durable subscriber."), new MBeanParameterInfo("jmsClientId", String.class.getName(), "The JMS Client ID of the durable subscriber."), new MBeanParameterInfo("uniqueName", String.class.getName(), "The name used to identify this subscription."), new MBeanParameterInfo("isConnectionConsumer", Boolean.class.getName(), "True if this durable subscription is in use for a Connection Consumer."), new MBeanParameterInfo("local", Boolean.class.getName(), "True if this durable browser should only browse information on the local broker. False if this durable browser should browse all message for this durable subscription across the cluster.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("createDurableBrowseToken", "Create a durable browse token for durable operations.", mbParamInfos, IBrowseToken.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("dsd", IDurableSubscriptionData.class.getName(), "A reference to the IDurableSubscriptionData to be browsed."), new MBeanParameterInfo("isLocal", Boolean.class.getName(), "True if this durable browser should only browse information on the local broker. False if this durable browser should browse all message for this durable subscription across the cluster.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("createDurableBrowseTokenFromDSD", "Create a durable browse token for durable operations from a IDurableSubscriptionData.", mbParamInfos, IBrowseToken.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("ibt", IBrowseToken.class.getName(), "An IBrowseToken representing an active durable browser."), new MBeanParameterInfo("maxMessages", Integer.class.getName(), "The maximum number of messages to return.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getBrowseMessages", "Get the next set of messages for a durable browser.<p>The number of messages returned may be less than or equal to the maximum number specified.", mbParamInfos, ArrayList.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("bt", IBrowseToken.class.getName(), "An IBrowseToken that should timeout in at least the specified time."), new MBeanParameterInfo("timeout", Integer.class.getName(), "The amount of until a inactivity timeout occurs (in seconds).")};
        OPERATION_INFOS.add(new MBeanOperationInfo("setBrowseInactiveTimeout", "Set the browser inactivity timeout. Default is 15 minutes. After the given period of inactivity, the browser will remove any broker-side state information.  Any operation on the browse token after the inactivity period will result in an exception.", mbParamInfos, Void.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("ht", IMessageHeaderToken.class.getName(), "A IMessageHeaderToken that represents the javax.jms.Message to retrieve.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getMessage", "Retrieve a message from a durable subscriber.", mbParamInfos, IMessage.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("ht", IMessageHeaderToken.class.getName(), "An IMessageHeaderToken that represents the javax.jms.Message to remove.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("removeMessage", "Remove a message from a durable subscriber.", mbParamInfos, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("ht", IMessageHeaderToken.class.getName(), "An IMessageHeaderToken that represents the javax.jms.Message to retrieve.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("searchMessage", "Search for a message from a durable subscriber.", mbParamInfos, IMessageHeader.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("userId", String.class.getName(), "The user that created the durable subscriber."), new MBeanParameterInfo("jmsClientId", String.class.getName(), "The JMS Client ID of the durable subscriber."), new MBeanParameterInfo("uniqueName", String.class.getName(), "The name used to identify this subscription."), new MBeanParameterInfo("isConnectionConsumer", Boolean.class.getName(), "True if this durable subscription is in use for a Connection Consumer."), new MBeanParameterInfo("messageId", String.class.getName(), "The JMS MessageID of the message.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("createDurableMessageHeaderToken", "Create a message header token for use in other operations. A message header token represents a message in a specific durable subscription.", mbParamInfos, IMessageHeaderToken.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("dsd", IDurableSubscriptionData.class.getName(), "A reference to the IDurableSubscriptionData to be browsed."), new MBeanParameterInfo("messageId", String.class.getName(), "The JMS MessageID of the message.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("createDurableMessageHeaderTokenDSD", "Create a message header token for use in other operations from a IDurableSubscriptionData", mbParamInfos, IMessageHeaderToken.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("token", IBrowseToken.class.getName(), "The browse token representing a browser.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("closeBrowser", "Cleanup all state information associated with the given IBrowseToken.", mbParamInfos, Void.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("nodePattern", String.class.getName(), "Remote routing node names match prefix. Null or zero-length string matches all remote routing nodes names.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getRemoteSubscriptionSummary", "For each remote node, get remote subscription summary information (accepts optional node name filter).<p>For remote routing nodes whose name starts with an optional prefix, get summary information on all propagated subscriptions. Summary information is only returned for remote routing node names that match the prefix and that are propagating subscriptions.<p>Equivalent to <a href=\"IBrokerProxy.html#getRemoteSubscriptionSummary(java.lang.String, java.lang.Boolean)\"><code>getRemoteSubscriptionSummary(nodePrefix,Boolean.FALSE)</code></a>", mbParamInfos, ArrayList.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("node", String.class.getName(), "Name of remote routing node that is propagating remote subscriptions."), new MBeanParameterInfo("topicPattern", String.class.getName(), "Optional topic pattern in subject namespace syntax. Null, empty string and \"#\" match all topics.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getRemoteSubscriptionTopics", "Retrieves remote subscription topics for a given remote node and optional matching topic pattern.<p>For a given remote routing node name and topic pattern, retrieve propagated remote subscription topics that match the given topic pattern.", mbParamInfos, ArrayList.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("remoteNodes", ArrayList.class.getName(), "An array list of java.lang.String objects supplying names of remote routing nodes which are propagating subscriptions and for which propagated remote subscriptions deletion is required.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("deleteRemoteSubscriptions", "Deletes remote subscriptions propagated by given remote nodes.<p>Deletes propagated remote subscriptions within the routing node to which this broker is a member. Remote subscriptions propagated by specified remote routing nodes are deleted.", mbParamInfos, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("remoteNodes", ArrayList.class.getName(), "An array list of java.lang.String objects supplying names of remote routing nodes with which to bi-laterally reconcile remote subscriptions.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("reconcileRemoteSubscriptions", "Bi-laterally reconciles remote subscriptions with given remote nodes.<p>Bi-laterally reconciles remote subscriptions with given remote nodes. Reconciliation synchronizes propagated remote subscription information between nodes.", mbParamInfos, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("nodePattern", String.class.getName(), "Remote routing node names match prefix. Null or zero-length string matches all remote routing nodes names."), new MBeanParameterInfo("getAllNodes", Boolean.class.getName(), "If true, return subscription information for all configured routing nodes that match the node prefix including nodes that are not propagating subscriptions. If false, return subscription information for routing nodes that match the node prefix and that are propagating subscriptions.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getRemoteSubscriptionSummary", "Get all remote nodes, for each node, get remote subscription summary information (accepts optional node name filter).<p>For remote routing nodes whose name starts with an optional prefix, get summary information on all propagated remote subscriptions. Summary information is only returned for remote routing node names that match the prefix. Summary information will be returned for all configured remote routing nodes that match the prefix regardless of whether they are propagating subscriptions if the <code>getAllNodes</code> parameter is true.", mbParamInfos, ArrayList.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("sourceWorkingDir", String.class.getName(), "The source broker's container working directory as visible to broker on which the operation is invoked.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("syncMessageStore", "Synchronize the message store of this broker to that of its replicated peer.", mbParamInfos, Void.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("activateWaitingBroker", "Activate a broker in the WAITING state.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("getReplicationConnections", "Retrieve the names of defined replication connections.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, String[].class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("name", String.class.getName(), "The name of the replication connection.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getReplicationConnectionState", "Retrieve the current state of a replication connection.", mbParamInfos, Integer.class.getName(), 0));
        OPERATION_INFOS.add(new MBeanOperationInfo("getReplicationConnectionStateString", "Retrieve the name of the current state of a replication connection.", mbParamInfos, String.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("prefix", String.class.getName(), "Not implemented/used in this release.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("refreshSecurity", "This operation is used in the PASS feature. If a Broker is connected to an External Authentication Domain, then this operation can be invoked to get the list of external users cached by the broker. The broker must be in an online state in order to invoke this operation. Returns true if the operation was successful.", mbParamInfos, Boolean.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("getExternalUsers", "This operation is used in the PASS feature. If a Broker is connected to an External Authentication Domain, then this operation can be invoked to get the list of external users cached by the broker. The broker must be in an online state in order to invoke this operation. Returns a list of external users cached by the broker.", mbParamInfos, String[].class.getName(), 0));
        OPERATION_INFOS.add(new MBeanOperationInfo("getCRLList", "Return the names of all known CRLs.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, String[].class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("distributionPoint", String.class.getName(), "LDAP DN of the cached CRL.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("forceCRLUpdate", "Force immediate refresh of the cached CRL.", mbParamInfos, Void.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("getReliableSendSequences", "For each remote broker, get reliable send sequences.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, ArrayList.class.getName(), 0));
        OPERATION_INFOS.add(new MBeanOperationInfo("getReliableReceiveSequences", "For each remote broker, get reliable receive sequences.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, ArrayList.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("ids", ArrayList.class.getName(), "ArrayList of String sequence identifiers that identify reliable sequences to be cancelled.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("cancelReliableSequences", "Management operation that supports cancelling of Web Service Reliable Messaging sequences.<p>Reliable sequences are identified by a universally unique identifier(UUID). A UUID identifies either a reliable send sequence or a receive receive sequence.<p>Cancelling a send sequence includes standard JMS undelivered message processing for messages that have been produced by Sonic JMS clients for Web Service transmission and that are pending acknowledgement by the remote RM Destination.<p>If a JMS client sends messages after a send sequence has been cancelled, the fault 'Sequence terminated' or 'Unknown sequence' may be generated and standard JMS undelivered message processing applied.<p>Cancelling a receive sequence causes a Web Service Reliable Messaging sequence fault, 'Sequence terminated', to be sent to the remote RM Source; if additional messages are received from the RM Source, these will be faulted with 'Unknown sequence'.", mbParamInfos, Void.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("startDBCompact", "Start a database compaction operation on the broker.<p>The broker must be offline.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("workdir", String.class.getName(), "A relative path to be used as the location for temporary files.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("startDBCompactWorkdir", "Start a database compaction, specifying an alternate location for workfiles generated during the operation. This variant is useful if the current volume hosting the message store is near capacity. The workDir parameter is relative to working directory of the container hosting the broker.", mbParamInfos, Void.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("stopDBCompact", "Stop an in-progress db compact operation. If none is pending, it is a no-op.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("ibt", IBrowseToken.class.getName(), "An IBrowseToken representing an active durable browser."), new MBeanParameterInfo("dateTime", Long.class.getName(), "An Long value representing the trim time.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("trimMessages", "When a message is persisted for a durable subscription a timestamp is added indicating the time it was placed into the database. The trimMessages method allows callers to delete all messages stored prior to (and including) the date/time value provided for a specific durable subscription.", mbParamInfos, Void.class.getName(), 0));
        String debugProp = System.getProperty("sonicsw.mf.qa");
        if (debugProp != null) {
            mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("invokeSpec", ArrayList.class.getName(), "")};
            OPERATION_INFOS.add(new MBeanOperationInfo("invokeDebug", "invoke debug callback", mbParamInfos, Void.class.getName(), 1));
        }
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("connectId", String.class.getName(), "The connectId for which the list of subscribers will be returned."), new MBeanParameterInfo("userId", String.class.getName(), "The userId for which the list of subscribers will be returned,")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getSubscribers", "Gets the list of subscribers for the given connection.<p>The alternative overloadings that take connection member references are preferred, provided the broker supports connection member references (SonicMQ 8.0 or later). This overloading will likely be deprecated in a future release.", mbParamInfos, ArrayList.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("ref", Long.class.getName(), "The connection member reference id of a connection for which the list of subscribers should be returned.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getSubscribers", "Gets the list of subscribers for the given connection.<p>The result is an ArrayList of ISubscriberData instances. An empty list is returned if the connection has no subscribers, no longer exists, or does not represent a Connection.<p>The broker must be in an online state in order to invoke this operation.", mbParamInfos, ArrayList.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("refs", ArrayList.class.getName(), "An ArrayList of Longs, each representing the connection member reference id of a connection for which the list of subscribers should be returned.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getSubscribers", "Gets lists of subscribers for a batch of connections. When dealing with multiple connections this is more efficient than calling getSubscribers individually for each connection.<p>The result is an ArrayList of ArrayLists of ISubscriberData instances, one ArrayList per requested connection member.<p>With a large number of connections each with many subscribers (especially subscribers with large multi-topic destinations) it is possible the response could exceed the Management Broker's CONNECTION_TUNING_PARAMETERS.MAX_MSG_SIZE setting (default 10Mb), resulting in the request failing. In this case the Management Broker will log an EMsgTooBigException.  Where the total number of subscribers is expected to be a few thousand or so, applications should use this API for appropriately-sized batches of connections rather than requesting the subscribers for all connections in a single call.<p>The broker must be in an online state in order to invoke this operation.", mbParamInfos, ArrayList.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("routingNode", String.class.getName(), "The routing node to be browsed."), new MBeanParameterInfo("messageSelector", String.class.getName(), "The message selector to be applied.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("createRoutingQueueBrowser", "Create a routing queue browser for the pending queue of the specified routing node.<p>The broker must be in an online state in order to invoke this operation.", mbParamInfos, IBrowseToken.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("token", IBrowseToken.class.getName(), "An IBrowseToken representing a pending queue browser."), new MBeanParameterInfo("maxMessages", Integer.class.getName(), "The maximum number of messages to return.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("browseRoutingQueueMessages", "Get the next set of messages (IMessageHeader objects) for a pending queue browser.<p>If the end of the queue is reached the number of messages returned may be less than the maximum number specified.<p>The broker must be in an online state in order to invoke this operation.", mbParamInfos, ArrayList.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("tokens", ArrayList.class.getName(), "A list of IMessageHeaderToken objects describing messages to be deleted.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("deleteRoutingQueueMessages", "Deletes messages from the routing queue managed by the broker.<p>The broker must be in an online state in order to invoke this operation.", mbParamInfos, Integer.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("acceptorName", String.class.getName(), "The acceptor name.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("enableAcceptors", "Start the acceptor(s) with the specified name if not already started.", mbParamInfos, Void.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("acceptorName", String.class.getName(), "The acceptor name."), new MBeanParameterInfo("dropConnection", Boolean.class.getName(), "If true, drop the connections accepted by the given acceptor.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("disableAcceptors", "Stop the acceptor(s) with the specified name and optionally drop the connections accepted by the given acceptor.", mbParamInfos, Void.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("acceptorNamePrefix", String.class.getName(), "When specified, filters the result set those acceptors whose acceptor name starts with, or equals, the given prefix. If not specified (null or empty string), all the broker's acceptors are returned.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getAcceptors", "Invokes the getAcceptors operation.<p>Returns a list of IAcceptorData objects representing the current state of the broker's acceptors. Returns an empty list if no acceptors match the filtering criteria.<p>The broker must be in an online state in order to invoke this operation.", mbParamInfos, ArrayList.class.getName(), 0));
    }

    private class SdfMFTracingIntegration
    extends AbstractMFComponentTracing {
        private boolean m_updateTraceLevelWasCalled;

        SdfMFTracingIntegration() {
            super("sonic.mq.broker." + BrokerComponent.this.m_context.getComponentName().getComponentName().replace(' ', '_'), BrokerComponent.this.getTraceMaskValues());
            this.m_updateTraceLevelWasCalled = false;
        }

        public void initTraceMask() {
            this.setTraceMask(new Integer(BrokerComponent.this.m_traceMask));
        }

        boolean wasUpdated() {
            return this.m_updateTraceLevelWasCalled;
        }

        public void updateTraceLevel(String doiIDNotUsed, HashMap parameters, StringBuffer buffer) {
            super.updateTraceLevel(doiIDNotUsed, parameters, buffer);
            this.m_updateTraceLevelWasCalled = true;
            BrokerComponent.this.setTraceMask(this.getCurrentMask(), true);
        }
    }

    private class ShutdownThread
    extends DebugThread {
        private static final String NAME = "AbortStopThread ";
        private int m_flags;

        ShutdownThread(int shutdownFlags) {
            super(NAME);
            this.m_flags = shutdownFlags;
        }

        @Override
        public void threadMain() {
            BrokerComponent.this.stop(this.m_flags);
        }
    }
}

