/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import progress.message.net.ssl.CRLCachePolicy;

public class CRLCachePolicyChangeHandler
implements IAttributeChangeHandler {
    private CRLCachePolicy m_policy = null;

    public CRLCachePolicyChangeHandler(CRLCachePolicy policy) {
        this.m_policy = policy;
    }

    public void itemDeleted() {
        CRLCachePolicy.deletePolicy(this.m_policy.getDistributionPoint());
        this.m_policy = null;
    }

    public void itemModified(Object newValue) {
        if (newValue == null) {
            return;
        }
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] newAttributes = delta.getNewAttributesNames();
        int len = newAttributes.length;
        String attributeName = null;
        for (int i = 0; i < len; ++i) {
            attributeName = newAttributes[i];
            this.setAttribute(attributeName, delta);
        }
        String[] modifiedAttributes = delta.getModifiedAttributesNames();
        len = modifiedAttributes.length;
        attributeName = null;
        for (int i = 0; i < len; ++i) {
            attributeName = modifiedAttributes[i];
            this.setAttribute(attributeName, delta);
        }
        String[] deletedAttributes = delta.getDeletedAttributesNames();
        len = deletedAttributes.length;
        attributeName = null;
        for (int i = 0; i < len; ++i) {
            attributeName = deletedAttributes[i];
            if (attributeName.equals("PERIODIC_CACHE_REFRESH_TIME")) {
                CRLCachePolicy.updateRefreshInterval(this.m_policy.getDistributionPoint(), 86400L);
                continue;
            }
            if (!attributeName.equals("MAX_CACHE_LIFETIME")) continue;
            CRLCachePolicy.updateRefreshInterval(this.m_policy.getDistributionPoint(), -1L);
        }
    }

    private void setAttribute(String attributeName, IDeltaAttributeSet delta) {
        if (attributeName.equals("PERIODIC_CACHE_REFRESH_TIME")) {
            try {
                Long interval = (Long)delta.getNewValue(attributeName);
                if (interval != null) {
                    CRLCachePolicy.updateRefreshInterval(this.m_policy.getDistributionPoint(), interval);
                }
            }
            catch (NotModifiedAttException nmae) {}
        } else if (attributeName.equals("MAX_CACHE_LIFETIME")) {
            try {
                Long lifetime = (Long)delta.getNewValue(attributeName);
                if (lifetime != null) {
                    CRLCachePolicy.updateCacheLifetime(this.m_policy.getDistributionPoint(), lifetime);
                }
            }
            catch (NotModifiedAttException notModifiedAttException) {
                // empty catch block
            }
        }
    }
}

