/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mq.components.AttributesHolder;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.ConfigurationChangeBindHelper;
import com.sonicsw.mq.components.ExternalDomainAuthSPIConfig;
import com.sonicsw.mq.components.HttpProxyConfig;
import com.sonicsw.mq.components.ReplicationConnDef;
import com.sonicsw.mq.components.prAccessor;
import com.sonicsw.mq.mgmtapi.config.constants.IBrokerConstants;
import com.sonicsw.security.cert.BrokerCertificateStore;
import com.sonicsw.security.cert.BrokerKeyStore;
import com.sonicsw.security.cert.BrokerTrustStore;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import progress.message.broker.Acceptor;
import progress.message.broker.AcceptorHolder;
import progress.message.broker.BrokerLicenseMgr;
import progress.message.broker.Config;
import progress.message.broker.FTPairPeerInfoHolder;
import progress.message.broker.HTTPAcceptor;
import progress.message.broker.HTTPDirectInboundEntry;
import progress.message.broker.HTTPDirectInboundHolder;
import progress.message.broker.HTTPDirectInboundProtocolHolder;
import progress.message.broker.HTTPDirectOutboundEntry;
import progress.message.broker.HTTPDirectOutboundHolder;
import progress.message.broker.HTTPDirectOutboundProtocolHolder;
import progress.message.broker.HTTPSAcceptor;
import progress.message.broker.PeerInfoHolder;
import progress.message.broker.ProvisionMonitor;
import progress.message.broker.QueueHolder;
import progress.message.broker.RemoteSubscriptionHolder;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.broker.RoutingUserAclEntry;
import progress.message.broker.SSLAcceptor;
import progress.message.broker.SubjectAclEntry;
import progress.message.broker.TCPIPAcceptor;
import progress.message.net.ESocketConfigException;
import progress.message.net.ssl.CRLCachePolicy;
import progress.message.net.ssl.CRLStore;
import progress.message.net.ssl.LDAPCRLStore;
import progress.message.net.ssl.LDAPCRLStoreParameters;
import progress.message.resources.prMessageFormat;
import progress.message.security.EPermissionConflict;
import progress.message.security.EUnknownPermission;
import progress.message.security.SecurityCache;
import progress.message.util.DraDestUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.QueueUtil;
import progress.message.zclient.ProgressGroup;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.ProgressPrincipal;
import progress.message.zclient.QOP;
import progress.message.zclient.SessionConfig;

public abstract class ConfigPropertiesPopulator {
    private static final String MQ_LOCATION_PREFIX = "/_MQRuntime/location/";
    static final boolean DEBUG_PRINCIPAL = false;
    static final boolean DEBUG_ACL = false;
    static final boolean DEBUG_URL = false;
    private static final boolean DEBUG_ACCEPTOR = false;
    private static Map m_externalUsersToInternalGroup = Collections.synchronizedMap(new HashMap());
    private static Map m_externalGroupsToAdd = Collections.synchronizedMap(new HashMap());
    private static volatile Properties m_props;
    private static volatile ConfigurationChangeBindHelper s_bindHelper;
    private static boolean m_isLoadingFromDS;
    private static boolean s_isBackup;

    public static void loadPrimary(IComponentContext context, IElement configuration, Properties props, AttributesHolder attributesHolder, ConfigurationChangeBindHelper bindHelper) throws Exception {
        IAttributeSet ceas;
        IAttributeSet cdas;
        m_props = props;
        s_bindHelper = bindHelper;
        IAttributeSet bkdas = null;
        IAttributeSet das = configuration.getAttributes();
        IAttributeSet cers = (IAttributeSet)das.getAttribute("CONFIG_ELEMENT_REFERENCES");
        Reference aref = (Reference)cers.getAttribute("ACCEPTOR_CONFIG_ELEMENT_REF");
        String aCID = aref.getElementName();
        Reference qref = (Reference)cers.getAttribute("QUEUE_CONFIG_ELEMENT_REF");
        String qCID = qref.getElementName();
        Reference rref = (Reference)cers.getAttribute("ROUTING_CONFIG_ELEMENT_REF");
        String rCID = rref.getElementName();
        Reference gsref = (Reference)cers.getAttribute("GLOBAL_SUBSCRIPTIONS_CONFIG_ELEMENT_REF");
        String gsCID = gsref.getElementName();
        String[] configIDs = new String[]{aCID, qCID, rCID, gsCID};
        boolean[] changeFlags = new boolean[]{true, true, true, true};
        IElement[] configElems = context.getConfigurations(configIDs, changeFlags);
        IElement ace = configElems[0];
        IElement qce = configElems[1];
        IElement rce = configElems[2];
        IElement gsce = configElems[3];
        ConfigPropertiesPopulator.getBrokerUniqueConfig(configuration.getAttributes(), null, props, bindHelper);
        ConfigPropertiesPopulator.getPrimaryDebugConfig(configuration.getAttributes(), props);
        Config.loadDebugParameters(props);
        Reference bkref = (Reference)cers.getAttribute("BACKUP_CONFIG_ELEMENT_REF");
        if (bkref != null) {
            props.put("BACKUP_CONFIG_ELEMENT_REF", bkref);
            String bkCID = bkref.getElementName();
            IElement bkce = context.getConfiguration(bkCID, true);
            bkdas = bkce.getAttributes();
            ConfigPropertiesPopulator.getBackupPeerStorageSyncConfig(bkdas, props);
        }
        boolean isSecurityEnabled = false;
        String secEnabled = (String)props.get("ENABLE_SECURITY");
        if (secEnabled != null && "true".equalsIgnoreCase(secEnabled)) {
            isSecurityEnabled = true;
        }
        AttributeName an = new AttributeName("CLUSTER_CONFIG_ELEMENT_REF");
        Reference cr = (Reference)cers.getAttribute(an);
        IElement cce = null;
        if (cr != null) {
            String cCID = cr.getElementName();
            cce = context.getConfiguration(cCID, true);
        }
        boolean isClustered = false;
        if (cce != null) {
            isClustered = true;
            props.put("ENABLE_INTERBROKER", "true");
        } else {
            props.put("ENABLE_INTERBROKER", "false");
        }
        String brokerName = (String)props.get("BROKER_NAME");
        if (isClustered) {
            ConfigPropertiesPopulator.readClusterAttributes(cce, props, bindHelper);
        }
        ConfigPropertiesPopulator.getAcceptorConfig(context, ace, props, isClustered);
        if (bkdas != null) {
            ConfigPropertiesPopulator.getBackupPeerAcceptorConfig(context, bkdas, props, isClustered);
        }
        bindHelper.bindBrokerAcceptorChangeDelegator(brokerName, configuration);
        Reference rcref = (Reference)cers.getAttribute("REPLICATION_CONNECTIONS_ELEMENT_REF");
        if (rcref != null) {
            String rcCID = rcref.getElementName();
            IElement rcce = context.getConfiguration(rcCID, true);
            ConfigPropertiesPopulator.getReplicationConnectionConfig(context, rcce, props, bindHelper);
        }
        if (isClustered) {
            ConfigPropertiesPopulator.getClusterPeerInfo(context, cce, props, attributesHolder, bindHelper);
        }
        ConfigPropertiesPopulator.getQueueConfig(context, qce, props, isClustered, cce, attributesHolder);
        if (isClustered) {
            cdas = cce.getAttributes();
            an = new AttributeName("CONFIG_ELEMENT_REFERENCES");
            ceas = (IAttributeSet)cdas.getAttribute(an);
            an = new AttributeName("ROUTING_CONFIG_ELEMENT_REF");
            Reference rRef = (Reference)ceas.getAttribute(an);
            rCID = rRef.getElementName();
            rce = context.getConfiguration(rCID, true);
            ConfigPropertiesPopulator.getRoutingConfig(context, rce, props, isSecurityEnabled, attributesHolder, bindHelper);
        } else {
            ConfigPropertiesPopulator.getRoutingConfig(context, rce, props, isSecurityEnabled, attributesHolder, bindHelper);
        }
        ConfigPropertiesPopulator.setBrokerLocation(context, configuration.getIdentity().getName(), props, false);
        if (isClustered) {
            cdas = cce.getAttributes();
            ceas = (IAttributeSet)cdas.getAttribute("CONFIG_ELEMENT_REFERENCES");
            Reference gsRef = (Reference)ceas.getAttribute("GLOBAL_SUBSCRIPTIONS_CONFIG_ELEMENT_REF");
            gsCID = gsRef.getElementName();
            gsce = context.getConfiguration(gsCID, true);
            ConfigPropertiesPopulator.getGlobalSubscriptionConfig(context, gsce, props, bindHelper);
        } else {
            ConfigPropertiesPopulator.getGlobalSubscriptionConfig(context, gsce, props, bindHelper);
        }
        ConfigPropertiesPopulator.loadCertificateStore(cers, props);
        if (isSecurityEnabled) {
            IElement[] userConfigElements = null;
            IElement[] groupConfigElements = null;
            IElement[] aclConfigElements = null;
            IElement[] qopConfigElements = null;
            String usersDir = null;
            String groupsDir = null;
            String aclsDir = null;
            String qopsDir = null;
            IAttributeSet ceRefAS = null;
            if (isClustered) {
                IAttributeSet cdas2 = cce.getAttributes();
                an = new AttributeName("CONFIG_ELEMENT_REFERENCES");
                ceRefAS = (IAttributeSet)cdas2.getAttribute(an);
            } else {
                ceRefAS = cers;
            }
            String authenticationDomainDir = ConfigPropertiesPopulator.getAuthenticationDomainDir(ceRefAS, context);
            usersDir = authenticationDomainDir + "_MFUsers";
            userConfigElements = context.getConfigurations(usersDir, true);
            groupsDir = authenticationDomainDir + "_MFGroups";
            groupConfigElements = context.getConfigurations(groupsDir, true);
            String authorizationPolicyDir = ConfigPropertiesPopulator.getAuthorizationPolicyDir(ceRefAS, context);
            qopsDir = authorizationPolicyDir + "_MQQoPs";
            qopConfigElements = context.getConfigurations(qopsDir, true);
            aclsDir = authorizationPolicyDir + "_MQACLs";
            aclConfigElements = context.getConfigurations(aclsDir, true);
            attributesHolder.setUserDomainName(usersDir);
            attributesHolder.setGroupDomainName(groupsDir);
            attributesHolder.setACLDomainName(aclsDir);
            attributesHolder.setQoPDomainName(qopsDir);
            Hashtable<String, ProgressPrincipal> principals = new Hashtable<String, ProgressPrincipal>();
            ConfigPropertiesPopulator.getPrincipals(context, userConfigElements, groupConfigElements, principals, props, attributesHolder, bindHelper);
            ConfigPropertiesPopulator.getExternalSecurityDomainInfo(usersDir, context, props, bindHelper);
            int size = 2 * principals.size();
            Hashtable<String, Vector<SubjectAclEntry>> subjectACLs = null;
            subjectACLs = size > 0 ? new Hashtable(size) : new Hashtable<String, Vector<SubjectAclEntry>>();
            Hashtable<String, Vector<RoutingUserAclEntry>> routingACLs = new Hashtable<String, Vector<RoutingUserAclEntry>>();
            ConfigPropertiesPopulator.getACLs(context, aclConfigElements, props, principals, subjectACLs, routingACLs, attributesHolder, bindHelper);
            String qopSecEnabled = (String)props.get("ENABLE_QOP_SECURITY");
            Hashtable<String, QOP> qops = null;
            if ("true".equalsIgnoreCase(qopSecEnabled)) {
                qops = new Hashtable<String, QOP>();
                ConfigPropertiesPopulator.getQoPs(context, qopConfigElements, qops, attributesHolder, bindHelper);
            }
            SecurityCache cache = new SecurityCache(principals, subjectACLs, routingACLs, qops);
            ConfigPropertiesPopulator.addExternalUsersToInternalGroups(cache);
            ConfigPropertiesPopulator.addExternalGroup(cache);
            props.put("SECURITY_CACHE", cache);
        }
        m_isLoadingFromDS = false;
    }

    private static void setBrokerLocation(IComponentContext context, String brokerConfigId, Properties props, boolean isBackup) throws Exception {
        String configID = MQ_LOCATION_PREFIX + props.getProperty("ROUTING_NODE_NAME") + "/" + props.getProperty("BROKER_NAME") + (isBackup ? "/backup" : "/primary");
        IDirElement element = ElementFactory.createElement((String)configID, (String)"MQ_RUNTIME_LOCATION", (String)"1.0");
        IAttributeSet attrs = element.getAttributes();
        String privateHost = System.getProperty("sonicsw.mf.privateHost");
        if (privateHost == null || privateHost.length() == 0) {
            throw new EAssertFailure("\"sonicsw.mf.privateHost\" has not been determined");
        }
        String publicHost = System.getProperty("sonicsw.mf.publicHost");
        if (publicHost == null) {
            publicHost = "";
        }
        attrs.setStringAttribute("BROKER_CONFIG_ELEMENT_REF", brokerConfigId);
        attrs.setStringAttribute("PRIVATE_HOSTNAME", privateHost);
        attrs.setStringAttribute("PUBLIC_HOSTNAME", publicHost);
        context.setRuntimeConfiguration(element);
    }

    private static String getAuthenticationDomainDir(IAttributeSet as, IComponentContext context) {
        String authDir = null;
        Reference ddRef = (Reference)as.getAttribute("AUTHENTICATION_DOMAIN_CONFIG_ELEMENT_REF");
        String ddCID = ddRef.getElementName();
        IElement ddCE = context.getConfiguration(ddCID, false);
        String ddPath = ddCE.getIdentity().getName();
        authDir = ddPath.substring(0, ddPath.indexOf("_MFDomainDescriptor"));
        return authDir;
    }

    private static String getAuthorizationPolicyDir(IAttributeSet as, IComponentContext context) {
        String authPolicyDir = null;
        Reference apdRef = (Reference)as.getAttribute("AUTHORIZATION_POLICY_CONFIG_ELEMENT_REF");
        String apdCID = apdRef.getElementName();
        IElement apdCE = context.getConfiguration(apdCID, false);
        String apdPath = apdCE.getIdentity().getName();
        authPolicyDir = apdPath.substring(0, apdPath.indexOf("_MQPolicyDescriptor"));
        return authPolicyDir;
    }

    public static void loadBackup(IComponentContext context, IElement configuration, Properties props, AttributesHolder attributesHolder, ConfigurationChangeBindHelper bindHelper) throws Exception {
        IAttributeSet ceas;
        IAttributeSet cdas;
        Reference rcref;
        s_isBackup = true;
        m_props = props;
        s_bindHelper = bindHelper;
        IAttributeSet bdas = configuration.getAttributes();
        IAttributeSet bcers = (IAttributeSet)bdas.getAttribute("CONFIG_ELEMENT_REFERENCES");
        Reference pref = (Reference)bcers.getAttribute("PRIMARY_CONFIG_ELEMENT_REF");
        String pCID = pref.getElementName();
        props.put("PRIMARY_CONFIG_ELEMENT_REF", pref);
        IElement pce = context.getConfiguration(pCID, true);
        IAttributeSet pdas = pce.getAttributes();
        ConfigPropertiesPopulator.getPrimaryPeerStorageSyncConfig(pdas, props);
        IAttributeSet pcers = (IAttributeSet)pdas.getAttribute("CONFIG_ELEMENT_REFERENCES");
        Reference aref = (Reference)bcers.getAttribute("ACCEPTOR_CONFIG_ELEMENT_REF");
        String aCID = aref.getElementName();
        Reference qref = (Reference)pcers.getAttribute("QUEUE_CONFIG_ELEMENT_REF");
        String qCID = qref.getElementName();
        Reference rref = (Reference)pcers.getAttribute("ROUTING_CONFIG_ELEMENT_REF");
        String rCID = rref.getElementName();
        Reference gsref = (Reference)pcers.getAttribute("GLOBAL_SUBSCRIPTIONS_CONFIG_ELEMENT_REF");
        String gsCID = gsref.getElementName();
        String[] configIDs = new String[]{aCID, qCID, rCID, gsCID};
        boolean[] changeFlags = new boolean[]{true, true, true, true};
        IElement[] configElems = context.getConfigurations(configIDs, changeFlags);
        IElement ace = configElems[0];
        IElement qce = configElems[1];
        IElement rce = configElems[2];
        IElement gsce = configElems[3];
        ConfigPropertiesPopulator.getBrokerUniqueConfig(pce.getAttributes(), configuration.getAttributes(), props, bindHelper);
        ConfigPropertiesPopulator.getBackupDebugConfig(configuration.getAttributes(), props);
        Config.loadDebugParameters(props);
        boolean isSecurityEnabled = false;
        String secEnabled = (String)props.get("ENABLE_SECURITY");
        if (secEnabled != null && "true".equalsIgnoreCase(secEnabled)) {
            isSecurityEnabled = true;
        }
        AttributeName an = new AttributeName("CLUSTER_CONFIG_ELEMENT_REF");
        Reference cr = (Reference)pcers.getAttribute(an);
        IElement cce = null;
        if (cr != null) {
            String cCID = cr.getElementName();
            cce = context.getConfiguration(cCID, true);
        }
        boolean isClustered = false;
        if (cce != null) {
            isClustered = true;
            props.put("ENABLE_INTERBROKER", "true");
        } else {
            props.put("ENABLE_INTERBROKER", "false");
        }
        if (isClustered) {
            ConfigPropertiesPopulator.readClusterAttributes(cce, props, bindHelper);
        }
        ConfigPropertiesPopulator.getAcceptorConfig(context, ace, props, isClustered);
        ConfigPropertiesPopulator.getPrimaryPeerAcceptorConfig(context, pdas, props, isClustered);
        bindHelper.bindBrokerAcceptorChangeDelegator((String)props.get("BROKER_NAME"), pce);
        if (isClustered) {
            ConfigPropertiesPopulator.getClusterPeerInfo(context, cce, props, attributesHolder, bindHelper);
        }
        if ((rcref = (Reference)pcers.getAttribute("REPLICATION_CONNECTIONS_ELEMENT_REF")) != null) {
            String rcCID = rcref.getElementName();
            IElement rcce = context.getConfiguration(rcCID, true);
            ConfigPropertiesPopulator.getReplicationConnectionConfig(context, rcce, props, bindHelper);
        }
        ConfigPropertiesPopulator.getQueueConfig(context, qce, props, isClustered, cce, attributesHolder);
        if (isClustered) {
            cdas = cce.getAttributes();
            an = new AttributeName("CONFIG_ELEMENT_REFERENCES");
            ceas = (IAttributeSet)cdas.getAttribute(an);
            an = new AttributeName("ROUTING_CONFIG_ELEMENT_REF");
            Reference rRef = (Reference)ceas.getAttribute(an);
            rCID = rRef.getElementName();
            rce = context.getConfiguration(rCID, true);
            ConfigPropertiesPopulator.getRoutingConfig(context, rce, props, isSecurityEnabled, attributesHolder, bindHelper);
        } else {
            ConfigPropertiesPopulator.getRoutingConfig(context, rce, props, isSecurityEnabled, attributesHolder, bindHelper);
        }
        ConfigPropertiesPopulator.setBrokerLocation(context, configuration.getIdentity().getName(), props, true);
        if (isClustered) {
            cdas = cce.getAttributes();
            ceas = (IAttributeSet)cdas.getAttribute("CONFIG_ELEMENT_REFERENCES");
            Reference gsRef = (Reference)ceas.getAttribute("GLOBAL_SUBSCRIPTIONS_CONFIG_ELEMENT_REF");
            gsCID = gsRef.getElementName();
            gsce = context.getConfiguration(gsCID, true);
            ConfigPropertiesPopulator.getGlobalSubscriptionConfig(context, gsce, props, bindHelper);
        } else {
            ConfigPropertiesPopulator.getGlobalSubscriptionConfig(context, gsce, props, bindHelper);
        }
        ConfigPropertiesPopulator.loadCertificateStore(pcers, props);
        if (isSecurityEnabled) {
            IElement[] userConfigElements = null;
            IElement[] groupConfigElements = null;
            IElement[] aclConfigElements = null;
            IElement[] qopConfigElements = null;
            String usersDir = null;
            String groupsDir = null;
            String aclsDir = null;
            String qopsDir = null;
            IAttributeSet ceRefAS = null;
            if (isClustered) {
                IAttributeSet cdas2 = cce.getAttributes();
                an = new AttributeName("CONFIG_ELEMENT_REFERENCES");
                ceRefAS = (IAttributeSet)cdas2.getAttribute(an);
            } else {
                ceRefAS = pcers;
            }
            String authenticationDomainDir = ConfigPropertiesPopulator.getAuthenticationDomainDir(ceRefAS, context);
            usersDir = authenticationDomainDir + "_MFUsers";
            userConfigElements = context.getConfigurations(usersDir, true);
            groupsDir = authenticationDomainDir + "_MFGroups";
            groupConfigElements = context.getConfigurations(groupsDir, true);
            String authorizationPolicyDir = ConfigPropertiesPopulator.getAuthorizationPolicyDir(ceRefAS, context);
            qopsDir = authorizationPolicyDir + "_MQQoPs";
            qopConfigElements = context.getConfigurations(qopsDir, true);
            aclsDir = authorizationPolicyDir + "_MQACLs";
            aclConfigElements = context.getConfigurations(aclsDir, true);
            attributesHolder.setUserDomainName(usersDir);
            attributesHolder.setGroupDomainName(groupsDir);
            attributesHolder.setACLDomainName(aclsDir);
            attributesHolder.setQoPDomainName(qopsDir);
            Hashtable<String, ProgressPrincipal> principals = new Hashtable<String, ProgressPrincipal>();
            ConfigPropertiesPopulator.getPrincipals(context, userConfigElements, groupConfigElements, principals, props, attributesHolder, bindHelper);
            ConfigPropertiesPopulator.getExternalSecurityDomainInfo(usersDir, context, props, bindHelper);
            int size = 2 * principals.size();
            Hashtable<String, Vector<SubjectAclEntry>> subjectACLs = null;
            subjectACLs = size > 0 ? new Hashtable(size) : new Hashtable<String, Vector<SubjectAclEntry>>();
            Hashtable<String, Vector<RoutingUserAclEntry>> routingACLs = new Hashtable<String, Vector<RoutingUserAclEntry>>();
            ConfigPropertiesPopulator.getACLs(context, aclConfigElements, props, principals, subjectACLs, routingACLs, attributesHolder, bindHelper);
            String qopSecEnabled = (String)props.get("ENABLE_QOP_SECURITY");
            Hashtable<String, QOP> qops = null;
            if ("true".equalsIgnoreCase(qopSecEnabled)) {
                qops = new Hashtable<String, QOP>();
                ConfigPropertiesPopulator.getQoPs(context, qopConfigElements, qops, attributesHolder, bindHelper);
            }
            SecurityCache cache = new SecurityCache(principals, subjectACLs, routingACLs, qops);
            ConfigPropertiesPopulator.addExternalUsersToInternalGroups(cache);
            ConfigPropertiesPopulator.addExternalGroup(cache);
            props.put("SECURITY_CACHE", cache);
        }
    }

    private static void getBackupPeerStorageSyncConfig(IAttributeSet backup, Properties props) {
        IAttributeSet bdbas = (IAttributeSet)backup.getAttribute("BROKER_DATABASE_PARAMETERS");
        Object val = null;
        val = bdbas.getAttribute("MQSTORE_DB_CONNECT");
        props.put("FTPEER_MQSTORE_DB_CONNECT", val == null ? "./SonicMQStore" : val);
        IAttributeSet brlas = (IAttributeSet)backup.getAttribute("BROKER_RECOVERY_LOG_PARAMETERS");
        val = brlas.getAttribute("RECOVERY_LOG_PATH");
        props.put("FTPEER_RECOVERY_LOG_PATH", val == null ? "./log" : val);
    }

    private static void getPrimaryPeerStorageSyncConfig(IAttributeSet primary, Properties props) {
        IAttributeSet pdbas = (IAttributeSet)primary.getAttribute("BROKER_DATABASE_PARAMETERS");
        Object val = null;
        val = pdbas.getAttribute("MQSTORE_DB_CONNECT");
        props.put("FTPEER_MQSTORE_DB_CONNECT", val == null ? "./SonicMQStore" : val);
        IAttributeSet prlas = (IAttributeSet)primary.getAttribute("BROKER_RECOVERY_LOG_PARAMETERS");
        val = prlas.getAttribute("RECOVERY_LOG_PATH");
        props.put("FTPEER_RECOVERY_LOG_PATH", val == null ? "./log" : val);
    }

    public static void getPrimaryPeerAcceptorConfig(IComponentContext context, IAttributeSet primary, Properties props, boolean isClustered) throws ESocketConfigException {
        IAttributeSet cers = (IAttributeSet)primary.getAttribute("CONFIG_ELEMENT_REFERENCES");
        Reference aref = (Reference)cers.getAttribute("ACCEPTOR_CONFIG_ELEMENT_REF");
        IElement ace = null;
        if (aref != null) {
            String cCID = aref.getElementName();
            ace = context.getConfiguration(cCID, true);
        }
        ConfigPropertiesPopulator.getFTPeerAcceptorConfig(context, ace, props, isClustered);
    }

    public static void getBackupPeerAcceptorConfig(IComponentContext context, IAttributeSet backup, Properties props, boolean isClustered) throws ESocketConfigException {
        IAttributeSet cers = (IAttributeSet)backup.getAttribute("CONFIG_ELEMENT_REFERENCES");
        Reference aref = (Reference)cers.getAttribute("ACCEPTOR_CONFIG_ELEMENT_REF");
        IElement ace = null;
        if (aref != null) {
            String cCID = aref.getElementName();
            ace = context.getConfiguration(cCID, true);
        }
        ConfigPropertiesPopulator.getFTPeerAcceptorConfig(context, ace, props, isClustered);
    }

    private static void readClusterAttributes(IElement clusterEl, Properties props, ConfigurationChangeBindHelper bindHelper) {
        Boolean flowToDisk;
        Integer clusterMonitorInterval;
        Integer pingTimeout;
        Integer pingInterval;
        Integer connectTimeout;
        IAttributeSet clusterSet = clusterEl.getAttributes();
        String routingNodeName = (String)clusterSet.getAttribute("ROUTING_NODE_NAME");
        if (routingNodeName != null && routingNodeName.length() > 0) {
            props.setProperty("ROUTING_NODE_NAME", routingNodeName);
        }
        if ((connectTimeout = (Integer)clusterSet.getAttribute("CLUSTER_BROKER_CONNECT_TIMEOUT")) != null && connectTimeout >= 0) {
            props.put("CLUSTER_BROKER_CONNECT_TIMEOUT", connectTimeout);
        }
        if ((pingInterval = (Integer)clusterSet.getAttribute("CLUSTER_BROKER_PING_INTERVAL")) != null && pingInterval >= 0) {
            props.put("CLUSTER_BROKER_PING_INTERVAL", pingInterval);
        }
        if ((pingTimeout = (Integer)clusterSet.getAttribute("CLUSTER_BROKER_PING_TIMEOUT")) != null && pingTimeout >= 0) {
            props.put("CLUSTER_BROKER_PING_TIMEOUT", pingTimeout);
        }
        if ((clusterMonitorInterval = (Integer)clusterSet.getAttribute("CLUSTER_FC_MONITOR_INTERVAL")) == null) {
            clusterMonitorInterval = new Integer(15);
        }
        if (clusterMonitorInterval >= 0) {
            props.put("FC_MONITOR_INTERVAL", clusterMonitorInterval);
        }
        if ((flowToDisk = (Boolean)clusterSet.getAttribute("CLUSTER_FLOW_TO_DISK")) == null) {
            flowToDisk = new Boolean(false);
        }
        props.put("FLOW_TO_DISK", flowToDisk);
        Integer clientDefMonitorInterval = (Integer)clusterSet.getAttribute("CLIENT_DEFAULT_FC_MONITOR_INTERVAL");
        if (clientDefMonitorInterval == null) {
            clientDefMonitorInterval = new Integer(60);
        }
        props.put("CLIENT_DEFAULT_FC_MONITOR_INTERVAL", clientDefMonitorInterval);
        Boolean useDynamicHostBinding = (Boolean)clusterSet.getAttribute("USE_DYNAMIC_HOST_BINDING");
        if (useDynamicHostBinding == null) {
            useDynamicHostBinding = Boolean.FALSE;
        }
        props.put("USE_DYNAMIC_HOST_BINDING", useDynamicHostBinding);
        bindHelper.bindClusterChangeHandler(clusterSet);
    }

    private static String getMQStoreConnectAttr(IAttributeSet primary, IAttributeSet backup) {
        if (backup != null) {
            return (String)backup.getAttribute("MQSTORE_DB_CONNECT");
        }
        return (String)primary.getAttribute("MQSTORE_DB_CONNECT");
    }

    private static String getRecoveryLogPathAttr(IAttributeSet primary, IAttributeSet backup) {
        if (backup != null) {
            return (String)backup.getAttribute("RECOVERY_LOG_PATH");
        }
        return (String)primary.getAttribute("RECOVERY_LOG_PATH");
    }

    private static Integer getLoadBalancingWeightAttr(IAttributeSet primary, IAttributeSet backup) {
        if (backup != null) {
            return (Integer)backup.getAttribute("LOAD_BALANCING_WEIGHT");
        }
        return (Integer)primary.getAttribute("LOAD_BALANCING_WEIGHT");
    }

    private static Boolean getBackupStartActiveAttr(IAttributeSet backup) {
        if (backup != null) {
            return (Boolean)backup.getAttribute("START_ACTIVE");
        }
        return new Boolean(false);
    }

    private static Boolean getPrimaryStartActiveAttr(IAttributeSet primary) {
        if (primary != null) {
            return (Boolean)primary.getAttribute("START_ACTIVE");
        }
        return new Boolean(false);
    }

    private static void getBrokerUniqueConfig(IAttributeSet das, IAttributeSet bdas, Properties props, ConfigurationChangeBindHelper bindHelper) throws Exception {
        IAttributeSet wras;
        IAttributeSet wsas;
        IAttributeSet spas;
        IAttributeSet ftpas;
        IAttributeSet ddas;
        IAttributeSet ctas;
        IAttributeSet tuas;
        IAttributeSet nas;
        IAttributeSet psas;
        IAttributeSet cbas;
        Integer provisionInterval;
        Object paramVal = null;
        props.put("BROKER_NAME", das.getAttribute("BROKER_NAME"));
        paramVal = das.getAttribute("BROKER_PASSWORD");
        if (paramVal != null) {
            props.put("BROKER_PASSWORD", paramVal);
        }
        IAttributeSet pias = (IAttributeSet)das.getAttribute("PRODUCT_INFORMATION");
        String controlNumber = (String)pias.getAttribute("CONTROL_NUMBER");
        props.put("CONTROL_NUMBER", controlNumber);
        Boolean eval = (Boolean)pias.getAttribute("EVALUATION_MODE");
        if (eval == null) {
            eval = new Boolean("false");
        }
        props.put("EVALUATION_MODE", eval);
        String provisionClassName = (String)pias.getAttribute("PROVISION_SPI_CLASSNAME");
        if (provisionClassName != null) {
            props.put("PROVISION_SPI_CLASSNAME", provisionClassName);
        }
        if ((provisionInterval = (Integer)pias.getAttribute("PROVISION_SPI_INTERVAL")) == null) {
            provisionInterval = new Integer(Config.PROVISION_SPI_INTERVAL_DEFAULT);
        }
        props.put("PROVISION_SPI_INTERVAL", provisionInterval);
        ProvisionMonitor provisionMonitor = new ProvisionMonitor();
        props.put("PROVISION_MONITOR", provisionMonitor);
        bindHelper.bindProductInfoChangeHandler(pias, props);
        paramVal = das.getAttribute("USE_DYNAMIC_HOST_BINDING");
        if (paramVal == null) {
            paramVal = Boolean.FALSE;
        }
        props.put("USE_DYNAMIC_HOST_BINDING", paramVal);
        BrokerLicenseMgr lm = BrokerLicenseMgr.createLicenseMgr(controlNumber);
        props.put("LICENSE_MANAGER", (Object)lm);
        IAttributeSet sas = (IAttributeSet)das.getAttribute("BROKER_SECURITY_PARAMETERS");
        Boolean B = (Boolean)sas.getAttribute("ENABLE_SECURITY");
        if (B == null) {
            B = new Boolean(false);
        }
        props.put("ENABLE_SECURITY", B.toString());
        B = (Boolean)sas.getAttribute("ENABLE_QOP_SECURITY");
        if (B != null) {
            props.put("ENABLE_QOP_SECURITY", B.toString());
        } else {
            props.put("ENABLE_QOP_SECURITY", "true");
        }
        B = (Boolean)sas.getAttribute("ENABLE_ACCESS_MEDIATION");
        if (B != null) {
            props.put("ENABLE_ACCESS_MEDIATION", B.toString());
        } else {
            props.put("ENABLE_ACCESS_MEDIATION", "true");
        }
        B = (Boolean)sas.getAttribute("ENABLE_ACL_CHECK_AT_RESTORE");
        if (B != null) {
            props.put("ENABLE_ACL_CHECK_AT_RESTORE", B);
        } else {
            props.put("ENABLE_ACL_CHECK_AT_RESTORE", Boolean.FALSE);
        }
        B = (Boolean)sas.getAttribute("SET_JMSXUSERID");
        if (B != null) {
            props.put("SET_JMSXUSERID", B);
        } else {
            props.put("SET_JMSXUSERID", Boolean.FALSE);
        }
        bindHelper.bindSecurityParametersChangeHandler(sas);
        IAttributeSet lgas = (IAttributeSet)das.getAttribute("ACTIONAL_PARAMETERS");
        if (lgas != null) {
            B = (Boolean)lgas.getAttribute("ACTIONAL_INTERCEPTOR");
            if (B != null) {
                props.put("ACTIONAL_INTERCEPTOR", B);
            } else {
                props.put("ACTIONAL_INTERCEPTOR", new Boolean(Config.LG_ENABLE));
            }
            B = (Boolean)lgas.getAttribute("INTERCEPTOR_DEBUG");
            if (B != null) {
                props.put("INTERCEPTOR_DEBUG", B);
            } else {
                props.put("INTERCEPTOR_DEBUG", Boolean.FALSE);
            }
            paramVal = lgas.getAttribute("INTERCEPTOR_FILTERS");
            if (paramVal != null) {
                props.put("INTERCEPTOR_FILTERS", paramVal);
            }
            if ((paramVal = lgas.getAttribute("MESSAGE_FIELDS")) != null) {
                props.put("MESSAGE_FIELDS", paramVal);
            }
            if ((paramVal = lgas.getAttribute("PAYLOAD_CAPTURE")) != null) {
                props.put("PAYLOAD_CAPTURE", paramVal);
            }
            if ((paramVal = lgas.getAttribute("EVENTS_LOG_FILE")) != null) {
                props.put("EVENTS_LOG_FILE", paramVal);
            }
        }
        s_bindHelper.bindLGConfigChangeHandler(lgas);
        IAttributeSet dbas = (IAttributeSet)das.getAttribute("BROKER_DATABASE_PARAMETERS");
        IAttributeSet bdbas = null;
        if (bdas != null) {
            bdbas = (IAttributeSet)bdas.getAttribute("BROKER_DATABASE_PARAMETERS");
        }
        if ((paramVal = dbas.getAttribute("DATABASE_STORE_TYPE")) == null) {
            paramVal = "Embedded";
        }
        props.put("DATABASE_STORE_TYPE", paramVal);
        paramVal = ConfigPropertiesPopulator.getMQStoreConnectAttr(dbas, bdbas);
        if (paramVal == null) {
            paramVal = "./SonicMQStore";
        }
        props.put("MQSTORE_DB_CONNECT", paramVal);
        paramVal = dbas.getAttribute("DB_MSG_CLEAN_THRESHOLD");
        if (paramVal != null) {
            props.put("DB_MSG_CLEAN_THRESHOLD", paramVal);
        }
        if ((paramVal = dbas.getAttribute("EXP_MSG_CLEAN_THRESHOLD")) != null) {
            props.put("EXP_MSG_CLEAN_THRESHOLD", paramVal);
        }
        if ((paramVal = dbas.getAttribute("DB_COMMIT_BATCH_SIZE")) != null) {
            props.put("DB_COMMIT_BATCH_SIZE", paramVal);
        }
        if ((paramVal = dbas.getAttribute("DB_CLEANUP_BATCH_SIZE")) != null) {
            props.put("DB_CLEANUP_BATCH_SIZE", paramVal);
        }
        if ((paramVal = dbas.getAttribute("DB_FORCE_SYNC")) != null) {
            props.put("DB_FORCE_SYNC", paramVal);
        }
        IAttributeSet rlas = (IAttributeSet)das.getAttribute("BROKER_RECOVERY_LOG_PARAMETERS");
        IAttributeSet brlas = null;
        if (bdas != null) {
            brlas = (IAttributeSet)bdas.getAttribute("BROKER_RECOVERY_LOG_PARAMETERS");
        }
        if ((paramVal = ConfigPropertiesPopulator.getRecoveryLogPathAttr(rlas, brlas)) == null) {
            paramVal = "./log";
        }
        props.put("RECOVERY_LOG_PATH", paramVal);
        paramVal = rlas.getAttribute("RECOVERY_LOG_MAX_FILE_SIZE");
        if (paramVal == null) {
            paramVal = new Long(0xC800000L);
        }
        props.put("RECOVERY_LOG_MAX_FILE_SIZE", paramVal);
        paramVal = rlas.getAttribute("RECOVERY_LOG_BLOCK_SIZE");
        if (paramVal == null) {
            paramVal = new Integer(8192);
        }
        props.put("RECOVERY_LOG_BLOCK_SIZE", paramVal);
        paramVal = rlas.getAttribute("RECOVERY_LOG_QUEUE_SIZE");
        if (paramVal == null) {
            paramVal = new Integer(5000000);
        }
        props.put("RECOVERY_LOG_QUEUE_SIZE", paramVal);
        paramVal = rlas.getAttribute("RECOVERY_LOG_NOTIFY_FACTOR");
        if (paramVal == null) {
            paramVal = new Float(IBrokerConstants.RECOVERY_LOG_NOTIFY_FACTOR_DEFAULT.floatValue());
        }
        props.put("RECOVERY_LOG_NOTIFY_FACTOR", paramVal);
        paramVal = rlas.getAttribute("RECOVERY_LOG_FLUSH_DELAY");
        if (paramVal != null) {
            props.put("RECOVERY_LOG_FLUSH_DELAY", paramVal);
        }
        if ((paramVal = rlas.getAttribute("RECOVERY_LOG_FLUSH_PRIORITY_BOOST")) != null) {
            props.put("RECOVERY_LOG_FLUSH_PRIORITY_BOOST", paramVal);
        }
        if ((paramVal = rlas.getAttribute("RECOVERY_LOG_OPEN_MODE")) != null) {
            props.put("RECOVERY_LOG_OPEN_MODE", paramVal);
        }
        if ((paramVal = rlas.getAttribute("RECOVERY_LOG_BUFFERED_BLOCKS")) != null) {
            props.put("RECOVERY_LOG_BUFFERED_BLOCKS", paramVal);
        }
        if ((paramVal = rlas.getAttribute("RECOVERY_LOG_FORCE_SYNC")) != null) {
            props.put("RECOVERY_LOG_FORCE_SYNC", paramVal);
        }
        if ((paramVal = rlas.getAttribute("XONCE_RECOVERY")) != null) {
            props.put("XONCE_RECOVERY", paramVal);
        }
        if ((paramVal = (cbas = (IAttributeSet)das.getAttribute("BROKER_CONNECTION_BUFFERS")).getAttribute("WAIT_MSG_BUFFER_SIZE")) == null) {
            paramVal = new Integer(75000);
        }
        props.put("WAIT_MSG_BUFFER_SIZE", paramVal);
        paramVal = cbas.getAttribute("PS_GUAR_MSG_BUFFER_SIZE");
        if (paramVal == null) {
            paramVal = new Integer(150000);
        }
        props.put("PS_GUAR_MSG_BUFFER_SIZE", paramVal);
        paramVal = cbas.getAttribute("OUTGOING_MSG_BUFFER_SIZE");
        if (paramVal == null) {
            paramVal = new Integer(150000);
        }
        props.put("OUTGOING_MSG_BUFFER_SIZE", paramVal);
        paramVal = cbas.getAttribute("PTP_GUAR_MSG_BUFFER_SIZE");
        if (paramVal == null) {
            paramVal = new Integer(150000);
        }
        props.put("PTP_GUAR_MSG_BUFFER_SIZE", paramVal);
        paramVal = cbas.getAttribute("SOCKET_QUEUE_LENGTH");
        if (paramVal != null) {
            props.put("SOCKET_QUEUE_LENGTH", paramVal);
        }
        if ((paramVal = cbas.getAttribute("AGENT_LISTENER_INPUT_BUFFER_SIZE")) != null) {
            props.put("AGENT_LISTENER_INPUT_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = cbas.getAttribute("AGENT_SENDER_OUTPUT_BUFFER_SIZE")) != null) {
            props.put("AGENT_SENDER_OUTPUT_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = cbas.getAttribute("AGENT_LISTENER_MIN_INPUT_BUFFER_SIZE")) != null) {
            props.put("AGENT_LISTENER_MIN_INPUT_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = cbas.getAttribute("AGENT_SENDER_MIN_OUTPUT_BUFFER_SIZE")) != null) {
            props.put("AGENT_SENDER_MIN_OUTPUT_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = cbas.getAttribute("AGENT_LISTENER_INITIAL_INPUT_BUFFER_SIZE")) != null) {
            props.put("AGENT_LISTENER_INITIAL_INPUT_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = cbas.getAttribute("AGENT_SENDER_INITIAL_OUTPUT_BUFFER_SIZE")) != null) {
            props.put("AGENT_SENDER_INITIAL_OUTPUT_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = cbas.getAttribute("AGENT_LISTENER_MIN_HTTP_INPUT_BUFFER_SIZE")) != null) {
            props.put("AGENT_LISTENER_MIN_HTTP_INPUT_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = cbas.getAttribute("AGENT_SENDER_MIN_HTTP_OUTPUT_BUFFER_SIZE")) != null) {
            props.put("AGENT_SENDER_MIN_HTTP_OUTPUT_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = cbas.getAttribute("AGENT_LISTENER_INITIAL_HTTP_INPUT_BUFFER_SIZE")) != null) {
            props.put("AGENT_LISTENER_INITIAL_HTTP_INPUT_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = cbas.getAttribute("AGENT_SENDER_INITIAL_HTTP_OUTPUT_BUFFER_SIZE")) != null) {
            props.put("AGENT_SENDER_INITIAL_HTTP_OUTPUT_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = cbas.getAttribute("OUTGOING_MSG_BUFFER_MIN_SIZE")) != null) {
            props.put("OUTGOING_MSG_BUFFER_MIN_SIZE", paramVal);
        }
        if ((paramVal = cbas.getAttribute("PS_GUAR_MSG_BUFFER_MIN_SIZE")) != null) {
            props.put("PS_GUAR_MSG_BUFFER_MIN_SIZE", paramVal);
        }
        if ((paramVal = cbas.getAttribute("WAIT_MSG_BUFFER_MIN_SIZE")) != null) {
            props.put("WAIT_MSG_BUFFER_MIN_SIZE", paramVal);
        }
        if ((paramVal = cbas.getAttribute("PTP_GUAR_MSG_BUFFER_MIN_SIZE")) != null) {
            props.put("PTP_GUAR_MSG_BUFFER_MIN_SIZE", paramVal);
        }
        if ((paramVal = cbas.getAttribute("PRIORITY_OUTGOING_MSG_BUFFER_SIZE")) != null) {
            props.put("PRIORITY_OUTGOING_MSG_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = cbas.getAttribute("PRIORITY_PS_GUAR_MSG_BUFFER_SIZE")) != null) {
            props.put("PRIORITY_PS_GUAR_MSG_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = cbas.getAttribute("PRIORITY_WAIT_MSG_BUFFER_SIZE")) != null) {
            props.put("PRIORITY_WAIT_MSG_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = cbas.getAttribute("PRIORITY_PTP_GUAR_MSG_BUFFER_SIZE")) != null) {
            props.put("PRIORITY_PTP_GUAR_MSG_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = cbas.getAttribute("PS_FLOW_CONTROL_RESTART_THRESHOLD")) != null) {
            props.put("PS_FLOW_CONTROL_RESTART_THRESHOLD", paramVal);
        }
        if ((paramVal = cbas.getAttribute("ACKNOWLEDGE_MONITOR_INTERVAL")) != null) {
            props.put("ACKNOWLEDGE_MONITOR_INTERVAL", paramVal);
        }
        if ((paramVal = cbas.getAttribute("PTP_GUAR_MSG_BUFFER_LIMIT_CHECK")) != null) {
            props.put("PTP_GUAR_MSG_BUFFER_LIMIT_CHECK", paramVal);
        }
        if ((paramVal = (psas = (IAttributeSet)das.getAttribute("BROKER_PUBSUB_PARAMETERS")).getAttribute("PS_DB_QUEUE_SIZE")) == null) {
            paramVal = new Integer(0x200000);
        }
        props.put("PS_DB_QUEUE_SIZE", paramVal);
        paramVal = psas.getAttribute("DURABLE_SUBSCRIBER_EXPIRATION_POLL_INTERVAL");
        if (paramVal != null) {
            props.put("DURABLE_SUBSCRIBER_EXPIRATION_POLL_INTERVAL", paramVal);
        }
        if ((paramVal = psas.getAttribute("EXP_MSG_CLEAN_POLL_INTERVAL")) != null) {
            props.put("EXP_MSG_CLEAN_POLL_INTERVAL", paramVal);
        }
        if ((paramVal = psas.getAttribute("SLOW_SUBSCRIBER_MONITOR_POLL_INTERVAL")) != null) {
            props.put("SLOW_SUBSCRIBER_MONITOR_POLL_INTERVAL", paramVal);
        }
        if ((paramVal = psas.getAttribute("SLOW_SUBSCRIBER_NOTIFY_THRESHOLD")) != null) {
            props.put("SLOW_SUBSCRIBER_NOTIFY_THRESHOLD", paramVal);
        }
        if ((paramVal = psas.getAttribute("PRESERVE_NON_DURABLE_WHEN_STOPPED")) != null) {
            props.put("PRESERVE_NON_DURABLE_WHEN_STOPPED", paramVal);
        }
        if ((paramVal = psas.getAttribute("REDELIVERY_BATCH_SIZE")) != null) {
            props.put("REDELIVERY_BATCH_SIZE", paramVal);
        }
        if ((paramVal = psas.getAttribute("THROTTLE_PUBS_DURING_RESTORE")) != null) {
            props.put("THROTTLE_PUBS_DURING_RESTORE", paramVal);
        }
        if ((paramVal = psas.getAttribute("RESTORE_MSGS_COUNT")) != null) {
            props.put("RESTORE_MSGS_COUNT", paramVal);
        }
        if ((paramVal = psas.getAttribute("RESTORE_MSGS_FC_COUNT")) != null) {
            props.put("RESTORE_MSGS_FC_COUNT", paramVal);
        }
        if ((paramVal = psas.getAttribute("FLOW_TO_DISK")) == null) {
            paramVal = new Boolean(false);
        }
        props.put("FLOW_TO_DISK", paramVal);
        paramVal = psas.getAttribute("FLOW_TO_DISK_NOTIFY");
        if (paramVal == null) {
            paramVal = new Boolean(Config.FLOW_TO_DISK_NOTIFY_DEFAULT);
        }
        props.put("FLOW_TO_DISK_NOTIFY", paramVal);
        paramVal = psas.getAttribute("SHARED_SUBS_RECOVERY_TIMEOUT");
        if (paramVal == null) {
            paramVal = new Long(Config.SHARED_SUBS_RECOVERY_TIMEOUT_DEFAULT);
        }
        props.put("SHARED_SUBS_RECOVERY_TIMEOUT", paramVal);
        paramVal = psas.getAttribute("MAX_TOPIC_DB_SIZE");
        if (paramVal == null) {
            paramVal = new Integer(0);
        }
        props.put("MAX_TOPIC_DB_SIZE", paramVal);
        paramVal = psas.getAttribute("TOPIC_DB_SIZE_RESTART_THRESHOLD");
        if (paramVal != null) {
            props.put("TOPIC_DB_SIZE_RESTART_THRESHOLD", paramVal);
        }
        if ((paramVal = psas.getAttribute("MAX_FTD_MEMORY_SIZE")) != null) {
            props.put("MAX_FTD_MEMORY_SIZE", paramVal);
        }
        if ((paramVal = psas.getAttribute("FTD_RESTORE_THREAD_CAP")) != null) {
            props.put("FTD_RESTORE_THREAD_CAP", paramVal);
        }
        if ((paramVal = psas.getAttribute("CHECK_DB_SIZE_ON_PUBLISH")) != null) {
            props.put("CHECK_DB_SIZE_ON_PUBLISH", paramVal);
        }
        bindHelper.bindPubSubConfigChangeHandler(psas);
        IAttributeSet qas = (IAttributeSet)das.getAttribute("BROKER_QUEUE_PARAMETERS");
        paramVal = qas.getAttribute("PTP_DB_QUEUE_SIZE");
        if (paramVal == null) {
            paramVal = new Integer(0x200000);
        }
        props.put("PTP_DB_QUEUE_SIZE", paramVal);
        paramVal = qas.getAttribute("ENABLE_QUEUE_CLEANUP");
        if (paramVal == null) {
            paramVal = new Boolean(true);
        }
        props.put("ENABLE_QUEUE_CLEANUP", paramVal);
        paramVal = qas.getAttribute("QUEUE_CLEANUP_INTERVAL");
        if (paramVal == null) {
            paramVal = new Long(600L);
        }
        props.put("QUEUE_CLEANUP_INTERVAL", paramVal);
        paramVal = qas.getAttribute("QUEUE_DELIVERY_THREADS");
        if (paramVal == null) {
            paramVal = new Integer(10);
        }
        props.put("QUEUE_DELIVERY_THREADS", paramVal);
        paramVal = qas.getAttribute("BROKER_MAX_DELIVERY_COUNT");
        if (paramVal == null) {
            paramVal = new Integer(0);
        }
        props.put("BROKER_MAX_DELIVERY_COUNT", paramVal);
        paramVal = qas.getAttribute("MAX_TEMPORARY_QUEUE_SIZE");
        if (paramVal == null) {
            paramVal = new Integer(1000);
        }
        props.put("MAX_TEMPORARY_QUEUE_SIZE", paramVal);
        paramVal = qas.getAttribute("MAX_QMSG_SAVER_ASYNC_CACHE_SIZE");
        if (paramVal != null) {
            props.put("MAX_QMSG_SAVER_ASYNC_CACHE_SIZE", paramVal);
        }
        if ((paramVal = qas.getAttribute("MAX_ADMINISTRATIVELY_CREATED_QUEUE_SIZE")) != null) {
            props.put("MAX_ADMINISTRATIVELY_CREATED_QUEUE_SIZE", paramVal);
        }
        if ((paramVal = qas.getAttribute("PTP_DB_DELETEOP_SIZE")) != null) {
            props.put("PTP_DB_DELETEOP_SIZE", paramVal);
        }
        if ((paramVal = qas.getAttribute("PTP_DB_ASYNC_RETRIEVEOP_SIZE")) != null) {
            props.put("PTP_DB_ASYNC_RETRIEVEOP_SIZE", paramVal);
        }
        if ((paramVal = qas.getAttribute("PTP_DB_ENABLE_SYNCSIZE_MONITOR")) != null) {
            props.put("PTP_DB_ENABLE_SYNCSIZE_MONITOR", paramVal);
        }
        if ((paramVal = qas.getAttribute("PTP_REDELIVERED_ON_BROKER_RESTART")) != null) {
            props.put("PTP_REDELIVERED_ON_BROKER_RESTART", paramVal);
        }
        if ((paramVal = qas.getAttribute("CLUSTERED_Q_PREFETCH_COUNT")) != null) {
            props.put("CLUSTERED_Q_PREFETCH_COUNT", paramVal);
        }
        if ((paramVal = qas.getAttribute("CLUSTERED_Q_PREFETCH_THRESHOLD")) != null) {
            props.put("CLUSTERED_Q_PREFETCH_THRESHOLD", paramVal);
        }
        if ((paramVal = qas.getAttribute("CLUSTERED_Q_AGGRESSIVE_PREFETCH_THRESHOLD")) != null) {
            props.put("CLUSTERED_Q_AGGRESSIVE_PREFETCH_THRESHOLD", paramVal);
        }
        if ((paramVal = (nas = (IAttributeSet)das.getAttribute("BROKER_NOTIFICATION_PARAMETERS")).getAttribute("DMQ_NOTIFY_FACTOR")) == null) {
            paramVal = new Float(IBrokerConstants.DMQ_NOTIFY_FACTOR_DEFAULT.floatValue());
        }
        props.put("DMQ_NOTIFY_FACTOR", paramVal);
        paramVal = nas.getAttribute("FLOW_CONTROL_NOTIFY_SIZE");
        if (paramVal != null) {
            props.put("FLOW_CONTROL_NOTIFY_SIZE", paramVal);
        }
        if ((paramVal = nas.getAttribute("ENABLE_WSRM_FLOW_CONTROL_NOTIFICATIONS")) != null) {
            props.put("ENABLE_WSRM_FLOW_CONTROL_NOTIFICATIONS", paramVal);
        }
        if ((paramVal = (Integer)nas.getAttribute("CLIENT_DEFAULT_FC_MONITOR_INTERVAL")) == null) {
            paramVal = new Integer(60);
        }
        props.put("CLIENT_DEFAULT_FC_MONITOR_INTERVAL", paramVal);
        paramVal = nas.getAttribute("BACKLOGGED_SESSION_SKIP_WARN_INTERVAL");
        if (paramVal != null) {
            props.put("BACKLOGGED_SESSION_SKIP_WARN_INTERVAL", paramVal);
        }
        if ((paramVal = nas.getAttribute("BACKLOGGED_SESSION_SKIP_WARN_BUNCH_LIMIT")) != null) {
            props.put("BACKLOGGED_SESSION_SKIP_WARN_BUNCH_LIMIT", paramVal);
        }
        bindHelper.bindBrokerNotificationConfigChangeHandler(nas);
        IAttributeSet tas = (IAttributeSet)das.getAttribute("BROKER_TXN_PARAMETERS");
        paramVal = tas.getAttribute("TXN_IDLE_TIMEOUT");
        if (paramVal == null) {
            paramVal = new Integer(0);
        }
        props.put("TXN_IDLE_TIMEOUT", paramVal);
        paramVal = tas.getAttribute("TXN_PRIMARY_THREADS");
        if (paramVal == null) {
            paramVal = new Integer(10);
        }
        props.put("TXN_PRIMARY_THREADS", paramVal);
        paramVal = tas.getAttribute("TXN_SECONDARY_THREADS");
        if (paramVal == null) {
            paramVal = new Integer(1);
        }
        props.put("TXN_SECONDARY_THREADS", paramVal);
        paramVal = tas.getAttribute("TXN_BUFFER_SIZE");
        if (paramVal == null) {
            paramVal = new Integer(32768);
        }
        props.put("TXN_BUFFER_SIZE", paramVal);
        paramVal = tas.getAttribute("TXN_FLUSH_THREADS");
        if (paramVal != null) {
            props.put("TXN_FLUSH_THREADS", paramVal);
        }
        if ((paramVal = tas.getAttribute("TXN_PARALLEL_PUBLISH")) != null) {
            props.put("TXN_PARALLEL_PUBLISH", paramVal);
        }
        if ((paramVal = (tuas = (IAttributeSet)das.getAttribute("BROKER_TUNNELING_PARAMETERS")).getAttribute("TUNNELING_PROXY_URL")) != null) {
            props.put("TUNNELING_PROXY_URL", paramVal);
        }
        if ((paramVal = tuas.getAttribute("PROXY_USER_NAME")) != null) {
            props.put("PROXY_USER_NAME", paramVal);
        }
        if ((paramVal = tuas.getAttribute("PROXY_PASSWORD")) != null) {
            props.put("PROXY_PASSWORD", paramVal);
        }
        if ((paramVal = (ctas = (IAttributeSet)das.getAttribute("CONNECTION_TUNING_PARAMETERS")).getAttribute("TCP_NODELAY")) == null) {
            paramVal = new Boolean(true);
        }
        props.put("TCP_NODELAY", paramVal);
        if (!SessionConfig.DISABLE_NIO) {
            props.put("DISABLE_NIO", new Boolean(false));
        } else {
            paramVal = ctas.getAttribute("DISABLE_NIO");
            if (paramVal == null) {
                paramVal = new Boolean(true);
            }
            props.put("DISABLE_NIO", paramVal);
            if (!((Boolean)paramVal).booleanValue()) {
                SessionConfig.DISABLE_NIO = false;
            }
        }
        paramVal = ctas.getAttribute("ENABLE_CHECKSUM");
        if (paramVal != null) {
            props.put("ENABLE_CHECKSUM", paramVal);
        }
        if ((paramVal = ctas.getAttribute("TCP_RECEIVE_BUFFER_SIZE")) != null) {
            props.put("TCP_RECEIVE_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = ctas.getAttribute("TCP_SEND_BUFFER_SIZE")) != null) {
            props.put("TCP_SEND_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = ctas.getAttribute("TCP_INITIAL_RCV_BUFFER_SIZE")) != null) {
            props.put("TCP_INITIAL_RCV_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = ctas.getAttribute("TCP_INITIAL_SEND_BUFFER_SIZE")) != null) {
            props.put("TCP_INITIAL_SEND_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = ctas.getAttribute("TCP_MIN_RCV_BUFFER_SIZE")) != null) {
            props.put("TCP_MIN_RCV_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = ctas.getAttribute("TCP_MIN_SEND_BUFFER_SIZE")) != null) {
            props.put("TCP_MIN_SEND_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = ctas.getAttribute("HTTP_SOCKET_RECEIVE_BUFFER_SIZE")) != null) {
            props.put("HTTP_SOCKET_RECEIVE_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = ctas.getAttribute("HTTP_SOCKET_SEND_BUFFER_SIZE")) != null) {
            props.put("HTTP_SOCKET_SEND_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = ctas.getAttribute("HTTP_SOCKET_INITIAL_RCV_BUFFER_SIZE")) != null) {
            props.put("HTTP_SOCKET_INITIAL_RCV_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = ctas.getAttribute("HTTP_SOCKET_INITIAL_SEND_BUFFER_SIZE")) != null) {
            props.put("HTTP_SOCKET_INITIAL_SEND_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = ctas.getAttribute("HTTP_SOCKET_MIN_RCV_BUFFER_SIZE")) != null) {
            props.put("HTTP_SOCKET_MIN_RCV_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = ctas.getAttribute("HTTP_SOCKET_MIN_SEND_BUFFER_SIZE")) != null) {
            props.put("HTTP_SOCKET_MIN_SEND_BUFFER_SIZE", paramVal);
        }
        if ((paramVal = ctas.getAttribute("BROKER_SEND_DELAY")) != null) {
            props.put("BROKER_SEND_DELAY", paramVal);
        }
        if ((paramVal = ctas.getAttribute("DOMAIN_SUFFIX_SEARCH_ORDER")) != null) {
            props.put("DOMAIN_SUFFIX_SEARCH_ORDER", paramVal);
        }
        if ((paramVal = ctas.getAttribute("MAX_CONNECTIONS")) != null) {
            props.put("MAX_CONNECTIONS", paramVal);
        }
        if ((paramVal = ctas.getAttribute("MAX_SESSIONS_PER_CONNECTION")) != null) {
            props.put("MAX_SESSIONS_PER_CONNECTION", paramVal);
        }
        if ((paramVal = ctas.getAttribute("MAX_TEMPORARY_QUEUES_PER_SESSION")) != null) {
            props.put("MAX_TEMPORARY_QUEUES_PER_SESSION", paramVal);
        }
        bindHelper.bindConnectionTuningConfigChangeHandler(ctas);
        paramVal = ctas.getAttribute("CONNECTION_ID_BLOCK_SIZE");
        if (paramVal != null) {
            props.put("CONNECTION_ID_BLOCK_SIZE", paramVal);
        }
        if ((paramVal = ctas.getAttribute("BROKER_CONNECT_TIMEOUT")) != null) {
            props.put("BROKER_CONNECT_TIMEOUT", paramVal);
        }
        if ((paramVal = ctas.getAttribute("BROKER_PING_INTERVAL")) != null) {
            props.put("BROKER_PING_INTERVAL", paramVal);
        }
        if ((paramVal = ctas.getAttribute("BROKER_PING_TIMEOUT")) != null) {
            props.put("BROKER_PING_TIMEOUT", paramVal);
        }
        if ((paramVal = ctas.getAttribute("CONNECT_PING_TIMEOUT")) != null) {
            props.put("CONNECT_PING_TIMEOUT", paramVal);
        }
        if ((paramVal = ctas.getAttribute("MAX_MSG_SIZE")) != null) {
            props.put("MAX_MSG_SIZE", paramVal);
        }
        if ((paramVal = ctas.getAttribute("CLIENT_RECONNECT_TIMEOUT")) == null) {
            paramVal = new Long(600L);
        }
        props.put("CLIENT_RECONNECT_TIMEOUT", paramVal);
        paramVal = ctas.getAttribute("MAX_CONNECTIONS_PER_USER");
        if (paramVal != null) {
            props.put("MAX_CONNECTIONS_PER_USER", paramVal);
        }
        if ((paramVal = ctas.getAttribute("MAX_CONNECTIONS_PER_USER_WARN_INTERVAL")) != null) {
            props.put("MAX_CONNECTIONS_PER_USER_WARN_INTERVAL", paramVal);
        }
        IAttributeSet ras = (IAttributeSet)das.getAttribute("BROKER_ROUTING_PARAMETERS");
        props.put("ROUTING_NODE_NAME", ras.getAttribute("ROUTING_NODE_NAME"));
        paramVal = ras.getAttribute("ROUTING_THREADS");
        if (paramVal == null) {
            paramVal = new Integer(10);
        }
        props.put("ROUTING_THREADS", paramVal);
        paramVal = ras.getAttribute("HTTP_DIRECT_OUTBOUND_DISPATCH_THREADS");
        if (paramVal == null) {
            paramVal = new Integer(10);
        }
        props.put("HTTP_DIRECT_OUTBOUND_DISPATCH_THREADS", paramVal);
        paramVal = ras.getAttribute("HTTP_DIRECT_OUTBOUND_RESERVED_FOR_GROUPED_REQUESTS_THREADS");
        if (paramVal == null) {
            paramVal = new Integer(0);
        }
        props.put("HTTP_DIRECT_OUTBOUND_RESERVED_FOR_GROUPED_REQUESTS_THREADS", paramVal);
        paramVal = ras.getAttribute("CONNECT_RETRY_COUNT");
        if (paramVal == null) {
            paramVal = new Integer(1);
        }
        props.put("CONNECT_RETRY_COUNT", paramVal);
        paramVal = ras.getAttribute("CONNECT_RETRY_INTERVAL");
        if (paramVal == null) {
            paramVal = new Long(30L);
        }
        props.put("CONNECT_RETRY_INTERVAL", paramVal);
        paramVal = ras.getAttribute("CONNECT_ATTEMPT_INTERVAL");
        if (paramVal == null) {
            paramVal = new Long(30L);
        }
        props.put("CONNECT_ATTEMPT_INTERVAL", paramVal);
        paramVal = ras.getAttribute("CONNECT_IDLE_TIMEOUT");
        if (paramVal == null) {
            paramVal = new Integer(300);
        }
        props.put("CONNECT_IDLE_TIMEOUT", paramVal);
        paramVal = ras.getAttribute("INDOUBT_TIMEOUT");
        if (paramVal == null) {
            paramVal = new Long(36000L);
        }
        props.put("INDOUBT_TIMEOUT", paramVal);
        paramVal = ras.getAttribute("INDOUBT_RECONNECT_INTERVAL");
        if (paramVal == null) {
            paramVal = new Long(300L);
        }
        props.put("INDOUBT_RECONNECT_INTERVAL", paramVal);
        paramVal = ras.getAttribute("ROUTING_TIMEOUT");
        if (paramVal == null) {
            paramVal = new Long(7200L);
        }
        props.put("ROUTING_TIMEOUT", paramVal);
        paramVal = ras.getAttribute("ENABLE_GLOBAL_SUBCRIPTIONS_FORWARDING");
        if (paramVal == null) {
            paramVal = new Boolean(false).toString();
        }
        props.put("ENABLE_GLOBAL_SUBCRIPTIONS_FORWARDING", paramVal);
        paramVal = ras.getAttribute("RECOVERY_RECONNECT_TIMEOUT");
        if (paramVal != null) {
            props.put("RECOVERY_RECONNECT_TIMEOUT", paramVal);
        }
        if ((paramVal = ras.getAttribute("ACKEXCHANGE_TIMEOUT")) != null) {
            props.put("ACKEXCHANGE_TIMEOUT", paramVal);
        }
        if ((paramVal = ras.getAttribute("DISABLE_ACKEXCHANGE")) != null) {
            props.put("DISABLE_ACKEXCHANGE", paramVal);
        }
        if ((paramVal = ras.getAttribute("DISABLE_QR_RECOVERY")) != null) {
            props.put("DISABLE_QR_RECOVERY", paramVal);
        }
        if ((paramVal = ras.getAttribute("DISABLE_INDOUBT_RECONNECT")) != null) {
            props.put("DISABLE_INDOUBT_RECONNECT", paramVal);
        }
        if ((paramVal = ras.getAttribute("GLOBAL_SUBSCRIPTION_EXPIRATION")) != null) {
            props.put("GLOBAL_SUBSCRIPTION_EXPIRATION", paramVal);
        }
        if ((paramVal = ras.getAttribute("DISCONNECTED_PENDING_MAX_QUEUE_SIZE")) != null) {
            props.put("DISCONNECTED_PENDING_MAX_QUEUE_SIZE", paramVal);
        }
        if ((paramVal = ras.getAttribute("DISCONNECTED_PENDING_SAVE_THRESHOLD")) != null) {
            props.put("DISCONNECTED_PENDING_SAVE_THRESHOLD", paramVal);
        }
        if ((paramVal = ras.getAttribute("FLOW_CONTROLLED_PENDING_MAX_QUEUE_SIZE")) != null) {
            props.put("FLOW_CONTROLLED_PENDING_MAX_QUEUE_SIZE", paramVal);
        }
        if ((paramVal = ras.getAttribute("FLOW_CONTROLLED_PENDING_SAVE_THRESHOLD")) != null) {
            props.put("FLOW_CONTROLLED_PENDING_SAVE_THRESHOLD", paramVal);
        }
        if ((paramVal = ras.getAttribute("REMOTE_BROKER_MONITOR_INTERVAL")) != null) {
            props.put("REMOTE_BROKER_MONITOR_INTERVAL", paramVal);
        }
        if ((paramVal = ras.getAttribute("REMOTE_BROKER_CONNECT_TIMEOUT")) != null) {
            props.put("REMOTE_BROKER_CONNECT_TIMEOUT", paramVal);
        }
        if ((paramVal = ras.getAttribute("REMOTE_BROKER_MONITOR_TIMEOUT")) != null) {
            props.put("REMOTE_BROKER_MONITOR_TIMEOUT", paramVal);
        }
        if ((paramVal = ras.getAttribute("FC_MONITOR_INTERVAL")) == null) {
            paramVal = new Integer(15);
        }
        props.put("FC_MONITOR_INTERVAL", paramVal);
        bindHelper.bindRoutingParametersChangeHandler(ras);
        IAttributeSet lbas = (IAttributeSet)das.getAttribute("BROKER_CLUSTER_PARAMETERS");
        IAttributeSet blbas = null;
        if (bdas != null) {
            blbas = (IAttributeSet)bdas.getAttribute("BROKER_CLUSTER_PARAMETERS");
        }
        if ((paramVal = lbas.getAttribute("CLUSTER_RECONNECT_INTERVAL")) == null) {
            paramVal = new Integer(10);
        }
        props.put("CLUSTER_RECONNECT_INTERVAL", paramVal);
        paramVal = lbas.getAttribute("ENABLE_LOAD_BALANCING");
        if (paramVal == null) {
            paramVal = new Boolean(true);
        }
        props.put("ENABLE_LOAD_BALANCING", paramVal);
        paramVal = ConfigPropertiesPopulator.getLoadBalancingWeightAttr(lbas, blbas);
        if (paramVal == null) {
            paramVal = new Integer(1);
        }
        props.put("LOAD_BALANCING_WEIGHT", paramVal);
        paramVal = lbas.getAttribute("LOAD_BALANCER");
        if (paramVal != null) {
            props.put("LOAD_BALANCER", paramVal);
        }
        if ((paramVal = (ddas = (IAttributeSet)das.getAttribute("DUPLICATE_DETECTION_PARAMETERS")).getAttribute("INDEXED_TXN")) == null) {
            paramVal = new Boolean(false);
        }
        if (((Boolean)paramVal).booleanValue()) {
            props.put("INDEXED_TXN", paramVal);
            paramVal = ddas.getAttribute("INDEXED_TXN_TABLE_NAME");
            if (paramVal != null) {
                props.put("INDEXED_TXN_TABLE_NAME", paramVal);
            }
            if ((paramVal = ddas.getAttribute("INDEXED_TXN_DB_USER")) != null) {
                props.put("INDEXED_TXN_DB_USER", paramVal);
            }
            if ((paramVal = ddas.getAttribute("INDEXED_TXN_DB_PASSWORD")) != null) {
                props.put("INDEXED_TXN_DB_PASSWORD", paramVal);
            }
            if ((paramVal = ddas.getAttribute("INDEXED_TXN_JDBC_DRIVER")) != null) {
                props.put("INDEXED_TXN_JDBC_DRIVER", paramVal);
            }
            if ((paramVal = ddas.getAttribute("INDEXED_TXN_DB_CONNECT")) != null) {
                props.put("INDEXED_TXN_DB_CONNECT", paramVal);
            }
            if ((paramVal = ddas.getAttribute("INDEXED_TXN_DB_PROPERTIES")) != null) {
                props.put("INDEXED_TXN_DB_PROPERTIES", paramVal);
            }
            if ((paramVal = ddas.getAttribute("INDEXED_TXN_DEFAULT_LIFESPAN")) != null) {
                props.put("INDEXED_TXN_DEFAULT_LIFESPAN", paramVal);
            }
            if ((paramVal = ddas.getAttribute("INDEXED_TXN_CLEANUP_INTERVAL")) != null) {
                props.put("INDEXED_TXN_CLEANUP_INTERVAL", paramVal);
            }
            if ((paramVal = ddas.getAttribute("INDEXED_TXN_DB_SHARED")) == null) {
                paramVal = new Boolean(false);
            }
            props.put("INDEXED_TXN_DB_SHARED", paramVal);
        }
        if ((ftpas = (IAttributeSet)das.getAttribute("BROKER_FAULT_TOLERANT_PARAMETERS")) != null) {
            paramVal = ftpas.getAttribute("FT_REPLICATE_NON_PERSISTENT");
            if (paramVal != null) {
                props.put("FT_REPLICATE_NON_PERSISTENT", paramVal);
            }
            if ((paramVal = ftpas.getAttribute("DUAL_ACTIVE_RESOLUTION")) != null) {
                props.put("DUAL_ACTIVE_RESOLUTION", paramVal);
            }
        }
        IAttributeSet ftas = (IAttributeSet)das.getAttribute("BROKER_REPLICATION_PARAMETERS");
        IAttributeSet bftas = null;
        if (bdas != null) {
            bftas = (IAttributeSet)bdas.getAttribute("BROKER_REPLICATION_PARAMETERS");
        }
        Object object = paramVal = bdas != null ? ConfigPropertiesPopulator.getBackupStartActiveAttr(bftas) : ConfigPropertiesPopulator.getPrimaryStartActiveAttr(ftas);
        if (paramVal == null) {
            paramVal = new Boolean(false);
        }
        props.put("START_ACTIVE", paramVal);
        if (ftas != null) {
            paramVal = ftas.getAttribute("FAILURE_DETECT_CALLBACK");
            if (paramVal != null) {
                props.put("FAILURE_DETECT_CALLBACK", paramVal);
            }
            if ((paramVal = ftas.getAttribute("REPLICATE_PERSISTENT")) == null) {
                paramVal = new Boolean(false);
            }
            props.put("REPLICATE_PERSISTENT", paramVal);
            paramVal = ftas.getAttribute("FAILURE_DETECT_TIMEOUT");
            if (paramVal == null) {
                paramVal = new Long(0L);
            }
            props.put("FAILURE_DETECT_TIMEOUT", paramVal);
            paramVal = ftas.getAttribute("RETRY_INTERVAL");
            if (paramVal != null) {
                props.put("RETRY_INTERVAL", paramVal);
            }
            if ((paramVal = ftas.getAttribute("CONNECT_TIMEOUT")) != null) {
                props.put("CONNECT_TIMEOUT", paramVal);
            }
            if ((paramVal = ftas.getAttribute("PING_INTERVAL")) != null) {
                props.put("PING_INTERVAL", paramVal);
            }
            if ((paramVal = ftas.getAttribute("PING_TIMEOUT")) != null) {
                props.put("PING_TIMEOUT", paramVal);
            }
            if ((paramVal = ftas.getAttribute("REPLICATION_CHUNK_SIZE")) == null) {
                paramVal = new Integer(102400);
            }
            props.put("REPLICATION_CHUNK_SIZE", paramVal);
            paramVal = ftas.getAttribute("PREFERRED_ACTIVE");
            if (paramVal == null) {
                paramVal = "Primary";
            }
            props.put("PREFERRED_ACTIVE", paramVal);
        }
        if ((spas = (IAttributeSet)das.getAttribute("BROKER_SSL_PARAMETERS")) != null) {
            ConfigPropertiesPopulator.getBrokerSSLAttributes(spas, props);
        }
        if (bdas != null && (spas = (IAttributeSet)bdas.getAttribute("BROKER_SSL_PARAMETERS")) != null) {
            ConfigPropertiesPopulator.getBrokerSSLAttributes(spas, props);
        }
        if ((wsas = (IAttributeSet)das.getAttribute("WS_SECURITY_PARAMETERS")) != null) {
            ConfigPropertiesPopulator.getWSSecurityAttributes(wsas, props);
        }
        if ((wras = (IAttributeSet)das.getAttribute("WS_RM_PARAMETERS")) != null) {
            ConfigPropertiesPopulator.getWSRMAttributes(wras, props);
        }
    }

    private static void getBackupDebugConfig(IAttributeSet bdas, Properties props) throws Exception {
        Object paramVal = null;
        IAttributeSet bdbgas = (IAttributeSet)bdas.getAttribute("BROKER_DEBUG_PARAMETERS");
        if (bdbgas != null) {
            paramVal = bdbgas.getAttribute("DS_CONFIGURED");
            if (paramVal != null) {
                props.put("DS_CONFIGURED", paramVal);
            }
            if ((paramVal = bdbgas.getAttribute("DS_DEBUG")) != null) {
                props.put("DS_DEBUG", paramVal);
            }
            if ((paramVal = bdbgas.getAttribute("BROKER_DEBUG")) != null) {
                props.put("BROKER_DEBUG", paramVal);
            }
            if ((paramVal = bdbgas.getAttribute("DEBUG")) != null) {
                props.put("DEBUG", paramVal);
            }
            if ((paramVal = bdbgas.getAttribute("DEBUG_CALLBACK")) != null) {
                props.put("DEBUG_CALLBACK", paramVal);
            }
            if ((paramVal = bdbgas.getAttribute("FLOW_DEBUG")) != null) {
                props.put("FLOW_DEBUG", paramVal);
            }
            if ((paramVal = bdbgas.getAttribute("DEBUG_NAME")) != null) {
                props.put("DEBUG_NAME", paramVal);
            }
            if ((paramVal = bdbgas.getAttribute("DEBUG_DIAGNOSTICS")) != null) {
                props.put("DEBUG_DIAGNOSTICS", paramVal);
            }
            if ((paramVal = bdbgas.getAttribute("DEBUG_THREAD_NAME")) != null) {
                props.put("DEBUG_THREAD_NAME", paramVal);
            }
            if ((paramVal = bdbgas.getAttribute("DEBUG_FT_CONNECTIONS")) != null) {
                props.put("DEBUG_FT_CONNECTIONS", paramVal);
            }
            if ((paramVal = bdbgas.getAttribute("DEBUG_FILTERS")) != null) {
                props.put("DEBUG_FILTERS", paramVal);
            }
        }
    }

    private static void getPrimaryDebugConfig(IAttributeSet das, Properties props) throws Exception {
        Object paramVal = null;
        IAttributeSet dbgas = (IAttributeSet)das.getAttribute("DEBUG_PARAMETERS");
        if (dbgas != null) {
            paramVal = dbgas.getAttribute("DS_CONFIGURED");
            if (paramVal != null) {
                props.put("DS_CONFIGURED", paramVal);
            }
            if ((paramVal = dbgas.getAttribute("DS_DEBUG")) != null) {
                props.put("DS_DEBUG", paramVal);
            }
            if ((paramVal = dbgas.getAttribute("BROKER_DEBUG")) != null) {
                props.put("BROKER_DEBUG", paramVal);
            }
            if ((paramVal = dbgas.getAttribute("DEBUG")) != null) {
                props.put("DEBUG", paramVal);
            }
            if ((paramVal = dbgas.getAttribute("DEBUG_CALLBACK")) != null) {
                props.put("DEBUG_CALLBACK", paramVal);
            }
            if ((paramVal = dbgas.getAttribute("FLOW_DEBUG")) != null) {
                props.put("FLOW_DEBUG", paramVal);
            }
            if ((paramVal = dbgas.getAttribute("DEBUG_NAME")) != null) {
                props.put("DEBUG_NAME", paramVal);
            }
            if ((paramVal = dbgas.getAttribute("DEBUG_DIAGNOSTICS")) != null) {
                props.put("DEBUG_DIAGNOSTICS", paramVal);
            }
            if ((paramVal = dbgas.getAttribute("DEBUG_THREAD_NAME")) != null) {
                props.put("DEBUG_THREAD_NAME", paramVal);
            }
            if ((paramVal = dbgas.getAttribute("DEBUG_FT_CONNECTIONS")) != null) {
                props.put("DEBUG_FT_CONNECTIONS", paramVal);
            }
            if ((paramVal = dbgas.getAttribute("DEBUG_FILTERS")) != null) {
                props.put("DEBUG_FILTERS", paramVal);
            }
        }
    }

    private static void getExternalSecurityDomainInfo(String usersDir, IComponentContext context, Properties props, ConfigurationChangeBindHelper bindHelper) {
        Reference ref;
        IAttributeSet attributeSet;
        String s;
        int index = usersDir.lastIndexOf("/");
        String domainDir = usersDir.substring(0, index);
        if (domainDir == null) {
            return;
        }
        String descriptorName = domainDir + "/" + "_MFDomainDescriptor";
        IElement element = null;
        try {
            element = context.getConfiguration(descriptorName, true);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (element == null) {
            return;
        }
        ExternalDomainAuthSPIConfig authenticationSPIFactory = new ExternalDomainAuthSPIConfig();
        IAttributeSet authenticationDomainAttributeSet = element.getAttributes();
        AttributeName name = new AttributeName("EXTERNAL");
        Boolean flag = (Boolean)element.getAttribute(name);
        if (flag != null) {
            authenticationSPIFactory.setExternalDomainFlag(flag);
            if (!flag.booleanValue()) {
                return;
            }
        } else {
            authenticationSPIFactory.setExternalDomainFlag(Boolean.FALSE);
        }
        if ((s = (String)element.getAttribute(name = new AttributeName("DOMAIN_NAME"))) != null) {
            authenticationSPIFactory.setExternalDomainName(s);
        }
        if ((attributeSet = (IAttributeSet)element.getAttribute(name = new AttributeName("GROUP_MAP"))) != null) {
            HashMap groupMap = attributeSet.getAttributes();
            if (groupMap != null) {
                for (String key : groupMap.keySet()) {
                    if (key == null) continue;
                    String values = (String)groupMap.get(key);
                    groupMap.put(key, values);
                }
            }
            authenticationSPIFactory.setGroupMap(groupMap);
            bindHelper.bindExternalDomainGroupMapChangeHandler(attributeSet);
        }
        String string = s = (ref = (Reference)element.getAttribute(name = new AttributeName("AUTH_SPI"))) == null ? null : ref.getElementName();
        if (s != null) {
            authenticationSPIFactory.setReferenceName(s);
            IElement e = context.getConfiguration(s, true);
            if (e != null && (attributeSet = e.getAttributes()) != null) {
                IAttributeList list;
                name = new AttributeName("AUTH_SPI_NAME");
                s = (String)attributeSet.getAttribute(name);
                if (s != null) {
                    authenticationSPIFactory.setAuthSPIName(s);
                }
                if ((s = (String)attributeSet.getAttribute(name = new AttributeName("CLASS_NAME"))) != null) {
                    authenticationSPIFactory.setClassName(s);
                }
                if ((list = (IAttributeList)attributeSet.getAttribute(name = new AttributeName("CLASSPATH"))) != null) {
                    authenticationSPIFactory.setClasspath(list.getItems());
                }
                bindHelper.bindAuthSPIDefinationChangeHandler(attributeSet);
            }
        }
        if ((attributeSet = (IAttributeSet)element.getAttribute(name = new AttributeName("AUTH_SPI_CONNECTION_PARAMETERS"))) != null) {
            authenticationSPIFactory.setAttributeSettings(attributeSet.getAttributes());
            bindHelper.bindAuthSPIAttributeSettingsChangeHandler(attributeSet);
        }
        bindHelper.bindExternalDomainAuthSPINameChangeHandler(authenticationDomainAttributeSet);
        props.put("ExternalDomainAuthSpiConfig", authenticationSPIFactory);
    }

    private static void getClusterPeerInfo(IComponentContext context, IElement cce, Properties props, AttributesHolder attributesHolder, ConfigurationChangeBindHelper bindHelper) {
        IAttributeSet das = cce.getAttributes();
        attributesHolder.setTopLevelClusterPeerAttributeSet(das);
        String clusterName = (String)das.getAttribute("CLUSTER_NAME");
        if (clusterName != null) {
            props.put("CLUSTER_NAME", clusterName);
        }
        String clusterRoutingNodeName = (String)das.getAttribute("ROUTING_NODE_NAME");
        String brokerName = (String)props.get("BROKER_NAME");
        String routingNodeName = (String)props.get("ROUTING_NODE_NAME");
        AttributeName an = new AttributeName("CLUSTER_MEMBERS");
        IAttributeSet peersAS = (IAttributeSet)das.getAttribute(an);
        Hashtable<String, FTPairPeerInfoHolder> peerInfoTable = new Hashtable<String, FTPairPeerInfoHolder>();
        if (peersAS != null) {
            Hashtable<String, FTPairPeerInfoHolder> h = new Hashtable<String, FTPairPeerInfoHolder>();
            Iterator it = peersAS.getAttributes().entrySet().iterator();
            HashMap<String, String> brokerNameMap = new HashMap<String, String>();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String attributeName = (String)entry.getKey();
                Reference peerBrokerRef = (Reference)entry.getValue();
                String buceStr = peerBrokerRef.getElementName();
                boolean needUpdates = true;
                IElement buce = context.getConfiguration(buceStr, needUpdates);
                IAttributeSet buas = buce.getAttributes();
                String peerBrokerName = (String)buas.getAttribute("BROKER_NAME");
                IAttributeSet peerRAS = (IAttributeSet)buas.getAttribute("BROKER_ROUTING_PARAMETERS");
                String peerRoutingNodeName = (String)peerRAS.getAttribute("ROUTING_NODE_NAME");
                if (!(clusterRoutingNodeName != null && clusterRoutingNodeName.length() != 0 || peerRoutingNodeName.equals(routingNodeName))) {
                    String conflict = MessageFormat.format(prAccessor.getString("CLUSTERED_ROUTING_NODE_NAME_MISMATCH"), peerBrokerName, peerRoutingNodeName, brokerName, routingNodeName, clusterName);
                    context.logMessage(conflict, 2);
                }
                brokerNameMap.put(attributeName, peerBrokerName);
                FTPairPeerInfoHolder holder = ConfigPropertiesPopulator.getFTPairPeerInfoHolder(context, peerBrokerName, buce);
                h.put(peerBrokerName, holder);
                if (holder != null) {
                    peerInfoTable.put(peerBrokerName, holder);
                }
                bindHelper.bindBrokerAcceptorChangeDelegator(peerBrokerName, buce);
            }
            bindHelper.bindClusterPeerUpdateChangeHandler(clusterName, peersAS, brokerNameMap);
            props.put("PEER_INFO_HASHTABLE", peerInfoTable);
        }
    }

    private static void getPeerAcceptorInfo(IComponentContext context, IElement ace, String peerDefaultRoutingURL, Hashtable peerAcceptorTable, String peerName, boolean isPeerPrimary, Hashtable peerProtocolsTable) {
        boolean hasPeerDefaultRoutingURL = false;
        String pdruProtocolType = null;
        if (peerDefaultRoutingURL != null && !"".equals(peerDefaultRoutingURL)) {
            hasPeerDefaultRoutingURL = true;
            pdruProtocolType = peerDefaultRoutingURL.startsWith("ssl://") || peerDefaultRoutingURL.startsWith("SSL://") ? "SSL" : (peerDefaultRoutingURL.startsWith("http://") || peerDefaultRoutingURL.startsWith("HTTP://") ? "HTTP" : (peerDefaultRoutingURL.startsWith("https://") || peerDefaultRoutingURL.startsWith("HTTPS://") ? "HTTPS" : "TCP"));
        }
        Vector peerURLList = null;
        AttributeName an = new AttributeName("ACCEPTORS");
        IAttributeSet alas = (IAttributeSet)ace.getAttribute(an);
        for (Reference ref2 : alas.getAttributes().values()) {
            AttributeName protocolsAttr;
            IAttributeSet protocolsAttrSet;
            String pbaCID = ref2.getElementName();
            IElement pbaCE = context.getConfiguration(pbaCID, true);
            IAttributeSet pbadas = pbaCE.getAttributes();
            String acceptorName = (String)pbadas.getAttribute("ACCEPTOR_NAME");
            String externalURL = (String)pbadas.getAttribute("ACCEPTOR_EXTERNAL_URL");
            if (externalURL != null && externalURL.trim().length() != 0) {
                peerURLList = (Vector)peerAcceptorTable.get(acceptorName);
                if (peerURLList == null) {
                    peerURLList = new Vector();
                    peerAcceptorTable.put(acceptorName, peerURLList);
                }
                peerURLList.addElement(externalURL);
            } else if (hasPeerDefaultRoutingURL) {
                String acceptorURL;
                peerURLList = (Vector)peerAcceptorTable.get(acceptorName);
                if (peerURLList != null) continue;
                String acceptorType = (String)pbadas.getAttribute("ACCEPTOR_TYPE");
                if (acceptorType.equals("TCPS")) {
                    acceptorURL = (String)pbadas.getAttribute("ACCEPTOR_URL");
                    acceptorType = !acceptorURL.startsWith("ssl://") && !acceptorURL.startsWith("SSL://") ? "TCP" : "SSL";
                } else if (acceptorType.equals("TUNNELING")) {
                    acceptorURL = (String)pbadas.getAttribute("ACCEPTOR_URL");
                    acceptorType = !acceptorURL.startsWith("https://") && !acceptorURL.startsWith("HTTPS://") ? "HTTP" : "HTTPS";
                }
                if (acceptorType.equalsIgnoreCase(pdruProtocolType)) {
                    peerURLList = new Vector();
                    peerURLList.addElement(peerDefaultRoutingURL);
                    peerAcceptorTable.put(acceptorName, peerURLList);
                }
            } else {
                String acceptorURL = (String)pbadas.getAttribute("ACCEPTOR_URL");
                if (acceptorURL.endsWith(Acceptor.BIND_TO_SPECIFIED_IP_OR_HOST_ONLY)) {
                    acceptorURL = acceptorURL.substring(0, acceptorURL.lastIndexOf(Acceptor.BIND_TO_SPECIFIED_IP_OR_HOST_ONLY));
                }
                if ((peerURLList = (Vector)peerAcceptorTable.get(acceptorName)) == null) {
                    peerURLList = new Vector();
                    peerAcceptorTable.put(acceptorName, peerURLList);
                }
                peerURLList.addElement(acceptorURL);
            }
            Hashtable<String, String> peerProtocols = null;
            String type = (String)pbadas.getAttribute("ACCEPTOR_TYPE");
            if (!type.equals("DIRECT") || (protocolsAttrSet = (IAttributeSet)pbadas.getAttribute(protocolsAttr = new AttributeName("PROTOCOLS"))) == null || protocolsAttrSet.getAttributes() == null || protocolsAttrSet.getAttributes().isEmpty()) continue;
            for (Reference ref2 : protocolsAttrSet.getAttributes().values()) {
                String hdceCID = ref2.getElementName();
                IElement hdce = context.getConfiguration(hdceCID, true);
                IAttributeSet das = hdce.getAttributes();
                String handlerName = (String)das.getAttribute("DIRECT_NAME");
                String handlerType = (String)das.getAttribute("DIRECT_TYPE");
                if (peerProtocols == null) {
                    peerProtocols = new Hashtable<String, String>();
                }
                peerProtocols.put(handlerName, handlerType);
            }
            if (peerProtocols.isEmpty()) continue;
            peerProtocolsTable.put(acceptorName, peerProtocols);
        }
    }

    private static void getQueueConfig(IComponentContext context, IElement qce, Properties props, boolean isClustered, IElement cce, AttributesHolder attributesHolder) {
        AttributeName an;
        Hashtable<String, QueueHolder> queues = new Hashtable<String, QueueHolder>();
        QueueHolder qHolder = null;
        if (isClustered) {
            IAttributeSet das = cce.getAttributes();
            an = new AttributeName("CONFIG_ELEMENT_REFERENCES");
            IAttributeSet ceas = (IAttributeSet)das.getAttribute(an);
            Reference cqRef = (Reference)ceas.getAttribute(an = new AttributeName("QUEUE_CONFIG_ELEMENT_REF"));
            if (cqRef != null) {
                String cqCID = cqRef.getElementName();
                IElement cqce = context.getConfiguration(cqCID, true);
                IAttributeSet qdas = cqce.getAttributes();
                an = new AttributeName("QUEUES");
                IAttributeSet qAttrs = (IAttributeSet)qdas.getAttribute(an);
                attributesHolder.addClusteredTopLevelQueueAttributeSet(qAttrs);
                HashMap map = qAttrs.getAttributes();
                Set set = map.entrySet();
                Iterator it = set.iterator();
                Map.Entry me = null;
                while (it.hasNext()) {
                    me = it.next();
                    if (me == null) continue;
                    IAttributeSet attrs = (IAttributeSet)me.getValue();
                    String queueName = (String)attrs.getAttribute("QUEUE_NAME");
                    String queueType = "AdministrativelyCreated";
                    Object paramVal = attrs.getAttribute("QUEUE_TYPE");
                    if (paramVal != null) {
                        queueType = (String)paramVal;
                    }
                    int queueMaxSize = 1000;
                    paramVal = attrs.getAttribute("QUEUE_MAX_SIZE");
                    if (paramVal != null) {
                        queueMaxSize = (Integer)paramVal;
                    }
                    int queueSaveThreshold = 1536;
                    paramVal = attrs.getAttribute("QUEUE_SAVE_THRESHOLD");
                    if (paramVal != null) {
                        queueSaveThreshold = (Integer)paramVal;
                    }
                    boolean global = false;
                    paramVal = attrs.getAttribute("GLOBAL");
                    if (paramVal != null) {
                        global = (Boolean)paramVal;
                    }
                    boolean readX = false;
                    paramVal = attrs.getAttribute("READ_EXCLUSIVE");
                    if (paramVal != null) {
                        readX = (Boolean)paramVal;
                    }
                    qHolder = new QueueHolder(queueName, queueType, queueMaxSize, queueSaveThreshold, global, readX, true);
                    queues.put(queueName, qHolder);
                    attributesHolder.addQueueAttributeSet(queueName, attrs);
                }
            }
        }
        IAttributeSet qdas = qce.getAttributes();
        an = new AttributeName("QUEUES");
        IAttributeSet qAttrs = (IAttributeSet)qdas.getAttribute(an);
        attributesHolder.addUnclusteredTopLevelQueueAttributeSet(qAttrs);
        HashMap map = qAttrs.getAttributes();
        Set set = map.entrySet();
        Iterator it = set.iterator();
        Map.Entry me = null;
        while (it.hasNext()) {
            me = it.next();
            if (me == null) continue;
            IAttributeSet attrs = (IAttributeSet)me.getValue();
            String queueName = (String)attrs.getAttribute("QUEUE_NAME");
            if (isClustered && queues.containsKey(queueName)) {
                String clusterName = (String)props.get("CLUSTER_NAME");
                if (clusterName == null) {
                    clusterName = "";
                }
                String conflict = MessageFormat.format(prAccessor.getString("CLUSTERED_QUEUE_NAME_CONFLICT"), queueName, clusterName);
                context.logMessage(conflict, 3);
                continue;
            }
            String queueType = "AdministrativelyCreated";
            Object paramVal = attrs.getAttribute("QUEUE_TYPE");
            if (paramVal != null) {
                queueType = (String)paramVal;
            }
            int queueMaxSize = 1000;
            paramVal = attrs.getAttribute("QUEUE_MAX_SIZE");
            if (paramVal != null) {
                queueMaxSize = (Integer)paramVal;
            }
            int queueSaveThreshold = 1536;
            paramVal = attrs.getAttribute("QUEUE_SAVE_THRESHOLD");
            if (paramVal != null) {
                queueSaveThreshold = (Integer)paramVal;
            }
            boolean global = false;
            paramVal = attrs.getAttribute("GLOBAL");
            if (paramVal != null) {
                global = (Boolean)paramVal;
            }
            boolean readX = false;
            paramVal = attrs.getAttribute("READ_EXCLUSIVE");
            if (paramVal != null) {
                readX = (Boolean)paramVal;
            }
            if (queueName.equals("SonicMQ.routingQueue")) {
                qHolder = new QueueHolder(queueName, "System", queueMaxSize, queueSaveThreshold, global, readX, false);
                queues.put(queueName, qHolder);
            } else if (queueName.equals("SonicMQ.deadMessage")) {
                qHolder = new QueueHolder(queueName, "System", queueMaxSize, queueSaveThreshold, global, readX, false);
                queues.put(queueName, qHolder);
            } else {
                qHolder = new QueueHolder(queueName, queueType, queueMaxSize, queueSaveThreshold, global, readX, false);
                paramVal = attrs.getAttribute("ENABLE_MESSAGE_GROUPING");
                if (paramVal != null && ((Boolean)paramVal).booleanValue()) {
                    qHolder.setMessageGroupEnabled(true);
                    paramVal = attrs.getAttribute("ALTERNATE_GROUP_NAME");
                    if (paramVal != null) {
                        qHolder.setMessageGroupIDPropertyName((String)paramVal);
                    }
                    if ((paramVal = attrs.getAttribute("GROUP_IDLE_TIMEOUT")) != null) {
                        qHolder.setMessageGroupIdleTimeoutInSeconds((Integer)paramVal * 60);
                    }
                    if ((paramVal = attrs.getAttribute("MAX_WAIT_TIME")) != null) {
                        qHolder.setMessageGroupMaxWaitTimeInSeconds((Integer)paramVal);
                    }
                    if ((paramVal = attrs.getAttribute("MIN_CONSUMERS")) != null) {
                        qHolder.setMessageGroupMinReceivers((Integer)paramVal);
                    }
                }
                queues.put(queueName, qHolder);
            }
            attributesHolder.addQueueAttributeSet(queueName, attrs);
        }
        props.put("QUEUES_HASHTABLE", queues);
    }

    private static void getPrincipals(IComponentContext context, IElement[] userConfigElems, IElement[] groupConfigElems, Hashtable principals, Properties props, AttributesHolder attributesHolder, ConfigurationChangeBindHelper bindHelper) {
        ProgressPasswordUser user = null;
        IElement userConfigElem = null;
        IAttributeSet das = null;
        String principalName = null;
        byte[] pwd = null;
        for (int i = 0; i < userConfigElems.length; ++i) {
            userConfigElem = userConfigElems[i];
            das = userConfigElem.getAttributes();
            principalName = (String)das.getAttribute("USER_NAME");
            if (principalName != null && principalName.indexOf(".") != -1) {
                principalName = principalName.replace('.', '$');
            }
            pwd = (byte[])das.getAttribute("PASSWORD");
            user = new ProgressPasswordUser(principalName, pwd);
            principals.put(principalName, user);
            bindHelper.bindRemoveUserChangeHandler(principalName, das);
            bindHelper.bindUserPasswordChangeHandler(user, das);
        }
        ProgressGroup group = null;
        IElement groupConfigElem = null;
        String groupName = null;
        AttributeName an = new AttributeName("GROUP_MEMBERS");
        IAttributeSet gmas = null;
        for (int i = 0; i < groupConfigElems.length; ++i) {
            groupConfigElem = groupConfigElems[i];
            das = groupConfigElem.getAttributes();
            groupName = (String)das.getAttribute("GROUP_NAME");
            Hashtable<String, ProgressPasswordUser> membersUsers = new Hashtable<String, ProgressPasswordUser>();
            gmas = (IAttributeSet)das.getAttribute(an);
            if (gmas != null) {
                HashMap map = gmas.getAttributes();
                Set set = map.entrySet();
                Iterator it = set.iterator();
                Map.Entry entry = null;
                while (it.hasNext()) {
                    entry = it.next();
                    if (entry == null) continue;
                    IAttributeSet as = (IAttributeSet)entry.getValue();
                    String memberName = (String)as.getAttribute("MEMBER_NAME");
                    String memberType = (String)as.getAttribute("MEMBER_TYPE");
                    if (!memberType.equalsIgnoreCase("USER")) continue;
                    user = (ProgressPasswordUser)principals.get(memberName = memberName.replace('.', '$'));
                    if (user == null) {
                        Object o = m_externalUsersToInternalGroup.get(groupName);
                        ArrayList<ProgressPasswordUser> users = null;
                        users = o == null ? new ArrayList<ProgressPasswordUser>() : (ArrayList<ProgressPasswordUser>)o;
                        if ((BrokerComponent.getBrokerComponent().getTraceMask() & 0x80) > 0) {
                            Object[] obj = new Object[]{memberName.replace('$', '.'), groupName};
                            String s = prMessageFormat.format(progress.message.broker.prAccessor.getString("STR358"), obj);
                            BrokerComponent.getComponentContext().logMessage(s, 7);
                        }
                        user = new ProgressPasswordUser(memberName, "");
                        user.setInternalPrincipal(false);
                        user.setExternalGroups(null);
                        users.add(user);
                        m_externalUsersToInternalGroup.put(groupName, users);
                    }
                    membersUsers.put(user.getName(), user);
                }
            }
            group = new ProgressGroup(groupName, membersUsers);
            Enumeration enumeration = membersUsers.elements();
            while (enumeration.hasMoreElements()) {
                user = (ProgressPasswordUser)enumeration.nextElement();
                if (user == null) continue;
                user.addGroup(group);
            }
            principals.put(groupName, group);
            bindHelper.bindRemoveGroupChangeHandler(groupName, das);
        }
    }

    private static void getACLs(IComponentContext context, IElement[] aclConfigElems, Properties props, Hashtable principals, Hashtable subjectACLs, Hashtable routingACLs, AttributesHolder attributesHolder, ConfigurationChangeBindHelper bindHelper) {
        String aclType = null;
        String principalName = null;
        String principalType = null;
        String resourceType = null;
        String resourceName = null;
        String permission = null;
        IElement aclConfigElem = null;
        IAttributeSet das = null;
        Vector<RoutingUserAclEntry> aclEntries = null;
        RoutingUserAclEntry ruae = null;
        boolean printed_dra_warning = false;
        for (int i = 0; i < aclConfigElems.length; ++i) {
            Principal p;
            aclConfigElem = aclConfigElems[i];
            das = aclConfigElem.getAttributes();
            aclType = (String)das.getAttribute("ACL_TYPE");
            principalName = (String)das.getAttribute("PRINCIPAL_NAME");
            principalType = (String)das.getAttribute("PRINCIPAL_TYPE");
            resourceType = (String)das.getAttribute("RESOURCE_TYPE");
            resourceName = (String)das.getAttribute("RESOURCE_NAME");
            permission = (String)das.getAttribute("PERMISSION");
            if (principalType.equalsIgnoreCase("USER") && principalName.indexOf(".") != -1) {
                principalName = principalName.replace('.', '$');
            }
            if (resourceType.equalsIgnoreCase("queue") && resourceName.startsWith("$Q.")) {
                throw new EAssertFailure("RESOURCE_NAME " + resourceName + " cannot have prefix " + "$Q.");
            }
            String internalName = DraDestUtil.resourceToSecSubject(resourceType, resourceName);
            if (internalName == null) {
                BrokerComponent.getComponentContext().logMessage("RESOURCE_NAME " + resourceName + " with " + "RESOURCE_TYPE" + " " + resourceType + " contains error ", 2);
                continue;
            }
            resourceName = internalName;
            aclEntries = aclType.equals("ROUTING_USER_ACL") ? (Vector<RoutingUserAclEntry>)routingACLs.get(resourceName) : (Vector)subjectACLs.get(resourceName);
            if (aclEntries == null) {
                aclEntries = new Vector<RoutingUserAclEntry>();
            }
            if ((p = (Principal)principals.get(principalName)) == null) {
                Object[] obj = new Object[]{principalName.replace('$', '.')};
                String s = prMessageFormat.format(progress.message.broker.prAccessor.getString("STR359"), obj);
                BrokerComponent.getComponentContext().logMessage(s, 3);
                if (principalType.equalsIgnoreCase("USER")) {
                    p = new ProgressPasswordUser(principalName, "");
                    ((ProgressPasswordUser)p).setInternalPrincipal(false);
                    ((ProgressPasswordUser)p).setExternalGroups(null);
                    ((ProgressPrincipal)p).setCreatedDueToACLEntry(true);
                    principals.put(principalName, p);
                } else if (principalType.equalsIgnoreCase("GROUP")) {
                    p = new ProgressGroup(principalName);
                    ((ProgressGroup)p).setInternalPrincipal(false);
                    ((ProgressPrincipal)p).setCreatedDueToACLEntry(true);
                    principals.put(principalName, p);
                    m_externalGroupsToAdd.put(p.getName(), p);
                }
            }
            if (aclType.equals("ROUTING_USER_ACL")) {
                BrokerLicenseMgr lm = (BrokerLicenseMgr)((Object)props.get("LICENSE_MANAGER"));
                if (lm != null && !lm.isRoutingAllowed()) {
                    if (printed_dra_warning) continue;
                    String warning = MessageFormat.format(progress.message.broker.prAccessor.getString("DRA_NOT_SUPPORTED3"), lm.getProductName());
                    context.logMessage(warning, 2);
                    printed_dra_warning = true;
                    continue;
                }
                Enumeration enumeration = aclEntries.elements();
                ruae = null;
                while (enumeration.hasMoreElements() && !(ruae = (RoutingUserAclEntry)enumeration.nextElement()).getPrincipal().getName().equals(principalName)) {
                    ruae = null;
                }
                if (ruae == null) {
                    ruae = new RoutingUserAclEntry(p, resourceName);
                }
                ConfigPropertiesPopulator.setRoutingUserACL(ruae, permission);
                aclEntries.addElement(ruae);
                routingACLs.put(resourceName, aclEntries);
            } else if (resourceName.equals(DraDestUtil.SUBJECT_SONIC_URL_ALL)) {
                ConfigPropertiesPopulator.processAclEntryForResource(subjectACLs, null, DraDestUtil.SUBJECT_RNN_ALL_HTTP_ALL, principalName, p, aclType, permission);
                ConfigPropertiesPopulator.processAclEntryForResource(subjectACLs, null, DraDestUtil.SUBJECT_RNN_ALL_HTTPS_ALL, principalName, p, aclType, permission);
            } else {
                ConfigPropertiesPopulator.processAclEntryForResource(subjectACLs, aclEntries, resourceName, principalName, p, aclType, permission);
            }
            bindHelper.bindACLPermissionChangeHandler(principalName, principalType, resourceName, aclType, das);
            bindHelper.bindRemoveACLChangeHandler(principalName, principalType, resourceName, aclType, das);
        }
    }

    private static void processAclEntryForResource(Hashtable subjectACLs, Vector aclEntries, String resourceName, String principalName, Principal p, String aclType, String permission) {
        if (aclEntries == null && (aclEntries = (Vector)subjectACLs.get(resourceName)) == null) {
            aclEntries = new Vector<SubjectAclEntry>();
        }
        Enumeration enumeration = aclEntries.elements();
        SubjectAclEntry sae = null;
        while (enumeration.hasMoreElements() && !(sae = (SubjectAclEntry)enumeration.nextElement()).getPrincipal().getName().equals(principalName)) {
            sae = null;
        }
        if (sae == null) {
            sae = new SubjectAclEntry(p);
            aclEntries.addElement(sae);
        }
        ConfigPropertiesPopulator.setSubjectACL(sae, aclType, permission);
        ((ProgressPrincipal)p).addAclSubject(resourceName);
        subjectACLs.put(resourceName, aclEntries);
        if ("#".equals(resourceName)) {
            subjectACLs.put("$SonicMQ-Root-Subject", aclEntries);
        }
    }

    private static void setSubjectACL(SubjectAclEntry sae, String aclType, String permission) {
        try {
            if (permission.equalsIgnoreCase("GRANT")) {
                if (aclType.equalsIgnoreCase("PUBLISH_ACL")) {
                    sae.addPermission((byte)1);
                } else if (aclType.equalsIgnoreCase("SUBSCRIBE_ACL")) {
                    sae.addPermission((byte)2);
                } else if (aclType.equalsIgnoreCase("GUARANTEED_ACL")) {
                    sae.addPermission((byte)4);
                } else if (aclType.equalsIgnoreCase("SEND_ACL")) {
                    sae.addPermission((byte)1);
                } else if (aclType.equalsIgnoreCase("RECEIVE_ACL")) {
                    sae.addPermission((byte)2);
                } else if (aclType.equalsIgnoreCase("BROWSE_ACL")) {
                    sae.addPermission((byte)8);
                } else {
                    BrokerComponent.getComponentContext().logMessage("Unknown ACL type: " + aclType, 2);
                }
            } else if (permission.equalsIgnoreCase("DENY")) {
                if (aclType.equalsIgnoreCase("PUBLISH_ACL")) {
                    sae.addPermission((byte)-2);
                } else if (aclType.equalsIgnoreCase("SUBSCRIBE_ACL")) {
                    sae.addPermission((byte)-3);
                } else if (aclType.equalsIgnoreCase("GUARANTEED_ACL")) {
                    sae.addPermission((byte)-5);
                } else if (aclType.equalsIgnoreCase("SEND_ACL")) {
                    sae.addPermission((byte)-2);
                } else if (aclType.equalsIgnoreCase("RECEIVE_ACL")) {
                    sae.addPermission((byte)-3);
                } else if (aclType.equalsIgnoreCase("BROWSE_ACL")) {
                    sae.addPermission((byte)-9);
                } else {
                    BrokerComponent.getComponentContext().logMessage("Unknown ACL type: " + aclType, 2);
                }
            }
        }
        catch (EPermissionConflict pc) {
        }
        catch (EUnknownPermission eUnknownPermission) {
            // empty catch block
        }
    }

    private static void setRoutingUserACL(RoutingUserAclEntry ruae, String permission) {
        if (permission.equalsIgnoreCase("GRANT")) {
            ruae.setPosPermission();
        } else if (permission.equalsIgnoreCase("DENY")) {
            ruae.setNegPermission();
        }
    }

    private static void getQoPs(IComponentContext context, IElement[] qopConfigElems, Hashtable qops, AttributesHolder attributesHolder, ConfigurationChangeBindHelper bindHelper) {
        String qopName = null;
        String resourceType = null;
        String resourceName = null;
        IElement qopConfigElem = null;
        IAttributeSet das = null;
        QOP qop = null;
        int qopType = 0;
        for (int i = 0; i < qopConfigElems.length; ++i) {
            qopConfigElem = qopConfigElems[i];
            das = qopConfigElem.getAttributes();
            qopName = (String)das.getAttribute("QOP");
            resourceType = (String)das.getAttribute("RESOURCE_TYPE");
            resourceName = (String)das.getAttribute("RESOURCE_NAME");
            if (resourceType.equalsIgnoreCase("queue")) {
                if (resourceName.startsWith("$Q.")) {
                    throw new EAssertFailure("RESOURCE_NAME " + resourceName + " cannot have prefix " + "$Q.");
                }
                resourceName = QueueUtil.queueNameToSecSubject(resourceName);
            }
            if (qopName.equalsIgnoreCase("NONE")) {
                qopType = 0;
            } else if (qopName.equalsIgnoreCase("INTEGRITY")) {
                qopType = 1;
            } else if (qopName.equalsIgnoreCase("PRIVACY")) {
                qopType = 2;
            }
            qop = new QOP(qopType);
            qops.put(resourceName, qop);
            bindHelper.bindRemoveQoPChangeHandler(resourceName, das);
            bindHelper.bindQoPTypeChangeHandler(resourceName, das);
        }
        Object o = qops.get("#");
        if (o != null) {
            qops.put("$SonicMQ-Root-Subject", o);
        }
    }

    private static void getGlobalSubscriptionConfig(IComponentContext context, IElement remoteSubConfigElem, Properties props, ConfigurationChangeBindHelper bindHelper) {
        IAttributeSet gsas;
        Vector<RemoteSubscriptionHolder> remoteSubs = new Vector<RemoteSubscriptionHolder>();
        IAttributeSet das = remoteSubConfigElem.getAttributes();
        if (das != null && (gsas = (IAttributeSet)das.getAttribute("SUBSCRIPTIONS")) != null) {
            bindHelper.bindAddNewGSRuleChangeHandler(gsas);
            HashMap map = gsas.getAttributes();
            Set set = map.entrySet();
            Iterator it = set.iterator();
            Map.Entry me = null;
            while (it.hasNext()) {
                IAttributeSet attrs;
                me = it.next();
                if (me == null || (attrs = (IAttributeSet)me.getValue()) == null) continue;
                String topicName = (String)attrs.getAttribute("TOPIC");
                bindHelper.bindRemoveGSRuleChangeHandler(topicName, attrs);
                RemoteSubscriptionHolder remoteSubHolder = new RemoteSubscriptionHolder(topicName);
                IAttributeSet as = (IAttributeSet)attrs.getAttribute("NODES");
                if (as == null) continue;
                Iterator iterator = as.getAttributes().values().iterator();
                while (iterator.hasNext()) {
                    remoteSubHolder.addNode((String)iterator.next());
                }
                remoteSubs.addElement(remoteSubHolder);
                bindHelper.bindUpdateGSRuleChangeHandler(topicName, remoteSubHolder.getNodes(), attrs);
            }
        }
        props.put("GLOBAL_SUBSCRIPTIONS_VECTOR", remoteSubs);
    }

    public static ReplicationConnDef getReplicationConnDef(String name, IAttributeSet rcas) {
        String protocol = (String)rcas.getAttribute("PROTOCOL");
        if (protocol == null) {
            protocol = "TCP";
        }
        String primaryAddr = (String)rcas.getAttribute("PRIMARY_ADDR");
        Integer boxedPrimaryPort = (Integer)rcas.getAttribute("PRIMARY_PORT");
        int primaryPort = boxedPrimaryPort != null ? boxedPrimaryPort : 22506;
        String backupAddr = (String)rcas.getAttribute("BACKUP_ADDR");
        Integer boxedBackupPort = (Integer)rcas.getAttribute("BACKUP_PORT");
        int backupPort = boxedBackupPort != null ? boxedBackupPort : 22506;
        Integer boxedWeight = (Integer)rcas.getAttribute("WEIGHT");
        int weight = boxedWeight != null ? boxedWeight : 1;
        Boolean useDynamicHost = (Boolean)m_props.get("USE_DYNAMIC_HOST_BINDING");
        String hostname = null;
        if (!(!useDynamicHost.booleanValue() || (hostname = System.getProperty("sonicsw.mf.publicHost")) != null && hostname.length() != 0 || (hostname = System.getProperty("sonicsw.mf.privateHost")) != null && hostname.length() != 0)) {
            throw new EAssertFailure("\"sonicsw.mf.privateHost\", \"sonicsw.mf.publicHost\"  have not been determined");
        }
        ReplicationConnDef conndef = new ReplicationConnDef(name, protocol, primaryAddr, primaryPort, backupAddr, backupPort, weight, null, rcas, hostname);
        return conndef;
    }

    private static void getReplicationConnectionConfig(IComponentContext context, IElement rcce, Properties props, ConfigurationChangeBindHelper bindHelper) throws ESocketConfigException {
        IAttributeSet clas = rcce.getAttributes();
        IAttributeSet clist = (IAttributeSet)clas.getAttribute("REPLICATION_CONNECTIONS");
        bindHelper.bindAddNewReplicationChannelChangeHandler(clist);
        Hashtable<String, ReplicationConnDef> replicationConns = new Hashtable<String, ReplicationConnDef>();
        for (String key : clist.getAttributes().keySet()) {
            IAttributeSet conn = (IAttributeSet)clist.getAttribute(key);
            String name = (String)conn.getAttribute("NAME");
            ReplicationConnDef conndef = ConfigPropertiesPopulator.getReplicationConnDef(name, conn);
            replicationConns.put(name, conndef);
        }
        props.put("REPLCONNS_TABLE", replicationConns);
    }

    private static final void addExternalUsersToInternalGroups(SecurityCache cache) {
        if (m_externalUsersToInternalGroup.isEmpty()) {
            return;
        }
        try {
            for (String internalGroupName : m_externalUsersToInternalGroup.keySet()) {
                ArrayList externalUsers = (ArrayList)m_externalUsersToInternalGroup.get(internalGroupName);
                ProgressPrincipal p = cache.getPrincipal(internalGroupName);
                if (externalUsers == null || externalUsers.isEmpty() || !(p instanceof ProgressGroup)) continue;
                ProgressGroup g = (ProgressGroup)p;
                Iterator iterator = externalUsers.iterator();
                while (iterator.hasNext()) {
                    g.addMember((Principal)iterator.next());
                }
            }
        }
        catch (Exception e) {
            String s = progress.message.broker.prAccessor.getString("STR360");
            BrokerComponent.getComponentContext().logMessage(s, (Throwable)e, 2);
        }
    }

    private static final void addExternalGroup(SecurityCache cache) {
        try {
            if (m_externalGroupsToAdd != null && !m_externalGroupsToAdd.isEmpty()) {
                for (Object key : m_externalGroupsToAdd.keySet()) {
                    Object value = m_externalGroupsToAdd.get(key);
                    cache.addGroup((ProgressGroup)value);
                }
            }
        }
        catch (Exception e) {
            String s = progress.message.broker.prAccessor.getString("STR361");
            BrokerComponent.getComponentContext().logMessage(s, (Throwable)e, 2);
        }
    }

    private static void getFTPeerAcceptorConfig(IComponentContext context, IElement ace, Properties props, boolean isClustered) throws ESocketConfigException {
        ConfigPropertiesPopulator.getAcceptorConfig(context, ace, props, isClustered, "FTPEER_ACCEPTOR_HOLDER", true);
    }

    private static void getAcceptorConfig(IComponentContext context, IElement ace, Properties props, boolean isClustered) throws ESocketConfigException {
        ConfigPropertiesPopulator.getAcceptorConfig(context, ace, props, isClustered, "ACCEPTOR_HOLDER", false);
    }

    private static void getAcceptorConfig(IComponentContext context, IElement ace, Properties props, boolean isClustered, String holderKey, boolean isFTPeer) throws ESocketConfigException {
        Acceptor ia;
        AcceptorHolder holder = new AcceptorHolder();
        IAttributeSet das = ace.getAttributes();
        IAttributeSet hpas = (IAttributeSet)das.getAttribute("HTTP_PARAMETERS");
        IAttributeSet daas = (IAttributeSet)das.getAttribute("DEFAULT_ACCEPTORS");
        IAttributeSet alas = (IAttributeSet)das.getAttribute("ACCEPTORS");
        if (hpas != null && !isFTPeer) {
            ConfigPropertiesPopulator.getDefaultHTTPAttributes(hpas, props);
        }
        Reference primaryAcceptorRef = (Reference)daas.getAttribute("PRIMARY_ACCEPTOR_REF");
        String paCID = primaryAcceptorRef.getElementName();
        String iaCID = null;
        Reference interbrokerAcceptorRef = (Reference)daas.getAttribute("INTERBROKER_ACCEPTOR_REF");
        iaCID = interbrokerAcceptorRef != null ? interbrokerAcceptorRef.getElementName() : paCID;
        String defaultRoutingURL = (String)daas.getAttribute("DEFAULT_ROUTING_URL");
        ConfigPropertiesPopulator.processAcceptorsSet(context, holder, alas, props, paCID, iaCID, isFTPeer);
        if (isClustered && (ia = holder.getInterbrokerAcceptor()) == null) {
            Acceptor pa = holder.getPrimaryAcceptor();
            holder.setInterbrokerAcceptor(pa);
        }
        if (defaultRoutingURL != null && !"".equals(defaultRoutingURL)) {
            holder.setDefaultRoutingURL(defaultRoutingURL);
        }
        props.put(holderKey, holder);
    }

    private static void processAcceptorsSet(IComponentContext context, AcceptorHolder holder, IAttributeSet alas, Properties mainProps, String paCID, String iaCID, boolean isFTPeer) throws ESocketConfigException {
        for (Reference ref : alas.getAttributes().values()) {
            String adceCID = ref.getElementName();
            IElement adce = context.getConfiguration(adceCID, true);
            try {
                ConfigPropertiesPopulator.processAcceptor(context, holder, adce, mainProps, paCID, iaCID, isFTPeer);
            }
            catch (ESocketConfigException e) {
                context.logMessage("Acceptor configuration failure, trace follows...", (Throwable)e, 2);
            }
        }
    }

    static Acceptor newAcceptor(IComponentContext context, AcceptorHolder holder, String configID, IElement primayBrokerConfig) throws ESocketConfigException {
        IElement acceptorConfig = context.getConfiguration(configID, true);
        if (acceptorConfig == null) {
            return null;
        }
        if ("MQ_ACCEPTOR_TUNNELING".equals(acceptorConfig.getIdentity().getType())) {
            IAttributeSet das = acceptorConfig.getAttributes();
            String acceptorName = (String)das.getAttribute("ACCEPTOR_NAME");
            String acceptorURL = (String)das.getAttribute("ACCEPTOR_URL");
            context.logMessage(acceptorName + ": dynamic configuration of HTTP acceptor on " + acceptorURL + " not supported, reload required", 2);
            return null;
        }
        if (acceptorConfig.getIdentity().getType().startsWith("MQ_ACCEPTOR_DIRECT")) {
            // empty if block
        }
        IAttributeSet das = BrokerComponent.getComponentContext().getConfiguration(true).getAttributes();
        IAttributeSet cers = (IAttributeSet)das.getAttribute("CONFIG_ELEMENT_REFERENCES");
        Reference aref = (Reference)cers.getAttribute("ACCEPTOR_CONFIG_ELEMENT_REF");
        das = context.getConfiguration(aref.getElementName(), true).getAttributes();
        IAttributeSet daas = (IAttributeSet)das.getAttribute("DEFAULT_ACCEPTORS");
        Reference primaryAcceptorRef = (Reference)daas.getAttribute("PRIMARY_ACCEPTOR_REF");
        String paCID = primaryAcceptorRef.getElementName();
        String iaCID = null;
        Reference interbrokerAcceptorRef = (Reference)daas.getAttribute("INTERBROKER_ACCEPTOR_REF");
        iaCID = interbrokerAcceptorRef != null ? interbrokerAcceptorRef.getElementName() : paCID;
        return ConfigPropertiesPopulator.processAcceptor(context, holder, acceptorConfig, m_props, paCID, iaCID, s_isBackup);
    }

    private static Acceptor processAcceptor(IComponentContext context, AcceptorHolder holder, IElement acceptorConfig, Properties mainProps, String primaryAcceptorConfigID, String interbrokerAcceptorConfigID, boolean isFTPeer) throws ESocketConfigException {
        IAttributeSet das = acceptorConfig.getAttributes();
        String acceptorName = (String)das.getAttribute("ACCEPTOR_NAME");
        String acceptorType = (String)das.getAttribute("ACCEPTOR_TYPE");
        String acceptorURL = (String)das.getAttribute("ACCEPTOR_URL");
        String acceptorExternalURL = (String)das.getAttribute("ACCEPTOR_EXTERNAL_URL");
        String acceptorConfigID = acceptorConfig.getIdentity().getName();
        boolean isPrimaryAcceptor = false;
        boolean isInterbrokerAcceptor = false;
        if (acceptorConfigID.equals(primaryAcceptorConfigID)) {
            isPrimaryAcceptor = true;
        }
        if (acceptorConfigID.equals(interbrokerAcceptorConfigID)) {
            isInterbrokerAcceptor = true;
        }
        Acceptor acceptor = null;
        AttributeName an = null;
        Properties acceptorProps = new Properties();
        String privateHost = null;
        String publicHost = null;
        Boolean useDynamicHost = (Boolean)mainProps.get("USE_DYNAMIC_HOST_BINDING");
        boolean dynHostBinding = useDynamicHost;
        if (!isFTPeer && dynHostBinding) {
            privateHost = System.getProperty("sonicsw.mf.privateHost");
            publicHost = System.getProperty("sonicsw.mf.publicHost");
            if (!(privateHost != null && privateHost.length() != 0 || publicHost != null && publicHost.length() != 0)) {
                throw new EAssertFailure("\"sonicsw.mf.privateHost\", \"sonicsw.mf.publicHost\" have not been determined");
            }
        }
        Object paramVal = null;
        Integer streamSendMax = null;
        Integer streamSendMin = (Integer)mainProps.get("AGENT_SENDER_MIN_OUTPUT_BUFFER_SIZE");
        Integer streamSendInit = (Integer)mainProps.get("AGENT_SENDER_INITIAL_OUTPUT_BUFFER_SIZE");
        Integer streamRcvMax = null;
        Integer streamRcvMin = (Integer)mainProps.get("AGENT_LISTENER_MIN_INPUT_BUFFER_SIZE");
        Integer streamRcvInit = (Integer)mainProps.get("AGENT_LISTENER_INITIAL_INPUT_BUFFER_SIZE");
        acceptorProps.put("TCP_NODELAY", mainProps.get("TCP_NODELAY"));
        Integer socketSendMax = (Integer)mainProps.get("TCP_SEND_BUFFER_SIZE");
        if (socketSendMax == null) {
            socketSendMax = new Integer(Config.SOCKET_MAX_SEND_BUFFER_SIZE);
        }
        Integer socketSendMin = (Integer)mainProps.get("TCP_MIN_SEND_BUFFER_SIZE");
        Integer socketSendInit = (Integer)mainProps.get("TCP_INITIAL_SEND_BUFFER_SIZE");
        Integer socketRcvMax = (Integer)mainProps.get("TCP_RECEIVE_BUFFER_SIZE");
        if (socketRcvMax == null) {
            socketRcvMax = new Integer(Config.SOCKET_MAX_RCV_BUFFER_SIZE);
        }
        Integer socketRcvMin = (Integer)mainProps.get("TCP_MIN_RCV_BUFFER_SIZE");
        Integer socketRcvInit = (Integer)mainProps.get("TCP_INITIAL_RCV_BUFFER_SIZE");
        String value = (String)mainProps.get("ENABLE_TLSV1_ONLY");
        if (value != null) {
            acceptorProps.put("ENABLE_TLSV1_ONLY", value);
        }
        if ((value = (String)mainProps.get("ENABLE_SSLV3_ONLY")) != null) {
            acceptorProps.put("ENABLE_SSLV3_ONLY", value);
        }
        String protocol = "tcp";
        int index = acceptorURL.indexOf("://");
        if (index > -1) {
            protocol = acceptorURL.substring(0, index);
        }
        if (acceptorType.equals("TCPS")) {
            streamSendMax = (Integer)das.getAttribute("MAX_CONNECTION_SEND_BUFFER_SIZE");
            if (streamSendMax == null) {
                streamSendMax = new Integer(8192);
            }
            streamRcvMax = (Integer)das.getAttribute("MAX_CONNECTION_RCV_BUFFER_SIZE");
            if (paramVal == null) {
                streamRcvMax = new Integer(8192);
            }
            if ("ssl".equalsIgnoreCase(protocol)) {
                an = new AttributeName("SSL_PARAMETERS");
                IAttributeSet spas = (IAttributeSet)das.getAttribute(an);
                ConfigPropertiesPopulator.getSSLAttributes(spas, acceptorProps, mainProps);
                acceptor = new SSLAcceptor(acceptorName, acceptorURL, acceptorExternalURL, dynHostBinding, privateHost, publicHost, acceptorProps);
                holder.addAcceptor(acceptorName, acceptorConfigID, acceptor, isPrimaryAcceptor, isInterbrokerAcceptor);
            } else {
                acceptor = new TCPIPAcceptor(acceptorName, acceptorURL, acceptorExternalURL, dynHostBinding, privateHost, publicHost, acceptorProps);
                holder.addAcceptor(acceptorName, acceptorConfigID, acceptor, isPrimaryAcceptor, isInterbrokerAcceptor);
            }
        } else if (acceptorType.equals("TUNNELING")) {
            streamSendMax = (Integer)das.getAttribute("MAX_CONNECTION_SEND_BUFFER_SIZE");
            if (streamSendMax == null) {
                streamSendMax = "http".equalsIgnoreCase(protocol) ? new Integer(131072) : new Integer(8192);
            }
            if ((streamRcvMax = (Integer)das.getAttribute("MAX_CONNECTION_RCV_BUFFER_SIZE")) == null) {
                streamRcvMax = "http".equalsIgnoreCase(protocol) ? new Integer(131072) : new Integer(8192);
            }
            if ((paramVal = das.getAttribute("USE_LEGACY_HTTP_SERVER")) == null) {
                paramVal = new Boolean(false);
            }
            acceptorProps.put("USE_LEGACY_HTTP_SERVER", paramVal);
            paramVal = das.getAttribute("ENABLE_HTTP_PIPELINING");
            if (paramVal == null) {
                paramVal = new Boolean(true);
            }
            acceptorProps.put("ENABLE_HTTP_PIPELINING", paramVal);
            if ("https".equalsIgnoreCase(protocol)) {
                an = new AttributeName("SSL_PARAMETERS");
                IAttributeSet spas = (IAttributeSet)das.getAttribute(an);
                ConfigPropertiesPopulator.getSSLAttributes(spas, acceptorProps, mainProps);
                ConfigPropertiesPopulator.getHTTPAttributes(null, acceptorProps, mainProps);
                acceptor = new HTTPSAcceptor(acceptorName, acceptorURL, acceptorExternalURL, dynHostBinding, privateHost, publicHost, acceptorProps);
                holder.addAcceptor(acceptorName, acceptorConfigID, acceptor, isPrimaryAcceptor, isInterbrokerAcceptor);
            } else {
                socketSendMax = (Integer)mainProps.get("HTTP_SOCKET_SEND_BUFFER_SIZE");
                if (socketSendMax == null) {
                    socketSendMax = new Integer(SessionConfig.HTTP_SOCKET_MAX_SEND_BUFFER_SIZE);
                }
                socketSendMin = (Integer)mainProps.get("HTTP_SOCKET_MIN_SEND_BUFFER_SIZE");
                socketSendInit = (Integer)mainProps.get("HTTP_SOCKET_INITIAL_SEND_BUFFER_SIZE");
                socketRcvMax = (Integer)mainProps.get("HTTP_SOCKET_RECEIVE_BUFFER_SIZE");
                if (socketRcvMax == null) {
                    socketRcvMax = new Integer(SessionConfig.HTTP_SOCKET_MAX_RCV_BUFFER_SIZE);
                }
                socketRcvMin = (Integer)mainProps.get("HTTP_SOCKET_MIN_RCV_BUFFER_SIZE");
                socketRcvInit = (Integer)mainProps.get("HTTP_SOCKET_INITIAL_RCV_BUFFER_SIZE");
                streamSendMin = (Integer)mainProps.get("AGENT_SENDER_MIN_HTTP_OUTPUT_BUFFER_SIZE");
                streamSendInit = (Integer)mainProps.get("AGENT_SENDER_INITIAL_HTTP_OUTPUT_BUFFER_SIZE");
                streamRcvMin = (Integer)mainProps.get("AGENT_LISTENER_MIN_HTTP_INPUT_BUFFER_SIZE");
                streamRcvInit = (Integer)mainProps.get("AGENT_LISTENER_INITIAL_HTTP_INPUT_BUFFER_SIZE");
                ConfigPropertiesPopulator.getHTTPAttributes(null, acceptorProps, mainProps);
                acceptor = new HTTPAcceptor(acceptorName, acceptorURL, acceptorExternalURL, dynHostBinding, privateHost, publicHost, acceptorProps);
                holder.addAcceptor(acceptorName, acceptorConfigID, acceptor, isPrimaryAcceptor, isInterbrokerAcceptor);
            }
        } else if (acceptorType.equals("DIRECT")) {
            streamSendMax = (Integer)mainProps.get("AGENT_SENDER_OUTPUT_BUFFER_SIZE");
            if (streamSendMax == null) {
                streamSendMax = new Integer(Config.MAX_SEND_IO_BUFFER_SIZE);
            }
            if ((streamRcvMax = (Integer)mainProps.get("AGENT_LISTENER_INPUT_BUFFER_SIZE")) == null) {
                streamRcvMax = new Integer(Config.MAX_RCV_IO_BUFFER_SIZE);
            }
            if ("https".equalsIgnoreCase(protocol)) {
                ConfigPropertiesPopulator.getHTTPAttributes(null, acceptorProps, mainProps);
                an = new AttributeName("SSL_PARAMETERS");
                IAttributeSet spas = (IAttributeSet)das.getAttribute(an);
                ConfigPropertiesPopulator.getSSLAttributes(spas, acceptorProps, mainProps);
                acceptor = new HTTPSAcceptor(acceptorName, acceptorURL, acceptorExternalURL, dynHostBinding, privateHost, publicHost, acceptorProps);
                acceptor.setFTPeerAcceptor(isFTPeer);
            } else {
                acceptorProps.put("USE_LEGACY_HTTP_SERVER", new Boolean(true));
                ConfigPropertiesPopulator.getHTTPAttributes(null, acceptorProps, mainProps);
                acceptor = new HTTPAcceptor(acceptorName, acceptorURL, acceptorExternalURL, dynHostBinding, privateHost, publicHost, acceptorProps);
                acceptor.setFTPeerAcceptor(isFTPeer);
            }
            an = new AttributeName("PROTOCOLS");
            IAttributeSet hdas = (IAttributeSet)das.getAttribute(an);
            HTTPAcceptor httpAcceptor = (HTTPAcceptor)acceptor;
            httpAcceptor.setAcceptorConfigID(acceptorConfigID);
            s_bindHelper.bindAddNewAcceptorDirectProtocolHandler(hdas, httpAcceptor);
            holder.addAcceptor(acceptorName, acceptorConfigID, acceptor, isPrimaryAcceptor, isInterbrokerAcceptor);
            ConfigPropertiesPopulator.getHTTPDirectParams(context, hdas, httpAcceptor);
        }
        acceptorProps.put("MAX_SEND_IO_BUFFER_SIZE", streamSendMax);
        if (streamSendMin == null || streamSendMin > streamSendMax) {
            streamSendMin = streamSendMax;
        }
        acceptorProps.put("MIN_SEND_IO_BUFFER_SIZE", streamSendMin);
        if (streamSendInit == null || streamSendInit < streamSendMin) {
            streamSendInit = streamSendMin;
        }
        acceptorProps.put("INITIAL_SEND_IO_BUFFER_SIZE", streamSendInit);
        acceptorProps.put("MAX_RCV_IO_BUFFER_SIZE", streamRcvMax);
        if (streamRcvMin == null || streamRcvMin > streamRcvMax) {
            streamRcvMin = streamRcvMax;
        }
        acceptorProps.put("MIN_RCV_IO_BUFFER_SIZE", streamRcvMin);
        if (streamRcvInit == null || streamRcvInit < streamRcvMin) {
            streamRcvInit = streamRcvMin;
        }
        acceptorProps.put("INITIAL_RCV_IO_BUFFER_SIZE", streamRcvInit);
        acceptorProps.put("SOCKET_MAX_SEND_BUFFER_SIZE", socketSendMax);
        if (socketSendMin == null || socketSendMin > socketSendMax) {
            socketSendMin = socketSendMax;
        }
        acceptorProps.put("SOCKET_MIN_SEND_BUFFER_SIZE", socketSendMin);
        if (socketSendInit == null || socketSendInit < socketSendMin) {
            socketSendInit = socketSendMin;
        }
        acceptorProps.put("SOCKET_INITIAL_SEND_BUFFER_SIZE", socketSendInit);
        acceptorProps.put("SOCKET_MAX_RCV_BUFFER_SIZE", socketRcvMax);
        if (socketRcvMin == null || socketRcvMin > socketRcvMax) {
            socketRcvMin = socketRcvMax;
        }
        acceptorProps.put("SOCKET_MIN_RCV_BUFFER_SIZE", socketRcvMin);
        if (socketRcvInit == null || socketRcvInit < socketRcvMin) {
            socketRcvInit = socketRcvMin;
        }
        acceptorProps.put("SOCKET_INITIAL_RCV_BUFFER_SIZE", socketRcvInit);
        return acceptor;
    }

    private static void getDefaultHTTPAttributes(IAttributeSet hpas, Properties mainProps) {
        mainProps.remove("HTTP_MIN_THREADS");
        Integer httpMinThreads = (Integer)hpas.getAttribute("HTTP_MIN_THREADS");
        if (httpMinThreads != null) {
            mainProps.put("HTTP_MIN_THREADS", httpMinThreads);
        }
        mainProps.remove("HTTP_MAX_THREADS");
        Integer httpMaxThreads = (Integer)hpas.getAttribute("HTTP_MAX_THREADS");
        if (httpMaxThreads != null) {
            mainProps.put("HTTP_MAX_THREADS", httpMaxThreads);
        }
        mainProps.remove("HTTP_THREAD_IDLE_TIMEOUT");
        Long httpThreadIdleTimeout = (Long)hpas.getAttribute("HTTP_THREAD_IDLE_TIMEOUT");
        if (httpThreadIdleTimeout != null) {
            mainProps.put("HTTP_THREAD_IDLE_TIMEOUT", httpThreadIdleTimeout);
        }
        mainProps.remove("HTTP_CONNECTION_CLEANUP_INTERVAL");
        Long httpConnectionCleanupInterval = (Long)hpas.getAttribute("HTTP_CONNECTION_CLEANUP_INTERVAL");
        if (httpConnectionCleanupInterval != null) {
            mainProps.put("HTTP_CONNECTION_CLEANUP_INTERVAL", httpConnectionCleanupInterval);
        }
        mainProps.remove("HTTP_CLIENT_IDLE_TIMEOUT");
        Long httpClientIdleTimeout = (Long)hpas.getAttribute("HTTP_CLIENT_IDLE_TIMEOUT");
        if (httpClientIdleTimeout != null) {
            mainProps.put("HTTP_CLIENT_IDLE_TIMEOUT", httpClientIdleTimeout);
        }
        mainProps.remove("HTTP_CLIENT_READ_TIMEOUT");
        Long httpClientReadTimeout = (Long)hpas.getAttribute("HTTP_CLIENT_READ_TIMEOUT");
        if (httpClientReadTimeout != null) {
            mainProps.put("HTTP_CLIENT_READ_TIMEOUT", httpClientReadTimeout);
        }
        mainProps.remove("HTTP_BROKER_READ_TIMEOUT");
        Long httpBrokerReadTimeout = (Long)hpas.getAttribute("HTTP_BROKER_READ_TIMEOUT");
        if (httpBrokerReadTimeout != null) {
            mainProps.put("HTTP_BROKER_READ_TIMEOUT", httpBrokerReadTimeout);
        }
        mainProps.remove("HTTP_DEBUG");
        Boolean httpDebug = (Boolean)hpas.getAttribute("HTTP_DEBUG");
        if (httpDebug != null) {
            mainProps.put("HTTP_DEBUG", httpDebug.toString());
        } else {
            mainProps.put("HTTP_DEBUG", "false");
        }
    }

    private static void getBrokerSSLAttributes(IAttributeSet spas, Properties mainProps) {
        IAttributeSet attrSet;
        Boolean bSslDebug;
        Boolean bClientAuth;
        Boolean sslSSLV3Only;
        Boolean sslTLSV1Only;
        String caCertsDir;
        String cipherSuites;
        String privateKeyPassword;
        String privateKey;
        String certChainForm;
        String providerClass = (String)spas.getAttribute("SSL_PROVIDER_CLASS");
        if (providerClass == null && (providerClass = (String)mainProps.get("SSL_PROVIDER_CLASS")) == null) {
            providerClass = "progress.message.net.ssl.jsse.jsseSSLImpl";
        }
        mainProps.put("SSL_PROVIDER_CLASS", providerClass);
        String certChain = (String)spas.getAttribute("SSL_CERTIFICATE_CHAIN");
        if (certChain != null && certChain.trim().length() > 0) {
            mainProps.put("SSL_CERTIFICATE_CHAIN", certChain);
        }
        if ((certChainForm = (String)spas.getAttribute("SSL_CERTIFICATE_CHAIN_FORM")) != null && certChainForm.trim().length() > 0) {
            mainProps.put("SSL_CERTIFICATE_CHAIN_FORM", certChainForm);
        }
        if ((privateKey = (String)spas.getAttribute("SSL_PRIVATE_KEY")) != null && privateKey.trim().length() > 0) {
            mainProps.put("SSL_PRIVATE_KEY", privateKey);
        }
        if ((privateKeyPassword = (String)spas.getAttribute("SSL_PRIVATE_KEY_PASSWORD")) != null && privateKeyPassword.trim().length() > 0) {
            mainProps.put("SSL_PRIVATE_KEY_PASSWORD", privateKeyPassword);
        }
        if ((cipherSuites = (String)spas.getAttribute("SSL_CIPHER_SUITES")) != null) {
            mainProps.put("SSL_CIPHER_SUITES", cipherSuites);
        }
        if ((caCertsDir = (String)spas.getAttribute("SSL_CA_CERTIFICATES_DIR")) != null && caCertsDir.trim().length() > 0) {
            mainProps.put("SSL_CA_CERTIFICATES_DIR", caCertsDir);
        }
        if ((sslTLSV1Only = (Boolean)spas.getAttribute("ENABLE_TLSV1_ONLY")) != null) {
            mainProps.put("ENABLE_TLSV1_ONLY", sslTLSV1Only.toString());
        }
        if ((sslSSLV3Only = (Boolean)spas.getAttribute("ENABLE_SSLV3_ONLY")) != null) {
            mainProps.put("ENABLE_SSLV3_ONLY", sslSSLV3Only.toString());
        }
        if ((bClientAuth = (Boolean)spas.getAttribute("SSL_CLIENT_AUTHENTICATION")) != null) {
            mainProps.put("SSL_CLIENT_AUTHENTICATION", bClientAuth.toString());
        }
        if ((bSslDebug = (Boolean)spas.getAttribute("SSL_DEBUG")) != null) {
            mainProps.setProperty("SSL_DEBUG", bSslDebug.toString());
        } else {
            mainProps.put("SSL_DEBUG", "false");
        }
        Boolean bCRLChecking = (Boolean)spas.getAttribute("DO_CRL_CHECKING");
        if (bCRLChecking != null) {
            mainProps.setProperty("DO_CRL_CHECKING", bCRLChecking.toString());
        } else {
            mainProps.put("DO_CRL_CHECKING", "false");
        }
        if (bSslDebug != null && bSslDebug.booleanValue()) {
            CRLStore.setDebug(true);
            CRLCachePolicy.setDebug(true);
            LDAPCRLStoreParameters.setDebug(true);
        }
        if (bCRLChecking != null && bCRLChecking.booleanValue()) {
            String user;
            String authType;
            IAttributeSet sslParams;
            String url;
            IAttributeSet as = null;
            as = (IAttributeSet)spas.getAttribute("CA_LIST");
            if (as != null) {
                s_bindHelper.bindAddNewCRLCachePolicyChangeHandler(as);
                HashMap caList = as.getAttributes();
                for (IAttributeSet ca : caList.values()) {
                    String dn = (String)ca.getAttribute("LDAP_DN");
                    Long interval = (Long)ca.getAttribute("PERIODIC_CACHE_REFRESH_TIME");
                    long refreshInterval = 86400L;
                    if (interval != null) {
                        refreshInterval = interval;
                    }
                    Long lifetime = (Long)ca.getAttribute("MAX_CACHE_LIFETIME");
                    long cacheLifeTime = -1L;
                    if (lifetime != null) {
                        cacheLifeTime = lifetime;
                    }
                    CRLCachePolicy policy = CRLCachePolicy.addPolicy(null, dn, refreshInterval, cacheLifeTime);
                    s_bindHelper.bindCRLCachePolicyChangeHandler(policy, ca);
                }
            }
            LDAPCRLStore crlStore = (LDAPCRLStore)CRLStore.getStore();
            as = (IAttributeSet)spas.getAttribute("PRIMARY_LDAP_SERVER_CONNECTION_PROPERTIES");
            if (as != null) {
                url = (String)as.getAttribute("LDAP_SERVER_URL");
                LDAPCRLStoreParameters primary = new LDAPCRLStoreParameters(url);
                if (url.toLowerCase().startsWith("ldaps") && (sslParams = (IAttributeSet)as.getAttribute("LDAP_SSL_PARAMETERS")) != null) {
                    primary.setTrustStore((String)sslParams.getAttribute("JSSE_TRUSTSTORE_LOCATION"));
                    primary.setTrustStorePassword((String)sslParams.getAttribute("JSSE_TRUSTSTORE_PASSWORD"));
                    primary.setKeyStoreType((String)sslParams.getAttribute("JSSE_KEYSTORE_TYPE"));
                    primary.setKeyStore((String)sslParams.getAttribute("JSSE_KEYSTORE_LOCATION"));
                    primary.setKeyStorePassword((String)sslParams.getAttribute("JSSE_KEYSTORE_PASSWORD"));
                }
                if ((authType = (String)as.getAttribute("LDAP_AUTH_MECHANISM")) != null) {
                    if (authType.equalsIgnoreCase("SIMPLE")) {
                        user = (String)as.getAttribute("LDAP_SERVER_USER");
                        String pwd = (String)as.getAttribute("LDAP_SERVER_PASSWORD");
                        primary.setSimpleAuth();
                        primary.setPrincipal(user);
                        primary.setCredentials(pwd);
                    } else if (authType.equalsIgnoreCase("EXTERNAL")) {
                        primary.setExternalAuth();
                    }
                }
                crlStore.setPrimaryCRLStoreParameters(primary);
            }
            if ((as = (IAttributeSet)spas.getAttribute("BACKUP_LDAP_SERVER_CONNECTION_PROPERTIES")) != null) {
                url = (String)as.getAttribute("LDAP_SERVER_URL");
                LDAPCRLStoreParameters backup = new LDAPCRLStoreParameters(url);
                if (url.toLowerCase().startsWith("ldaps") && (sslParams = (IAttributeSet)as.getAttribute("LDAP_SSL_PARAMETERS")) != null) {
                    backup.setTrustStore((String)sslParams.getAttribute("JSSE_TRUSTSTORE_LOCATION"));
                    backup.setTrustStorePassword((String)sslParams.getAttribute("JSSE_TRUSTSTORE_PASSWORD"));
                    backup.setKeyStoreType((String)sslParams.getAttribute("JSSE_KEYSTORE_TYPE"));
                    backup.setKeyStore((String)sslParams.getAttribute("JSSE_KEYSTORE_LOCATION"));
                    backup.setKeyStorePassword((String)sslParams.getAttribute("JSSE_KEYSTORE_PASSWORD"));
                }
                if ((authType = (String)as.getAttribute("LDAP_AUTH_MECHANISM")) != null) {
                    if (authType.equalsIgnoreCase("SIMPLE")) {
                        user = (String)as.getAttribute("LDAP_SERVER_USER");
                        String pwd = (String)as.getAttribute("LDAP_SERVER_PASSWORD");
                        backup.setSimpleAuth();
                        backup.setPrincipal(user);
                        backup.setCredentials(pwd);
                    } else if (authType.equalsIgnoreCase("EXTERNAL")) {
                        backup.setExternalAuth();
                    }
                }
                crlStore.setBackupCRLStoreParameters(backup);
            }
        }
        if ((attrSet = (IAttributeSet)spas.getAttribute("JSSE_PARAMETERS")) != null) {
            String keyManager;
            String trustManager;
            String trustStoreType;
            String trustStorePassword;
            String trustStore;
            String keyStoreType;
            String keyStorePassword;
            String keyStore;
            String keyStoreKeyPassword;
            String keyStoreAlias = (String)attrSet.getAttribute("JSSE_KEYSTORE_ALIAS");
            if (keyStoreAlias != null) {
                mainProps.put("JSSE_KEYSTORE_ALIAS", keyStoreAlias);
            }
            if ((keyStoreKeyPassword = (String)attrSet.getAttribute("JSSE_KEYSTORE_KEY_PASSWORD")) != null) {
                mainProps.put("JSSE_KEYSTORE_KEY_PASSWORD", keyStoreKeyPassword);
            }
            if ((keyStore = (String)attrSet.getAttribute("JSSE_KEYSTORE_LOCATION")) != null) {
                mainProps.put("JSSE_KEYSTORE_LOCATION", keyStore);
            }
            if ((keyStorePassword = (String)attrSet.getAttribute("JSSE_KEYSTORE_PASSWORD")) != null) {
                mainProps.put("JSSE_KEYSTORE_PASSWORD", keyStorePassword);
            }
            if ((keyStoreType = (String)attrSet.getAttribute("JSSE_KEYSTORE_TYPE")) != null) {
                mainProps.put("JSSE_KEYSTORE_TYPE", keyStoreType);
            }
            if ((trustStore = (String)attrSet.getAttribute("JSSE_TRUSTSTORE_LOCATION")) != null) {
                mainProps.put("JSSE_TRUSTSTORE_LOCATION", trustStore);
            }
            if ((trustStorePassword = (String)attrSet.getAttribute("JSSE_TRUSTSTORE_PASSWORD")) != null) {
                mainProps.put("JSSE_TRUSTSTORE_PASSWORD", trustStorePassword);
            }
            if ((trustStoreType = (String)attrSet.getAttribute("JSSE_TRUSTSTORE_TYPE")) != null) {
                mainProps.put("JSSE_TRUSTSTORE_TYPE", trustStoreType);
            }
            if ((trustManager = (String)attrSet.getAttribute("JSSE_TRUSTMANAGER")) != null) {
                mainProps.put("JSSE_TRUSTMANAGER", trustManager);
            }
            if ((keyManager = (String)attrSet.getAttribute("JSSE_KEYMANAGER")) != null) {
                mainProps.put("JSSE_KEYMANAGER", keyManager);
            }
        }
    }

    private static void getHTTPDirectParams(IComponentContext context, IAttributeSet hdas, HTTPAcceptor httpAcceptor) {
        if (hdas == null) {
            return;
        }
        HTTPDirectInboundHolder inboundHolder = new HTTPDirectInboundHolder(httpAcceptor.getAcceptorConfigID());
        Reference ref2 = null;
        for (Reference ref2 : hdas.getAttributes().values()) {
            String hdceCID = ref2.getElementName();
            IElement hdce = context.getConfiguration(hdceCID, true);
            HTTPDirectInboundProtocolHolder idph = ConfigPropertiesPopulator.processHTTPDirectProtocol(context, hdce, httpAcceptor);
            inboundHolder.addHTTPDirectInboundProtocolHolder(idph);
        }
        httpAcceptor.setHTTPDirectInboundHolder(inboundHolder);
    }

    static HTTPDirectInboundProtocolHolder processHTTPDirectProtocol(IComponentContext context, IElement element, HTTPAcceptor httpAcceptor) {
        Hashtable contentMaps = null;
        HTTPDirectInboundProtocolHolder idph = null;
        IAttributeSet das = element.getAttributes();
        String handlerName = (String)das.getAttribute("DIRECT_NAME");
        String handlerType = (String)das.getAttribute("DIRECT_TYPE");
        String handlerFactory = (String)das.getAttribute("DIRECT_FACTORY");
        IAttributeSet contentSet = (IAttributeSet)das.getAttribute("DIRECT_CONTENT_MAP");
        if (contentSet != null) {
            contentMaps = ConfigPropertiesPopulator.getDirectContentMapInfo(contentSet);
        }
        if (!httpAcceptor.isFTPeerAcceptor()) {
            s_bindHelper.bindDirectProtocolConfigChangeHandler(das, handlerName, httpAcceptor);
        }
        if (!m_isLoadingFromDS) {
            context.logMessage("HttpDirect protocol entry \"" + handlerName + "\" is created ", 3);
        }
        IAttributeSet urlSet = (IAttributeSet)das.getAttribute("DIRECT_URL_MAP");
        if (!httpAcceptor.isFTPeerAcceptor()) {
            s_bindHelper.bindAddNewAcceptorDirectURLHandler(urlSet, handlerName, handlerType, httpAcceptor);
        }
        if (urlSet == null) {
            idph = new HTTPDirectInboundProtocolHolder(httpAcceptor.getAcceptorConfigID());
        } else if (handlerType.equals("DIRECT")) {
            idph = ConfigPropertiesPopulator.getDirectURLEntries(context, handlerName, urlSet, httpAcceptor);
        } else if (handlerType.equals("SOAP")) {
            idph = ConfigPropertiesPopulator.getSOAPURLEntries(context, handlerName, urlSet, httpAcceptor);
        } else if (handlerType.equals("JMS")) {
            idph = ConfigPropertiesPopulator.getJMSURLEntries(context, handlerName, urlSet, httpAcceptor);
        } else if (handlerType.equals("WS")) {
            idph = ConfigPropertiesPopulator.getSOAPURLEntries(context, handlerName, urlSet, httpAcceptor);
        }
        if (contentMaps != null) {
            if (idph == null) {
                throw new NullPointerException("HTTPDirectInboundProtocolHolder idph is null.");
            }
            idph.setContentMappings(contentMaps);
        }
        String protocol = null;
        if (handlerType.equals("DIRECT")) {
            protocol = httpAcceptor instanceof HTTPSAcceptor ? "HTTPS" : "HTTP";
            if (handlerFactory == null) {
                handlerFactory = "com.sonicsw.net.http.direct.DirectHttpProtocolHandlerFactory";
            }
        } else if (handlerType.equals("SOAP")) {
            if (handlerFactory == null) {
                handlerFactory = "com.sonicsw.net.http.soap.SoapHttpProtocolHandlerFactory";
            }
            protocol = "SOAP";
        } else if (handlerType.equals("JMS")) {
            protocol = "JMS";
            if (handlerFactory == null) {
                handlerFactory = "com.sonicsw.net.http.jms.JmsHttpProtocolHandlerFactory";
            }
        } else if (handlerType.equals("WS")) {
            protocol = "WS";
            if (handlerFactory == null) {
                handlerFactory = "com.sonicsw.net.http.ws.WSHttpProtocolHandlerFactory";
            }
        }
        if (idph == null) {
            throw new NullPointerException("HTTPDirectInboundProtocolHolder idph is null.");
        }
        idph.setInboundProps(handlerName, protocol, handlerFactory);
        return idph;
    }

    private static Hashtable getDirectContentMapInfo(IAttributeSet contentSet) {
        HashMap map = contentSet.getAttributes();
        int count = map.size();
        if (count == 0) {
            return null;
        }
        Hashtable<String, String> mappings = new Hashtable<String, String>(count);
        IAttributeSet cmas2 = null;
        String httpType = null;
        String jmsType = null;
        for (IAttributeSet cmas2 : map.values()) {
            httpType = (String)cmas2.getAttribute("HTTP_TYPE");
            jmsType = (String)cmas2.getAttribute("JMS_TYPE");
            if (httpType == null || jmsType == null) continue;
            mappings.put(httpType, jmsType);
        }
        return mappings;
    }

    private static HTTPDirectInboundProtocolHolder getDirectURLEntries(IComponentContext context, String handlerName, IAttributeSet urlSet, HTTPAcceptor httpAcceptor) {
        Reference urlRef2 = null;
        String urlceCID = null;
        IElement urlCE = null;
        HTTPDirectInboundProtocolHolder inboundDirectProtocolHolder = new HTTPDirectInboundProtocolHolder(httpAcceptor.getAcceptorConfigID());
        HashMap map = urlSet.getAttributes();
        for (Reference urlRef2 : map.values()) {
            urlceCID = urlRef2.getElementName();
            urlCE = context.getConfiguration(urlceCID, true);
            HTTPDirectInboundEntry entry = ConfigPropertiesPopulator.processDirectURLEntry(context, urlCE, handlerName, httpAcceptor);
            inboundDirectProtocolHolder.addHTTPDirectInboundEntry(entry);
        }
        return inboundDirectProtocolHolder;
    }

    static HTTPDirectInboundEntry processDirectURLEntry(IComponentContext context, IElement element, String handlerName, HTTPAcceptor httpAcceptor) {
        IAttributeSet das = null;
        String elementType = null;
        String requestMode = null;
        Long timeout = null;
        String user = null;
        String pwd = null;
        String deliveryMode = null;
        String destinationType = null;
        String destinationName = null;
        Integer priority = null;
        Long ttl = null;
        Boolean notifyUndelivered = null;
        Boolean preserveUndelivered = null;
        String url = null;
        Boolean httpBasic = null;
        Boolean configUser = null;
        Boolean sslCertificate = null;
        das = element.getAttributes();
        IElementIdentity id = element.getIdentity();
        elementType = id.getType();
        requestMode = null;
        if (elementType.equals("MQ_ACCEPTOR_DIRECT_PROTOCOL_URL_SEND_ONEWAY")) {
            requestMode = "Oneway";
            ttl = (Long)das.getAttribute("TIME_TO_LIVE");
            if (ttl == null) {
                ttl = new Long(60000L);
            }
            if ((priority = (Integer)das.getAttribute("PRIORITY")) == null) {
                priority = new Integer(4);
            }
            notifyUndelivered = (Boolean)das.getAttribute("NOTIFY_UNDELIVERED");
            preserveUndelivered = (Boolean)das.getAttribute("PRESERVE_UNDELIVERED");
        } else if (elementType.equals("MQ_ACCEPTOR_DIRECT_PROTOCOL_URL_SEND_REPLY")) {
            requestMode = "ContentReply";
            ttl = (Long)das.getAttribute("TIME_TO_LIVE");
            if (ttl == null) {
                ttl = new Long(60000L);
            }
            if ((priority = (Integer)das.getAttribute("PRIORITY")) == null) {
                priority = new Integer(4);
            }
            if ((timeout = (Long)das.getAttribute("TIMEOUT")) == null) {
                timeout = new Long(60L);
            }
            notifyUndelivered = (Boolean)das.getAttribute("NOTIFY_UNDELIVERED");
            preserveUndelivered = (Boolean)das.getAttribute("PRESERVE_UNDELIVERED");
        } else if (elementType.equals("MQ_ACCEPTOR_DIRECT_PROTOCOL_URL_RECEIVE")) {
            requestMode = "Receive";
            timeout = (Long)das.getAttribute("TIMEOUT");
            if (timeout == null) {
                timeout = new Long(3L);
            }
        }
        url = (String)das.getAttribute("URL");
        user = (String)das.getAttribute("USER");
        pwd = (String)das.getAttribute("PASSWORD");
        deliveryMode = (String)das.getAttribute("DELIVERY_MODE");
        destinationType = (String)das.getAttribute("DESTINATION_TYPE");
        destinationName = (String)das.getAttribute("DESTINATION_NAME");
        IAttributeSet as = (IAttributeSet)das.getAttribute("AUTHENTICATION");
        httpBasic = (Boolean)as.getAttribute("HTTP_BASIC");
        sslCertificate = (Boolean)as.getAttribute("SSL_CERTIFICATE");
        configUser = (Boolean)as.getAttribute("CONFIG_USER");
        if (configUser == null) {
            configUser = new Boolean(true);
        }
        HTTPDirectInboundEntry entry = new HTTPDirectInboundEntry(url, deliveryMode, destinationType, destinationName, priority, ttl, user, pwd, requestMode, timeout, preserveUndelivered, notifyUndelivered, null, null, httpBasic, sslCertificate, configUser);
        ConfigPropertiesPopulator.configureHTTPDirectUndelivered(entry, das);
        s_bindHelper.bindDirectURLConfigChangeHandler(das, entry, handlerName, httpAcceptor);
        if (!m_isLoadingFromDS) {
            context.logMessage("HttpDirect url entry \"" + url + "\" is created ", 3);
        }
        return entry;
    }

    private static void configureHTTPDirectUndelivered(HTTPDirectInboundEntry entry, IAttributeSet das) {
        if (entry.getPreserveUndelivered()) {
            String uDestinationName;
            String uDestinationType = (String)das.getAttribute("UNDELIVERED_DESTINATION_TYPE");
            if (uDestinationType == null) {
                uDestinationType = "QUEUE";
            }
            if ((uDestinationName = (String)das.getAttribute("UNDELIVERED_DESTINATION_NAME")) == null) {
                uDestinationName = "SonicMQ.deadMessage";
            }
            entry.configureUndelivered(uDestinationType, uDestinationName);
        }
    }

    private static HTTPDirectInboundProtocolHolder getSOAPURLEntries(IComponentContext context, String handlerName, IAttributeSet urlSet, HTTPAcceptor httpAcceptor) {
        Reference urlRef2 = null;
        String urlceCID = null;
        IElement urlCE = null;
        HTTPDirectInboundProtocolHolder inboundDirectProtocolHolder = new HTTPDirectInboundProtocolHolder(httpAcceptor.getAcceptorConfigID());
        HashMap map = urlSet.getAttributes();
        for (Reference urlRef2 : map.values()) {
            urlceCID = urlRef2.getElementName();
            urlCE = context.getConfiguration(urlceCID, true);
            HTTPDirectInboundEntry entry = ConfigPropertiesPopulator.processSOAPURLEntry(context, urlCE, handlerName, httpAcceptor);
            inboundDirectProtocolHolder.addHTTPDirectInboundEntry(entry);
        }
        return inboundDirectProtocolHolder;
    }

    static HTTPDirectInboundEntry processSOAPURLEntry(IComponentContext context, IElement element, String handlerName, HTTPAcceptor httpAcceptor) {
        IAttributeSet as;
        IAttributeSet das = null;
        String elementType = null;
        String requestMode = null;
        Long timeout = null;
        String user = null;
        String pwd = null;
        String deliveryMode = null;
        String destinationType = null;
        String destinationName = null;
        Integer priority = null;
        Long ttl = null;
        Boolean notifyUndelivered = null;
        Boolean preserveUndelivered = null;
        String url = null;
        Boolean httpBasic = null;
        Boolean sslCertificate = null;
        Boolean configUser = null;
        das = element.getAttributes();
        IElementIdentity id = element.getIdentity();
        elementType = id.getType();
        requestMode = null;
        if (elementType.equals("MQ_ACCEPTOR_DIRECT_PROTOCOL_URL_SEND_ONEWAY")) {
            requestMode = "Oneway";
        } else if (elementType.equals("MQ_ACCEPTOR_DIRECT_PROTOCOL_URL_SEND_REPLY")) {
            requestMode = "ContentReply";
        } else if (elementType.equals("MQ_ACCEPTOR_DIRECT_PROTOCOL_URL_RECEIVE")) {
            requestMode = "Receive";
        } else if (elementType.equals("MQ_ACCEPTOR_DIRECT_PROTOCOL_URL_SEND")) {
            requestMode = "Send";
        } else if (elementType.equals("MQ_WS_PROTOCOL_URL_ENDPOINT")) {
            requestMode = "WS";
        }
        url = (String)das.getAttribute("URL");
        user = (String)das.getAttribute("USER");
        pwd = (String)das.getAttribute("PASSWORD");
        deliveryMode = (String)das.getAttribute("DELIVERY_MODE");
        destinationType = (String)das.getAttribute("DESTINATION_TYPE");
        destinationName = (String)das.getAttribute("DESTINATION_NAME");
        notifyUndelivered = (Boolean)das.getAttribute("NOTIFY_UNDELIVERED");
        preserveUndelivered = (Boolean)das.getAttribute("PRESERVE_UNDELIVERED");
        if (requestMode.equals("Oneway")) {
            ttl = (Long)das.getAttribute("TIME_TO_LIVE");
            if (ttl == null) {
                ttl = new Long(60000L);
            }
            if ((priority = (Integer)das.getAttribute("PRIORITY")) == null) {
                priority = new Integer(4);
            }
        } else if (requestMode.equals("ContentReply")) {
            timeout = (Long)das.getAttribute("TIMEOUT");
            if (timeout == null) {
                timeout = new Long(60L);
            }
            if ((priority = (Integer)das.getAttribute("PRIORITY")) == null) {
                priority = new Integer(4);
            }
            if ((ttl = (Long)das.getAttribute("TIME_TO_LIVE")) == null) {
                ttl = new Long(60000L);
            }
        } else if (requestMode.equals("Receive")) {
            timeout = (Long)das.getAttribute("TIMEOUT");
            if (timeout == null) {
                timeout = new Long(3L);
            }
        } else if (requestMode.equals("WS")) {
            timeout = (Long)das.getAttribute("TIMEOUT");
            if (timeout == null) {
                timeout = new Long(60L);
            }
            if ((priority = (Integer)das.getAttribute("PRIORITY")) == null) {
                priority = new Integer(4);
            }
            if ((ttl = (Long)das.getAttribute("TIME_TO_LIVE")) == null) {
                ttl = new Long(0L);
            }
        }
        if ((as = (IAttributeSet)das.getAttribute("AUTHENTICATION")) != null) {
            httpBasic = (Boolean)as.getAttribute("HTTP_BASIC");
            sslCertificate = (Boolean)as.getAttribute("SSL_CERTIFICATE");
            configUser = (Boolean)as.getAttribute("CONFIG_USER");
            if (configUser == null) {
                configUser = new Boolean(true);
            }
        } else {
            httpBasic = Boolean.FALSE;
            sslCertificate = Boolean.FALSE;
            configUser = new Boolean(true);
        }
        HTTPDirectInboundEntry entry = new HTTPDirectInboundEntry(url, deliveryMode, destinationType, destinationName, priority, ttl, user, pwd, requestMode, timeout, preserveUndelivered, notifyUndelivered, null, null, httpBasic, sslCertificate, configUser);
        ConfigPropertiesPopulator.configureHTTPDirectUndelivered(entry, das);
        if (requestMode.equals("WS")) {
            String soapRoles = (String)das.getAttribute("SOAP_ROLES");
            String wsdlLocation = (String)das.getAttribute("WSDL_LOCATION");
            entry.configureWS(soapRoles, wsdlLocation);
            Boolean mapCertificateToUserName = (Boolean)das.getAttribute("MAP_CERTIFICATE_TO_USERNAME");
            if (mapCertificateToUserName == null) {
                mapCertificateToUserName = new Boolean(true);
            }
            boolean configureWSS = false;
            String keyStoreFormat = null;
            String keyStoreLocation = null;
            String keyStorePassword = null;
            IAttributeSet serviceTrustStore = (IAttributeSet)das.getAttribute("SERVICE_TRUST_STORE");
            if (serviceTrustStore != null) {
                configureWSS = true;
                keyStoreFormat = (String)serviceTrustStore.getAttribute("KEYSTORE_FORMAT");
                keyStoreLocation = (String)serviceTrustStore.getAttribute("KEYSTORE_LOCATION");
                keyStorePassword = (String)serviceTrustStore.getAttribute("KEYSTORE_PASSWORD");
            }
            String x509Alias = null;
            String x509Pwd = null;
            IAttributeSet credentials = (IAttributeSet)das.getAttribute("CREDENTIALS");
            if (credentials != null && (x509Alias = (String)credentials.getAttribute("X509TOKEN_ALIAS")) != null && x509Alias.length() > 0) {
                x509Pwd = (String)credentials.getAttribute("X509TOKEN_PASSWORD");
                if (x509Pwd == null || x509Pwd.length() == 0) {
                    BrokerComponent.getComponentContext().logMessage("Private key password for the X.509 token cannot be null or empty string.", 2);
                } else {
                    configureWSS = true;
                }
            }
            if (configureWSS) {
                try {
                    entry.configureWSSecurity(keyStoreFormat, keyStoreLocation, keyStorePassword, mapCertificateToUserName, x509Alias, x509Pwd);
                }
                catch (KeyStoreException ex) {
                    BrokerComponent.getComponentContext().logMessage(ex.getMessage(), (Throwable)ex, 3);
                }
            }
        }
        if (requestMode.equals("WS")) {
            if (!httpAcceptor.isFTPeerAcceptor()) {
                s_bindHelper.bindDirectURLWSConfigChangeHandler(das, entry, handlerName, httpAcceptor);
            }
        } else {
            s_bindHelper.bindDirectURLConfigChangeHandler(das, entry, handlerName, httpAcceptor);
        }
        if (!m_isLoadingFromDS) {
            context.logMessage("HttpDirect SOAP url entry \"" + url + "\" is created ", 3);
        }
        return entry;
    }

    private static HTTPDirectInboundProtocolHolder getJMSURLEntries(IComponentContext context, String handlerName, IAttributeSet urlSet, HTTPAcceptor httpAcceptor) {
        Reference urlRef2 = null;
        String urlceCID = null;
        IElement urlCE = null;
        HTTPDirectInboundProtocolHolder inboundDirectProtocolHolder = new HTTPDirectInboundProtocolHolder(httpAcceptor.getAcceptorConfigID());
        HashMap map = urlSet.getAttributes();
        for (Reference urlRef2 : map.values()) {
            urlceCID = urlRef2.getElementName();
            urlCE = context.getConfiguration(urlceCID, true);
            HTTPDirectInboundEntry entry = ConfigPropertiesPopulator.processJMSURLEntry(context, urlCE, handlerName, httpAcceptor);
            inboundDirectProtocolHolder.addHTTPDirectInboundEntry(entry);
        }
        return inboundDirectProtocolHolder;
    }

    static HTTPDirectInboundEntry processJMSURLEntry(IComponentContext context, IElement element, String handlerName, HTTPAcceptor httpAcceptor) {
        IAttributeSet das = null;
        String elementType = null;
        String requestMode = null;
        Long timeout = null;
        String url = null;
        String user = null;
        Boolean detectDuplicates = null;
        Boolean httpHeader = null;
        Boolean httpBasic = null;
        Boolean sslCertificate = null;
        Boolean configUser = null;
        das = element.getAttributes();
        IElementIdentity id = element.getIdentity();
        elementType = id.getType();
        url = (String)das.getAttribute("URL");
        user = (String)das.getAttribute("USER");
        IAttributeSet as = (IAttributeSet)das.getAttribute("AUTHENTICATION");
        httpHeader = (Boolean)as.getAttribute("HTTP_HEADER");
        httpBasic = (Boolean)as.getAttribute("HTTP_BASIC");
        sslCertificate = (Boolean)as.getAttribute("SSL_CERTIFICATE");
        configUser = (Boolean)as.getAttribute("CONFIG_USER");
        if (configUser == null) {
            configUser = new Boolean(true);
        }
        requestMode = null;
        if (elementType.equals("MQ_ACCEPTOR_DIRECT_PROTOCOL_JMS_URL_SEND_ONEWAY")) {
            requestMode = "Oneway";
            detectDuplicates = (Boolean)das.getAttribute("DUPLICATE_DETECT");
        } else if (elementType.equals("MQ_ACCEPTOR_DIRECT_PROTOCOL_JMS_URL_SEND_REPLY")) {
            requestMode = "ContentReply";
            detectDuplicates = (Boolean)das.getAttribute("DUPLICATE_DETECT");
            timeout = (Long)das.getAttribute("TIMEOUT");
            if (timeout == null) {
                timeout = new Long(1L);
            }
        } else if (elementType.equals("MQ_ACCEPTOR_DIRECT_PROTOCOL_JMS_URL_RECEIVE")) {
            requestMode = "Receive";
        }
        HTTPDirectInboundEntry entry = new HTTPDirectInboundEntry(url, null, null, null, null, null, user, null, requestMode, timeout, null, null, detectDuplicates, httpHeader, httpBasic, sslCertificate, configUser);
        ConfigPropertiesPopulator.configureHTTPDirectUndelivered(entry, das);
        s_bindHelper.bindDirectURLConfigChangeHandler(das, entry, handlerName, httpAcceptor);
        if (!m_isLoadingFromDS) {
            context.logMessage("HttpDirect JMS url entry \"" + url + "\" is created ", 3);
        }
        return entry;
    }

    private static void getSSLAttributes(IAttributeSet spas, Properties sslProps, Properties mainProps) {
        String caCertsDir;
        String tlsPreferredProtocols;
        String cipherSuites;
        String privateKeyPassword;
        String privateKey;
        String certChainForm;
        String certChain;
        if (spas == null) {
            String clientAuth;
            String caCertsDir2;
            String cipherSuites2;
            String privateKeyPassword2;
            String privateKey2;
            String certChainForm2;
            String certChain2;
            String providerClass = (String)mainProps.get("SSL_PROVIDER_CLASS");
            if (providerClass != null) {
                sslProps.put("SSL_PROVIDER_CLASS", providerClass);
            }
            if ((certChain2 = (String)mainProps.get("SSL_CERTIFICATE_CHAIN")) != null) {
                sslProps.put("SSL_CERTIFICATE_CHAIN", certChain2);
            }
            if ((certChainForm2 = (String)mainProps.get("SSL_CERTIFICATE_CHAIN_FORM")) != null) {
                sslProps.put("SSL_CERTIFICATE_CHAIN_FORM", certChainForm2);
            }
            if ((privateKey2 = (String)mainProps.get("SSL_PRIVATE_KEY")) != null) {
                sslProps.put("SSL_PRIVATE_KEY", privateKey2);
            }
            if ((privateKeyPassword2 = (String)mainProps.get("SSL_PRIVATE_KEY_PASSWORD")) != null) {
                sslProps.put("SSL_PRIVATE_KEY_PASSWORD", privateKeyPassword2);
            }
            if ((cipherSuites2 = (String)mainProps.get("SSL_CIPHER_SUITES")) != null) {
                sslProps.put("SSL_CIPHER_SUITES", cipherSuites2);
            }
            if ((caCertsDir2 = (String)mainProps.get("SSL_CA_CERTIFICATES_DIR")) != null) {
                sslProps.put("SSL_CA_CERTIFICATES_DIR", caCertsDir2);
            }
            if ((clientAuth = (String)mainProps.get("SSL_CLIENT_AUTHENTICATION")) == null) {
                clientAuth = "false";
            }
            sslProps.put("SSL_CLIENT_AUTHENTICATION", clientAuth);
            String sslDebug = (String)mainProps.get("SSL_DEBUG");
            if (sslDebug == null) {
                sslDebug = "false";
            }
            sslProps.setProperty("SSL_DEBUG", sslDebug);
            return;
        }
        String providerClass = (String)spas.getAttribute("SSL_PROVIDER_CLASS");
        if (providerClass == null) {
            providerClass = (String)mainProps.get("SSL_PROVIDER_CLASS");
        }
        if (providerClass != null) {
            sslProps.put("SSL_PROVIDER_CLASS", providerClass);
        }
        if ((certChain = (String)spas.getAttribute("SSL_CERTIFICATE_CHAIN")) == null) {
            certChain = (String)mainProps.get("SSL_CERTIFICATE_CHAIN");
        }
        if (certChain != null) {
            sslProps.put("SSL_CERTIFICATE_CHAIN", certChain);
        }
        if ((certChainForm = (String)spas.getAttribute("SSL_CERTIFICATE_CHAIN_FORM")) == null) {
            certChainForm = (String)mainProps.get("SSL_CERTIFICATE_CHAIN_FORM");
        }
        if (certChainForm != null) {
            sslProps.put("SSL_CERTIFICATE_CHAIN_FORM", certChainForm);
        }
        if ((privateKey = (String)spas.getAttribute("SSL_PRIVATE_KEY")) == null) {
            privateKey = (String)mainProps.get("SSL_PRIVATE_KEY");
        }
        if (privateKey != null) {
            sslProps.put("SSL_PRIVATE_KEY", privateKey);
        }
        if ((privateKeyPassword = (String)spas.getAttribute("SSL_PRIVATE_KEY_PASSWORD")) == null) {
            privateKeyPassword = (String)mainProps.get("SSL_PRIVATE_KEY_PASSWORD");
        }
        if (privateKeyPassword != null) {
            sslProps.put("SSL_PRIVATE_KEY_PASSWORD", privateKeyPassword);
        }
        if ((cipherSuites = (String)spas.getAttribute("SSL_CIPHER_SUITES")) == null) {
            cipherSuites = (String)mainProps.get("SSL_CIPHER_SUITES");
        }
        if (cipherSuites != null) {
            sslProps.put("SSL_CIPHER_SUITES", cipherSuites);
        }
        if ((tlsPreferredProtocols = (String)spas.getAttribute("SSL_TLS_PREFERRED_PROTOCOLS")) != null) {
            sslProps.put("SSL_TLS_PREFERRED_PROTOCOLS", tlsPreferredProtocols);
        }
        if ((caCertsDir = (String)spas.getAttribute("SSL_CA_CERTIFICATES_DIR")) == null) {
            caCertsDir = (String)mainProps.get("SSL_CA_CERTIFICATES_DIR");
        }
        if (caCertsDir != null) {
            sslProps.put("SSL_CA_CERTIFICATES_DIR", caCertsDir);
        }
        String clientAuth = null;
        Boolean bClientAuth = (Boolean)spas.getAttribute("SSL_CLIENT_AUTHENTICATION");
        if (bClientAuth != null) {
            clientAuth = bClientAuth.toString();
        } else {
            clientAuth = (String)mainProps.get("SSL_CLIENT_AUTHENTICATION");
            if (clientAuth == null) {
                clientAuth = "false";
            }
        }
        sslProps.put("SSL_CLIENT_AUTHENTICATION", clientAuth);
        String sslDebug = null;
        Boolean bSslDebug = (Boolean)spas.getAttribute("SSL_DEBUG");
        if (bSslDebug != null) {
            sslDebug = bSslDebug.toString();
        } else {
            sslDebug = (String)mainProps.get("SSL_DEBUG");
            if (sslDebug == null) {
                sslDebug = "false";
            }
        }
        sslProps.setProperty("SSL_DEBUG", sslDebug);
        IAttributeSet attrSet = (IAttributeSet)spas.getAttribute("JSSE_PARAMETERS");
        if (attrSet != null) {
            String keyManager;
            String trustManager;
            String trustStoreType;
            String trustStorePassword;
            String trustStore;
            String keyStoreType;
            String keyStorePassword;
            String keyStore;
            String keyStoreKeyPassword;
            String keyStoreAlias = (String)attrSet.getAttribute("JSSE_KEYSTORE_ALIAS");
            if (keyStoreAlias != null) {
                sslProps.put("JSSE_KEYSTORE_ALIAS", keyStoreAlias);
            }
            if ((keyStoreKeyPassword = (String)attrSet.getAttribute("JSSE_KEYSTORE_KEY_PASSWORD")) != null) {
                sslProps.put("JSSE_KEYSTORE_KEY_PASSWORD", keyStoreKeyPassword);
            }
            if ((keyStore = (String)attrSet.getAttribute("JSSE_KEYSTORE_LOCATION")) != null) {
                sslProps.put("JSSE_KEYSTORE_LOCATION", keyStore);
            }
            if ((keyStorePassword = (String)attrSet.getAttribute("JSSE_KEYSTORE_PASSWORD")) != null) {
                sslProps.put("JSSE_KEYSTORE_PASSWORD", keyStorePassword);
            }
            if ((keyStoreType = (String)attrSet.getAttribute("JSSE_KEYSTORE_TYPE")) != null) {
                sslProps.put("JSSE_KEYSTORE_TYPE", keyStoreType);
            }
            if ((trustStore = (String)attrSet.getAttribute("JSSE_TRUSTSTORE_LOCATION")) != null) {
                sslProps.put("JSSE_TRUSTSTORE_LOCATION", trustStore);
            }
            if ((trustStorePassword = (String)attrSet.getAttribute("JSSE_TRUSTSTORE_PASSWORD")) != null) {
                sslProps.put("JSSE_TRUSTSTORE_PASSWORD", trustStorePassword);
            }
            if ((trustStoreType = (String)attrSet.getAttribute("JSSE_TRUSTSTORE_TYPE")) != null) {
                sslProps.put("JSSE_TRUSTSTORE_TYPE", trustStoreType);
            }
            if ((trustManager = (String)attrSet.getAttribute("JSSE_TRUSTMANAGER")) != null) {
                sslProps.put("JSSE_TRUSTMANAGER", trustManager);
            }
            if ((keyManager = (String)attrSet.getAttribute("JSSE_KEYMANAGER")) != null) {
                sslProps.put("JSSE_KEYMANAGER", keyManager);
            }
        }
    }

    private static void getHTTPAttributes(IAttributeSet hpas, Properties httpProps, Properties mainProps) {
        Long httpBrokerReadTimeout;
        Long httpClientReadTimeout;
        Long httpClientIdleTimeout;
        Long httpConnectionCleanupInterval;
        Long httpThreadIdleTimeout;
        if (hpas == null) {
            String httpDebug;
            Long httpBrokerReadTimeout2;
            Long httpClientReadTimeout2;
            Long httpClientIdleTimeout2;
            Long httpConnectionCleanupInterval2;
            Long httpThreadIdleTimeout2;
            Integer httpMaxThreads;
            Integer httpMinThreads = (Integer)mainProps.get("HTTP_MIN_THREADS");
            if (httpMinThreads != null) {
                httpProps.put("HTTP_MIN_THREADS", httpMinThreads);
            }
            if ((httpMaxThreads = (Integer)mainProps.get("HTTP_MAX_THREADS")) != null) {
                httpProps.put("HTTP_MAX_THREADS", httpMaxThreads);
            }
            if ((httpThreadIdleTimeout2 = (Long)mainProps.get("HTTP_THREAD_IDLE_TIMEOUT")) != null) {
                httpProps.put("HTTP_THREAD_IDLE_TIMEOUT", httpThreadIdleTimeout2);
            }
            if ((httpConnectionCleanupInterval2 = (Long)mainProps.get("HTTP_CONNECTION_CLEANUP_INTERVAL")) != null) {
                httpProps.put("HTTP_CONNECTION_CLEANUP_INTERVAL", httpConnectionCleanupInterval2);
            }
            if ((httpClientIdleTimeout2 = (Long)mainProps.get("HTTP_CLIENT_IDLE_TIMEOUT")) != null) {
                httpProps.put("HTTP_CLIENT_IDLE_TIMEOUT", httpClientIdleTimeout2);
            }
            if ((httpClientReadTimeout2 = (Long)mainProps.get("HTTP_CLIENT_READ_TIMEOUT")) != null) {
                httpProps.put("HTTP_CLIENT_READ_TIMEOUT", httpClientReadTimeout2);
            }
            if ((httpBrokerReadTimeout2 = (Long)mainProps.get("HTTP_BROKER_READ_TIMEOUT")) != null) {
                httpProps.put("HTTP_BROKER_READ_TIMEOUT", httpBrokerReadTimeout2);
            }
            if ((httpDebug = (String)mainProps.get("HTTP_DEBUG")) == null) {
                httpDebug = "false";
            }
            httpProps.setProperty("HTTP_DEBUG", httpDebug);
            return;
        }
        Integer httpMinThreads = (Integer)hpas.getAttribute("HTTP_MIN_THREADS");
        if (httpMinThreads == null) {
            httpMinThreads = (Integer)mainProps.get("HTTP_MIN_THREADS");
        }
        if (httpMinThreads != null) {
            httpProps.put("HTTP_MIN_THREADS", httpMinThreads);
        }
        Integer httpMaxThreads = (Integer)hpas.getAttribute("HTTP_MAX_THREADS");
        if (httpMinThreads == null) {
            httpMaxThreads = (Integer)mainProps.get("HTTP_MAX_THREADS");
        }
        if (httpMaxThreads != null) {
            httpProps.put("HTTP_MAX_THREADS", httpMaxThreads);
        }
        if ((httpThreadIdleTimeout = (Long)hpas.getAttribute("HTTP_THREAD_IDLE_TIMEOUT")) == null) {
            httpThreadIdleTimeout = (Long)mainProps.get("HTTP_THREAD_IDLE_TIMEOUT");
        }
        if (httpThreadIdleTimeout != null) {
            httpProps.put("HTTP_THREAD_IDLE_TIMEOUT", httpThreadIdleTimeout);
        }
        if ((httpConnectionCleanupInterval = (Long)hpas.getAttribute("HTTP_CONNECTION_CLEANUP_INTERVAL")) == null) {
            httpConnectionCleanupInterval = (Long)mainProps.get("HTTP_CONNECTION_CLEANUP_INTERVAL");
        }
        if (httpConnectionCleanupInterval != null) {
            httpProps.put("HTTP_CONNECTION_CLEANUP_INTERVAL", httpConnectionCleanupInterval);
        }
        if ((httpClientIdleTimeout = (Long)hpas.getAttribute("HTTP_CLIENT_IDLE_TIMEOUT")) == null) {
            httpClientIdleTimeout = (Long)mainProps.get("HTTP_CLIENT_IDLE_TIMEOUT");
        }
        if (httpClientIdleTimeout != null) {
            httpProps.put("HTTP_CLIENT_IDLE_TIMEOUT", httpClientIdleTimeout);
        }
        if ((httpClientReadTimeout = (Long)hpas.getAttribute("HTTP_CLIENT_READ_TIMEOUT")) == null) {
            httpClientReadTimeout = (Long)mainProps.get("HTTP_CLIENT_READ_TIMEOUT");
        }
        if (httpClientReadTimeout != null) {
            httpProps.put("HTTP_CLIENT_READ_TIMEOUT", httpClientReadTimeout);
        }
        if ((httpBrokerReadTimeout = (Long)hpas.getAttribute("HTTP_BROKER_READ_TIMEOUT")) == null) {
            httpBrokerReadTimeout = (Long)mainProps.get("HTTP_BROKER_READ_TIMEOUT");
        }
        if (httpBrokerReadTimeout != null) {
            httpProps.put("HTTP_BROKER_READ_TIMEOUT", httpBrokerReadTimeout);
        }
        String httpDebug = null;
        Boolean bHttpDebug = (Boolean)hpas.getAttribute("HTTP_DEBUG");
        if (bHttpDebug != null) {
            httpDebug = bHttpDebug.toString();
        } else {
            httpDebug = (String)mainProps.get("HTTP_DEBUG");
            if (httpDebug == null) {
                httpDebug = "false";
            }
        }
        httpProps.setProperty("HTTP_DEBUG", httpDebug);
    }

    private static void getRoutingConfig(IComponentContext context, IElement rce, Properties props, boolean securityEnabled, AttributesHolder attributesHolder, ConfigurationChangeBindHelper bindHelper) {
        boolean routesDefined;
        Vector<RoutingConnectionInfo> routes = new Vector<RoutingConnectionInfo>();
        IAttributeSet das = rce.getAttributes();
        if (das == null) {
            return;
        }
        IAttributeSet routesAS = (IAttributeSet)das.getAttribute("ROUTES");
        if (routesAS == null) {
            return;
        }
        attributesHolder.setTopLevelRouteAttributeSet(routesAS);
        bindHelper.bindAddNewRouteChangeHandler(routesAS, securityEnabled);
        BrokerLicenseMgr lm = (BrokerLicenseMgr)((Object)props.get("LICENSE_MANAGER"));
        boolean bl = routesDefined = !routesAS.getAttributes().isEmpty();
        if (routesDefined && lm != null && !lm.isRoutingAllowed()) {
            String warning = MessageFormat.format(progress.message.broker.prAccessor.getString("DRA_NOT_SUPPORTED1"), lm.getProductName());
            context.logMessage(warning, 2);
            return;
        }
        HTTPDirectOutboundHolder oh = null;
        HTTPDirectOutboundProtocolHolder odph = null;
        HTTPDirectOutboundProtocolHolder osph = null;
        HTTPDirectOutboundProtocolHolder ojph = null;
        HTTPDirectOutboundProtocolHolder owph = null;
        for (Reference ref : routesAS.getAttributes().values()) {
            HTTPDirectOutboundEntry entry;
            HttpProxyConfig pConfig;
            RoutingConnectionInfo r;
            Boolean groupByUrl;
            String url;
            String directType;
            String userPwd;
            String userName;
            String brokerName;
            String nodeName;
            String routeCID = ref.getElementName();
            IElement routeCE = context.getConfiguration(routeCID, true);
            IAttributeSet rdas = routeCE.getAttributes();
            String elementType = routeCE.getIdentity().getType();
            if (elementType.equals("MQ_ROUTE_SONIC")) {
                Boolean propagateJMSXUserID;
                Boolean staticRouting;
                Boolean advertiseRoutes;
                Boolean sequentialAccess;
                nodeName = (String)rdas.getAttribute("NODE_NAME");
                brokerName = (String)rdas.getAttribute("BROKER");
                userName = "";
                userPwd = "";
                if (securityEnabled) {
                    userName = (String)rdas.getAttribute("USER_NAME");
                    if (userName == null) {
                        userName = "";
                    }
                    if (userName.indexOf(".") != -1) {
                        userName = userName.replace('.', '$');
                    }
                    if ((userPwd = (String)rdas.getAttribute("USER_PASSWORD")) == null) {
                        userPwd = "";
                    }
                }
                String urls = (String)rdas.getAttribute("URLS");
                Integer timeout = (Integer)rdas.getAttribute("IDLE_TIMEOUT");
                Long subExpiration = (Long)rdas.getAttribute("GLOBAL_SUBSCRIPTION_EXPIRATION");
                String routingAcceptor = (String)rdas.getAttribute("ROUTING_ACCEPTOR");
                Boolean loadBalancing = (Boolean)rdas.getAttribute("LOAD_BALANCING");
                if (loadBalancing == null) {
                    loadBalancing = new Boolean(false);
                }
                if ((sequentialAccess = (Boolean)rdas.getAttribute("SEQUENTIAL")) == null) {
                    sequentialAccess = new Boolean(false);
                }
                if ((advertiseRoutes = (Boolean)rdas.getAttribute("ADVERTISE")) == null) {
                    advertiseRoutes = new Boolean(false);
                }
                if ((staticRouting = (Boolean)rdas.getAttribute("STATIC_ROUTING")) == null) {
                    staticRouting = new Boolean(false);
                }
                if ((propagateJMSXUserID = (Boolean)rdas.getAttribute("PROPAGATE_JMSXUSERID")) == null) {
                    propagateJMSXUserID = Boolean.TRUE;
                }
                RoutingConnectionInfo r2 = new RoutingConnectionInfo(nodeName);
                r2.setOutboundBrokerName(brokerName);
                r2.setConnectionURLs(urls);
                r2.setUserName(userName);
                r2.setPassword(userPwd);
                if (subExpiration != null) {
                    r2.setGlobalSubscriptionExpiration(subExpiration);
                }
                if (timeout != null) {
                    r2.setTimeout(timeout);
                }
                if (loadBalancing != null) {
                    r2.setLoadBalance(loadBalancing);
                }
                if (sequentialAccess != null) {
                    r2.setSequentialLoadBalancing(sequentialAccess);
                }
                if (advertiseRoutes != null) {
                    r2.setForwardRoutings(advertiseRoutes);
                }
                if (staticRouting != null) {
                    r2.setStaticRouting(staticRouting);
                }
                if (routingAcceptor != null) {
                    r2.setRoutingAcceptor(routingAcceptor);
                }
                r2.setPropagateJMSXUserID(propagateJMSXUserID);
                HttpProxyConfig pConfig2 = new HttpProxyConfig(rdas);
                if (pConfig2 != null && pConfig2.getHost() != null && pConfig2.getHost().trim().length() > 0) {
                    r2.setProxyConfig(pConfig2);
                }
                routes.addElement(r2);
                bindHelper.bindRouteConfigChangeHandler(r2, rdas);
                continue;
            }
            if (elementType.equals("MQ_ROUTE_DIRECT")) {
                if (oh == null) {
                    oh = new HTTPDirectOutboundHolder();
                }
                if (odph == null) {
                    odph = new HTTPDirectOutboundProtocolHolder();
                    directType = (String)rdas.getAttribute("DIRECT_TYPE");
                    String directFactory = (String)rdas.getAttribute("DIRECT_FACTORY");
                    odph.setOutboundProps(directType, directFactory);
                }
                nodeName = (String)rdas.getAttribute("NODE_NAME");
                brokerName = (String)rdas.getAttribute("BROKER");
                userName = (String)rdas.getAttribute("USER_NAME");
                if (userName == null) {
                    userName = "";
                }
                if ((userPwd = (String)rdas.getAttribute("USER_PASSWORD")) == null) {
                    userPwd = "";
                }
                url = (String)rdas.getAttribute("URL");
                groupByUrl = (Boolean)rdas.getAttribute("GROUP_BY_URL");
                r = new RoutingConnectionInfo(nodeName, RoutingConnectionInfo.ROUTE_TYPE_DIRECT);
                r.setOutboundBrokerName(brokerName);
                r.setConnectionURLs(url);
                r.setUserName(userName);
                r.setPassword(userPwd);
                if (groupByUrl != null) {
                    r.setGroupByUrl(groupByUrl);
                } else {
                    r.setGroupByUrl(true);
                }
                pConfig = new HttpProxyConfig(rdas);
                if (pConfig != null && pConfig.getHost() != null && pConfig.getHost().trim().length() > 0) {
                    r.setProxyConfig(pConfig);
                }
                routes.addElement(r);
                entry = ConfigPropertiesPopulator.createHttpDirectOutbouondEntry(rdas, nodeName, "DIRECT");
                odph.addHTTPDirectOutboundEntry(entry);
                bindHelper.bindRouteConfigChangeHandler(r, rdas);
                continue;
            }
            if (elementType.equals("MQ_ROUTE_DIRECT_SOAP")) {
                if (oh == null) {
                    oh = new HTTPDirectOutboundHolder();
                }
                if (osph == null) {
                    osph = new HTTPDirectOutboundProtocolHolder();
                    directType = (String)rdas.getAttribute("DIRECT_TYPE");
                    String soapFactory = (String)rdas.getAttribute("DIRECT_FACTORY");
                    osph.setOutboundProps(directType, soapFactory);
                }
                nodeName = (String)rdas.getAttribute("NODE_NAME");
                brokerName = (String)rdas.getAttribute("BROKER");
                userName = (String)rdas.getAttribute("USER_NAME");
                if (userName == null) {
                    userName = "";
                }
                if ((userPwd = (String)rdas.getAttribute("USER_PASSWORD")) == null) {
                    userPwd = "";
                }
                url = (String)rdas.getAttribute("URL");
                groupByUrl = (Boolean)rdas.getAttribute("GROUP_BY_URL");
                r = new RoutingConnectionInfo(nodeName, RoutingConnectionInfo.ROUTE_TYPE_SOAP);
                r.setOutboundBrokerName(brokerName);
                r.setConnectionURLs(url);
                r.setUserName(userName);
                r.setPassword(userPwd);
                if (groupByUrl != null) {
                    r.setGroupByUrl(groupByUrl);
                } else {
                    r.setGroupByUrl(true);
                }
                pConfig = new HttpProxyConfig(rdas);
                if (pConfig != null && pConfig.getHost() != null && pConfig.getHost().trim().length() > 0) {
                    r.setProxyConfig(pConfig);
                }
                routes.addElement(r);
                entry = ConfigPropertiesPopulator.createHttpDirectOutbouondEntry(rdas, nodeName, "SOAP");
                osph.addHTTPDirectOutboundEntry(entry);
                bindHelper.bindRouteConfigChangeHandler(r, rdas);
                continue;
            }
            if (elementType.equals("MQ_ROUTE_DIRECT_WS")) {
                IAttributeSet rmas;
                String userPwd2;
                if (oh == null) {
                    oh = new HTTPDirectOutboundHolder();
                }
                if (owph == null) {
                    owph = new HTTPDirectOutboundProtocolHolder();
                    directType = (String)rdas.getAttribute("DIRECT_TYPE");
                    String wsFactory = (String)rdas.getAttribute("DIRECT_FACTORY");
                    owph.setOutboundProps(directType, wsFactory);
                }
                nodeName = (String)rdas.getAttribute("NODE_NAME");
                brokerName = (String)rdas.getAttribute("BROKER");
                String routingAcceptor = (String)rdas.getAttribute("ROUTING_ACCEPTOR");
                String userName2 = (String)rdas.getAttribute("USER_NAME");
                if (userName2 == null) {
                    userName2 = "";
                }
                if ((userPwd2 = (String)rdas.getAttribute("USER_PASSWORD")) == null) {
                    userPwd2 = "";
                }
                String url2 = (String)rdas.getAttribute("URL");
                Boolean groupByUrl2 = (Boolean)rdas.getAttribute("GROUP_BY_URL");
                RoutingConnectionInfo r3 = new RoutingConnectionInfo(nodeName, RoutingConnectionInfo.ROUTE_TYPE_WS);
                r3.setOutboundBrokerName(brokerName);
                r3.setConnectionURLs(url2);
                r3.setUserName(userName2);
                r3.setPassword(userPwd2);
                if (routingAcceptor != null) {
                    r3.setRoutingAcceptor(routingAcceptor);
                }
                if (groupByUrl2 != null) {
                    r3.setGroupByUrl(groupByUrl2);
                } else {
                    r3.setGroupByUrl(true);
                }
                HttpProxyConfig pConfig3 = new HttpProxyConfig(rdas);
                if (pConfig3 != null && pConfig3.getHost() != null && pConfig3.getHost().trim().length() > 0) {
                    r3.setProxyConfig(pConfig3);
                }
                IAttributeSet wss = (IAttributeSet)rdas.getAttribute("WSS_PARAMETERS");
                IAttributeSet credentials = null;
                if (wss != null) {
                    String serialNumber;
                    credentials = (IAttributeSet)wss.getAttribute("CREDENTIALS");
                    String issuerName = (String)wss.getAttribute("DESTINATION_CERTIFICATE_ISSUER_NAME");
                    if (issuerName != null) {
                        r3.setDestinationX509IssuerName(issuerName);
                    }
                    if ((serialNumber = (String)wss.getAttribute("DESTINATION_CERTIFICATE_ISSUER_NUMBER")) != null) {
                        r3.setDestinationX509SerialNumber(serialNumber);
                    }
                }
                if (credentials != null) {
                    String x509Alias;
                    String utName = (String)credentials.getAttribute("USERNAMETOKEN_USERNAME");
                    if (utName != null && utName.length() > 0) {
                        String utPwd = (String)credentials.getAttribute("USERNAMETOKEN_PASSWORD");
                        if (utPwd == null || utPwd.length() == 0) {
                            BrokerComponent.getComponentContext().logMessage("Password of Username token for the routing node " + r3.getRoutingNodeName() + " cannot be null or empty string.", 2);
                        } else {
                            r3.setUsernameTokenName(utName);
                            r3.setUsernameTokenPassword(utPwd.toCharArray());
                        }
                    }
                    if ((x509Alias = (String)credentials.getAttribute("X509TOKEN_ALIAS")) != null && x509Alias.length() > 0) {
                        String x509Pwd = (String)credentials.getAttribute("X509TOKEN_PASSWORD");
                        if (x509Pwd == null || x509Pwd.length() == 0) {
                            BrokerComponent.getComponentContext().logMessage("Private key password of X.509 token for the routing node " + r3.getRoutingNodeName() + " cannot be null or empty string.", 2);
                        } else {
                            r3.setX509Alias(x509Alias);
                            r3.setX509Password(x509Pwd.toCharArray());
                        }
                    }
                }
                if ((rmas = (IAttributeSet)rdas.getAttribute("WSRM_PARAMETERS")) != null) {
                    Integer idleTimeout = (Integer)rmas.getAttribute("IDLE_TIMEOUT");
                    Integer sequenceExpiration = (Integer)rmas.getAttribute("SEQUENCE_EXPIRATION");
                    if (idleTimeout != null) {
                        r3.setRmIdleTimeout(idleTimeout.intValue());
                    }
                    if (sequenceExpiration != null) {
                        r3.setRmSequenceExpiration(sequenceExpiration.intValue());
                    }
                }
                routes.addElement(r3);
                HTTPDirectOutboundEntry entry2 = ConfigPropertiesPopulator.createHttpDirectOutbouondEntry(rdas, nodeName, "WS");
                owph.addHTTPDirectOutboundEntry(entry2);
                bindHelper.bindRouteConfigChangeHandler(r3, rdas);
                continue;
            }
            if (!elementType.equals("MQ_ROUTE_DIRECT_JMS")) continue;
            if (oh == null) {
                oh = new HTTPDirectOutboundHolder();
            }
            if (ojph == null) {
                ojph = new HTTPDirectOutboundProtocolHolder();
                directType = (String)rdas.getAttribute("DIRECT_TYPE");
                String jmsFactory = (String)rdas.getAttribute("DIRECT_FACTORY");
                ojph.setOutboundProps(directType, jmsFactory);
            }
            nodeName = (String)rdas.getAttribute("NODE_NAME");
            brokerName = (String)rdas.getAttribute("BROKER");
            userName = (String)rdas.getAttribute("USER_NAME");
            if (userName == null) {
                userName = "";
            }
            if ((userPwd = (String)rdas.getAttribute("USER_PASSWORD")) == null) {
                userPwd = "";
            }
            url = (String)rdas.getAttribute("URL");
            groupByUrl = (Boolean)rdas.getAttribute("GROUP_BY_URL");
            r = new RoutingConnectionInfo(nodeName, RoutingConnectionInfo.ROUTE_TYPE_JMS);
            r.setOutboundBrokerName(brokerName);
            r.setConnectionURLs(url);
            r.setUserName(userName);
            r.setPassword(userPwd);
            if (groupByUrl != null) {
                r.setGroupByUrl(groupByUrl);
            } else {
                r.setGroupByUrl(true);
            }
            pConfig = new HttpProxyConfig(rdas);
            if (pConfig != null && pConfig.getHost() != null && pConfig.getHost().trim().length() > 0) {
                r.setProxyConfig(pConfig);
            }
            routes.addElement(r);
            entry = ConfigPropertiesPopulator.createHttpDirectOutbouondEntry(rdas, nodeName, "JMS");
            ojph.addHTTPDirectOutboundEntry(entry);
            bindHelper.bindRouteConfigChangeHandler(r, rdas);
        }
        props.put("ROUTES_VECTOR", routes);
        if (oh != null) {
            if (odph != null) {
                oh.addHTTPDirectOutboundProtocolHolder(odph);
            }
            if (osph != null) {
                oh.addHTTPDirectOutboundProtocolHolder(osph);
            }
            if (owph != null) {
                oh.addHTTPDirectOutboundProtocolHolder(owph);
            }
            if (ojph != null) {
                oh.addHTTPDirectOutboundProtocolHolder(ojph);
            }
            props.put("HTTP_OUTBOUND_HOLDER", oh);
        }
    }

    static HTTPDirectOutboundEntry createHttpDirectOutbouondEntry(IAttributeSet rdas, String nodeName, String protocol) {
        Integer retryInterval;
        Integer onewayRetryCount;
        Integer onewayTimeout;
        Boolean contentReply = (Boolean)rdas.getAttribute("CONTENT_REPLY");
        if ("JMS".equals(protocol)) {
            contentReply = new Boolean(false);
        }
        if (contentReply == null) {
            contentReply = new Boolean(false);
        }
        String contentreplyUserName = null;
        Integer contentreplyTimeout = null;
        Integer contentreplyRetryCount = null;
        String requestMode = null;
        if (contentReply.booleanValue()) {
            requestMode = "ContentReply";
            contentreplyUserName = (String)rdas.getAttribute("CONTENT_REPLY_USER_NAME");
            if (contentreplyUserName != null && contentreplyUserName.indexOf(".") != -1) {
                contentreplyUserName = contentreplyUserName.replace('.', '$');
            }
            if ((contentreplyTimeout = (Integer)rdas.getAttribute("CONTENT_REPLY_TIMEOUT")) == null) {
                contentreplyTimeout = new Integer(60);
            }
            if ((contentreplyRetryCount = (Integer)rdas.getAttribute("CONTENT_REPLY_RETRY_COUNT")) == null) {
                contentreplyRetryCount = new Integer(0);
            }
        } else {
            requestMode = "Oneway";
        }
        if ((onewayTimeout = (Integer)rdas.getAttribute("ONEWAY_TIMEOUT")) == null) {
            onewayTimeout = new Integer(30);
        }
        if ((onewayRetryCount = (Integer)rdas.getAttribute("ONEWAY_RETRY_COUNT")) == null) {
            onewayRetryCount = new Integer(0);
        }
        if ((retryInterval = (Integer)rdas.getAttribute("RETRY_INTERVAL")) == null) {
            retryInterval = new Integer(3);
        }
        IAttributeSet rdcas = (IAttributeSet)rdas.getAttribute("DIRECT_CONTENT_MAP");
        Hashtable contentMaps = null;
        if (rdcas != null) {
            contentMaps = ConfigPropertiesPopulator.getDirectContentMapInfo(rdcas);
        }
        return new HTTPDirectOutboundEntry(nodeName, protocol, requestMode, onewayTimeout, onewayRetryCount, retryInterval, contentreplyUserName, contentreplyTimeout, contentreplyRetryCount, contentMaps);
    }

    public static FTPairPeerInfoHolder getFTPairPeerInfoHolder(IComponentContext context, String bname, IElement primarybce) {
        FTPairPeerInfoHolder result = null;
        PeerInfoHolder primaryPeerInfo = null;
        PeerInfoHolder backupPeerInfo = null;
        primaryPeerInfo = ConfigPropertiesPopulator.getPeerInfoHolder(context, primarybce, bname, true);
        IAttributeSet primarybuas = primarybce.getAttributes();
        IAttributeSet primarycers = (IAttributeSet)primarybuas.getAttribute("CONFIG_ELEMENT_REFERENCES");
        Reference backupref = (Reference)primarycers.getAttribute("BACKUP_CONFIG_ELEMENT_REF");
        if (backupref != null) {
            String backupCID = backupref.getElementName();
            boolean needsUpdates = false;
            IElement backupbce = context.getConfiguration(backupCID, needsUpdates);
            backupPeerInfo = ConfigPropertiesPopulator.getPeerInfoHolder(context, backupbce, bname, false);
        }
        if (primaryPeerInfo != null || backupPeerInfo != null) {
            result = new FTPairPeerInfoHolder(primaryPeerInfo, backupPeerInfo, primaryPeerInfo != null ? primaryPeerInfo.getIBAcceptorUrls() : null, backupPeerInfo != null ? backupPeerInfo.getIBAcceptorUrls() : null);
        }
        return result;
    }

    private static PeerInfoHolder getPeerInfoHolder(IComponentContext context, IElement bce, String bname, boolean isPrimary) {
        Reference pbaRef;
        String pbaCID;
        IElement pbaCE;
        IAttributeSet pbadas;
        String primaryAcceptorURL;
        Integer pWeight;
        IAttributeSet bcas;
        Boolean pLB;
        boolean needsUpdate;
        IAttributeSet buas = bce.getAttributes();
        IAttributeSet cers = (IAttributeSet)buas.getAttribute("CONFIG_ELEMENT_REFERENCES");
        Reference aref = (Reference)cers.getAttribute("ACCEPTOR_CONFIG_ELEMENT_REF");
        String aCID = aref.getElementName();
        IElement ace = context.getConfiguration(aCID, needsUpdate = true);
        IAttributeSet adas = ace.getAttributes();
        IAttributeSet daas = (IAttributeSet)adas.getAttribute("DEFAULT_ACCEPTORS");
        Reference interbrokerAcceptorRef = (Reference)daas.getAttribute("INTERBROKER_ACCEPTOR_REF");
        if (interbrokerAcceptorRef == null) {
            interbrokerAcceptorRef = (Reference)daas.getAttribute("PRIMARY_ACCEPTOR_REF");
        }
        String iaCID = interbrokerAcceptorRef.getElementName();
        IElement iaCE = context.getConfiguration(iaCID, true);
        IAttributeSet iadas = iaCE.getAttributes();
        String iaURL = (String)iadas.getAttribute("ACCEPTOR_URL");
        String iaName = (String)iadas.getAttribute("ACCEPTOR_NAME");
        if (iaURL.endsWith(Acceptor.BIND_TO_SPECIFIED_IP_OR_HOST_ONLY)) {
            iaURL = iaURL.substring(0, iaURL.lastIndexOf(Acceptor.BIND_TO_SPECIFIED_IP_OR_HOST_ONLY));
        }
        if ((pLB = (Boolean)(bcas = (IAttributeSet)buas.getAttribute("BROKER_CLUSTER_PARAMETERS")).getAttribute("ENABLE_LOAD_BALANCING")) == null) {
            pLB = new Boolean(true);
        }
        if ((pWeight = (Integer)bcas.getAttribute("LOAD_BALANCING_WEIGHT")) == null) {
            pWeight = pLB != false ? new Integer(1) : new Integer(0);
        }
        if ((primaryAcceptorURL = (String)(pbadas = (pbaCE = context.getConfiguration(pbaCID = (pbaRef = (Reference)daas.getAttribute("PRIMARY_ACCEPTOR_REF")).getElementName(), true)).getAttributes()).getAttribute("ACCEPTOR_URL")).endsWith(Acceptor.BIND_TO_SPECIFIED_IP_OR_HOST_ONLY)) {
            primaryAcceptorURL = primaryAcceptorURL.substring(0, primaryAcceptorURL.lastIndexOf(Acceptor.BIND_TO_SPECIFIED_IP_OR_HOST_ONLY));
        }
        String peerDefaultRoutingURL = (String)daas.getAttribute("DEFAULT_ROUTING_URL");
        Hashtable peerURLTable = new Hashtable();
        Hashtable peerProtocolsTable = new Hashtable();
        ConfigPropertiesPopulator.getPeerAcceptorInfo(context, ace, peerDefaultRoutingURL, peerURLTable, bname, isPrimary, peerProtocolsTable);
        ArrayList<String> ibAcceptorUrls = new ArrayList<String>();
        ibAcceptorUrls.add(iaURL);
        Vector v = (Vector)peerURLTable.get(iaName);
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                String url = (String)v.elementAt(i);
                if (url.equals(iaURL)) continue;
                ibAcceptorUrls.add(url);
            }
        }
        PeerInfoHolder holder = new PeerInfoHolder(bname, primaryAcceptorURL, pLB, pWeight, ibAcceptorUrls, peerURLTable, peerProtocolsTable);
        return holder;
    }

    private static void loadCertificateStore(IAttributeSet configElementRefs, Properties mainProps) throws CertificateException, KeyStoreException {
        AttributeName name = new AttributeName("CERTIFICATE_STORE_ELEMENT_REF");
        Reference ref = (Reference)configElementRefs.getAttribute(name);
        if (ref == null) {
            return;
        }
        String cCID = ref.getElementName();
        IElement certStore = BrokerComponent.getComponentContext().getConfiguration(cCID, true);
        if (certStore == null) {
            BrokerComponent.getComponentContext().logMessage("Unable to retrieve the certificate store element from DS.", 2);
            return;
        }
        name = new AttributeName("CERTIFICATES");
        IAttributeSet certificates = (IAttributeSet)certStore.getAttribute(name);
        if (certificates == null) {
            BrokerComponent.getComponentContext().logMessage("Unable to retrieve the certificate store attributes from DS.", 2);
            return;
        }
        BrokerCertificateStore store = BrokerCertificateStore.getInstance();
        mainProps.put("CERTIFICATE_STORE_ELEMENT_REF", store);
        BrokerComponent.getComponentContext().logMessage("Loading broker certificate store", 3);
        s_bindHelper.bindCertStoreChangeHandler(certificates, store);
        int size = certificates.getAttributes().size();
        HashMap<String, X509Certificate> x509certs = null;
        if (size > 0) {
            x509certs = new HashMap<String, X509Certificate>(size);
            Iterator iter = certificates.getAttributes().values().iterator();
            CertificateFactory certFactory = null;
            try {
                certFactory = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException ex) {
                BrokerComponent.getComponentContext().logMessage("Unable to populate broker certificate store : " + ex.getMessage(), (Throwable)ex, 2);
                return;
            }
            while (iter.hasNext()) {
                String certURL = (String)iter.next();
                try {
                    URL url;
                    URLConnection connection;
                    InputStream is;
                    Certificate o;
                    if (certURL == null || certURL.trim().length() == 0 || !((o = certFactory.generateCertificate(is = (connection = (url = new URL(certURL)).openConnection()).getInputStream())) instanceof X509Certificate)) continue;
                    X509Certificate cert = (X509Certificate)o;
                    x509certs.put(certURL, cert);
                }
                catch (Exception ex) {
                    BrokerComponent.getComponentContext().logMessage("Unable to load certificate from " + certURL + " : " + ex.getMessage(), (Throwable)ex, 2);
                }
            }
        }
        store.init(x509certs);
    }

    private static void getWSSecurityAttributes(IAttributeSet wsas, Properties mainProps) throws CertificateException {
        Boolean dsigPrefixList;
        IAttributeSet bcas;
        BrokerKeyStore keyStore = null;
        IAttributeSet ksas = (IAttributeSet)wsas.getAttribute("BROKER_KEYSTORE");
        if (ksas != null) {
            keyStore = BrokerKeyStore.getInstance("JKS");
            s_bindHelper.bindBrokerKeyStoreChangeHandler(ksas, keyStore);
            String keyStoreFormat = (String)ksas.getAttribute("KEYSTORE_FORMAT");
            String keyStoreURL = (String)ksas.getAttribute("KEYSTORE_LOCATION");
            String keyStorePassword = (String)ksas.getAttribute("KEYSTORE_PASSWORD");
            if (keyStoreURL != null) {
                BrokerComponent.getComponentContext().logMessage("Loading broker key store", 3);
                try {
                    keyStore.load(keyStoreURL, keyStorePassword == null ? null : keyStorePassword.toCharArray());
                    mainProps.put("BROKER_KEYSTORE", keyStore);
                }
                catch (Exception ex) {
                    BrokerComponent.getComponentContext().logMessage("Unable to load broker key store \"" + keyStoreURL + "\"; reason: " + ex.getMessage(), (Throwable)ex, 2);
                }
            }
        }
        BrokerTrustStore trustStore = null;
        IAttributeSet tsas = (IAttributeSet)wsas.getAttribute("BROKER_TRUSTSTORE");
        if (tsas != null) {
            trustStore = BrokerTrustStore.getInstance("JKS");
            s_bindHelper.bindBrokerTrustStoreChangeHandler(tsas, trustStore);
            String trustStoreFormat = (String)tsas.getAttribute("KEYSTORE_FORMAT");
            String trustStoreURL = (String)tsas.getAttribute("KEYSTORE_LOCATION");
            String trustStorePassword = (String)tsas.getAttribute("KEYSTORE_PASSWORD");
            if (trustStoreURL != null) {
                BrokerComponent.getComponentContext().logMessage("Loading broker trust store", 3);
                try {
                    trustStore.load(trustStoreURL, trustStorePassword == null ? null : trustStorePassword.toCharArray());
                    mainProps.put("BROKER_TRUSTSTORE", trustStore);
                }
                catch (Exception ex) {
                    BrokerComponent.getComponentContext().logMessage("Unable to load broker trust store \"" + trustStoreURL + "\"; reason: " + ex.getMessage(), (Throwable)ex, 2);
                }
            }
        }
        if ((bcas = (IAttributeSet)wsas.getAttribute("BROKER_CREDENTIALS")) != null) {
            String x509Alias;
            s_bindHelper.bindBrokerCredentialsChangeHandler(bcas, keyStore);
            String utName = (String)bcas.getAttribute("USERNAMETOKEN_USERNAME");
            if (utName != null && utName.length() > 0) {
                String utPwd = (String)bcas.getAttribute("USERNAMETOKEN_PASSWORD");
                if (utPwd == null || utPwd.length() == 0) {
                    BrokerComponent.getComponentContext().logMessage("Password for the broker Username token cannot be null or empty string.", 2);
                } else {
                    mainProps.put("USERNAMETOKEN_USERNAME", utName);
                    mainProps.put("USERNAMETOKEN_PASSWORD", utPwd);
                }
            }
            if ((x509Alias = (String)bcas.getAttribute("X509TOKEN_ALIAS")) != null && x509Alias.trim().length() > 0) {
                String x509Pwd = (String)bcas.getAttribute("X509TOKEN_PASSWORD");
                if (x509Pwd == null || x509Pwd.trim().length() == 0) {
                    BrokerComponent.getComponentContext().logMessage("Private key password for the broker X.509 token cannot be null or empty string.", 2);
                } else {
                    BrokerKeyStore ks = (BrokerKeyStore)mainProps.get("BROKER_KEYSTORE");
                    if (ks != null) {
                        try {
                            ks.setDefaultCertificate(x509Alias, x509Pwd);
                            mainProps.put("X509TOKEN_ALIAS", x509Alias);
                            mainProps.put("X509TOKEN_PASSWORD", x509Pwd);
                        }
                        catch (KeyStoreException ex) {
                            BrokerComponent.getComponentContext().logMessage(ex.getMessage(), (Throwable)ex, 2);
                        }
                    }
                }
            }
        }
        if ((dsigPrefixList = (Boolean)wsas.getAttribute("WS_SIGNATURE_PREFIXLIST_REQUIRED")) != null) {
            mainProps.put("WS_SIGNATURE_PREFIXLIST_REQUIRED", dsigPrefixList);
        }
    }

    private static void getWSRMAttributes(IAttributeSet wras, Properties mainProps) {
        Integer sequenceControlThreads = (Integer)wras.getAttribute("SEQUENCE_CONTROL_THREADS");
        if (sequenceControlThreads != null) {
            mainProps.put("SEQUENCE_CONTROL_THREADS", sequenceControlThreads);
        }
    }

    static {
        s_bindHelper = null;
        m_isLoadingFromDS = true;
        s_isBackup = false;
    }
}

