/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.ExternalDomainAuthSPIConfig;
import com.sonicsw.security.pass.broker.ConnectionException;
import java.util.HashMap;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;

class ExternalDomainGroupMapChangeHandler
implements IAttributeChangeHandler {
    private HashMap m_attributeSet;

    ExternalDomainGroupMapChangeHandler(IAttributeSet attributeSet) {
        if (attributeSet != null) {
            this.m_attributeSet = attributeSet.getAttributes();
        }
    }

    public void itemDeleted() {
    }

    public void itemModified(Object newValue) {
        if (newValue == null || this.m_attributeSet == null) {
            return;
        }
        if (newValue instanceof IDeltaAttributeSet) {
            String[] newAttrNames;
            String[] modifiedAttrNames;
            IDeltaAttributeSet das = (IDeltaAttributeSet)newValue;
            String[] deletedAttrNames = das.getDeletedAttributesNames();
            if (deletedAttrNames != null && deletedAttrNames.length > 0) {
                for (int i = 0; i < deletedAttrNames.length; ++i) {
                    if (!this.m_attributeSet.containsKey(deletedAttrNames[i])) continue;
                    this.m_attributeSet.remove(deletedAttrNames[i]);
                }
            }
            if ((modifiedAttrNames = das.getModifiedAttributesNames()) != null && modifiedAttrNames.length > 0) {
                for (int i = 0; i < modifiedAttrNames.length; ++i) {
                    try {
                        this.m_attributeSet.put(modifiedAttrNames[i], das.getNewValue(modifiedAttrNames[i]));
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            if ((newAttrNames = das.getNewAttributesNames()) != null && newAttrNames.length > 0) {
                for (int i = 0; i < newAttrNames.length; ++i) {
                    try {
                        this.m_attributeSet.put(newAttrNames[i], das.getNewValue(newAttrNames[i]));
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            ExternalDomainAuthSPIConfig externalDomainAuthSPIConfig = AgentRegistrar.getExternalDomainAuthSPIConfig();
            externalDomainAuthSPIConfig.setGroupMap(this.m_attributeSet);
            try {
                String[] extUsers = Broker.getBroker().getSecurityCache().getExternalUsers();
                if (extUsers != null && extUsers.length > 0) {
                    Broker.getBroker().getSecurityCache().updateExternalUsers(extUsers);
                }
            }
            catch (ConnectionException e) {
                BrokerComponent.getComponentContext().logMessage(e.getMessage(), (Throwable)e, 2);
            }
            catch (Exception e) {
                BrokerComponent.getComponentContext().logMessage(e.getMessage(), (Throwable)e, 2);
            }
            catch (Throwable e) {
                BrokerComponent.getComponentContext().logMessage(e.getMessage(), e, 2);
            }
        }
    }
}

