/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mq.components.AttributesHolder;
import com.sonicsw.mq.components.HttpProxyConfig;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;

public class RouteConfigChangeHandler
implements IAttributeChangeHandler {
    private RoutingConnectionInfo m_rci = null;
    private static volatile AttributesHolder s_attributesHolder = null;
    private static final Object ATTRIBUTEHOLDER_LOCK_OBJ = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RouteConfigChangeHandler(RoutingConnectionInfo rci, AttributesHolder attributesHolder) {
        this.m_rci = rci;
        if (s_attributesHolder == null) {
            Object object = ATTRIBUTEHOLDER_LOCK_OBJ;
            synchronized (object) {
                if (s_attributesHolder == null) {
                    s_attributesHolder = attributesHolder;
                }
            }
        }
    }

    public void itemDeleted() {
        AgentRegistrar.getAgentRegistrar().getRoutingConfig().deleteRoutingConnection(this.m_rci.getRoutingNodeName());
        this.m_rci = null;
    }

    public void itemModified(Object newValue) {
        if (newValue == null) {
            return;
        }
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] newAttributes = delta.getNewAttributesNames();
        int len = newAttributes.length;
        String attributeName = null;
        for (int i = 0; i < len; ++i) {
            attributeName = newAttributes[i];
            this.setAttribute(attributeName, delta);
        }
        String[] modifiedAttributes = delta.getModifiedAttributesNames();
        len = modifiedAttributes.length;
        attributeName = null;
        for (int i = 0; i < len; ++i) {
            attributeName = modifiedAttributes[i];
            this.setAttribute(attributeName, delta);
        }
        String[] deletedAttributes = delta.getDeletedAttributesNames();
        len = deletedAttributes.length;
        attributeName = null;
        for (int i = 0; i < len; ++i) {
            HttpProxyConfig new_pConfig;
            IHttpProxyConfig old_pConfig;
            attributeName = deletedAttributes[i];
            if (attributeName.equals("NODE_NAME")) continue;
            if (attributeName.equals("BROKER")) {
                this.m_rci.setOutboundBrokerName(null);
                continue;
            }
            if (attributeName.equals("ADVERTISE")) {
                this.m_rci.setForwardRoutings(false);
                continue;
            }
            if (attributeName.equals("GLOBAL_SUBSCRIPTION_EXPIRATION")) {
                this.m_rci.setGlobalSubscriptionExpiration(0L);
                continue;
            }
            if (attributeName.equals("LOAD_BALANCING")) {
                this.m_rci.setLoadBalance(false);
                continue;
            }
            if (attributeName.equals("SEQUENTIAL")) {
                this.m_rci.setSequentialLoadBalancing(false);
                continue;
            }
            if (attributeName.equals("STATIC_ROUTING")) {
                this.m_rci.setStaticRouting(false);
                continue;
            }
            if (attributeName.equals("IDLE_TIMEOUT")) {
                this.m_rci.setTimeout(0);
                continue;
            }
            if (attributeName.equals("URLS") || attributeName.equals("URL")) continue;
            if (attributeName.equals("GROUP_BY_URL")) {
                this.m_rci.setGroupByUrl(true);
                continue;
            }
            if (attributeName.equals("USER_NAME")) {
                this.m_rci.setUserName("");
                continue;
            }
            if (attributeName.equals("USER_PASSWORD")) {
                this.m_rci.setPassword("");
                continue;
            }
            if (attributeName.equals("PROXY_URL")) {
                old_pConfig = this.m_rci.getProxyConfig();
                if (old_pConfig == null) continue;
                new_pConfig = new HttpProxyConfig(null, old_pConfig.getUserName(), old_pConfig.getUserPassword());
                this.m_rci.setProxyConfig(new_pConfig);
                continue;
            }
            if (attributeName.equals("PROXY_USER_NAME")) {
                old_pConfig = this.m_rci.getProxyConfig();
                if (old_pConfig == null) continue;
                new_pConfig = new HttpProxyConfig(old_pConfig.getProtocol(), old_pConfig.getHost(), old_pConfig.getPort(), "", old_pConfig.getUserPassword());
                this.m_rci.setProxyConfig(new_pConfig);
                continue;
            }
            if (attributeName.equals("PROXY_PASSWORD")) {
                old_pConfig = this.m_rci.getProxyConfig();
                if (old_pConfig == null) continue;
                new_pConfig = new HttpProxyConfig(old_pConfig.getProtocol(), old_pConfig.getHost(), old_pConfig.getPort(), old_pConfig.getUserName(), "");
                this.m_rci.setProxyConfig(new_pConfig);
                continue;
            }
            if (attributeName.equals("WSS_PARAMETERS")) {
                this.m_rci.setDestinationX509IssuerName(null);
                this.m_rci.setDestinationX509SerialNumber(null);
                this.m_rci.setUsernameTokenName(null);
                this.m_rci.setUsernameTokenPassword(null);
                this.m_rci.setX509Alias(null);
                this.m_rci.setX509Password(null);
                continue;
            }
            if (attributeName.equals("WSRM_PARAMETERS")) {
                this.m_rci.setRmIdleTimeout(0L);
                this.m_rci.setRmSequenceExpiration(0L);
                continue;
            }
            if (!attributeName.equals("ROUTING_ACCEPTOR")) continue;
            this.m_rci.setRoutingAcceptor("");
        }
        AgentRegistrar.getAgentRegistrar().getRoutingConfig().setRoutingConnection(this.m_rci);
    }

    private void setAttribute(String attributeName, IDeltaAttributeSet delta) {
        block85: {
            int i;
            block102: {
                IDeltaAttributeSet serviceCredentialsDelta;
                int i2;
                block101: {
                    block100: {
                        block99: {
                            block98: {
                                block97: {
                                    block96: {
                                        block95: {
                                            block94: {
                                                block93: {
                                                    block92: {
                                                        block91: {
                                                            block90: {
                                                                block89: {
                                                                    block88: {
                                                                        block87: {
                                                                            block86: {
                                                                                block84: {
                                                                                    if (!attributeName.equals("NODE_NAME")) break block84;
                                                                                    try {
                                                                                        String nodeName = (String)delta.getNewValue("NODE_NAME");
                                                                                        if (nodeName != null) {
                                                                                            this.m_rci.setRoutingNodeName(nodeName);
                                                                                        }
                                                                                    }
                                                                                    catch (NotModifiedAttException nmae) {}
                                                                                    break block85;
                                                                                }
                                                                                if (!attributeName.equals("BROKER")) break block86;
                                                                                try {
                                                                                    String brokerName = (String)delta.getNewValue("BROKER");
                                                                                    if (brokerName != null) {
                                                                                        this.m_rci.setOutboundBrokerName(brokerName);
                                                                                    }
                                                                                }
                                                                                catch (NotModifiedAttException nmae) {}
                                                                                break block85;
                                                                            }
                                                                            if (!attributeName.equals("ADVERTISE")) break block87;
                                                                            try {
                                                                                Boolean advertise = (Boolean)delta.getNewValue("ADVERTISE");
                                                                                if (advertise != null) {
                                                                                    this.m_rci.setForwardRoutings(advertise);
                                                                                }
                                                                            }
                                                                            catch (NotModifiedAttException nmae) {}
                                                                            break block85;
                                                                        }
                                                                        if (!attributeName.equals("GLOBAL_SUBSCRIPTION_EXPIRATION")) break block88;
                                                                        try {
                                                                            Long globalSubscriptionExpiration = (Long)delta.getNewValue("GLOBAL_SUBSCRIPTION_EXPIRATION");
                                                                            if (globalSubscriptionExpiration != null) {
                                                                                this.m_rci.setGlobalSubscriptionExpiration(globalSubscriptionExpiration);
                                                                            }
                                                                        }
                                                                        catch (NotModifiedAttException nmae) {}
                                                                        break block85;
                                                                    }
                                                                    if (!attributeName.equals("LOAD_BALANCING")) break block89;
                                                                    try {
                                                                        Boolean loadBalance = (Boolean)delta.getNewValue("LOAD_BALANCING");
                                                                        if (loadBalance != null) {
                                                                            this.m_rci.setLoadBalance(loadBalance);
                                                                        }
                                                                    }
                                                                    catch (NotModifiedAttException nmae) {}
                                                                    break block85;
                                                                }
                                                                if (!attributeName.equals("SEQUENTIAL")) break block90;
                                                                try {
                                                                    Boolean sequential = (Boolean)delta.getNewValue("SEQUENTIAL");
                                                                    if (sequential != null) {
                                                                        this.m_rci.setSequentialLoadBalancing(sequential);
                                                                    }
                                                                }
                                                                catch (NotModifiedAttException nmae) {}
                                                                break block85;
                                                            }
                                                            if (!attributeName.equals("STATIC_ROUTING")) break block91;
                                                            try {
                                                                Boolean staticRouting = (Boolean)delta.getNewValue("STATIC_ROUTING");
                                                                if (staticRouting != null) {
                                                                    this.m_rci.setStaticRouting(staticRouting);
                                                                }
                                                            }
                                                            catch (NotModifiedAttException nmae) {}
                                                            break block85;
                                                        }
                                                        if (!attributeName.equals("IDLE_TIMEOUT")) break block92;
                                                        try {
                                                            Integer idleTimeout = (Integer)delta.getNewValue("IDLE_TIMEOUT");
                                                            if (idleTimeout != null) {
                                                                this.m_rci.setTimeout(idleTimeout);
                                                            }
                                                        }
                                                        catch (NotModifiedAttException nmae) {}
                                                        break block85;
                                                    }
                                                    if (!attributeName.equals("URLS")) break block93;
                                                    try {
                                                        String urls = (String)delta.getNewValue("URLS");
                                                        if (urls != null) {
                                                            this.m_rci.setConnectionURLs(urls);
                                                        }
                                                    }
                                                    catch (NotModifiedAttException nmae) {}
                                                    break block85;
                                                }
                                                if (!attributeName.equals("URL")) break block94;
                                                try {
                                                    String url = (String)delta.getNewValue("URL");
                                                    if (url != null) {
                                                        this.m_rci.setConnectionURLs(url);
                                                    }
                                                }
                                                catch (NotModifiedAttException nmae) {}
                                                break block85;
                                            }
                                            if (!attributeName.equals("GROUP_BY_URL")) break block95;
                                            try {
                                                Boolean groupByUrl = (Boolean)delta.getNewValue("GROUP_BY_URL");
                                                if (groupByUrl != null) {
                                                    this.m_rci.setGroupByUrl(groupByUrl);
                                                }
                                            }
                                            catch (NotModifiedAttException nmae) {}
                                            break block85;
                                        }
                                        if (!attributeName.equals("ROUTING_ACCEPTOR")) break block96;
                                        try {
                                            String routingAcceptor = (String)delta.getNewValue("ROUTING_ACCEPTOR");
                                            if (routingAcceptor != null) {
                                                this.m_rci.setRoutingAcceptor(routingAcceptor);
                                            }
                                        }
                                        catch (NotModifiedAttException nmae) {}
                                        break block85;
                                    }
                                    if (!attributeName.equals("USER_NAME")) break block97;
                                    try {
                                        String username = (String)delta.getNewValue("USER_NAME");
                                        if (username != null) {
                                            if (this.m_rci.getRouteType() == RoutingConnectionInfo.ROUTE_TYPE_SONIC && username.indexOf(".") != -1) {
                                                username = username.replace('.', '$');
                                            }
                                            this.m_rci.setUserName(username);
                                        }
                                    }
                                    catch (NotModifiedAttException nmae) {}
                                    break block85;
                                }
                                if (!attributeName.equals("USER_PASSWORD")) break block98;
                                try {
                                    String pwd = (String)delta.getNewValue("USER_PASSWORD");
                                    if (pwd != null) {
                                        this.m_rci.setPassword(pwd);
                                    }
                                }
                                catch (NotModifiedAttException nmae) {}
                                break block85;
                            }
                            if (!attributeName.equals("PROXY_URL")) break block99;
                            try {
                                IHttpProxyConfig old_pConfig = this.m_rci.getProxyConfig();
                                HttpProxyConfig new_pConfig = new HttpProxyConfig(delta);
                                if (old_pConfig != null && new_pConfig != null) {
                                    new_pConfig = new HttpProxyConfig(new_pConfig.getProtocol(), new_pConfig.getHost(), new_pConfig.getPort(), old_pConfig.getUserName(), old_pConfig.getUserPassword());
                                    this.m_rci.setProxyConfig(new_pConfig);
                                }
                            }
                            catch (NotModifiedAttException nmae) {}
                            break block85;
                        }
                        if (!attributeName.equals("PROXY_USER_NAME")) break block100;
                        try {
                            IHttpProxyConfig old_pConfig = this.m_rci.getProxyConfig();
                            HttpProxyConfig new_pConfig = new HttpProxyConfig(delta);
                            if (old_pConfig != null && new_pConfig != null) {
                                new_pConfig = new HttpProxyConfig(old_pConfig.getProtocol(), old_pConfig.getHost(), old_pConfig.getPort(), new_pConfig.getUserName(), old_pConfig.getUserPassword());
                                this.m_rci.setProxyConfig(new_pConfig);
                            }
                        }
                        catch (NotModifiedAttException nmae) {}
                        break block85;
                    }
                    if (!attributeName.equals("PROXY_PASSWORD")) break block101;
                    try {
                        IHttpProxyConfig old_pConfig = this.m_rci.getProxyConfig();
                        HttpProxyConfig new_pConfig = new HttpProxyConfig(delta);
                        if (old_pConfig != null && new_pConfig != null) {
                            new_pConfig = new HttpProxyConfig(old_pConfig.getProtocol(), old_pConfig.getHost(), old_pConfig.getPort(), old_pConfig.getUserName(), new_pConfig.getUserPassword());
                            this.m_rci.setProxyConfig(new_pConfig);
                        }
                    }
                    catch (NotModifiedAttException nmae) {}
                    break block85;
                }
                if (!attributeName.equals("WSS_PARAMETERS")) break block102;
                IDeltaAttributeSet wssDelta = null;
                String[] deletedAttributes = null;
                String[] modifiedAttributes = null;
                String[] newAttributes = null;
                try {
                    wssDelta = (IDeltaAttributeSet)delta.getNewValue("WSS_PARAMETERS");
                    deletedAttributes = wssDelta.getDeletedAttributesNames();
                    modifiedAttributes = wssDelta.getModifiedAttributesNames();
                    newAttributes = wssDelta.getNewAttributesNames();
                }
                catch (NotModifiedAttException nmae) {
                    // empty catch block
                }
                if (deletedAttributes == null) {
                    throw new NullPointerException("String[] deletedAttributes is null at " + this.getClass().getName() + ".setAttribute( String attributeName, IDeltaAttributeSet delta )");
                }
                String wssAttributeName = null;
                for (i2 = 0; i2 < deletedAttributes.length; ++i2) {
                    wssAttributeName = deletedAttributes[i2];
                    if (wssAttributeName.equals("DESTINATION_CERTIFICATE_ISSUER_NAME")) {
                        this.m_rci.setDestinationX509IssuerName(null);
                        continue;
                    }
                    if (wssAttributeName.equals("DESTINATION_CERTIFICATE_ISSUER_NUMBER")) {
                        this.m_rci.setDestinationX509SerialNumber(null);
                        continue;
                    }
                    if (!wssAttributeName.equals("CREDENTIALS")) continue;
                    this.m_rci.setUsernameTokenName(null);
                    this.m_rci.setUsernameTokenPassword(null);
                    this.m_rci.setX509Alias(null);
                    this.m_rci.setX509Password(null);
                }
                for (i2 = 0; i2 < modifiedAttributes.length; ++i2) {
                    wssAttributeName = modifiedAttributes[i2];
                    try {
                        if (wssAttributeName.equals("DESTINATION_CERTIFICATE_ISSUER_NAME")) {
                            this.m_rci.setDestinationX509IssuerName((String)wssDelta.getNewValue(wssAttributeName));
                            continue;
                        }
                        if (wssAttributeName.equals("DESTINATION_CERTIFICATE_ISSUER_NUMBER")) {
                            this.m_rci.setDestinationX509SerialNumber((String)wssDelta.getNewValue(wssAttributeName));
                            continue;
                        }
                        if (!wssAttributeName.equals("CREDENTIALS")) continue;
                        serviceCredentialsDelta = null;
                        try {
                            serviceCredentialsDelta = (IDeltaAttributeSet)wssDelta.getNewValue("CREDENTIALS");
                            deletedAttributes = serviceCredentialsDelta.getDeletedAttributesNames();
                            modifiedAttributes = serviceCredentialsDelta.getModifiedAttributesNames();
                            newAttributes = serviceCredentialsDelta.getNewAttributesNames();
                        }
                        catch (NotModifiedAttException nmae) {
                            // empty catch block
                        }
                        this.resetIdentity(serviceCredentialsDelta, deletedAttributes, modifiedAttributes, newAttributes);
                        continue;
                    }
                    catch (NotModifiedAttException nmae) {
                        // empty catch block
                    }
                }
                for (i2 = 0; i2 < newAttributes.length; ++i2) {
                    wssAttributeName = newAttributes[i2];
                    try {
                        if (wssAttributeName.equals("DESTINATION_CERTIFICATE_ISSUER_NAME")) {
                            this.m_rci.setDestinationX509IssuerName((String)wssDelta.getNewValue(wssAttributeName));
                            continue;
                        }
                        if (wssAttributeName.equals("DESTINATION_CERTIFICATE_ISSUER_NUMBER")) {
                            this.m_rci.setDestinationX509SerialNumber((String)wssDelta.getNewValue(wssAttributeName));
                            continue;
                        }
                        if (!wssAttributeName.equals("CREDENTIALS")) continue;
                        try {
                            serviceCredentialsDelta = (IDeltaAttributeSet)wssDelta.getNewValue("CREDENTIALS");
                            this.m_rci.setUsernameTokenName((String)serviceCredentialsDelta.getNewValue("USERNAMETOKEN_USERNAME"));
                            String pwd = (String)serviceCredentialsDelta.getNewValue("USERNAMETOKEN_PASSWORD");
                            this.m_rci.setUsernameTokenPassword(pwd == null ? null : pwd.toCharArray());
                            this.m_rci.setX509Alias((String)serviceCredentialsDelta.getNewValue("X509TOKEN_ALIAS"));
                            pwd = (String)serviceCredentialsDelta.getNewValue("X509TOKEN_PASSWORD");
                            this.m_rci.setX509Password(pwd == null ? null : pwd.toCharArray());
                        }
                        catch (NotModifiedAttException nmae) {}
                        continue;
                    }
                    catch (NotModifiedAttException nmae) {
                        // empty catch block
                    }
                }
                break block85;
            }
            if (!attributeName.equals("WSRM_PARAMETERS")) break block85;
            IDeltaAttributeSet wsrmDelta = null;
            String[] deletedAttributes = null;
            String[] modifiedAttributes = null;
            String[] newAttributes = null;
            try {
                wsrmDelta = (IDeltaAttributeSet)delta.getNewValue("WSRM_PARAMETERS");
                deletedAttributes = wsrmDelta.getDeletedAttributesNames();
                modifiedAttributes = wsrmDelta.getModifiedAttributesNames();
                newAttributes = wsrmDelta.getNewAttributesNames();
            }
            catch (NotModifiedAttException nmae) {
                // empty catch block
            }
            String wsrmAttributeName = null;
            for (i = 0; i < deletedAttributes.length; ++i) {
                wsrmAttributeName = deletedAttributes[i];
                if (wsrmAttributeName.equals("IDLE_TIMEOUT")) {
                    this.m_rci.setRmIdleTimeout(0L);
                    continue;
                }
                if (!wsrmAttributeName.equals("SEQUENCE_EXPIRATION")) continue;
                this.m_rci.setRmSequenceExpiration(0L);
            }
            for (i = 0; i < modifiedAttributes.length; ++i) {
                wsrmAttributeName = modifiedAttributes[i];
                try {
                    if (wsrmAttributeName.equals("IDLE_TIMEOUT")) {
                        this.m_rci.setRmIdleTimeout(((Integer)wsrmDelta.getNewValue(wsrmAttributeName)).intValue());
                        continue;
                    }
                    if (!wsrmAttributeName.equals("SEQUENCE_EXPIRATION")) continue;
                    this.m_rci.setRmSequenceExpiration(((Integer)wsrmDelta.getNewValue(wsrmAttributeName)).intValue());
                    continue;
                }
                catch (NotModifiedAttException nmae) {
                    // empty catch block
                }
            }
            for (i = 0; i < newAttributes.length; ++i) {
                wsrmAttributeName = newAttributes[i];
                try {
                    if (wsrmAttributeName.equals("IDLE_TIMEOUT")) {
                        this.m_rci.setRmIdleTimeout(((Integer)wsrmDelta.getNewValue(wsrmAttributeName)).intValue());
                        continue;
                    }
                    if (!wsrmAttributeName.equals("SEQUENCE_EXPIRATION")) continue;
                    this.m_rci.setRmSequenceExpiration(((Integer)wsrmDelta.getNewValue(wsrmAttributeName)).intValue());
                    continue;
                }
                catch (NotModifiedAttException nmae) {
                    // empty catch block
                }
            }
        }
    }

    private void resetIdentity(IDeltaAttributeSet delta, String[] deletedAttributes, String[] modifiedAttributes, String[] newAttributes) {
        int i;
        if (delta == null) {
            return;
        }
        String pwd = null;
        for (i = 0; i < newAttributes.length; ++i) {
            if (newAttributes.length > i && newAttributes[i].equalsIgnoreCase("USERNAMETOKEN_USERNAME")) {
                try {
                    this.m_rci.setUsernameTokenName((String)delta.getNewValue(newAttributes[i]));
                }
                catch (NotModifiedAttException e) {}
                continue;
            }
            if (newAttributes.length > i && newAttributes[i].equalsIgnoreCase("USERNAMETOKEN_PASSWORD")) {
                try {
                    pwd = (String)delta.getNewValue(newAttributes[i]);
                    this.m_rci.setUsernameTokenPassword(pwd == null ? null : pwd.toCharArray());
                }
                catch (NotModifiedAttException e) {}
                continue;
            }
            if (newAttributes.length > i && newAttributes[i].equalsIgnoreCase("X509TOKEN_ALIAS")) {
                try {
                    this.m_rci.setX509Alias((String)delta.getNewValue(newAttributes[i]));
                }
                catch (NotModifiedAttException e) {}
                continue;
            }
            if (newAttributes.length <= i || !newAttributes[i].equalsIgnoreCase("X509TOKEN_PASSWORD")) continue;
            try {
                pwd = (String)delta.getNewValue(newAttributes[i]);
                this.m_rci.setX509Password(pwd == null ? null : pwd.toCharArray());
                continue;
            }
            catch (NotModifiedAttException e) {
                // empty catch block
            }
        }
        for (i = 0; i < modifiedAttributes.length; ++i) {
            if (modifiedAttributes.length > i && modifiedAttributes[i].equalsIgnoreCase("USERNAMETOKEN_USERNAME")) {
                try {
                    this.m_rci.setUsernameTokenName((String)delta.getNewValue(modifiedAttributes[i]));
                }
                catch (NotModifiedAttException e) {}
                continue;
            }
            if (modifiedAttributes.length > i && modifiedAttributes[i].equalsIgnoreCase("USERNAMETOKEN_PASSWORD")) {
                try {
                    pwd = (String)delta.getNewValue(modifiedAttributes[i]);
                    this.m_rci.setUsernameTokenPassword(pwd == null ? null : pwd.toCharArray());
                }
                catch (NotModifiedAttException e) {}
                continue;
            }
            if (modifiedAttributes.length > i && modifiedAttributes[i].equalsIgnoreCase("X509TOKEN_ALIAS")) {
                try {
                    this.m_rci.setX509Alias((String)delta.getNewValue(modifiedAttributes[i]));
                }
                catch (NotModifiedAttException e) {}
                continue;
            }
            if (modifiedAttributes.length <= i || !modifiedAttributes[i].equalsIgnoreCase("X509TOKEN_PASSWORD")) continue;
            try {
                pwd = (String)delta.getNewValue(modifiedAttributes[i]);
                this.m_rci.setX509Password(pwd == null ? null : pwd.toCharArray());
                continue;
            }
            catch (NotModifiedAttException e) {
                // empty catch block
            }
        }
        for (i = 0; i < deletedAttributes.length; ++i) {
            if (deletedAttributes.length > i && deletedAttributes[i].equalsIgnoreCase("USERNAMETOKEN_USERNAME")) {
                this.m_rci.setUsernameTokenName(null);
                continue;
            }
            if (deletedAttributes.length > i && deletedAttributes[i].equalsIgnoreCase("USERNAMETOKEN_PASSWORD")) {
                this.m_rci.setUsernameTokenPassword(null);
                continue;
            }
            if (deletedAttributes.length > i && deletedAttributes[i].equalsIgnoreCase("X509TOKEN_ALIAS")) {
                this.m_rci.setX509Alias(null);
                continue;
            }
            if (deletedAttributes.length <= i || !deletedAttributes[i].equalsIgnoreCase("X509TOKEN_PASSWORD")) continue;
            this.m_rci.setX509Password(null);
        }
    }
}

