/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.security.cert.X509Certificate;
import progress.message.zclient.IUser;
import progress.message.zclient.ProgressPasswordUser;

public class AccessController {
    private static Object _sync = new Object();
    private static AccessController s_controller = null;
    private IUser m_secdb = null;

    private AccessController() {
        if (Config.ENABLE_SECURITY) {
            this.m_secdb = AgentRegistrar.getAgentRegistrar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessController getController() {
        if (s_controller == null) {
            Object object = _sync;
            synchronized (object) {
                if (s_controller == null) {
                    s_controller = new AccessController();
                }
            }
        }
        return s_controller;
    }

    public ProgressPasswordUser authenticate(String name, String password, X509Certificate cert) {
        boolean passwordRequired = true;
        return this.authenticate(name, password, passwordRequired, cert);
    }

    public ProgressPasswordUser authenticate(String name, String password, boolean passwordRequired, X509Certificate cert) {
        if (name != null) {
            name = name.replace('.', '$');
        }
        ProgressPasswordUser user = null;
        String cn = null;
        if (this.m_secdb == null) {
            if (name != null) {
                return new ProgressPasswordUser(name, "");
            }
            if (cert != null) {
                try {
                    cn = cert.getSubjectCommonName();
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                if (cn != null && !cn.equals("")) {
                    return new ProgressPasswordUser(cn, "");
                }
            }
            return new ProgressPasswordUser("ANONYMOUS", "");
        }
        if (name != null && !name.equals("AUTHENTICATED")) {
            if (!passwordRequired) {
                user = this.m_secdb.getUser(name);
                return user;
            }
            if (password == null) {
                return null;
            }
            user = this.m_secdb.getUser(name);
            if (user == null) {
                return null;
            }
            return user.authenticate(password) ? user : null;
        }
        if (cert == null) {
            return null;
        }
        try {
            cn = cert.getSubjectCommonName();
        }
        catch (SecurityException e) {
            // empty catch block
        }
        cn = cn.replace('.', '$');
        user = this.m_secdb.getUser(cn);
        return user != null ? user : null;
    }
}

