/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import com.sonicsw.net.http.Http2Mgram;
import com.sonicsw.net.http.HttpConstants;
import com.sonicsw.net.http.MessageHandlingException;
import com.sonicsw.net.http.PropertyBadValueException;
import com.sonicsw.net.http.PropertyMissingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.mortbay.http.HttpRequest;
import progress.message.security.cert.X509Certificate;
import progress.message.zclient.EMsgTooBigException;
import progress.message.zclient.SessionConfig;

public class HttpInRequest
extends Http2Mgram {
    protected HttpRequest req = null;
    protected int m_method;
    protected X509Certificate m_certificate = null;
    protected String m_basicAuthUser = null;
    protected String m_userAgentAddress = null;
    protected String m_cipher = null;
    protected String m_mappedURL = null;
    protected Destination m_jmsDestination = null;
    public static final int METHOD_OTHER = 0;
    public static final int METHOD_GET = 1;
    public static final int METHOD_POST = 2;

    public HttpInRequest(HttpRequest req) {
        this.req = req;
        this.setRequestMethod(req.getMethod());
    }

    public boolean isGet() {
        return this.m_method == 1;
    }

    public boolean isPost() {
        return this.m_method == 2;
    }

    public HttpRequest getRequest() {
        return this.req;
    }

    @Override
    public String getProperty(String name, boolean required) throws PropertyMissingException {
        String value = this.req.getField(name);
        if (required && value == null) {
            throw new PropertyMissingException(name);
        }
        return value;
    }

    @Override
    public int getPropertyInt(String name, boolean required) throws PropertyMissingException, PropertyBadValueException {
        String value = this.req.getField(name);
        if (required && value == null) {
            throw new PropertyMissingException(name);
        }
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new PropertyBadValueException(name, value);
        }
    }

    @Override
    public long getPropertyLong(String name, boolean required) throws PropertyMissingException, PropertyBadValueException {
        String value = this.req.getField(name);
        if (required && value == null) {
            throw new PropertyMissingException(name);
        }
        if (value == null) {
            return -1L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            throw new PropertyBadValueException(name, value);
        }
    }

    @Override
    public Boolean getPropertyBoolean(String name, boolean required) throws PropertyMissingException, PropertyBadValueException {
        String value = this.req.getField(name);
        if (required && value == null) {
            throw new PropertyMissingException(name);
        }
        if (value == null) {
            return null;
        }
        try {
            return Boolean.valueOf(value);
        }
        catch (Exception e) {
            throw new PropertyBadValueException(name, value);
        }
    }

    @Override
    public Hashtable getPropertySet() {
        Hashtable<String, String> set = new Hashtable<String, String>();
        Enumeration enumeration = this.req.getFieldNames();
        while (enumeration.hasMoreElements()) {
            String value;
            String key = (String)enumeration.nextElement();
            if (key == null || (value = this.req.getField(key)) == null) continue;
            set.put(key, value);
        }
        return set;
    }

    private byte[] getContent() throws IOException {
        String transferEncoding = this.req.getField("Transfer-Encoding");
        if (transferEncoding != null && transferEncoding.equalsIgnoreCase("chunked")) {
            System.out.println("Chunked content is not currently supported");
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream in = this.req.getInputStream();
        byte[] buf = new byte[2048];
        int totalRead = 0;
        int len = 0;
        while ((len = in.read(buf)) >= 0) {
            if (SessionConfig.MAX_MSG_SIZE > 0 && (totalRead += len) > SessionConfig.MAX_MSG_SIZE) {
                throw new EMsgTooBigException(-1, SessionConfig.MAX_MSG_SIZE);
            }
            out.write(buf, 0, len);
        }
        return out.toByteArray();
    }

    protected InputStream getInputStream() {
        return this.req.getInputStream();
    }

    protected void handleMultipartContent() throws JMSException, MessageHandlingException {
        super.handleMultipartContent(this.getInputStream());
    }

    protected void handleSinglepartContent() throws PropertyBadValueException, JMSException, MessageHandlingException, UnsupportedEncodingException {
        byte[] buffer = null;
        try {
            buffer = this.getContent();
        }
        catch (EMsgTooBigException e) {
            throw new MessageHandlingException(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.handleSinglepartContent(buffer);
    }

    public void handleEncodedContent() throws PropertyBadValueException, JMSException, MessageHandlingException, UnsupportedEncodingException {
        if (this.m_multipart) {
            this.handleMultipartContent();
        } else if (!this.isGet()) {
            this.handleSinglepartContent();
        }
    }

    protected void handleCopyAllProperties() {
        Enumeration enumeration = this.req.getFieldNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            try {
                if (this.isIgnoredHTTPProperty(key)) continue;
                String value = this.req.getField(key);
                if (key.indexOf(String.valueOf('\u00ff')) > 0) {
                    key = key.replace('\u00ff', ':');
                }
                if (key.equalsIgnoreCase("Content-Length")) {
                    this.writeProperty("X-HTTP-ContentLength", value);
                }
                this.writeProperty(key, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.propagateUserID();
            this.writeProperty("X-HTTP-UserAgentAddrress", this.m_userAgentAddress);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeProperty(String key, String value) throws JMSException {
        this.m_message.setStringProperty(key, value);
    }

    protected void handleRequestURL() throws JMSException {
        String receiveURL = this.req.getRequestURL().toString();
        String reqQuery = this.req.getQuery();
        if (reqQuery != null && !reqQuery.equals("")) {
            receiveURL = receiveURL + "?" + reqQuery;
        }
        if (receiveURL != null) {
            this.m_message.setStringProperty("X-HTTP-ReceiveURL", receiveURL);
        }
        if (this.m_mappedURL != null) {
            this.m_message.setStringProperty("X-HTTP-MappedURL", this.m_mappedURL);
        }
    }

    protected void handleRequestMethod() throws JMSException {
        String requestMethod = this.req.getMethod();
        if (requestMethod != null) {
            this.m_message.setStringProperty("X-HTTP-RequestMethod", requestMethod);
        }
    }

    @Override
    public String getCharacterEncoding() throws UnsupportedEncodingException {
        if (this.m_charset != null) {
            return this.m_charset;
        }
        String ce = this.req.getCharacterEncoding();
        if (ce != null) {
            StringTokenizer st = new StringTokenizer(ce, "\"'", false);
            this.m_charset = (String)st.nextElement();
        }
        return this.m_charset;
    }

    private void propagateUserID() throws JMSException {
        if (this.m_basicAuthUser != null) {
            this.m_message.setStringProperty("X-HTTP-AuthUser", this.m_basicAuthUser);
        }
        if (this.m_certificate != null) {
            this.m_message.setStringProperty("X-HTTPS-CertificateCN", this.m_certificate.getSubjectCommonName());
            String s = null;
            Principal o = this.m_certificate.getSubjectDN();
            if (o instanceof Principal) {
                s = o.getName();
            } else if (o instanceof String) {
                s = (String)((Object)o);
            }
            this.m_message.setStringProperty("X-HTTPS-CertificateDN", s);
            s = null;
            o = this.m_certificate.getIssuerDN();
            if (o instanceof Principal) {
                s = o.getName();
            } else if (o instanceof String) {
                s = (String)((Object)o);
            }
            this.m_message.setStringProperty("X-HTTPS-CACertificateDN", s);
        }
    }

    private void setRequestMethod(String method) {
        this.m_method = method.equalsIgnoreCase("POST") ? 2 : (method.equalsIgnoreCase("GET") ? 1 : 0);
    }

    void notifySetAuthUser(String basicAuthUser) {
        this.m_basicAuthUser = basicAuthUser;
    }

    void notifySetCertificate(X509Certificate certificate) {
        this.m_certificate = certificate;
    }

    public void notifySetMappedURL(String mappedURL) {
        this.m_mappedURL = mappedURL;
        HttpConstants.DEBUG("request.m_mappedURL =   " + this.m_mappedURL, 0);
    }

    public String getMappedURL() {
        return this.m_mappedURL;
    }

    public Destination getJMSDestionation() {
        return this.m_jmsDestination;
    }

    public void setUserAgentAddress(String addr) {
        this.m_userAgentAddress = addr;
    }

    public String getUserAgentAddress() {
        return this.m_userAgentAddress;
    }
}

