/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import java.util.Vector;
import progress.message.msg.IMgram;

public class HttpLock {
    private long m_id = -1L;
    private Vector m_responseMgrams = null;
    private int m_numWaiting = 0;
    private boolean m_ack = false;
    private int m_errorType = 200;
    private String m_message = null;
    private boolean m_contentReply = false;
    private int m_contentReplyTimeout = 60;
    private boolean m_ptp = false;
    private String m_tempDest = null;
    private int m_dmqReason = 0;
    private String m_dmqMessage = null;

    public HttpLock(long id) {
        this.m_id = id;
        this.m_responseMgrams = new Vector();
    }

    public static int toHttpErrorCode(int lockErrorCode) {
        switch (lockErrorCode) {
            case 507: {
                return 503;
            }
        }
        return lockErrorCode;
    }

    public long getId() {
        return this.m_id;
    }

    public boolean getAck() {
        return this.m_ack;
    }

    public int getErrorType() {
        return this.m_errorType;
    }

    public String getMessage() {
        return this.m_message;
    }

    public int getDmqReason() {
        return this.m_dmqReason;
    }

    public String getDmqMessage() {
        return this.m_dmqMessage;
    }

    public void setDmqReason(int reason) {
        this.m_dmqReason = reason;
    }

    public void setDmqMessage(String message) {
        this.m_dmqMessage = message;
    }

    public synchronized void ack(int errorType, String message) {
        this.m_errorType = errorType;
        this.m_message = message;
        if (!this.m_contentReply) {
            this.m_ack = true;
            this.notifyAll();
        } else if (this.m_contentReply && errorType != 200 && errorType != 202) {
            this.m_ack = true;
            this.notifyAll();
        } else if (this.m_contentReply && !this.m_responseMgrams.isEmpty()) {
            this.m_ack = true;
            this.notifyAll();
        }
    }

    public synchronized void ackMgramReceipt(IMgram m) {
        this.m_responseMgrams.addElement(m);
        this.m_ack = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IMgram waitForAck(long timeout) throws InterruptedException {
        try {
            if (this.getMgramCount() == 0) {
                this.wait(timeout);
            }
        }
        finally {
            --this.m_numWaiting;
        }
        return this.getResponseMgram();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IMgram waitForAck() throws InterruptedException {
        try {
            while (!this.m_ack) {
                this.wait();
            }
        }
        finally {
            --this.m_numWaiting;
        }
        return this.getResponseMgram();
    }

    public void setError(int errorType) {
        this.m_errorType = errorType;
    }

    public synchronized void setMessage(String msg) {
        this.m_message = msg;
    }

    public void setContentReplyExpected(boolean contentReply) {
        this.m_contentReply = contentReply;
    }

    public boolean getContentReplyExpected() {
        return this.m_contentReply;
    }

    public void setContentReplyTimeout(int timeout) {
        this.m_contentReplyTimeout = timeout;
    }

    public int getContentReplyTimeout() {
        return this.m_contentReplyTimeout;
    }

    public void setPTP() {
        this.m_ptp = true;
    }

    public synchronized void setTempDest(String dest) {
        this.m_tempDest = dest;
    }

    public synchronized String getTempDest() {
        return this.m_tempDest;
    }

    public boolean isPTP() {
        return this.m_ptp;
    }

    public synchronized int getMgramCount() {
        return this.m_responseMgrams.size();
    }

    public synchronized IMgram getResponseMgram() {
        if (this.m_responseMgrams.size() <= 0) {
            return null;
        }
        IMgram m = (IMgram)this.m_responseMgrams.elementAt(0);
        this.m_responseMgrams.removeElementAt(0);
        return m;
    }

    public synchronized void addWaiting() {
        ++this.m_numWaiting;
    }

    public synchronized int getNumWaiting() {
        return this.m_numWaiting;
    }
}

