/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.AccessController;
import com.sonicsw.net.http.HttpBaseHandler;
import com.sonicsw.net.http.HttpClientContext;
import com.sonicsw.net.http.HttpClientContextManager;
import com.sonicsw.net.http.HttpConfigInfo;
import com.sonicsw.net.http.HttpConstants;
import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.net.http.HttpInRequest;
import com.sonicsw.net.http.HttpInResponse;
import com.sonicsw.net.http.HttpLock;
import com.sonicsw.net.http.HttpProtocolHandlerFactory;
import com.sonicsw.net.http.HttpRequestContext;
import com.sonicsw.net.http.PropertyMissingException;
import com.sonicsw.security.pass.broker.ConnectionException;
import com.sonicsw.security.pass.broker.IAuthentication;
import com.sonicsw.security.pass.broker.UnauthenticatedException;
import com.sonicsw.security.pass.client.IPasswordUser;
import java.io.IOException;
import java.net.Socket;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import progress.message.broker.AMPScratchPad;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Authorize;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EOldVirtualClockException;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IClientContext;
import progress.message.broker.QueueAttributes;
import progress.message.broker.SubscribeEvt;
import progress.message.broker.parser.ParseException;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.jimpl.Message;
import progress.message.msg.IMgram;
import progress.message.net.http.server.IHttpRequestHandler;
import progress.message.net.http.server.SonicHttpServer;
import progress.message.net.https.server.SonicHttpsConnection;
import progress.message.security.cert.X509Certificate;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.Envelope;
import progress.message.zclient.Label;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.ProgressSecureRandom;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;
import progress.message.zclient.SubjectUtil;

public abstract class HttpProtocolHandler
extends HttpBaseHandler
implements IHttpRequestHandler {
    public static final String CONTENT_REPLY_TEMP_DESTINATION_PREFIX = "HttpProtocolHandlerResponse";
    public static final int CONTENT_REPLY_TEMP_DESTINATION_PREFIX_LENGTH = "HttpProtocolHandlerResponse".length();
    private boolean m_oneway = true;
    private int m_contentReplyTimeout = 60;
    private BrokerComponent m_brokerComponent = BrokerComponent.getBrokerComponent();
    public static final int STYLE_CONFIG = 0;
    public static final int STYLE_ONEWAY = 1;
    public static final int STYLE_REQRESP = 2;
    private String m_destinationTopic = null;
    private static final String DESTINATION_T = "DestinationTopic";
    private String m_appId = null;

    public HttpProtocolHandler(HttpConfigInfo config) {
        super(config);
        String requestMode = this.m_config.getStringElement("RequestMode", "Oneway");
        if (requestMode != null && (requestMode.equalsIgnoreCase("ContentReply") || requestMode.equalsIgnoreCase("WS"))) {
            this.m_oneway = false;
        }
        if (!this.m_oneway) {
            this.m_contentReplyTimeout = this.m_config.getIntElement("ContentReplyTimeout", 60);
        }
        this.m_destinationTopic = this.m_config.getStringElement(DESTINATION_T);
        HttpProtocolHandlerFactory factory = (HttpProtocolHandlerFactory)config.getFactoryInstance();
        this.m_appId = HttpProtocolHandler.getAppIdPrefix() + factory.getAcceptorName().replace(' ', '_') + "$" + factory.getProtocolName().replace(' ', '_') + "$" + config.getName().replace('/', '$');
    }

    private String getAppId() {
        return this.m_appId;
    }

    public abstract HttpInRequest getInRequest(HttpRequest var1);

    public abstract HttpInResponse getInResponse(HttpResponse var1);

    public abstract void service(HttpInRequest var1, HttpInResponse var2, HttpClientContext var3);

    protected X509Certificate getCertificate(HttpInRequest inReq) {
        X509Certificate cert = null;
        HttpRequest req = inReq.getRequest();
        HttpConnection conn = req.getHttpConnection();
        if (conn instanceof SonicHttpsConnection) {
            cert = ((SonicHttpsConnection)conn).getPeerCertificate();
        }
        return cert;
    }

    protected X509Certificate[] getCertificateChain(HttpInRequest inReq) {
        X509Certificate[] certs = null;
        HttpRequest req = inReq.getRequest();
        HttpConnection conn = req.getHttpConnection();
        if (conn instanceof SonicHttpsConnection) {
            certs = ((SonicHttpsConnection)conn).getPeerCertificateChain();
        }
        return certs;
    }

    protected boolean checkMaxMessageSize(int size, HttpInRequest request, HttpInResponse response) throws JMSException {
        if (SessionConfig.MAX_MSG_SIZE > 0 && size > SessionConfig.MAX_MSG_SIZE) {
            response.create413MessageTooLargeResponse();
            HttpProtocolHandler.logLargeMessageWarning(request);
            return false;
        }
        return true;
    }

    protected static void logLargeMessageWarning(HttpInRequest request) {
        String msg = "Rejected HTTP acceptor request/response exceeding " + SessionConfig.MAX_MSG_SIZE / 0x100000 + "Mb message size limit.";
        if (request != null) {
            int size = request.getContentLength();
            msg = msg + " Request size " + (size > 0 ? Integer.toString(size) + " bytes" : "unknown") + ", client ip " + request.getRequest().getRemoteAddr() + ", url " + request.getRequest().getRequestURL();
        }
        BrokerComponent.getComponentContext().logMessage(msg, 2);
    }

    protected void setRequestReplyTo(progress.message.jclient.Message message, String type) {
        this.setRequestReplyTo(message, type, null);
    }

    protected void setRequestReplyTo(progress.message.jclient.Message message, String type, HttpClientContext httpCC) {
        Envelope envelope = ((Message)message).getEnvelope();
        if (envelope.isQueueMessage()) {
            envelope.setReplyTo("$Q." + type);
        } else {
            String tempTopic = "TEMPORARYTOPIC.";
            if (httpCC != null) {
                tempTopic = tempTopic + httpCC.getClientId() + ".";
            }
            envelope.setReplyTo(tempTopic + type);
        }
    }

    public abstract ProgressPasswordUser authenticate(HttpInRequest var1);

    public abstract boolean isBasicAuthSupported();

    protected ProgressPasswordUser authenticate(HttpInRequest request, String configUser, boolean jmsHeaderAuthentication, boolean basicAuthentication, boolean userPreconfigured, boolean allowCertificate) {
        Exception authException;
        String clientIP;
        X509Certificate cert;
        ProgressPasswordUser user;
        block31: {
            user = null;
            cert = this.getCertificate(request);
            clientIP = request.getRequest().getRemoteAddr();
            authException = null;
            if (!Config.ENABLE_SECURITY) {
                if (configUser != null) {
                    user = new ProgressPasswordUser(configUser, "");
                }
                return user;
            }
            if (jmsHeaderAuthentication) {
                try {
                    String username = request.getProperty("X-JMS-User", false);
                    if (username == null) break block31;
                    String password = request.getProperty("X-JMS-Password", false);
                    HttpConstants.DEBUG("Authenticating with X-JMS-User[X-JMS-Password]: " + username + "[" + password + "]", 0);
                    try {
                        user = this.authenticate(username, password, cert);
                    }
                    catch (Exception e) {
                        authException = e;
                    }
                    if (user == null) {
                        this.logUnauthorized(clientIP, username, cert, authException);
                    } else if (cert != null && cert.getSubjectCommonName().equals(user.getName())) {
                        request.notifySetCertificate(cert);
                    }
                    return user;
                }
                catch (PropertyMissingException pme) {
                    // empty catch block
                }
            }
        }
        if (basicAuthentication) {
            request.handleAuthHeader();
            String userName = request.getAuthUser();
            if (userName != null) {
                HttpConstants.DEBUG("Authenticating with Basic auth user[pass]: " + userName + "[" + request.getAuthPassword() + "]", 0);
                if (!"AUTHENTICATED".equals(userName)) {
                    request.notifySetAuthUser(userName);
                } else {
                    if (!allowCertificate) {
                        this.logUnauthorized(clientIP, configUser, null, null);
                        return null;
                    }
                    if (cert != null) {
                        request.notifySetCertificate(cert);
                    }
                }
                try {
                    user = this.authenticate(userName, request.getAuthPassword(), cert);
                }
                catch (Exception e) {
                    authException = e;
                }
                if (user == null) {
                    this.logUnauthorized(clientIP, userName, cert, authException);
                }
                return user;
            }
        }
        if (userPreconfigured) {
            HttpConstants.DEBUG("Authenticating with configured user: " + configUser, 0);
            if (configUser == null) {
                configUser = "HTTP_DEFAULT_USER";
            }
            if ("AUTHENTICATED".equals(configUser)) {
                if (!allowCertificate) {
                    this.logUnauthorized(clientIP, configUser, null, null);
                    return null;
                }
                if (cert != null) {
                    request.notifySetCertificate(cert);
                }
            }
            try {
                user = this.authenticate(configUser, null, false, cert);
            }
            catch (Exception e) {
                authException = e;
            }
            if (user == null) {
                this.logUnauthorized(clientIP, configUser, cert, authException);
            }
            return user;
        }
        if (allowCertificate) {
            HttpConstants.DEBUG("Authenticating with client certificate", 0);
            try {
                user = this.authenticate("AUTHENTICATED", null, cert);
            }
            catch (Exception e) {
                authException = e;
            }
            if (user == null) {
                this.logUnauthorized(clientIP, "AUTHENTICATED", cert, authException);
                return null;
            }
            request.notifySetCertificate(cert);
            return user;
        }
        return user;
    }

    private ProgressPasswordUser authenticate(String username, String password, X509Certificate cert) throws ConnectionException, UnauthenticatedException {
        return this.authenticate(username, password, true, cert);
    }

    private ProgressPasswordUser authenticate(String username, String password, boolean passwordRequired, X509Certificate cert) throws ConnectionException, UnauthenticatedException {
        ProgressPasswordUser user = null;
        AccessController ac = AccessController.getController();
        IAuthentication externalProvider = AgentRegistrar.getAuthenticationSPI();
        user = ac.authenticate(username, password, passwordRequired, cert);
        if (user == null && externalProvider != null) {
            X509Certificate[] x509CertificateArray;
            byte[] byArray = password == null ? null : password.getBytes();
            if (cert == null) {
                x509CertificateArray = null;
            } else {
                X509Certificate[] x509CertificateArray2 = new X509Certificate[1];
                x509CertificateArray = x509CertificateArray2;
                x509CertificateArray2[0] = cert;
            }
            IPasswordUser externalUser = externalProvider.authenticate(username, byArray, x509CertificateArray);
            if (externalUser != null) {
                String[] externalGroups = externalUser.getGroups();
                ArrayList<String> newExternalGroups = new ArrayList<String>();
                if (externalGroups != null && externalGroups.length > 0) {
                    for (int i = 0; i < externalGroups.length; ++i) {
                        newExternalGroups.add(externalGroups[i]);
                    }
                }
                user = new ProgressPasswordUser(externalUser.getName().replace('.', '$'), externalUser.getPassword());
                user.setInternalPrincipal(false);
                user.setExternalGroups(newExternalGroups);
                AgentRegistrar.getAgentRegistrar().processExternalUsersAndGroupMap(user);
            }
        }
        return user;
    }

    private boolean checkIPLimit(HttpRequest request, HttpResponse response) {
        String remoteAddress = request.getRemoteAddr();
        return Broker.getBroker().getBrokerLicenseMgr().checkIPAddressLimit(remoteAddress);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void handle(HttpRequest req, HttpResponse res, SonicHttpServer server, Socket socket) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String makeTraceMessage(HttpRequest request, HttpResponse response, String authuser, int returnCode, int traceMask) {
        String respContentLength;
        boolean traceVerbose = (traceMask & 1) > 0;
        StringBuffer sb = new StringBuffer("Received HTTP Direct inbound message, containing");
        if (traceVerbose) {
            sb.append(" details");
        }
        sb.append("...");
        String remoteAddr = request.getRemoteAddr();
        sb.append("\n\t").append("Client IP=").append(remoteAddr);
        if (!authuser.equals("HTTP_DEFAULT_USER")) {
            sb.append("\n\t").append("User=").append(authuser);
        }
        String requestLine = request.getRequestLine();
        sb.append("\n\t").append("Request Line=").append(requestLine);
        sb.append("\n\t").append("Status Code=").append(returnCode);
        String reqContentLength = request.getField("Content-Length");
        if (reqContentLength != null) {
            sb.append("\n\t[req]Content-Length=").append(reqContentLength);
        }
        if (traceVerbose) {
            Enumeration enumeration = request.getFieldNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (HttpHelper.isIgnoredHTTPRequestTraceProperty(key)) continue;
                String value = request.getField(key);
                sb.append("\n\t[req]").append(key).append("=").append(value);
            }
        }
        if ((respContentLength = response.getField("Content-Length")) != null) {
            sb.append("\n\t[resp]Content-Length=").append(respContentLength);
        }
        if (traceVerbose) {
            Enumeration enumeration = response.getFieldNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (key.equalsIgnoreCase("Content-Length") || HttpHelper.isIgnoredHTTPResponseTraceProperty(key)) continue;
                String value = response.getField(key);
                sb.append("\n\t[resp]").append(key).append("=").append(value);
            }
        }
        return sb.toString();
    }

    private int getMessagePriority(progress.message.jclient.Message m) throws JMSException {
        int priority;
        try {
            priority = m.getJMSPriority();
        }
        catch (JMSException jmse) {
            priority = 4;
            m.setJMSPriority(priority);
        }
        return priority;
    }

    private boolean checkPubSubFlowControl(progress.message.jclient.Message message, HttpClientContext httpCC, HttpLock lock) throws JMSException {
        int priority = this.getMessagePriority(message);
        if (priority < httpCC.getMinTopicPriority()) {
            lock.setError(507);
            lock.setMessage("Destination is flow controlled, msg priority = " + priority + ", must send with priority >= " + httpCC.getMinTopicPriority());
            return false;
        }
        return true;
    }

    public HttpRequestContext sendMessageReusableLock(progress.message.jclient.Message message, HttpClientContext hcctx) {
        return this.sendMessageReusableLock(message, hcctx, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequestContext sendMessageReusableLock(progress.message.jclient.Message message, HttpClientContext httpCC, int style) {
        HttpRequestContext reqContext = null;
        HttpLock lock = new HttpLock(0L);
        boolean contentReply = false;
        String tempDest = null;
        boolean ptp = false;
        try {
            String replyTo;
            int priority = this.getMessagePriority(message);
            if (!this.checkPubSubFlowControl(message, httpCC, lock)) {
                HttpRequestContext httpRequestContext = reqContext = new HttpRequestContext(lock);
                return httpRequestContext;
            }
            AMPScratchPad scratch = new AMPScratchPad();
            scratch.setClientContext(httpCC);
            ClientSecurityContext csc = httpCC.getCSC();
            Envelope envelope = ((Message)message).getEnvelope();
            envelope.setTimestamp(System.currentTimeMillis());
            envelope.setMessageID(this.getBrokerID(), this.getNextMessageID(), "");
            long tracking = this.getNextTrackingId();
            boolean oneway = false;
            if (style == 0) {
                oneway = this.m_oneway;
            } else {
                boolean bl = oneway = style == 1;
            }
            if (!oneway && (replyTo = envelope.getReplyTo()) != null && !"".equals(replyTo)) {
                boolean hasNode;
                int pos;
                contentReply = true;
                String tempTopicPrefix = "TEMPORARYTOPIC." + httpCC.getClientId() + ".";
                ptp = envelope.isQueueMessage();
                if (ptp) {
                    pos = replyTo.indexOf("$Q.");
                    if (pos != -1) {
                        replyTo = replyTo.substring(pos + "$Q.".length());
                    }
                } else {
                    pos = replyTo.indexOf(tempTopicPrefix);
                    if (pos != -1) {
                        replyTo = replyTo.substring(pos + tempTopicPrefix.length());
                    }
                }
                int uniqueId = ProgressSecureRandom.theSecureRandom().nextInt();
                String uniqueReplyTo = Config.BROKER_NAME + uniqueId + replyTo + CONTENT_REPLY_TEMP_DESTINATION_PREFIX + String.valueOf(tracking);
                String node = Config.ROUTING_NODE_NAME;
                boolean bl = hasNode = node != null && !"".equals(node);
                if (ptp) {
                    String queueReplyTo;
                    String queueNodeReplyTo;
                    String newReplyTo = null;
                    newReplyTo = hasNode ? (queueNodeReplyTo = "$Q." + node + "::" + uniqueReplyTo) : (queueReplyTo = "$Q." + uniqueReplyTo);
                    envelope.setReplyTo(newReplyTo);
                    this.handleGet(uniqueReplyTo, httpCC);
                    tempDest = uniqueReplyTo;
                } else {
                    String topicReplyTo = tempTopicPrefix + uniqueReplyTo;
                    this.handleSubscribe(topicReplyTo, httpCC);
                    if (hasNode) {
                        String topicNodeReplyTo = node + "::" + tempTopicPrefix + uniqueReplyTo;
                        envelope.setReplyTo(topicNodeReplyTo);
                    } else {
                        envelope.setReplyTo(topicReplyTo);
                    }
                    tempDest = topicReplyTo;
                }
            }
            this.sync(csc, envelope, s_mp);
            IMgram mgram = envelope.getMgram();
            boolean isPersistent = mgram.isJMSPersistent();
            byte mgramType = mgram.getType();
            mgram.setGuarenteed(tracking);
            mgram.getBrokerHandle().setSenderID(csc.getClientId());
            if (mgram.getSidebandData() != null) {
                Hashtable table = mgram.getSidebandData().getProperties();
                String uid = csc.getUid();
                if (uid != null) {
                    table.put("JMSXUserID", uid);
                    mgram.getSidebandData().setProperties(table);
                }
            }
            if (!isPersistent && mgramType == 2) {
                if (contentReply) {
                    reqContext = this.sendAndWait(tracking, mgram, scratch, httpCC, true, ptp, tempDest);
                } else {
                    AgentRegistrar.getAgentRegistrar().getMsgProc().newMgram(mgram, scratch);
                    reqContext = new HttpRequestContext(lock);
                }
            } else {
                reqContext = this.sendAndWait(tracking, mgram, scratch, httpCC, contentReply, ptp, tempDest);
            }
        }
        catch (JMSException jmse) {
            HttpConstants.DEBUG(jmse, 1);
            lock.setError(500);
            lock.setMessage("Failed to send message due to internal error.");
            HttpRequestContext httpRequestContext = reqContext = new HttpRequestContext(lock);
            return httpRequestContext;
        }
        catch (InterruptedException ioe) {
            HttpConstants.DEBUG(ioe, 1);
            lock.setError(500);
            lock.setMessage("Failed to send message due to internal error.");
            HttpRequestContext httpRequestContext = reqContext = new HttpRequestContext(lock);
            return httpRequestContext;
        }
        finally {
            HttpClientContextManager.getInstance().release(httpCC);
        }
        return reqContext;
    }

    private void handleSubscribe(String dest, IClientContext cc) {
        this.handleSubscribe(dest, cc, false);
    }

    protected void handleSubscribe(String dest, IClientContext cc, boolean global) {
        long senderID = ((HttpClientContext)cc).getCSC().getClientId();
        Label label = new Label();
        label.setPersistent(false);
        if (global) {
            label.setRouteLimit(7);
        } else {
            label.setRouteLimit(0);
        }
        SubscribeEvt se = new SubscribeEvt(null, senderID, new Subject(dest), label);
        try {
            AgentRegistrar.getAgentRegistrar().subscribe(se);
        }
        catch (ESecurityPolicyViolation spve) {
            System.out.println("Error - security policy violation, client id = " + senderID);
        }
        catch (EClientNotRegistered cnre) {
            System.out.println("Error - client not registered, client id = " + senderID);
        }
        catch (EOldVirtualClockException ovce) {
            System.out.println("Error - virtual clock old, client id = " + senderID);
        }
        catch (EInvalidSubjectSyntax isse) {
            System.out.println("Error - invalid subject syntax, client id = " + senderID);
        }
        catch (ParseException pe) {
            System.out.println("Error - parse exception while subscribing, client id = " + senderID);
        }
    }

    private int handleGet(String qname, IClientContext cc) throws InterruptedException {
        long senderID = ((HttpClientContext)cc).getCSC().getClientId();
        QueueAttributes attributes = new QueueAttributes(qname);
        attributes.setGlobal(true);
        attributes.setMaxQSize(Integer.MAX_VALUE);
        AgentRegistrar.getAgentRegistrar().getQueueProc().createTempQueue(senderID, attributes);
        return this.handleGet(qname, senderID, 1, cc);
    }

    private int handleGet(String qname, long senderID, int prefetchCount, IClientContext cc) {
        IAgentQueue iaq = AgentRegistrar.getAgentRegistrar().getQueueProc().getAgentQueue(qname);
        if (iaq == null) {
            return 505;
        }
        if (iaq.getQueueType() != 1 && !this.okToPull(qname, cc.getPrincipal())) {
            return 401;
        }
        iaq.get(senderID, (short)1, 1, cc.isRemoteBroker() || cc.isInterbroker());
        return 200;
    }

    private boolean okToPull(String qName, Principal p) {
        if (!Config.ENABLE_ACCESS_MEDIATION) {
            return true;
        }
        String subject = "$Q." + qName;
        if (subject.equals("$Q.SonicMQ.deadMessage")) {
            subject = "$Q.#";
        }
        int[] hashSubject = SubjectUtil.computeMatchVector(subject);
        return Authorize.checkPermission(p, new Subject(subject), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpRequestContext sendAndWait(long tracking, IMgram mgram, AMPScratchPad scratch, HttpClientContext httpCC, boolean isContentReply, boolean ptp, String tempDest) throws InterruptedException {
        HttpRequestContext reqContext;
        block9: {
            reqContext = null;
            HttpLock lock = null;
            try {
                String qname;
                lock = httpCC.setAckLock(tracking);
                if (isContentReply) {
                    lock.setContentReplyExpected(true);
                    lock.setContentReplyTimeout(this.m_contentReplyTimeout);
                    lock.setTempDest(tempDest);
                    if (ptp) {
                        lock.setPTP();
                    }
                }
                AgentRegistrar.getAgentRegistrar().getMsgProc().newMgram(mgram, scratch);
                reqContext = httpCC.waitForAck(lock);
                if (reqContext == null || !isContentReply || reqContext.getMgram() == null) break block9;
                IMgram responseMgram = reqContext.getMgram();
                if (responseMgram.isJMSPersistent()) {
                    try {
                        this.ack(responseMgram);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (lock.isPTP() && (qname = lock.getTempDest()) != null) {
                    long clientID = httpCC.getCSC().getClientId();
                    AgentRegistrar.getAgentRegistrar().getQueueProc().removeTemporaryQueue(clientID, qname);
                    lock.setTempDest(null);
                }
            }
            finally {
                httpCC.releaseAckLock(lock);
            }
        }
        return reqContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpRequestContext receiveMessageAndWait(String dest, HttpClientContext httpCC, int timeout) {
        HttpRequestContext reqContext = null;
        HttpLock lock = new HttpLock(0L);
        try {
            Long identity = httpCC.extractPollingReceiveTracking(dest);
            lock = httpCC.setAckLock(identity);
            lock.setContentReplyExpected(true);
            int rc = this.handleGet(dest, httpCC.getCSC().getClientId(), 1, httpCC);
            if (rc == 401) {
                lock.setError(401);
                lock.setMessage("User not permitted to access this resource.");
            } else if (rc == 505) {
                lock.setError(505);
                lock.setMessage("The JMS Queue does not exist.");
            }
            reqContext = httpCC.waitForAck(lock, timeout);
        }
        catch (InterruptedException ioe) {
            HttpConstants.DEBUG(ioe, 1);
            lock.setError(500);
            lock.setMessage("Failed to send message due to internal error.");
            HttpRequestContext httpRequestContext = reqContext = new HttpRequestContext(lock);
            return httpRequestContext;
        }
        finally {
            httpCC.releaseAckLock(lock);
            HttpClientContextManager.getInstance().release(httpCC);
        }
        return reqContext;
    }

    private void logUnauthorized(String clientIP, String userName, X509Certificate cert, Exception e) {
        String protocol = "HTTP";
        if (cert != null) {
            protocol = protocol + "S";
        }
        StringBuffer sb = new StringBuffer("Unauthorized ");
        sb.append(protocol).append(" access");
        if (e != null) {
            sb.append(" due to " + e.toString());
        }
        sb.append(", Client IP=").append(clientIP);
        if (cert == null) {
            sb.append(", UserName=").append(userName == null ? "" : userName);
        } else {
            sb.append(", Certificate Subject=\"").append(cert.getSubjectName().toString()).append("\"");
            sb.append(", Certificate Serial Number=0x").append(cert.getSerialNumber().toString(16));
        }
        BrokerComponent.getComponentContext().logMessage(sb.toString(), 2);
    }

    public boolean isBestMatch(HttpRequest req) {
        return this.getConfigInfo().isBestMatch(req.getPath());
    }
}

