/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.ConfigurationException;
import com.sonicsw.net.http.HttpConfigInfo;
import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.net.http.prAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import progress.message.resources.prMessageFormat;

public abstract class XmlConfigReader {
    public void load(String source, String type, String protocol, Hashtable configTable) throws ConfigurationException {
        InputStream is = this.getInputStream(source, type, protocol);
        Element root = null;
        try {
            root = this.parse(is);
            if (!"Http".equalsIgnoreCase(root.getNodeName())) {
                Object[] obj = new Object[]{source, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                String msg = prAccessor.getString("HTTP_DIRECT_INVALID_CONFIG_XML");
                throw new ConfigurationException(prMessageFormat.format(msg, obj));
            }
            this.populateConfigTable(root, configTable, source);
        }
        catch (ParserConfigurationException e) {
            Object[] obj = new Object[]{source, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
            String msg = prAccessor.getString("HTTP_DIRECT_CONFIG_XML_RESOURCE_ERROR");
            throw new ConfigurationException(prMessageFormat.format(msg, obj));
        }
        catch (SAXException e) {
            Object[] obj = new Object[]{source, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
            String msg = prAccessor.getString("HTTP_DIRECT_CONFIG_XML_RESOURCE_ERROR");
            throw new ConfigurationException(prMessageFormat.format(msg, obj));
        }
        catch (IOException ioe) {
            Object[] obj = new Object[]{source, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
            String msg = prAccessor.getString("HTTP_DIRECT_CONFIG_XML_RESOURCE_ERROR");
            throw new ConfigurationException(prMessageFormat.format(msg, obj));
        }
    }

    public abstract InputStream getInputStream(String var1, String var2, String var3) throws ConfigurationException;

    private Element parse(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        Element root = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        root = builder.parse(is).getDocumentElement();
        return root;
    }

    private void populateConfigTable(Element root, Hashtable configTable, String source) throws IOException {
        Hashtable contentMaps = new Hashtable();
        Element child = HttpHelper.getFirstChildElement(root);
        while (child != null) {
            if (child.getNodeName().equalsIgnoreCase("ContentTypeMap")) {
                this.addContentTypeMap(child, contentMaps, source);
                break;
            }
            child = HttpHelper.getNextSiblingElement(child);
        }
        child = HttpHelper.getFirstChildElement(root);
        while (child != null) {
            if ("Inbound".equalsIgnoreCase(child.getNodeName())) {
                this.handleEntries(child, configTable, "URL", contentMaps);
            } else if ("Outbound".equalsIgnoreCase(child.getNodeName())) {
                this.handleEntries(child, configTable, "Node", contentMaps);
            }
            child = HttpHelper.getNextSiblingElement(child);
        }
    }

    private void addContentTypeMap(Element parent, Hashtable contentMaps, String source) {
        Element child = HttpHelper.getFirstChildElement(parent);
        while (child != null) {
            String nodeTag = child.getNodeName();
            if (nodeTag != null && nodeTag.equalsIgnoreCase("Map")) {
                String msg;
                String contentType = null;
                String messageType = null;
                NamedNodeMap atts = child.getAttributes();
                int numatts = atts.getLength();
                if (numatts >= 2) {
                    for (int i = 0; i < numatts; ++i) {
                        Node c;
                        Node att = atts.item(i);
                        String attname = att.getNodeName();
                        if (attname == null) continue;
                        if (attname.equalsIgnoreCase("ContentType")) {
                            c = att.getFirstChild();
                            if (c == null) continue;
                            contentType = c.getNodeValue();
                            continue;
                        }
                        if (!attname.equalsIgnoreCase("MessageType") || (c = att.getFirstChild()) == null) continue;
                        messageType = c.getNodeValue();
                    }
                }
                if (contentType == null || messageType == null) {
                    Object[] obj;
                    if (contentType != null) {
                        obj = new Object[]{contentType, source, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                        msg = prMessageFormat.format(prAccessor.getString("HTTP_DIRECT_CONFIG_MISSING_MAP_MESSAGE_TYPE"), obj);
                        BrokerComponent.getComponentContext().logMessage(msg, 2);
                    } else {
                        obj = new Object[]{source, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                        msg = prMessageFormat.format(prAccessor.getString("HTTP_DIRECT_CONFIG_MAP_ENTRY_ERROR"), obj);
                        BrokerComponent.getComponentContext().logMessage(msg, 2);
                    }
                    child = HttpHelper.getNextSiblingElement(child);
                    continue;
                }
                if (!(messageType.equalsIgnoreCase("BYTES") || messageType.equalsIgnoreCase("XML") || messageType.equalsIgnoreCase("TEXT") || messageType.equalsIgnoreCase("MULTIPART"))) {
                    Object[] obj = new Object[]{messageType, source, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                    msg = prMessageFormat.format(prAccessor.getString("HTTP_DIRECT_CONFIG_INVALID_MAP_MESSAGE_TYPE"), obj);
                    BrokerComponent.getComponentContext().logMessage(msg, 2);
                } else {
                    int index;
                    if (!contentType.equals("*/*") && (index = contentType.indexOf("/*")) > 0) {
                        contentType = contentType.substring(0, index);
                    }
                    contentMaps.put(contentType, messageType);
                }
            }
            child = HttpHelper.getNextSiblingElement(child);
        }
    }

    private void handleEntries(Element parent, Hashtable configTable, String str, Hashtable contentMaps) throws IOException {
        Element child = HttpHelper.getFirstChildElement(parent);
        while (child != null) {
            Object[] obj;
            String url;
            try {
                String nodeTag = child.getNodeName();
                if (nodeTag != null && nodeTag.equalsIgnoreCase(str)) {
                    this.handleEntry(child, configTable, str, contentMaps);
                } else {
                    url = child.getAttribute("name");
                    if (url == null) {
                        url = "";
                    }
                    obj = new Object[]{url, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                    BrokerComponent.getComponentContext().logMessage(prMessageFormat.format(prAccessor.getString("HTTP_DIRECT_CONFIG_ENTRY_ERROR"), obj), 2);
                }
            }
            catch (IOException ioe) {
                url = child.getAttribute("name");
                if (url == null) {
                    url = "";
                }
                obj = new Object[]{url, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                BrokerComponent.getComponentContext().logMessage(prMessageFormat.format(prAccessor.getString("HTTP_DIRECT_CONFIG_ENTRY_ERROR"), obj), 2);
            }
            child = HttpHelper.getNextSiblingElement(child);
        }
    }

    private void handleEntry(Element parent, Hashtable configTable, String str, Hashtable contentMaps) throws IOException {
        String name = parent.getAttribute("name");
        if ("".equals(name)) {
            throw new IOException("Failed to obtain name and protocol");
        }
        if (!configTable.containsKey(name)) {
            HttpConfigInfo info = new HttpConfigInfo(name, parent);
            if (contentMaps != null && !contentMaps.isEmpty()) {
                info.setContentMappings(contentMaps);
            }
            configTable.put(name, info);
        }
    }
}

