/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.jms;

import com.sonicsw.net.http.HttpInRequest;
import com.sonicsw.net.http.PropertyBadValueException;
import com.sonicsw.net.http.PropertyMissingException;
import com.sonicsw.net.http.jms.JmsHttpConfig;
import com.sonicsw.net.http.jms.JmsHttpHelper;
import javax.jms.JMSException;
import org.mortbay.http.HttpRequest;
import progress.message.jclient.Message;

public class JmsHttpInRequest
extends HttpInRequest {
    private String m_receiveQ = null;
    private int m_timeout = 1000;

    public JmsHttpInRequest(HttpRequest req) {
        super(req);
    }

    public String getReceiveQueue() {
        return this.m_receiveQ;
    }

    public int getReceiveTimeout() {
        return this.m_timeout;
    }

    protected Message createMessage(JmsHttpConfig config) throws PropertyMissingException, PropertyBadValueException, JMSException {
        String messageType = this.getProperty("X-JMS-MessageType", false);
        if (messageType == null) {
            String contentType = this.getProperty("Content-Type", false);
            messageType = this.contentTypeToMessageType(contentType, config.getContentMappings());
        }
        return super.createMessage(messageType, "X-JMS-MessageType");
    }

    protected void handleDestination(boolean required) throws PropertyMissingException, PropertyBadValueException, JMSException {
        String queue = this.getProperty("X-JMS-DestinationQueue", false);
        String topic = this.getProperty("X-JMS-DestinationTopic", false);
        if (required && topic == null && queue == null) {
            throw new PropertyMissingException("Destination");
        }
        if (topic != null && queue != null) {
            throw new PropertyBadValueException("X-JMS-DestinationQueue and X-JMS-DestinationTopic defined.");
        }
        super.handleDestination(queue, topic);
    }

    protected void handleDeliveryMode(boolean required) throws PropertyMissingException, PropertyBadValueException, JMSException {
        String value = this.getProperty("X-JMS-DeliveryMode", required);
        super.handleDeliveryMode(value, "X-JMS-DeliveryMode");
    }

    protected void handlePriority(boolean required) throws PropertyMissingException, PropertyBadValueException, JMSException {
        int value = this.getPropertyInt("X-JMS-Priority", required);
        super.handlePriority(value, "X-JMS-Priority");
    }

    protected void handleTimeToLive(boolean required) throws PropertyMissingException, PropertyBadValueException, JMSException {
        long value = this.getPropertyLong("X-JMS-TimeToLive", required);
        super.handleTimeToLive(value);
    }

    protected void handleCorrelationID(boolean required) throws PropertyMissingException, PropertyBadValueException, JMSException {
        String value = this.getProperty("X-JMS-CorrelationID", required);
        super.handleCorrelationID(value);
    }

    protected void handleType(boolean required) throws PropertyMissingException, PropertyBadValueException, JMSException {
        String value = this.getProperty("X-JMS-Type", required);
        super.handleType(value);
    }

    protected void handleReplyTo(boolean required) throws PropertyMissingException, PropertyBadValueException, JMSException {
        String queue = this.getProperty("X-JMS-ReplyToQueue", false);
        String topic = this.getProperty("X-JMS-ReplyToTopic", false);
        if (required && topic == null && queue == null) {
            throw new PropertyMissingException("ReplyTo");
        }
        if (topic != null && queue != null) {
            throw new PropertyBadValueException("X-JMS-ReplyToQueue and X-JMS-ReplyToTopic defined.");
        }
        super.handleReplyTo(queue, topic);
    }

    protected void handleNotifyUndeliv(boolean required) throws PropertyMissingException, PropertyBadValueException, JMSException {
        Boolean value = this.getPropertyBoolean("X-JMS-SonicMQ_NotifyUndelivered", required);
        super.handleNotifyUndeliv(value);
    }

    protected void handlePreserveUndeliv(boolean required) throws PropertyMissingException, PropertyBadValueException, JMSException {
        Boolean value = this.getPropertyBoolean("X-JMS-SonicMQ_PreserveUndelivered", required);
        super.handlePreserveUndeliv(value);
    }

    protected void handleDestinationUndeliv(boolean required) throws PropertyMissingException, PropertyBadValueException, JMSException {
        String undelDestName = this.getProperty("X-JMS-SonicMQ_DestinationUndelivered", required);
        Boolean undelDestIsQueue = this.getPropertyBoolean("X-JMS-SonicMQ_DestinationUndeliveredIsQueue", required);
        String undelDestType = undelDestIsQueue == null ? null : (undelDestIsQueue != false ? "QUEUE" : "TOPIC");
        super.handleDestinationUndeliv(undelDestType, undelDestName);
    }

    protected void handleProperties() throws PropertyMissingException, PropertyBadValueException, JMSException {
        String value = this.getProperty("X-JMS-Properties", false);
        if (value != null) {
            this.m_message.setStringProperty("X-JMS-Properties", value);
        }
    }

    protected void handleOptionalProperties() throws PropertyMissingException, PropertyBadValueException, JMSException {
        String id = this.getProperty("X-JMSX-GroupID", false);
        int seq = this.getPropertyInt("X-JMSX-GroupSeq", false);
        super.handleOptionalProperties(id, seq);
    }

    protected void handleCommonProperties() throws JMSException, PropertyBadValueException, PropertyMissingException {
        this.handleCorrelationID(false);
        this.handleDeliveryMode(false);
        this.handlePriority(false);
        this.handleTimeToLive(false);
        this.handleReplyTo(false);
        this.handleType(false);
        this.handleNotifyUndeliv(false);
        this.handlePreserveUndeliv(false);
        this.handleDestinationUndeliv(false);
        this.handleOptionalProperties();
        this.handleProperties();
        this.handleCopyAllProperties();
        this.handleRequestURL();
        this.handleRequestMethod();
    }

    @Override
    protected boolean isIgnoredHTTPProperty(String key) {
        if (JmsHttpHelper.isIgnoredHTTPProperty(key)) {
            return true;
        }
        return super.isIgnoredHTTPProperty(key);
    }

    protected void handleReceiveTimeout(boolean required) throws PropertyMissingException, PropertyBadValueException, JMSException {
        this.m_timeout = this.getPropertyInt("X-JMS-Timeout", required);
        if (this.m_timeout < 1000) {
            this.m_timeout = 1000;
        }
    }

    protected void handleReceiveDestination(boolean required) throws PropertyMissingException, PropertyBadValueException, JMSException {
        this.m_receiveQ = this.getProperty("X-JMS-ReceiveQueue", required);
    }
}

