/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.jms;

import com.sonicsw.net.http.HttpInResponse;
import com.sonicsw.net.http.MessageHandlingException;
import javax.jms.Destination;
import javax.jms.Queue;
import org.mortbay.http.HttpResponse;
import progress.message.jclient.Message;
import progress.message.msg.IMgram;

public class JmsHttpInResponse
extends HttpInResponse {
    public JmsHttpInResponse(HttpResponse res) {
        super(res);
    }

    protected void createOKResponse(long id) {
        this.createOKResponse(id, null);
    }

    protected void createOKResponse(long id, Message message) {
        block5: {
            this.createResponse(id, 200, null);
            if (message != null) {
                try {
                    this.setProperty("X-JMS-Timestamp", message.getJMSTimestamp());
                    this.setProperty("X-JMS-Expiration", message.getJMSExpiration());
                    this.setProperty("X-JMS-MessageID", message.getJMSMessageID());
                    this.setProperty("X-JMS-Priority", message.getJMSPriority());
                    this.setProperty("X-JMS-DeliveryMode", message.getJMSDeliveryMode());
                    Destination dest = message.getJMSDestination();
                    if (dest == null) break block5;
                    if (dest instanceof Queue) {
                        this.setProperty("X-JMS-DestinationQueue", dest.toString());
                        break block5;
                    }
                    this.setProperty("X-JMS-DestinationTopic", dest.toString());
                }
                catch (Exception e) {}
            } else {
                this.setProperty("X-JMS-Timestamp", System.currentTimeMillis());
            }
        }
    }

    protected void createResponse(long id, int code, String message) {
        this.setProperty("X-JMS-Version", "jmshttp/1.0");
        if (id > 0L) {
            this.setProperty("X-JMS-SonicMQ_ReferenceUniqueID", id);
        }
        if (message != null) {
            this.setProperty("X-JMS-Description", message);
            this.setReason(message);
        }
        this.setCode(code);
    }

    @Override
    public void createContentResponse(IMgram mgram) throws MessageHandlingException, Exception {
        this.setProperty("X-JMS-CorrelationID", this.getCorrelationID(mgram));
        this.setProperty("X-JMS-DeliveryMode", this.getDeliveryMode(mgram));
        this.setProperty("X-JMS-MessageID", this.getMessageID(mgram));
        this.setProperty("X-JMS-MessageType", JmsHttpInResponse.getMessageType(mgram));
        this.setProperty("X-JMS-Priority", this.getPriority(mgram));
        this.setProperty("X-JMS-Timestamp", this.getTimestamp(mgram));
        this.setProperty("X-JMS-Type", this.getType(mgram));
        super.createContentResponse(mgram);
    }
}

