/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.soap;

import com.sonicsw.net.http.HttpInResponse;
import com.sonicsw.net.http.MessageHandlingException;
import com.sonicsw.net.http.UnsupportedJMSMessageTypeException;
import com.sonicsw.net.http.soap.SOAPUtils;
import com.sonicsw.net.http.soap.prAccessor;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.xml.soap.SOAPException;
import org.apache.axis.Message;
import org.apache.axis.soap.SOAPConstants;
import org.mortbay.http.HttpResponse;
import progress.message.jclient.Constants;
import progress.message.msg.IMgram;

public class SoapHttpInResponse
extends HttpInResponse {
    protected Message m_axisMessage = null;
    private String m_soapVersion = "SOAP 1.1";

    public SoapHttpInResponse(HttpResponse res) {
        super(res);
    }

    public void createOKResponse() {
        this.buildSuccessResponse(200);
    }

    public void buildSuccessResponse(int statusCode) {
        try {
            this.m_axisMessage = SOAPUtils.buildSuccessMessage(this.getSoapVersion());
            this.buildResponse(this.m_axisMessage, statusCode);
        }
        catch (Exception e) {
            System.out.println("Failed to create response " + e.toString());
        }
    }

    @Override
    public void createResponse(int code, String message) {
        if (code >= 300) {
            String faultCode = "Server";
            String faultString = message;
            int status = 500;
            if (code == 401) {
                faultCode = faultCode + "." + Constants.UNDELIVERED_REASONS[13];
                faultString = prAccessor.getString("HTTP_SOAP_AUTHEN_FAIL_MESSAGE");
                status = code;
            }
            try {
                this.m_axisMessage = SOAPUtils.buildFaultMessage(this.getSoapVersion(), faultCode, faultString);
                this.buildResponse(this.m_axisMessage, status);
            }
            catch (Exception e) {
                System.out.println("Failed to create response " + e.toString());
            }
            return;
        }
        this.buildSuccessResponse(code);
    }

    public void createResponse(Throwable th) {
        try {
            this.m_axisMessage = SOAPUtils.buildFaultMessage(this.getSoapVersion(), th);
            this.buildResponse(this.m_axisMessage, 500);
        }
        catch (Exception e) {
            System.out.println("Failed to create response " + e.toString());
        }
    }

    @Override
    public void createContentResponse(IMgram mgram) throws MessageHandlingException, Exception {
        String msgType = SoapHttpInResponse.getMessageType(mgram);
        if (msgType == null) {
            throw new UnsupportedJMSMessageTypeException("Unsupported JMS message type in the content reply.");
        }
        super.createContentResponse(mgram);
    }

    protected void buildResponse(Message msg, int status) throws IOException, MessagingException, SOAPException {
        this.setCode(status);
        if (msg != null) {
            msg.saveChanges();
            if (this.getSoapVersion().equals("SOAP 1.2")) {
                this.setContentType(SOAPConstants.SOAP12_CONSTANTS.getContentType() + "; charset=utf-8");
            } else {
                this.setContentType(SOAPConstants.SOAP11_CONSTANTS.getContentType() + "; charset=utf-8");
            }
            this.setContentLength((int)msg.getContentLength());
            msg.writeTo(this.getOutputStream());
        }
    }

    public void setSoapVersion(String version) {
        if (version != null) {
            this.m_soapVersion = version;
        }
    }

    public String getSoapVersion() {
        return this.m_soapVersion;
    }
}

