/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.soap;

import com.sonicsw.net.http.HttpClientContext;
import com.sonicsw.net.http.HttpConfigInfo;
import com.sonicsw.net.http.HttpInRequest;
import com.sonicsw.net.http.HttpInResponse;
import com.sonicsw.net.http.HttpLock;
import com.sonicsw.net.http.HttpRequestContext;
import com.sonicsw.net.http.MessageHandlingException;
import com.sonicsw.net.http.PropertyBadValueException;
import com.sonicsw.net.http.PropertyMissingException;
import com.sonicsw.net.http.direct.DirectHttpInConfig;
import com.sonicsw.net.http.direct.DirectHttpProtocolHandler;
import com.sonicsw.net.http.soap.SoapHttpInRequest;
import com.sonicsw.net.http.soap.SoapHttpInResponse;
import com.sonicsw.ws.axis.handlers.HandlerUtils;
import javax.jms.JMSException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.MessageContext;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.server.AxisServer;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import progress.message.jclient.Message;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;

public class SoapHttpProtocolHandler
extends DirectHttpProtocolHandler {
    protected static final String REPLYTO_TYPE_SOAP = "SOAP";

    public SoapHttpProtocolHandler(HttpConfigInfo config) {
        super(config);
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("SoapHttpProtocolHandler " + config.toString());
        }
        this.config = new DirectHttpInConfig(config);
    }

    @Override
    public HttpInRequest getInRequest(HttpRequest req) {
        return new SoapHttpInRequest(req);
    }

    @Override
    public HttpInResponse getInResponse(HttpResponse res) {
        return new SoapHttpInResponse(res);
    }

    protected AxisServer createAxisServer() {
        SimpleProvider axiscfg = new SimpleProvider();
        return new AxisServer((EngineConfiguration)axiscfg);
    }

    private void serviceReceive(SoapHttpInRequest req, SoapHttpInResponse resp, HttpClientContext httpContext) {
        IMgram mgram = null;
        try {
            HttpRequestContext reqContext = this.receiveMessageAndWait(this.config.receiveQueue, httpContext, this.config.contentReplyTimeout * 1000);
            HttpLock lock = reqContext.getHttpLock();
            if (lock.getErrorType() != 200) {
                resp.create500InternalErrorResponse(lock.getMessage());
                return;
            }
            mgram = reqContext.getMgram();
            if (mgram == null) {
                resp.createResponse(204, "The receive queue is empty, or the request timed out while waiting for the next message.");
                return;
            }
            if (!this.checkMaxMessageSize(mgram.getBodyLength(), req, resp)) {
                return;
            }
            try {
                resp.createEncodedContentResponse(mgram, "ISO-8859-1");
            }
            catch (Exception e) {
                this.restore(mgram, this.config.receiveQueue);
                resp.create500InternalErrorResponse("Failed to process receive request.");
            }
            try {
                this.ack(mgram);
            }
            catch (Exception e) {}
        }
        catch (Exception e) {
            resp.create500InternalErrorResponse("Failed to process receive request.");
        }
    }

    protected HttpRequestContext sendToBroker(Message message, HttpClientContext hctx) {
        HttpRequestContext reqContext = this.sendMessageReusableLock(message, hctx);
        return reqContext;
    }

    protected void handleContentReply(HttpRequestContext reqContext, SoapHttpInRequest req, SoapHttpInResponse response) {
        HttpLock lock = reqContext.getHttpLock();
        if (lock.getContentReplyExpected() && reqContext.getMgram() != null) {
            try {
                response.createEncodedContentResponse(reqContext.getMgram(), req.getCharacterEncoding());
            }
            catch (MessageHandlingException e) {
                response.createResponse(500, e.getMessage());
                int dmqReason = 10;
                String msg = this.getPrBundleMsg("HTTP_DIRECT_UNSUPPORTED_MESSAGE_TYPE");
                this.dmqNoException(reqContext.getMgram(), dmqReason, msg);
            }
            catch (Exception e) {
                response.createResponse(500, "Failed to process content reply.");
                int dmqReason = 4;
                String msg = this.getPrBundleMsg("HTTP_DIRECT_CONNECTION_UNREACHABLE");
                this.dmqNoException(reqContext.getMgram(), dmqReason, msg);
            }
        } else if (lock.getErrorType() != 200 && lock.getErrorType() != 202) {
            response.create500InternalErrorResponse(lock.getMessage());
        } else {
            response.createOKResponse();
        }
    }

    @Override
    public void service(HttpInRequest req, HttpInResponse resp, HttpClientContext httpContext) {
        SoapHttpInRequest request = (SoapHttpInRequest)req;
        SoapHttpInResponse response = (SoapHttpInResponse)resp;
        try {
            request.mapJMSDestination(this.config);
        }
        catch (Exception e) {
            response.createResponse(506, e.getMessage());
            return;
        }
        try {
            if (this.config.isReceive()) {
                this.serviceReceive(request, response, httpContext);
                return;
            }
            if (httpContext == null) {
                response.create500InternalErrorResponse("Service temporarily unavailable.");
                return;
            }
            SOAPMessage soapmsg = request.createSoapMessage();
            Message message = request.createJMSMessage(this.config);
            response.setSoapVersion(request.getSoapVersion());
            if (!this.checkMaxMessageSize(message.getBodySize(), request, response)) {
                return;
            }
            if (!this.config.isOneway()) {
                this.setRequestReplyTo(message, REPLYTO_TYPE_SOAP, httpContext);
            }
            HttpRequestContext reqContext = this.sendToBroker(message, httpContext);
            this.handleContentReply(reqContext, request, response);
        }
        catch (Throwable e) {
            response.createResponse(e);
        }
    }

    private class HttpInBrokerHandler
    extends BasicHandler {
        private HttpInBrokerHandler() {
        }

        public void invoke(MessageContext mctx) throws AxisFault {
            SoapHttpInRequest request = (SoapHttpInRequest)mctx.getProperty("com.sonicsw.net.http.HttpInRequest");
            HttpClientContext hctx = (HttpClientContext)mctx.getProperty("com.sonicsw.net.http.HttpClientContext");
            try {
                if (!HandlerUtils.hasSOAPEnvelope(mctx.getRequestMessage())) {
                    return;
                }
                DirectHttpInConfig cloner = null;
                if (mctx.getProperty("DEST") != null) {
                    cloner = SoapHttpProtocolHandler.this.config.clonedCopy();
                    cloner.destinationQueue = (String)mctx.getProperty("DEST");
                }
                Message message = request.createJMSMessage(cloner);
                HttpRequestContext reqContext = SoapHttpProtocolHandler.this.sendMessageReusableLock(message, hctx);
            }
            catch (PropertyBadValueException e) {
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
            catch (PropertyMissingException e) {
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
            catch (MessageHandlingException e) {
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
            catch (JMSException e) {
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
        }
    }
}

