/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.ws;

import com.sonicsw.net.http.InvalidSoapContentException;
import com.sonicsw.net.http.MessageHandlingException;
import com.sonicsw.net.http.Mgram2Http;
import com.sonicsw.net.http.UnsupportedJMSMessageTypeException;
import com.sonicsw.net.http.prAccessor;
import com.sonicsw.net.http.soap.SonicSoapVerifier;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import javax.xml.soap.SOAPMessage;
import progress.message.jclient.MessagePart;
import progress.message.jclient.Part;
import progress.message.jimpl.xmessage.MultipartMessage;
import progress.message.msg.IMgram;
import progress.message.zclient.Envelope;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.Message;

public class SOAPUtils {
    public static SOAPMessage createSOAPMessage(IMgram mgram) throws MessageHandlingException {
        InputStream is;
        block18: {
            byte[] body;
            String messageType = Mgram2Http.getMessageType(mgram);
            if (messageType == null) {
                throw new UnsupportedJMSMessageTypeException(prAccessor.getString("HTTP_ROUTING_UNSUPPORTED_JMS_MESSAGE_TYPE"));
            }
            ISidebandData side = mgram.getSidebandData();
            Hashtable table = side.getProperties();
            Object soapactionProperty = table.get("SOAPAction");
            is = null;
            int contentLength = 0;
            if ("XML".equals(messageType) || "TEXT".equals(messageType)) {
                body = mgram.getRawBody();
                int offset = 4;
                if (body == null || body.length < offset) {
                    throw new MessageHandlingException(com.sonicsw.net.http.soap.prAccessor.getString("SOAP_DIRECT_INVALID_SOAP_CONTENT"));
                }
                contentLength = body.length - offset;
                is = new ByteArrayInputStream(body, offset, contentLength);
            } else if ("BYTES".equals(messageType)) {
                body = mgram.getRawBody();
                int offset = 0;
                if (body == null || body.length < offset) {
                    throw new MessageHandlingException(com.sonicsw.net.http.soap.prAccessor.getString("SOAP_DIRECT_INVALID_SOAP_CONTENT"));
                }
                contentLength = body.length - offset;
                is = new ByteArrayInputStream(body, offset, contentLength);
            } else if ("MULTIPART".equals(messageType)) {
                try {
                    MultipartMessage multiMessage = new MultipartMessage(new Envelope(new Message(mgram.getRawBody())));
                    int count = multiMessage.getPartCount();
                    if (count < 1) {
                        throw new MessageHandlingException(com.sonicsw.net.http.soap.prAccessor.getString("SOAP_DIRECT_INVALID_SOAP_CONTENT"));
                    }
                    Part part = multiMessage.getPart(0);
                    if (!part.isMessagePart()) {
                        is = part.getInputStream();
                        break block18;
                    }
                    MessagePart mp = (MessagePart)part;
                    javax.jms.Message jmsMsg = mp.getMessage();
                    if (!(jmsMsg instanceof TextMessage)) {
                        throw new MessageHandlingException(com.sonicsw.net.http.soap.prAccessor.getString("SOAP_DIRECT_INVALID_SOAP_CONTENT"));
                    }
                    try {
                        progress.message.jimpl.TextMessage textJmsMsg = (progress.message.jimpl.TextMessage)jmsMsg;
                        byte[] body2 = textJmsMsg.getEnvelope().getMessage().getBody();
                        is = new ByteArrayInputStream(body2, 4, body2.length - 4);
                    }
                    catch (Exception e) {
                        throw new MessageHandlingException(com.sonicsw.net.http.soap.prAccessor.getString("SOAP_DIRECT_INVALID_SOAP_CONTENT") + e.getMessage());
                    }
                }
                catch (ClassCastException e) {
                    throw new MessageHandlingException(com.sonicsw.net.http.soap.prAccessor.getString("SOAP_DIRECT_INVALID_SOAP_CONTENT"));
                }
                catch (JMSException jmse) {
                    throw new MessageHandlingException(com.sonicsw.net.http.soap.prAccessor.getString("SOAP_DIRECT_INVALID_SOAP_CONTENT"));
                }
            }
        }
        try {
            SonicSoapVerifier verifier = new SonicSoapVerifier(is, "text/xml");
            return verifier.getSoapMessage();
        }
        catch (Exception e) {
            throw new InvalidSoapContentException(com.sonicsw.net.http.soap.prAccessor.getString("SOAP_DIRECT_INVALID_SOAP_CONTENT") + e.getMessage());
        }
    }
}

