/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.security.pcs;

import com.sonicsw.security.pcs.CipherSuiteInfo;
import com.sonicsw.security.pcs.EInvalidCipherSuiteException;
import com.sonicsw.security.pcs.IPluggableCipherSuite;
import com.sonicsw.security.pcs.PluggableCipherSuite;
import com.sonicsw.security.pcs.PluggableMessageProtection;
import com.sonicsw.security.pcs.SonicCipherSuite;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import progress.message.crypto.KeyGen;
import progress.message.zclient.IMessageProtection;

public abstract class AbstractCipherSuite
implements IPluggableCipherSuite {
    static final String AES = "AES";
    static final String BLOWFISH = "Blowfish";
    static final String DES = "DES";
    static final String DESEDE = "DESEDE";
    static final String ECB = "ECB";
    private static volatile Class s_mpClass;
    private static volatile Class s_pmpClass;
    private static final Object MPCLASS_LOCK_OBJ;
    private static final Object PMPCLASS_LOCK_OBJ;
    public static boolean m_isSonicCipherSuite;
    public static volatile String s_cipherProviderName;
    public static volatile String s_cipherProviderVersion;
    public static volatile String s_cipherTransformation;
    public static volatile String s_cipherAlgorithm;
    public static boolean m_isCipherModeECB;
    public static int m_secretKeyLength;
    public static int m_encodedSecretKeyLengthInBytes;
    public static boolean m_isKeySizeSupplied;
    public static int m_blockSize;
    public static volatile String s_digestProviderName;
    public static volatile String s_digestProviderVersion;
    public static volatile String s_digestAlgorithm;
    public static int m_hashLength;

    protected AbstractCipherSuite() {
        this.processSonicCipherSuite();
    }

    protected AbstractCipherSuite(String cipherProviderName, String cipherProviderVersion, String transformation, int keySize, String digestProviderName, String digestProviderVersion, String digest) throws EInvalidCipherSuiteException {
        this.processPluggableCipherSuite(cipherProviderName, cipherProviderVersion, transformation, keySize, digestProviderName, digestProviderVersion, digest);
    }

    public static final IPluggableCipherSuite getCipherSuiteInstance(CipherSuiteInfo cipherSuiteInfo) throws EInvalidCipherSuiteException {
        String[] cipherDetails = null;
        String[] digestDetails = null;
        cipherDetails = cipherSuiteInfo.getTransformation(0);
        String[] cipherAndKeySize = AbstractCipherSuite.getTransformationAndKeySize(cipherDetails[2]);
        if (cipherAndKeySize == null || cipherAndKeySize.length == 0 || cipherAndKeySize[0] == null) {
            throw new EInvalidCipherSuiteException("Invalid transformation " + cipherDetails[2]);
        }
        String transformation = cipherAndKeySize[0];
        String s = cipherAndKeySize[1];
        int keySize = 0;
        if (s != null) {
            keySize = Integer.parseInt(s);
        }
        digestDetails = cipherSuiteInfo.getDigest(0);
        return AbstractCipherSuite.getCipherSuiteInstance(cipherDetails[0], cipherDetails[1], transformation, keySize, digestDetails[0], digestDetails[1], digestDetails[2]);
    }

    public static IPluggableCipherSuite getCipherSuiteInstance(String cipherProviderName, String cipherProviderVersion, String transformation, int keySize, String digestProviderName, String digestProviderVersion, String digest) throws EInvalidCipherSuiteException {
        if (cipherProviderName != null && cipherProviderName.equalsIgnoreCase("SonicSoftware") && cipherProviderVersion != null && cipherProviderVersion.equalsIgnoreCase("1.0") && transformation != null && transformation.equalsIgnoreCase(DES) && digestProviderName != null && digestProviderName.equalsIgnoreCase("SonicSoftware") && digestProviderVersion != null && digestProviderVersion.equalsIgnoreCase("1.0") && digest != null && digest.equalsIgnoreCase("MD5")) {
            return SonicCipherSuite.getInstance();
        }
        return PluggableCipherSuite.getInstance(cipherProviderName, cipherProviderVersion, transformation, keySize, digestProviderName, digestProviderVersion, digest);
    }

    private final void processPluggableCipherSuite(String cipherProviderName, String cipherProviderVersion, String transformation, int keySize, String digestProviderName, String digestProviderVersion, String digest) throws EInvalidCipherSuiteException {
        Provider[] providers;
        Provider cipherProvider = null;
        Provider digestProvider = null;
        if (cipherProviderName != null && cipherProviderName.trim().length() != 0 && cipherProviderVersion != null && cipherProviderVersion.trim().length() != 0 && digestProviderName != null && digestProviderName.trim().length() != 0 && digestProviderVersion != null && digestProviderVersion.trim().length() != 0 && (providers = Security.getProviders()) != null && providers.length > 0) {
            for (int i = 0; i < providers.length; ++i) {
                Provider p = providers[i];
                double d = Double.parseDouble(cipherProviderVersion);
                if (p != null && d == p.getVersion() && p.getName().equalsIgnoreCase(cipherProviderName)) {
                    cipherProvider = p;
                }
                d = Double.parseDouble(digestProviderVersion);
                if (p != null && d == p.getVersion() && p.getName().equalsIgnoreCase(digestProviderVersion)) {
                    digestProvider = p;
                }
                if (cipherProvider != null && digestProvider != null) break;
            }
        }
        this.generateCipherInformation(cipherProvider, transformation);
        this.generateKeyInformation(transformation, keySize);
        this.generateDigestInformation(digestProvider, digest);
    }

    private final void processSonicCipherSuite() {
        m_isSonicCipherSuite = true;
        s_cipherProviderName = "SonicSoftware";
        s_cipherProviderVersion = "1.0";
        s_cipherTransformation = DES;
        s_cipherAlgorithm = DES;
        m_secretKeyLength = SonicCipherSuite.KEY_LENGTH_IN_BITS;
        m_encodedSecretKeyLengthInBytes = 8;
        m_blockSize = 8;
        s_digestProviderName = "SonicSoftware";
        s_digestProviderVersion = "1.0";
        s_digestAlgorithm = "MD5";
        m_hashLength = 16;
    }

    private final void generateCipherInformation(Provider cipherProvider, String transformation) throws EInvalidCipherSuiteException {
        Cipher cipher = null;
        try {
            cipher = cipherProvider == null ? Cipher.getInstance(transformation) : Cipher.getInstance(transformation, cipherProvider);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EInvalidCipherSuiteException(transformation + ": " + ex.getMessage(), ex);
        }
        catch (GeneralSecurityException ex) {
            throw new EInvalidCipherSuiteException(ex.getMessage(), ex);
        }
        Provider provider = cipher.getProvider();
        s_cipherProviderName = provider.getName();
        s_cipherProviderVersion = Double.toString(provider.getVersion());
        s_cipherTransformation = transformation;
        int pos = 0;
        pos = s_cipherTransformation.indexOf("/");
        if (pos != -1) {
            String cipherMode;
            s_cipherAlgorithm = s_cipherTransformation.substring(0, pos);
            if (s_cipherTransformation.indexOf("/", pos + 1) != -1 && (cipherMode = s_cipherTransformation.substring(pos + 1, s_cipherTransformation.indexOf("/", pos + 1))) != null && !cipherMode.equalsIgnoreCase(ECB)) {
                m_isCipherModeECB = false;
            }
        } else {
            s_cipherAlgorithm = s_cipherTransformation;
        }
        if ((m_blockSize = cipher.getBlockSize()) == 0) {
            throw new EInvalidCipherSuiteException("Unable to generate the appropriate block size: " + m_blockSize + " using " + s_cipherProviderName + ". " + s_cipherProviderVersion);
        }
    }

    private final void generateKeyInformation(String algorithm, int keySize) throws EInvalidCipherSuiteException {
        if (keySize == 0) {
            throw new EInvalidCipherSuiteException("Invalid key length: 0.");
        }
        m_isKeySizeSupplied = true;
        m_secretKeyLength = keySize;
        int pos = 0;
        pos = algorithm.indexOf("/");
        if (pos != -1) {
            algorithm = algorithm.substring(0, pos);
        }
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(algorithm);
            kgen.init(keySize);
            SecretKey skey = kgen.generateKey();
            byte[] raw = skey.getEncoded();
            m_encodedSecretKeyLengthInBytes = raw.length;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EInvalidCipherSuiteException(algorithm + ": " + ex.getMessage(), ex);
        }
        catch (NullPointerException ex) {
            throw new EInvalidCipherSuiteException(algorithm + ": " + ex.getMessage(), ex);
        }
        if (m_secretKeyLength == 0) {
            throw new EInvalidCipherSuiteException("Unable to generate the appropriate secret key length: " + m_secretKeyLength + " using " + s_cipherProviderName + ". " + s_cipherProviderVersion);
        }
    }

    private final void generateDigestInformation(Provider digestProvider, String digest) throws EInvalidCipherSuiteException {
        MessageDigest md = null;
        try {
            md = digestProvider == null ? MessageDigest.getInstance(digest) : MessageDigest.getInstance(digest, digestProvider);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EInvalidCipherSuiteException(digest + ": " + ex.getMessage(), ex);
        }
        catch (GeneralSecurityException ex) {
            throw new EInvalidCipherSuiteException(ex.getMessage(), ex);
        }
        Provider provider = md.getProvider();
        s_digestProviderName = provider.getName();
        s_digestProviderVersion = Double.toString(provider.getVersion());
        m_hashLength = md.getDigestLength();
        s_digestAlgorithm = digest;
    }

    public static final Cipher getNewCipherInstance(String transformation) throws EInvalidCipherSuiteException {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(transformation);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EInvalidCipherSuiteException(transformation + ": " + ex.getMessage(), ex);
        }
        catch (GeneralSecurityException ex) {
            throw new EInvalidCipherSuiteException(ex.getMessage(), ex);
        }
        return cipher;
    }

    public static final MessageDigest getNewMessageDigestInstance(String algorithm) throws EInvalidCipherSuiteException {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EInvalidCipherSuiteException(algorithm + ": " + ex.getMessage(), ex);
        }
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final IMessageProtection getNewMessageProtectionInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        IMessageProtection mp;
        block15: {
            mp = null;
            try {
                if (m_isSonicCipherSuite) {
                    if (s_mpClass == null) {
                        Object object = MPCLASS_LOCK_OBJ;
                        synchronized (object) {
                            if (s_mpClass == null) {
                                s_mpClass = Class.forName("progress.message.crypto.MessageProtection");
                            }
                        }
                    }
                    mp = (IMessageProtection)s_mpClass.newInstance();
                    break block15;
                }
                if (s_pmpClass == null) {
                    Object object = PMPCLASS_LOCK_OBJ;
                    synchronized (object) {
                        if (s_pmpClass == null) {
                            s_pmpClass = Class.forName("com.sonicsw.security.pcs.PluggableMessageProtection");
                        }
                    }
                }
                mp = (IMessageProtection)s_pmpClass.newInstance();
            }
            catch (ClassNotFoundException ex) {
                throw ex;
            }
            catch (IllegalAccessException ex) {
                throw ex;
            }
            catch (InstantiationException ex) {
                throw ex;
            }
        }
        return mp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final IMessageProtection getNewMessageProtectionInstance(IPluggableCipherSuite pcs) throws ClassNotFoundException, IllegalAccessException, InstantiationException, EInvalidCipherSuiteException {
        IMessageProtection mp;
        block11: {
            mp = null;
            try {
                if (pcs.isSonicCipherSuite()) {
                    if (s_mpClass == null) {
                        Object object = MPCLASS_LOCK_OBJ;
                        synchronized (object) {
                            if (s_mpClass == null) {
                                s_mpClass = Class.forName("progress.message.crypto.MessageProtection");
                            }
                        }
                    }
                    mp = (IMessageProtection)s_mpClass.newInstance();
                    break block11;
                }
                PluggableMessageProtection pmp = new PluggableMessageProtection(pcs);
                mp = pmp;
            }
            catch (ClassNotFoundException ex) {
                throw ex;
            }
            catch (IllegalAccessException ex) {
                throw ex;
            }
            catch (InstantiationException ex) {
                throw ex;
            }
            catch (EInvalidCipherSuiteException ex) {
                throw ex;
            }
        }
        return mp;
    }

    @Override
    public CipherSuiteInfo getCipherSuiteInfo() {
        CipherSuiteInfo cipherSuiteInfo = new CipherSuiteInfo();
        if (m_isKeySizeSupplied) {
            cipherSuiteInfo.setCipherInfo(s_cipherProviderName, s_cipherProviderVersion, s_cipherTransformation + "/" + m_secretKeyLength);
        } else {
            cipherSuiteInfo.setCipherInfo(s_cipherProviderName, s_cipherProviderVersion, s_cipherTransformation);
        }
        cipherSuiteInfo.setDigestInfo(s_digestProviderName, s_digestProviderVersion, s_digestAlgorithm);
        return cipherSuiteInfo;
    }

    @Override
    public String getCipherTransformation() {
        return s_cipherTransformation;
    }

    @Override
    public String getCipherAlgorithm() {
        return s_cipherAlgorithm;
    }

    @Override
    public String getDigestAlgorithm() {
        return s_digestAlgorithm;
    }

    @Override
    public int getSecretKeyLength() {
        return m_secretKeyLength;
    }

    @Override
    public int getEncodedSecretKeyLengthInBytes() {
        return m_encodedSecretKeyLengthInBytes;
    }

    @Override
    public int getBlockSize() {
        return m_blockSize;
    }

    @Override
    public int getHashLength() {
        return m_hashLength;
    }

    @Override
    public final boolean isSonicCipherSuite() {
        return m_isSonicCipherSuite;
    }

    public static final boolean isCipherModeECB() {
        return m_isCipherModeECB;
    }

    public static final AlgorithmParameterSpec getAlgorithmParameterSpec(byte[] key, int offset, int len) {
        byte[] ivBytes = new byte[m_blockSize];
        byte[] iv = KeyGen.getIV(key);
        if (iv.length >= ivBytes.length) {
            System.arraycopy(iv, 0, ivBytes, 0, ivBytes.length);
        } else {
            System.arraycopy(iv, 0, ivBytes, 0, iv.length);
            for (int i = iv.length; i < ivBytes.length; ++i) {
                ivBytes[i] = 48;
            }
        }
        IvParameterSpec apSpec = new IvParameterSpec(ivBytes, 0, ivBytes.length);
        return apSpec;
    }

    public static final String[] getTransformationAndKeySize(String rawTransformation) {
        String s;
        String cipher = s = rawTransformation;
        String keySizeStr = null;
        int keySize = 0;
        int pos = 0;
        int count = 0;
        while (pos != -1) {
            if ((pos = s.indexOf("/", pos + 1)) == -1) continue;
            ++count;
        }
        if (count == 3) {
            cipher = s.substring(0, s.lastIndexOf("/"));
            if ((s = s.substring(s.lastIndexOf("/") + 1, s.length())) != null) {
                try {
                    keySize = Integer.parseInt(s);
                    keySizeStr = s;
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        String[] retVal = new String[]{cipher, keySizeStr};
        return retVal;
    }

    static {
        MPCLASS_LOCK_OBJ = new Object();
        PMPCLASS_LOCK_OBJ = new Object();
        s_cipherProviderName = null;
        s_cipherProviderVersion = null;
        s_cipherTransformation = null;
        s_cipherAlgorithm = null;
        m_isCipherModeECB = true;
        m_secretKeyLength = 0;
        m_encodedSecretKeyLengthInBytes = 0;
        m_blockSize = 0;
        s_digestProviderName = null;
        s_digestProviderVersion = null;
        s_digestAlgorithm = null;
        m_hashLength = 0;
    }
}

