/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.security.ssl;

import java.util.Arrays;
import java.util.Hashtable;

public class CipherSuiteUtil {
    private static final String[] RSACipherSuites1 = new String[]{"DHE_DSS_Export_With_DES_40_CBC_SHA", "DHE_DSS_With_3DES_EDE_CBC_SHA", "DHE_DSS_With_DES_CBC_SHA", "DHE_RSA_Export_With_DES_40_CBC_SHA", "DHE_RSA_With_3DES_EDE_CBC_SHA", "DHE_RSA_With_DES_CBC_SHA", "DH_DSS_Export_With_DES_40_CBC_SHA", "DH_DSS_With_3DES_EDE_CBC_SHA", "DH_DSS_With_DES_CBC_SHA", "DH_RSA_Export_With_DES_40_CBC_SHA", "DH_RSA_With_3DES_EDE_CBC_SHA", "DH_RSA_With_DES_CBC_SHA", "DH_Anon_Export_With_DES_40_CBC_SHA", "DH_Anon_Export_With_RC4_40_MD5", "DH_Anon_With_3DES_EDE_CBC_SHA", "DH_Anon_With_DES_CBC_SHA", "DH_Anon_With_RC4_MD5", "RSA_Export_With_DES_40_CBC_SHA", "RSA_Export_With_RC2_40_CBC_MD5", "RSA_Export_With_RC4_40_MD5", "RSA_With_3DES_EDE_CBC_SHA", "RSA_With_DES_CBC_SHA", "RSA_With_Null_MD5", "RSA_With_Null_SHA", "RSA_With_RC4_MD5", "RSA_With_RC4_SHA", "DHE_DSS_With_AES_128_CBC_SHA", "DHE_DSS_With_AES_256_CBC_SHA", "DHE_RSA_With_AES_128_CBC_SHA", "DHE_RSA_With_AES_256_CBC_SHA", "DH_Anon_With_AES_128_CBC_SHA", "DH_Anon_With_AES_256_CBC_SHA", "RSA_With_AES_128_CBC_SHA", "RSA_With_AES_256_CBC_SHA"};
    private static final String[] JSSECipherSuites = new String[]{"SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DH_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_DH_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_DH_DSS_WITH_DES_CBC_SHA", "SSL_DH_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DH_RSA_WITH_DES_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_WITH_RC4_128_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA", "SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DH_anon_WITH_AES_128_CBC_SHA", "TLS_DH_anon_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA"};
    private static final String[] RSACipherSuites2 = new String[]{"RSA_With_3DES_EDE_CBC_MD5", "RSA_With_DES_CBC_MD5"};
    private static final String[] RSA2JSSECipherSuites2 = new String[]{"SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA"};
    private static final String[] unsupportedRSACipherSuites = new String[]{"DH_DSS_With_AES_128_CBC_SHA", "DH_DSS_With_AES_256_CBC_SHA", "DH_RSA_With_AES_128_CBC_SHA", "DH_RSA_With_AES_256_CBC_SHA", "Null_With_Null_Null", "RSA_With_RC2_CBC_MD5"};
    private static Hashtable RSA2JSSETable = new Hashtable();
    private static Hashtable JSSE2RSATable = new Hashtable();
    private static String[] AllRSACipherSuites;

    public static String getRSACipherSuiteFromJSSE(String jsse) {
        return (String)JSSE2RSATable.get(jsse);
    }

    public static String getJSSECipherSuiteFromRSA(String rsa) {
        return (String)RSA2JSSETable.get(rsa);
    }

    public static String[] getRSACipherSuites() {
        return Arrays.copyOf(AllRSACipherSuites, AllRSACipherSuites.length);
    }

    public static String[] getJSSECipherSuites() {
        return Arrays.copyOf(JSSECipherSuites, JSSECipherSuites.length);
    }

    public static String[] getUnsupportedRSACipherSuites() {
        return Arrays.copyOf(unsupportedRSACipherSuites, unsupportedRSACipherSuites.length);
    }

    static {
        for (int i = 0; i < RSACipherSuites1.length; ++i) {
            RSA2JSSETable.put(RSACipherSuites1[i], JSSECipherSuites[i]);
            JSSE2RSATable.put(JSSECipherSuites[i], RSACipherSuites1[i]);
        }
        for (int j = 0; j < RSACipherSuites2.length; ++j) {
            RSA2JSSETable.put(RSACipherSuites2[j], RSA2JSSECipherSuites2[j]);
        }
        AllRSACipherSuites = RSA2JSSETable.keySet().toArray(new String[0]);
    }
}

