/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.util.action;

import com.sonicsw.sonicmq.util.action.Action;
import com.sonicsw.sonicmq.util.action.Event;
import java.util.HashSet;
import java.util.Set;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.util.Queue;
import progress.message.zclient.DebugThread;

public class ActionProcessor
extends DebugThread {
    static final int DEFAULT_MAX_SIZE = Config.LOG_QUEUE_SIZE;
    private final int m_maxSize;
    private int m_currentSize;
    private Set m_pending;
    private Queue m_enabled;

    public ActionProcessor() {
        this("Action Processor", DEFAULT_MAX_SIZE);
    }

    public ActionProcessor(String name) {
        this(name, DEFAULT_MAX_SIZE);
    }

    public ActionProcessor(String name, int maxSize) {
        super(name);
        this.m_maxSize = maxSize;
        this.m_enabled = new Queue();
        this.m_pending = new HashSet();
    }

    public Event createEvent(Action action) {
        return new Event(action);
    }

    public Event createEvent(Action action, int maxPreconditions) {
        return new Event(action, maxPreconditions);
    }

    public synchronized boolean reserveRoom(Event evt) {
        int size = evt.memsize();
        boolean hasRoom = this.hasRoom(size);
        if (hasRoom) {
            this.m_currentSize += size;
        }
        return hasRoom;
    }

    private boolean hasRoom(int size) {
        boolean hasRoom = this.m_currentSize + size <= this.m_maxSize || this.m_currentSize == 0;
        return hasRoom;
    }

    public synchronized void waitAndReserveRoom(Event evt) throws InterruptedException {
        int size = evt.memsize();
        while (!this.hasRoom(size) && !this.isShuttingDown()) {
            this.wait();
        }
        if (!this.isShuttingDown()) {
            this.m_currentSize += size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFire() throws InterruptedException {
        Queue queue = this.m_enabled;
        synchronized (queue) {
            while (!this.m_enabled.isEmpty()) {
                this.m_enabled.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(Event evt, boolean isReserved) {
        Object object;
        if (!isReserved) {
            object = this;
            synchronized (object) {
                this.m_currentSize += evt.memsize();
            }
        }
        object = evt;
        synchronized (object) {
            evt.setActionProcessor(this);
            if (!evt.isEnabled()) {
                ActionProcessor actionProcessor = this;
                synchronized (actionProcessor) {
                    this.m_pending.add(evt);
                }
            }
            Queue queue = this.m_enabled;
            synchronized (queue) {
                this.m_enabled.enqueue(evt);
                this.m_enabled.notifyAll();
            }
        }
    }

    public synchronized boolean removeEvent(Event evt) {
        boolean result = this.m_pending.remove(evt);
        if (result) {
            this.m_currentSize -= evt.memsize();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enable(Event evt) {
        Object object = this;
        synchronized (object) {
            this.m_pending.remove(evt);
        }
        object = this.m_enabled;
        synchronized (object) {
            this.m_enabled.enqueue(evt);
            this.m_enabled.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void threadMain() {
        try {
            while (!Thread.interrupted()) {
                Event evt = null;
                Object object = this.m_enabled;
                // MONITORENTER : object
                try {
                    while (this.m_enabled.isEmpty()) {
                        this.m_enabled.wait();
                    }
                }
                catch (InterruptedException e) {
                    // MONITOREXIT : object
                    ActionProcessor actionProcessor = this;
                    // MONITORENTER : actionProcessor
                    this.m_currentSize = 0;
                    this.notifyAll();
                    // MONITOREXIT : actionProcessor
                    return;
                }
                evt = (Event)this.m_enabled.dequeue();
                this.m_enabled.notifyAll();
                // MONITOREXIT : object
                if (this.DEBUG) {
                    this.debug("ActionProcessor exec: " + evt.getAction());
                }
                try {
                    evt.getAction().exec();
                }
                catch (RuntimeException ex) {
                    if (!Broker.exiting) {
                        throw ex;
                    }
                    this.interrupt();
                }
                object = this;
                // MONITORENTER : object
                this.m_currentSize -= evt.memsize();
                this.notifyAll();
                // MONITOREXIT : object
            }
            ActionProcessor actionProcessor = this;
        }
        catch (Throwable throwable) {
            ActionProcessor actionProcessor = this;
            // MONITORENTER : actionProcessor
            this.m_currentSize = 0;
            this.notifyAll();
            // MONITOREXIT : actionProcessor
            throw throwable;
        }
        this.m_currentSize = 0;
        this.notifyAll();
        // MONITOREXIT : actionProcessor
    }
}

