/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.util.action;

import com.sonicsw.sonicmq.util.action.Action;
import com.sonicsw.sonicmq.util.action.ActionProcessor;
import com.sonicsw.sonicmq.util.action.PreCondition;
import progress.message.util.EAssertFailure;

public final class Event {
    static final int DEFAULT_MAX_PRECONDITIONS = 4;
    PreCondition[] m_conditions = null;
    Action m_action = null;
    ActionProcessor m_processor = null;
    int m_pending;

    public Event(Action action, int maxPreConditions) {
        this.m_action = action;
        if (maxPreConditions > 0) {
            this.m_conditions = new PreCondition[maxPreConditions];
        }
    }

    public Event(Action action) {
        this(action, 4);
    }

    public synchronized void addPreCondition(PreCondition c) {
        if (this.m_conditions == null || this.m_pending >= this.m_conditions.length) {
            throw new ArrayIndexOutOfBoundsException("Number of preconditions exceeded");
        }
        if (this.m_processor != null) {
            throw new EAssertFailure("Can't add precondition to event already in action processor queue");
        }
        this.m_conditions[this.m_pending] = c;
        ++this.m_pending;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean firePreCondition(PreCondition c, boolean syncAction) {
        int i;
        int size = this.m_conditions.length;
        for (i = 0; i < size; ++i) {
            if (this.m_conditions[i] == null || !this.m_conditions[i].equals(c)) continue;
            this.m_conditions[i] = null;
            --this.m_pending;
            break;
        }
        if (i == size) {
            return false;
        }
        boolean ret = false;
        if (this.m_pending != 0) return ret;
        ret = true;
        if (this.m_processor != null) {
            if (syncAction) {
                if (!this.m_processor.removeEvent(this)) throw new EAssertFailure("Event already enabled");
                this.m_action.prepareToFire();
                this.m_action.exec();
                return ret;
            } else {
                this.m_action.prepareToFire();
                this.m_processor.enable(this);
            }
            return ret;
        } else {
            if (!syncAction) throw new EAssertFailure("Event not added to action processor queue");
            this.m_action.exec();
        }
        return ret;
    }

    public boolean firePreCondition(PreCondition c) throws InterruptedException {
        return this.firePreCondition(c, false);
    }

    public String toString() {
        return " action event of " + this.m_action;
    }

    boolean isEnabled() {
        return this.m_pending == 0;
    }

    Action getAction() {
        return this.m_action;
    }

    void setActionProcessor(ActionProcessor ap) {
        this.m_processor = ap;
    }

    public int memsize() {
        return this.m_action.memsize();
    }
}

