/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.util.debug;

import com.sonicsw.util.debug.DebugConstants;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;

public final class Debug
implements DebugConstants {
    private static final String PROPERTY_KEY_TRACEFILE = "debug.tracefile";
    private static final String PROPERTY_KEY_RESULTFILE = "debug.outputfile";
    private static final String TRACE_LABEL = "TRACE:";
    private static final Object m_syncObject = new byte[0];
    private static volatile ArrayList m_classnameList;
    private static volatile FileOutputStream m_fileOutputStream;
    private static volatile ByteArrayOutputStream m_byteArrayOutputStream;
    private static volatile PrintWriter m_printWriter;

    private Debug() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void trace(String msg) {
        if (m_classnameList != null) {
            Object object = m_syncObject;
            synchronized (object) {
                String s = Debug.generateTraceInfo(msg);
                if (s != null) {
                    System.err.println(s);
                    if (m_fileOutputStream != null) {
                        try {
                            m_fileOutputStream.write((s + "\r\n").getBytes());
                            m_fileOutputStream.flush();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            m_fileOutputStream = null;
                        }
                    }
                }
            }
        }
    }

    public static final void trace(String msg, Throwable th) {
        StringBuilder sb = new StringBuilder();
        if (msg != null && !msg.trim().isEmpty()) {
            sb.append(msg).append("\n");
        }
        if (th != null) {
            sb.append(Debug.getStackTrace(th));
        }
        if (sb.length() > 0) {
            System.err.println(sb.toString());
            if (m_fileOutputStream != null) {
                try {
                    m_fileOutputStream.write(sb.toString().getBytes());
                    m_fileOutputStream.flush();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    m_fileOutputStream = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTrace(Throwable th) {
        if (th == null) {
            return "";
        }
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            th.printStackTrace(pw);
        }
        catch (Exception ignore) {
            String string = th.toString() + "\n  -- unable to display Exception stack due to [" + ignore + "]";
            return string;
        }
        finally {
            if (sw != null) {
                try {
                    sw.close();
                }
                catch (Exception ignore) {}
            }
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Exception ignore) {}
            }
        }
        return sw.toString();
    }

    private static boolean getTraceableClassNames() {
        String filename = System.getProperty(PROPERTY_KEY_TRACEFILE);
        if (filename == null) {
            return false;
        }
        File file = new File(filename);
        FileReader fileReader = null;
        if (!file.isFile()) {
            return false;
        }
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        BufferedReader reader = new BufferedReader(fileReader);
        m_classnameList = new ArrayList();
        String line = null;
        while (true) {
            try {
                line = reader.readLine();
            }
            catch (IOException e1) {
                try {
                    reader.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return false;
            }
            if (line == null) break;
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
            m_classnameList.add(line);
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            m_classnameList = null;
            return false;
        }
        if (m_classnameList.isEmpty()) {
            m_classnameList = null;
            return false;
        }
        return true;
    }

    private static void allocateOutputStreams() {
        m_byteArrayOutputStream = new ByteArrayOutputStream();
        m_printWriter = new PrintWriter(m_byteArrayOutputStream);
        String filename = System.getProperty(PROPERTY_KEY_RESULTFILE);
        if (filename == null) {
            return;
        }
        try {
            File file = new File(filename);
            if (file.exists() && file.isFile()) {
                File newFile = new File(file.getPath() + Long.toString(new Date().getTime()) + ".log");
                file.renameTo(newFile);
            }
            m_fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException ex) {
            m_fileOutputStream = null;
            ex.printStackTrace();
        }
    }

    private static String generateTraceInfo(String msg) {
        Exception e = new Exception();
        e.printStackTrace(m_printWriter);
        m_printWriter.flush();
        String exception_msg = m_byteArrayOutputStream.toString();
        m_byteArrayOutputStream.reset();
        int open_paren_index = -1;
        int THIRD_OPEN_PAREN = 3;
        for (int i = 0; i < 3; ++i) {
            open_paren_index = exception_msg.indexOf(40, open_paren_index + 1);
        }
        int close_paren_index = exception_msg.indexOf(41, open_paren_index + 1);
        int start_index = exception_msg.lastIndexOf(32, open_paren_index);
        String package_class_method = exception_msg.substring(start_index + 1, open_paren_index);
        String package_class_method_line = exception_msg.substring(start_index + 1, close_paren_index + 1);
        int period_index = exception_msg.lastIndexOf(46, open_paren_index - 1);
        String package_class = exception_msg.substring(start_index + 1, period_index);
        String traceinfo = null;
        if (m_classnameList.contains(package_class) || m_classnameList.contains("ALL")) {
            traceinfo = TRACE_LABEL + package_class_method_line + ": " + msg;
        }
        return traceinfo;
    }

    public static final void main(String[] args) {
    }

    static {
        if (Debug.getTraceableClassNames()) {
            Debug.allocateOutputStreams();
        }
    }
}

